VERSION 2.00
Begin Form DDS60 
   BackColor       =   &H00C0C0C0&
   BorderStyle     =   1  'Fixed Single
   Caption         =   "Form1"
   ClientHeight    =   6360
   ClientLeft      =   1950
   ClientTop       =   1665
   ClientWidth     =   5415
   Height          =   6765
   Icon            =   DDS60.FRX:0000
   Left            =   1890
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   ScaleHeight     =   6360
   ScaleWidth      =   5415
   Top             =   1320
   Width           =   5535
   Begin Frame Frame 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Sweep"
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   2445
      Index           =   2
      Left            =   120
      TabIndex        =   12
      Top             =   3420
      Width           =   5145
      Begin SSPanel Panel 
         BackColor       =   &H00C0C0C0&
         BevelOuter      =   1  'Inset
         Caption         =   "Panel"
         FloodShowPct    =   0   'False
         FloodType       =   1  'Left To Right
         Font3D          =   0  'None
         Height          =   195
         Left            =   210
         TabIndex        =   21
         Top             =   2100
         Width           =   4725
      End
      Begin ComboBox Combo1 
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   315
         Left            =   2580
         TabIndex        =   14
         Text            =   "Combo1"
         Top             =   1680
         Width           =   1035
      End
      Begin TextBox Text3 
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   285
         Left            =   2580
         MaxLength       =   10
         TabIndex        =   15
         Text            =   "10"
         Top             =   1290
         Width           =   1065
      End
      Begin TextBox Text2 
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   285
         Left            =   2580
         MaxLength       =   10
         TabIndex        =   13
         Text            =   "1"
         Top             =   900
         Width           =   1065
      End
      Begin Label Label1 
         BackStyle       =   0  'Transparent
         Caption         =   "Steps"
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   285
         Index           =   9
         Left            =   150
         TabIndex        =   16
         Top             =   1710
         Width           =   555
      End
      Begin Label Label1 
         BackStyle       =   0  'Transparent
         Caption         =   "Upper frequency (MHz)"
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   285
         Index           =   8
         Left            =   150
         TabIndex        =   17
         Top             =   1320
         Width           =   2475
      End
      Begin Label Label1 
         BackStyle       =   0  'Transparent
         Caption         =   "Enter the required lower and upper frequencies in MHz, select the number of steps and then click the Start button to start the sweep."
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         ForeColor       =   &H00800000&
         Height          =   465
         Index           =   7
         Left            =   90
         TabIndex        =   19
         Top             =   240
         Width           =   4935
      End
      Begin Label Label1 
         BackStyle       =   0  'Transparent
         Caption         =   "Lower frequency (MHz)"
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   285
         Index           =   6
         Left            =   150
         TabIndex        =   18
         Top             =   930
         Width           =   2475
      End
   End
   Begin Frame Frame 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Mode"
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   705
      Index           =   0
      Left            =   120
      TabIndex        =   9
      Top             =   390
      Width           =   5145
      Begin OptionButton ModeOption 
         BackColor       =   &H00C0C0C0&
         Caption         =   "Sweep"
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   195
         Index           =   1
         Left            =   1740
         TabIndex        =   11
         Top             =   330
         Width           =   855
      End
      Begin OptionButton ModeOption 
         BackColor       =   &H00C0C0C0&
         Caption         =   "Fixed frequency"
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   195
         Index           =   0
         Left            =   150
         TabIndex        =   10
         Top             =   330
         Value           =   -1  'True
         Width           =   1395
      End
   End
   Begin CommandButton StartButton 
      Caption         =   "&Start"
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   375
      Left            =   120
      TabIndex        =   1
      Top             =   5970
      Width           =   945
   End
   Begin Frame Frame 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Fixed frequency"
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   2205
      Index           =   1
      Left            =   120
      TabIndex        =   6
      Top             =   1140
      Width           =   5145
      Begin TextBox Text1 
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   285
         Left            =   2580
         MaxLength       =   10
         TabIndex        =   0
         Text            =   "10"
         Top             =   900
         Width           =   1065
      End
      Begin Label Label2 
         BorderStyle     =   1  'Fixed Single
         Caption         =   "Label2"
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   255
         Index           =   1
         Left            =   2580
         TabIndex        =   2
         Top             =   1770
         Width           =   1065
      End
      Begin Label Label1 
         BackStyle       =   0  'Transparent
         Caption         =   "Delta Phase (hex)"
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   285
         Index           =   2
         Left            =   150
         TabIndex        =   3
         Top             =   1800
         Width           =   1635
      End
      Begin Label Label2 
         BorderStyle     =   1  'Fixed Single
         Caption         =   "Label2"
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   255
         Index           =   0
         Left            =   2580
         TabIndex        =   4
         Top             =   1350
         Width           =   1065
      End
      Begin Label Label1 
         BackStyle       =   0  'Transparent
         Caption         =   "Delta Phase (decimal)"
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   285
         Index           =   1
         Left            =   150
         TabIndex        =   5
         Top             =   1380
         Width           =   1635
      End
      Begin Label Label1 
         BackStyle       =   0  'Transparent
         Caption         =   "Required output frequency (MHz)"
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   285
         Index           =   0
         Left            =   150
         TabIndex        =   8
         Top             =   930
         Width           =   2475
      End
      Begin Label Label1 
         BackStyle       =   0  'Transparent
         Caption         =   "Enter the required frequency in MHz and click the Start button. The delta phase value will then be calculated and sent to the DDS60 daughterboard."
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         ForeColor       =   &H00800000&
         Height          =   705
         Index           =   3
         Left            =   90
         TabIndex        =   7
         Top             =   240
         Width           =   4935
      End
   End
   Begin Label versionlabel 
      Alignment       =   2  'Center
      BackColor       =   &H00C0C0C0&
      Caption         =   "version"
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      ForeColor       =   &H00800000&
      Height          =   285
      Left            =   150
      TabIndex        =   20
      Top             =   90
      Width           =   5235
   End
End
Option Explicit

Sub fixedfrequency ()
    Dim deltaphase As Long, hx As String

    text1 = Trim$(text1)
    If Not Validfrequency(text1) Then
        text1.SetFocus
        Exit Sub
    End If
    
    lowf = Val(text1) * 1000000
    'multiply the frequency in Hz by the deltaphase
    'value for 1 Hz which is 23.86092942222
    '(this value is 2^32 / 180 Mhz)
    deltaphase = lowf * 23.86092942222
    label2(0) = Format$(deltaphase)
    hx = Hex$(deltaphase)
    If Len(hx) <> 8 Then
        hx = String$(8 - Len(hx), "0") + hx
    End If
    label2(1) = hx
    setfreq deltaphase
    If text1.Visible Then
        text1.SetFocus
    End If

End Sub

Sub Form_Load ()

    Caption = "ZS1AYJ DDS60 frequency controller"
    versionlabel = version
    formcentre Me
    'initialise printer data port to zero
    clearport

    'the AD9851 initialises in parallel data mode.
    'to switch to serial data mode we need to set
    'parallel word W0 to xxxxx011 binary. The DDS60
    'board has this pattern hard wired on the 8 data
    'bits so we simply have to send a clock pulse
    'followed by a load pulse to enter serial mode.

    clockpulse
    loadpulse

    'Initialise frequency to 10 MHz
    text1 = "10"
    startButton_Click
    
    modeoption(1).Value = True
    modeoption(0).Value = True
    frame(2).Top = frame(1).Top
    frame(2).Left = frame(1).Left
    combo1.AddItem "10"
    combo1.AddItem "30"
    combo1.AddItem "100"
    combo1.AddItem "300"
    combo1.AddItem "1000"
    combo1.AddItem "3000"
    combo1.AddItem "10000"
    
    combo1.ListIndex = 4
End Sub

Sub Form_QueryUnload (Cancel As Integer, unloadmode As Integer)

    If unloadmode = 0 Then
        End
    End If
End Sub

Sub ModeOption_Click (index As Integer)

    If index = 0 Then
        sweeping = False
        startbutton.Caption = "&Start"
        frame(1).Visible = True
        frame(2).Visible = False
        Height = frame(1).Top + frame(1).Height + 900
        startbutton.Top = frame(1).Top + frame(1).Height + 90
    Else
        frame(1).Visible = False
        frame(2).Visible = True
        Height = frame(2).Top + frame(2).Height + 900
        startbutton.Top = frame(2).Top + frame(2).Height + 90
    End If
End Sub

Sub startButton_Click ()
    
    If modeoption(0).Value Then
        fixedfrequency
    Else
        sweepfrequency
    End If


End Sub

Sub sweepfrequency ()
    Dim deltaphase As Long, hx As String, steps
    Dim f, pc

    If sweeping Then
        sweeping = False
        Exit Sub
    End If

    text2 = Trim$(text2)
    If Not Validfrequency(text2) Then
        text2.SetFocus
        Exit Sub
    End If
    lowf = Val(text2) * 1000000
    
    text3 = Trim$(text3)
    If Not Validfrequency(text3) Then
        text3.SetFocus
        Exit Sub
    End If
    highf = Val(text3) * 1000000
    
    If lowf >= highf Then
        MsgBox "Upper frequency must be higher than lower frequency", 0, "DDS60"
        text3.SetFocus
        Exit Sub
    End If
 
    sweeping = True
    startbutton.Caption = "&Stop"
    
    steps = Val(combo1.Text)
    stepf = (highf - lowf) / steps

    'main sweep loop
    Do
        'send trigger pulse on strobe line for
        'scope synchronization
        TriggerPulse
        For f = lowf To highf Step stepf
            pc = (f - lowf) / (highf - lowf) * 100
            panel.FloodPercent = pc
            'multiply the frequency in Hz by the deltaphase
            'value for 1 Hz which is 23.86092942222
            '(this value is 2^32 / 180 Mhz)
            deltaphase = f * 23.86092942222
            setfreq deltaphase
            'DoEvents
            If Not sweeping Then
                Exit For
            End If
        Next
        DoEvents
    Loop While sweeping
    startbutton.Caption = "&Start"
    panel.FloodPercent = 0
End Sub

Function Validfrequency (f)
    Dim i, char As String

    Validfrequency = False
    If f = "" Then
        MsgBox "Enter a frequency in MHz", 0, "DDS60"
        Exit Function
    End If
    
    If (f < .01) Or (f > 60) Then
        MsgBox "Frequency must be in the range .01 MHz to 60 MHz", 0, "DDS60"
        Exit Function
    End If
    Validfrequency = True
End Function

