Option Explicit

Global Const version = "Version 1.2 - November 2006"
Global lowF As Long, HighF As Long, stepF As Long
Global sweeping As Integer

' declarations for 16 bit port driver dll
' Note that this directly drives the PC parallel port.
' This works fine on Win95/98/XP but not on Win NT/2000
' which do not allow port access by default.
' If you are using NT/2000 then google userport.sys. This
' is a driver which give access to the ports on NT/2000.

Declare Sub agoutp Lib "apiguide.dll" (ByVal portid%, ByVal outval%)
Declare Function aginp Lib "apiguide.dll" (ByVal portid%) As Integer

Global portdata As Integer 'current value of port output data

Sub clearport ()

    portdata = 0
    agoutp &H378, portdata 'set all data bits to zero
End Sub

Sub clockpulse ()

    portdata = portdata Or 2
    agoutp &H378, portdata 'clock line high
    Waitabit
    portdata = portdata And &H5
    agoutp &H378, portdata 'clock line low
    Waitabit

End Sub

Sub formcentre (f As Form)
    f.Top = (screen.Height - f.Height) / 2
    f.Left = (screen.Width - f.Width) / 2
    f.Icon = dds60.Icon
End Sub

Sub loadpulse ()

    portdata = portdata Or 1
    agoutp &H378, portdata 'load line high
    Waitabit
    portdata = portdata And &H6
    agoutp &H378, portdata 'load line low
    Waitabit

End Sub

Sub setfreq (deltaphase As Long)
     Dim i As Integer, word As Long

    'send the 32 bits of deltaphase (W4 to W1) least
    'significant bit first to most significant bit last
    word = deltaphase
    For i = 1 To 32
        portdata = (word And 1) * 4
        agoutp &H378, portdata  'assert data line
        clockpulse              'send clock pulse
        word = word \ 2
    Next

    'Next load data word W0 as 09h which is fixed
    'in this application as phase=0, power-up and
    '6 x CLK enabled

    word = &H9
    For i = 1 To 8
        portdata = (word And 1) * 4
        agoutp &H378, portdata  'assert data line
        clockpulse              'send clock pulse
        word = word \ 2
    Next

    'we have sent 40 data bits so lastly send a
    'load pulse to switch to the new frequency
    loadpulse

End Sub

Sub TriggerPulse ()

    agoutp &H37A, 0  'strobe line high
    Waitabit
    agoutp &H37A, 1 'strobe line low

End Sub

Sub Waitabit ()
    Dim i

    'short delay to lengthen clock, data,load pulses
    'probably not required so exit sub here.
    'Exit Sub

    'if you are using a long cable and experience
    'problems controlling the DDS60 then you can
    'try deleting the exit sub above which will
    'cause the loop below to execute and introduce
    'a delay.

    For i = 1 To 100
    Next


End Sub

