MODULE vt100;
(*
#
#                        VT100 Escape Codes
#        symbology:
#        ^[       = escape character (ascii 27 decimal)
#        <v>         = single or double digit number.  Vertical coordinate
#        <h>         = single or double digit number.  Horizontal coordinate
#        <n>         = single or double digit number.  Number of chars/lines
#        others   = single characters just as they appear.
#
# NOTE: Many sequences have "^[[" which is two chars: "escape" and "[".
#

Name                  Description                            Esc Code
--------------------  -------------------------------------  -----------
setnl LMN             Set new line mode                      ^[[20h
setappl DECCKM        Set cursor key to application          ^[[?1h
setansi DECANM        Set ANSI (versus VT52)                 none
setcol DECCOLM        Set number of columns to 132           ^[[?3h
setsmooth DECSCLM     Set smooth scrolling                   ^[[?4h
setrevscrn DECSCNM    Set reverse video on screen            ^[[?5h
setorgrel DECOM       Set origin to relative                 ^[[?6h
setwrap DECAWM        Set auto-wrap mode                     ^[[?7h
setrep DECARM         Set auto-repeat mode                   ^[[?8h
setinter DECINLM      Set interlacing mode                   ^[[?9h

setlf LMN             Set line feed mode                     ^[[20l
setcursor DECCKM      Set cursor key to cursor               ^[[?1l
setvt52 DECANM        Set VT52 (versus ANSI)                 ^[[?2l
resetcol DECCOLM      Set number of columns to 80            ^[[?3l
setjump DECSCLM       Set jump scrolling                     ^[[?4l
setnormscrn DECSCNM   Set normal video on screen             ^[[?5l
setorgabs DECOM       Set origin to absolute                 ^[[?6l
resetwrap DECAWM      Reset auto-wrap mode                   ^[[?7l
resetrep DECARM       Reset auto-repeat mode                 ^[[?8l
resetinter DECINLM    Reset interlacing mode                 ^[[?9l

altkeypad DECKPAM     Set alternate keypad mode              ^[=
numkeypad DECKPNM     Set numeric keypad mode                ^[>

setukg0               Set United Kingdom G0 character set    ^[(A
setukg1               Set United Kingdom G1 character set    ^[)A
setusg0               Set United States G0 character set     ^[(B
setusg1               Set United States G1 character set     ^[)B
setspecg0             Set G0 special chars. & line set       ^[(0
setspecg1             Set G1 special chars. & line set       ^[)0
setaltg0              Set G0 alternate character ROM         ^[(1
setaltg1              Set G1 alternate character ROM         ^[)1
setaltspecg0          Set G0 alt char ROM and spec. graphics ^[(2
setaltspecg1          Set G1 alt char ROM and spec. graphics ^[)2

setss2 SS2            Set single shift 2                     ^[N
setss3 SS3            Set single shift 3                     ^[O

modesoff SGR0         Turn off character attributes          ^[[m
modesoff SGR0         Turn off character attributes          ^[[0m
bold SGR1             Turn bold mode on                      ^[[1m
lowint SGR2           Turn low intensity mode on             ^[[2m
underline SGR4        Turn underline mode on                 ^[[4m
blink SGR5            Turn blinking mode on                  ^[[5m
reverse SGR7          Turn reverse video on                  ^[[7m
invisible SGR8        Turn invisible text mode on            ^[[8m

setwin DECSTBM        Set top and bottom line#s of a window  ^[[<v>;<v>r

cursorup(n) CUU       Move cursor up n lines                 ^[[<n>A
cursordn(n) CUD       Move cursor down n lines               ^[[<n>B
cursorrt(n) CUF       Move cursor right n lines              ^[[<n>C
cursorlf(n) CUB       Move cursor left n lines               ^[[<n>D
cursorhome            Move cursor to upper left corner       ^[[H
cursorhome            Move cursor to upper left corner       ^[[;H
cursorpos(v,h) CUP    Move cursor to screen location v,h     ^[[<v>;<h>H
hvhome                Move cursor to upper left corner       ^[[f
hvhome                Move cursor to upper left corner       ^[[;f
hvpos(v,h) CUP        Move cursor to screen location v,h     ^[[<v>;<h>f
index IND             Move/scroll window up one line         ^[D
revindex RI           Move/scroll window down one line       ^[M
nextline NEL          Move to next line                      ^[E
savecursor DECSC      Save cursor position and attributes    ^[7
restorecursor DECSC   Restore cursor position and attributes ^[8

tabset HTS            Set a tab at the current column        ^[H
tabclr TBC            Clear a tab at the current column      ^[[g
tabclr TBC            Clear a tab at the current column      ^[[0g
tabclrall TBC         Clear all tabs                         ^[[3g

dhtop DECDHL          Double-height letters, top half        ^[#3
dhbot DECDHL          Double-height letters, bottom half     ^[#4
swsh DECSWL           Single width, single height letters    ^[#5
dwsh DECDWL           Double width, single height letters    ^[#6

cleareol EL0          Clear line from cursor right           ^[[K
cleareol EL0          Clear line from cursor right           ^[[0K
clearbol EL1          Clear line from cursor left            ^[[1K
clearline EL2         Clear entire line                      ^[[2K

cleareos ED0          Clear screen from cursor down          ^[[J
cleareos ED0          Clear screen from cursor down          ^[[0J
clearbos ED1          Clear screen from cursor up            ^[[1J
clearscreen ED2       Clear entire screen                    ^[[2J

devstat DSR           Device status report                   ^[5n
termok DSR               Response: terminal is OK            ^[0n
termnok DSR              Response: terminal is not OK        ^[3n

getcursor DSR         Get cursor position                    ^[6n
cursorpos CPR            Response: cursor is at v,h          ^[<v>;<h>R

ident DA              Identify what terminal type            ^[[c
ident DA              Identify what terminal type (another)  ^[[0c
gettype DA               Response: terminal type code n      ^[[?1;<n>0c

reset RIS             Reset terminal to initial state        ^[c

align DECALN          Screen alignment display               ^[#8
testpu DECTST         Confidence power up test               ^[[2;1y
testlb DECTST         Confidence loopback test               ^[[2;2y
testpurep DECTST      Repeat power up test                   ^[[2;9y
testlbrep DECTST      Repeat loopback test                   ^[[2;10y

ledsoff DECLL0        Turn off all four leds                 ^[[0q
led1 DECLL1           Turn on LED #1                         ^[[1q
led2 DECLL2           Turn on LED #2                         ^[[2q
led3 DECLL3           Turn on LED #3                         ^[[3q
led4 DECLL4           Turn on LED #4                         ^[[4q

#=======================================================================

#
# VT100 Special Key Codes
#
# These are sent from the terminal back to the computer when the
# particular key is pressed.  Note that the numeric keypad keys
# send different codes in numeric mode than in alternate mode.
# See escape codes above to change keypad mode.
#

# Function Keys:

PF1                ^[OP
PF2                ^[OQ
PF3                ^[OR
PF4                ^[OS


# Arrow Keys:
		Reset         Set
		-----         ---
up               ^[A         ^[OA
down             ^[B         ^[OB
right            ^[C         ^[OC
left             ^[D         ^[OD


# Numeric Keypad Keys:

		Keypad Mode
		-----------------
Keypad Key        Numeric        Alternate
----------        -------        ---------
0                0        ^[Op
1                1        ^[Oq
2                2        ^[Or
3                3        ^[Os
4                4        ^[Ot
5                5        ^[Ou
6                6        ^[Ov
7                7        ^[Ow
8                8        ^[Ox
9                9        ^[Oy
- (minus)        -        ^[Om
, (comma)        ,        ^[Ol
. (period)       .        ^[On
ENTER           ^M        ^[OM
*)


FROM IO IMPORT Put;
FROM Fmt IMPORT Int;

VAR n, v, h : INTEGER;


PROCEDURE Bell() =
(* Campanella *)
BEGIN
     Put("\007");
END Bell ;

PROCEDURE NL() =
(* New Line : A capo *)
BEGIN
     Put("\n");
END NL ;

PROCEDURE NLn(n:CARDINAL) =
(* New Line : A capo n volte *)
VAR i : CARDINAL;
BEGIN
  FOR i := 1 TO n DO
     Put("\n");
  END;
END NLn ;

PROCEDURE CLRight () =
(* cleareol EL0          Clear line from cursor right           ^[[0K *)
BEGIN
     Put("\033[0K");
END CLRight;
(*-------------------------------------------------------------------------*)

PROCEDURE CLLeft () =
(*clearbol EL1          Clear line from cursor left            ^[[1K *)
BEGIN
     Put("\033[1K");
END CLLeft;
(*-------------------------------------------------------------------------*)

PROCEDURE CL () =
(* clearline EL2         Clear entire line                      ^[[2K *)
BEGIN
     Put("\033[");
END  CL;
(*-------------------------------------------------------------------------*)

PROCEDURE CSCDown () =
(* cleareos ED0          Clear screen from cursor down          ^[[J *)
BEGIN
     Put("\033[J");
END CSCDown ;
(*-------------------------------------------------------------------------*)

PROCEDURE CSCUp () =
(* clearbos ED1          Clear screen from cursor up            ^[[1J *)
BEGIN
     Put("\033[1J");
END CSCUp;
(*-------------------------------------------------------------------------*)

PROCEDURE CLS () =
(* clearscreen ED2       Clear entire screen                    ^[[2J *)
BEGIN
     Put("\033[2J");
END CLS;
(*-------------------------------------------------------------------------*)

PROCEDURE Normal() =
(* modesoff SGR0         Turn off character attributes          ^[[0m *)
BEGIN
     Put("\033[0m");
END Normal;
(*-------------------------------------------------------------------------*)

PROCEDURE Bold() =
(* bold SGR1             Turn bold mode on                      ^[[1m *)
BEGIN
     Put("\033[1m");
END Bold;
(*-------------------------------------------------------------------------*)

PROCEDURE LowInt() =
(* lowint SGR2           Turn low intensity mode on             ^[[2m *)
BEGIN
     Put("\033[2m");
END LowInt;
(*-------------------------------------------------------------------------*)

PROCEDURE UnderL() =
(* underline SGR4        Turn underline mode on                 ^[[4m *)
BEGIN
     Put("\033[4m");
END UnderL;
(*-------------------------------------------------------------------------*)

PROCEDURE Blink() =
(* blink SGR5            Turn blinking mode on                  ^[[5m *)
BEGIN
     Put("\033[5m");
END Blink;
(*-------------------------------------------------------------------------*)

PROCEDURE RevVideo() =
(* reverse SGR7          Turn reverse video on                  ^[[7m *)
BEGIN
     Put("\033[7m");
END RevVideo;
(*-------------------------------------------------------------------------*)

PROCEDURE Invisible() =
(* invisible SGR8        Turn invisible text mode on            ^[[8m *)
BEGIN
     Put("\033[8m");
END Invisible;
(*-------------------------------------------------------------------------*)

PROCEDURE CUU (n:INTEGER) =
(* cursorup(n) CUU       Move cursor up n lines                 ^[[<n>A *)
BEGIN
     Put("\033["& Int(n,10) &"A");
END CUU   ;
(*-------------------------------------------------------------------------*)
PROCEDURE CUD (n:INTEGER) =
(* cursordn(n) CUD       Move cursor down n lines               ^[[<n>B *)
BEGIN
     Put("\033["& Int(n,10) &"B");
END CUD   ;
(*-------------------------------------------------------------------------*)
PROCEDURE CUF (n:INTEGER) =
(* cursorrt(n) CUF       Move cursor right n lines              ^[[<n>C *)
BEGIN
     Put("\033["& Int(n,10) &"C");
END CUF   ;
(*-------------------------------------------------------------------------*)
PROCEDURE CUB (n:INTEGER) =
(* cursorlf(n) CUB       Move cursor left n lines               ^[[<n>D *)
BEGIN
     Put("\033["& Int(n,10) &"D");
END CUB   ;
(*-------------------------------------------------------------------------*)


PROCEDURE CUP (v:INTEGER; h:INTEGER) =
(* cursorpos(v,h) CUP    Move cursor to screen location v,h     ^[[<v>;<h>H *)
BEGIN
     Put("\033["& Int(v,10) & ";" & Int(h,10) & "H");
END CUP   ;
(*-------------------------------------------------------------------------*)


PROCEDURE Home() =
(* cursorhome            Move cursor to upper left corner       ^[[H *)
BEGIN
     Put("\033[H");
END Home ;

PROCEDURE SavCur() =
(* savecursor DECSC      Save cursor position and attributes    ^[7 *)
BEGIN
     Put("\033[7");
END SavCur;

PROCEDURE RestCur() =
(* restorecursor DECSC   Restore cursor position and attributes ^[8 *)
BEGIN
     Put("\033[8");
END RestCur;


BEGIN
END vt100.
