INTERFACE vt100;


PROCEDURE Bell() ;
(* Campanella *)

PROCEDURE NL();
(* New Line : A capo *)


PROCEDURE NLn(n:CARDINAL) ;
(* New Line n : A capo n volte *)


PROCEDURE CLRight () ;
(* cleareol EL0          Clear line from cursor right           ^[[0K *)


PROCEDURE CLLeft () ;
(*clearbol EL1          Clear line from cursor left            ^[[1K *)


PROCEDURE CL ();
(* clearline EL2         Clear entire line                      ^[[2K *)


PROCEDURE CSCDown () ;
(* cleareos ED0          Clear screen from cursor down          ^[[J *)


PROCEDURE CSCUp () ;
(* clearbos ED1          Clear screen from cursor up            ^[[1J *)


PROCEDURE CLS () ;
(* clearscreen ED2       Clear entire screen                    ^[[2J *)


PROCEDURE Normal() ;
(* modesoff SGR0         Turn off character attributes          ^[[0m *)


PROCEDURE Bold() ;
(* bold SGR1             Turn bold mode on                      ^[[1m *)


PROCEDURE LowInt() ;
(* lowint SGR2           Turn low intensity mode on             ^[[2m *)


PROCEDURE UnderL() ;
(* underline SGR4        Turn underline mode on                 ^[[4m *)


PROCEDURE Blink() ;
(* blink SGR5            Turn blinking mode on                  ^[[5m *)


PROCEDURE RevVideo() ;
(* reverse SGR7          Turn reverse video on                  ^[[7m *)


PROCEDURE Invisible() ;
(* invisible SGR8        Turn invisible text mode on            ^[[8m *)



PROCEDURE CUU (n:INTEGER) ;
(* cursorup(n) CUU       Move cursor up n lines                 ^[[<n>A *)


PROCEDURE CUD (n:INTEGER) ;
(* cursordn(n) CUD       Move cursor down n lines               ^[[<n>B *)


PROCEDURE CUF (n:INTEGER) ;
(* cursorrt(n) CUF       Move cursor right n lines              ^[[<n>C *)


PROCEDURE CUB (n:INTEGER) ;
(* cursorlf(n) CUB       Move cursor left n lines               ^[[<n>D *)


PROCEDURE Home() ;
(* cursorhome            Move cursor to upper left corner       ^[[H *)


PROCEDURE CUP (v:INTEGER; h:INTEGER) ;
(* cursorpos(v,h) CUP    Move cursor to screen location v,h     ^[[<v>;<h>H *)


PROCEDURE SavCur() ;
(* savecursor DECSC      Save cursor position and attributes    ^[7 *)


PROCEDURE RestCur() ;
(* restorecursor DECSC   Restore cursor position and attributes ^[8 *)


END vt100.
