UNSAFE MODULE Utex3 EXPORTS Main;

FROM IP IMPORT Address, Endpoint, GetHostByName, GetHostAddr ;
FROM TCP IMPORT  Connect, Close ;
FROM vt100 IMPORT Bell,  CSCDown, CUP, Normal, CLRight ;
FROM Text IMPORT GetChar, Equal, Sub, FindChar, SetChars, FromChars,
		 Cat, FromChar;
FROM Input IMPORT   PutErr;
FROM Tempo IMPORT  DataCT, OraT;
FROM Fmt  IMPORT Style, LongReal;
FROM MD2  IMPORT MD2Code;
FROM Convert IMPORT FromInt, ToLongFloat, FromLongFloat ;
IMPORT IO, Rd, Wr, Thread, Process, OSError, ConnFD,
       ConnMsgRW, MsgRd, MsgWr ;
IMPORT Usignal;
IMPORT Tempo, Time, Params, Fmt, IP, File, FileWr, Convert;

(* < > -_ \ | $ / ' ~ ` ^ *)

<*FATAL IO.Error *>
<*FATAL Rd.Failure *>
<*FATAL Wr.Failure *>
<*FATAL IP.Error *>
<*FATAL Rd.EndOfFile *>
<*FATAL Thread.Alerted *>
<*FATAL OSError.E *>
<*FATAL Convert.Failed *>

VAR
    Str, CodiceC, PassW, Tipo, CodH, CodTess : TEXT;
    FileR, FileTess : Rd.T;
    FileL : Wr.T;
    AddLocale   : Address;
    MutCon : MUTEX; (* Per l'uso di Write *)
	id : Process.ID;
	Processo : Process.T;
	Secondi : LONGREAL;
	Scaduta : BOOLEAN;
	TempoUsato : TEXT;
	Start, TUsato : LONGREAL ;
	MaxT, Passato : LONGREAL ;
	LocalHost : BOOLEAN;
	nick : TEXT;
CONST
      FileBAR =    (* "BAR.BAR" *)  "/usr/bar/BAR.BAR"      ;
      Spazi = "                                                                                ";
(*    Durate = ARRAY['A'..'D'] OF LONGREAL  {5.0d0, 5.0d0, 15.0d0, 10.0d0 };*)
      Durate = ARRAY['A'..'D'] OF LONGREAL  {30.0d0, 60.0d0, 15.0d0, 10.0d0 };



PROCEDURE ToHex(Text:TEXT): TEXT =
TYPE
	BYTE = [0..255];

VAR	i : CARDINAL;
	X : ARRAY [0..15] OF BYTE;
  	CodeSt : ARRAY[1..32] OF CHAR;
  	CC     : ARRAY[0..15] OF CHAR;

(* ---------- Procedura Interna --------------------------*)
PROCEDURE NbHex (Nibble:BYTE):CHAR =
(* Azione: Converte un nibble in carattere esadecimale *)
BEGIN
	IF Nibble < 10 THEN
		RETURN VAL(Nibble+48, CHAR)  (* Cifra *)
	ELSE
		RETURN VAL(Nibble+87, CHAR); (* Lettera minuscola *)
	END;
END NbHex;
(* ----Fine   Procedura Interna --------------------------*)


BEGIN
	SetChars(CC,Text);
	(* Converti X[0..15] in una stringa esadecimale di 2*16 caratteri *)
	i := 0; (* Contatore *)
	WHILE i <= 15 DO
		       (* Converti da BYTE a Hex *)
		        X[i] := ORD(CC[i]);
			CodeSt[2*i+1] := NbHex (X[i] DIV 16);
			CodeSt[2*i+2] := NbHex (X[i] MOD 16);
			i := i + 1;
	END;
	RETURN  FromChars(CodeSt);
END ToHex;

(*--------------- Procedure X Chat -----------------------------------------*)


PROCEDURE ChiusuraTessera(Tes:TEXT)=
VAR Contenuto, Messaggio : TEXT;
    TipoMessaggio : CHAR;
BEGIN
  TipoMessaggio := VAL(4, CHAR);
  Contenuto :=  Tes ;
  Messaggio := Cat(FromChar(TipoMessaggio), Contenuto);
 TRY
  LOCK MutCon  DO
   Wr.PutText(HandWr,Messaggio);
   HandWr.nextMsg();
  END;
 EXCEPT Wr.Failure => LOG("utex3: No Chiusura Tessera: Wr.Failure");
		      RETURN ;
 END;
  RETURN ;
END ChiusuraTessera;


PROCEDURE Avvisatore(): Thread.T =
BEGIN
 RETURN Thread.Fork(NEW(Thread.Closure, apply := Terminator ));
END Avvisatore;


PROCEDURE Terminator(<*UNUSED*> closure:Thread.Closure): REFANY =
VAR Avv10, Avv5, Avv1 : BOOLEAN;
BEGIN
 Avv10 := FALSE; Avv5  := FALSE; Avv1  := FALSE;
 IF MaxT - TUsato <= 10.0d0 THEN Avv10 := TRUE; END;
 IF MaxT - TUsato <= 5.0d0  THEN Avv5  := TRUE; END;
 IF MaxT - TUsato <= 1.0d0  THEN Avv1  := TRUE; END;
 LOOP
     Thread.Pause(10.0d0);
     IF Thread.TestAlert() THEN RETURN NIL ;
     ELSE
	Passato := Time.Now()- Start;
	  (* Controlla il tempo usato *)
	 IF  TUsato + Passato / 60.0d0 > MaxT THEN
	      PutErr(9,1,Spazi);
	      PutErr(11,1,Spazi);
	      PutErr(10,25,"Tempo scaduto..... a presto !"); Normal();
	       f0m();
	       Thread.Pause(10.0d0);
	       (* ed alla fine uccide IRC *)
	      EVAL Usignal.kill(id+5, Usignal.SIGTERM);
	      EVAL Usignal.kill(id+3, Usignal.SIGTERM);
	      EVAL Usignal.kill(id+1, Usignal.SIGTERM);
	      EVAL Usignal.kill(id, Usignal.SIGTERM);
	      EXIT;
	 ELSIF MaxT - (TUsato + Passato / 60.0d0) <= 10.0d0 AND NOT Avv10 THEN
	       PutErr(1,50,"    10 minuti alla fine !!             ");
	       f10m();
	       Avv10 := TRUE;
	 ELSIF MaxT - (TUsato + Passato / 60.0d0) <= 5.0d0 AND NOT Avv5 THEN
	       PutErr(1,50,"     5 minuti alla fine !!             ");
	       f5m();
	       Avv5 := TRUE;
	 ELSIF MaxT - (TUsato + Passato / 60.0d0) <= 1.0d0 AND NOT Avv1 THEN
	       PutErr(1,50,"     1 minuto alla fine !!             ");
	       f1m();
	       Avv1 := TRUE;
	 END;
     END;
 END;
 (*  marca la tessera come esaurita *)
   DBStore(CodH, Tipo & "S" & "S" & "00" & Tempo.DataT());
	    (* Tessera esaurita *)
   Scaduta := TRUE;
   Thread.Pause(4.0d0);
   RETURN NIL;
END Terminator;


PROCEDURE T2L(st:TEXT): LONGREAL =
VAR Int : INTEGER;
    Buf : ARRAY[0..9] OF CHAR;
    Nch : INTEGER;
BEGIN
     IF GetChar(st,1) = ' ' THEN
	  Int := ORD(GetChar(st,0))-48 ;
     ELSE
	  Int := (ORD(GetChar(st,0))-48)*10 - (ORD(GetChar(st,1))-48);
     END;
	  Nch := FromInt(Buf,Int);
	  RETURN ToLongFloat(Buf,Nch);
END T2L;
(*--------------- Procedure X Chat -----------------------------------------*)

PROCEDURE Chat()=
VAR
    Av : Thread.T ;
    Buf : ARRAY[0..2] OF CHAR;
BEGIN
   DBFetch(CodH);
   Str := FetchDati();
       Tipo := Sub(Str,0,1);
 (*  TUsato := 0.0d0; *)
   MaxT := Durate[GetChar(Tipo,0)]; (* Se prima volta *)
   EVAL FromLongFloat(Buf,MaxT,3);
   TempoUsato := Sub(Str,3,2);
   TUsato := T2L(TempoUsato);   (* Minuti *)
IF Equal(TempoUsato, "00") THEN  (* Prima Volta *)
   DBStore(CodH, Tipo & "N" & "S" & "00" & Tempo.DataT());
   LOG("utex3: " & Tipo & "N" & "S" & "00" & Tempo.DataT());
ELSE
   DBStore(CodH, Tipo & "N" & "S" & TempoUsato & Tempo.DataT());
   LOG("utex3: " & Tipo & "N" & "S" & TempoUsato & Tempo.DataT());
END;

       Start := Time.Now();
       Av := Avvisatore();
       EVAL Process.Wait(Processo);
IF NOT Scaduta THEN   (* Registra il tempo usato e *)
    Thread.Alert(Av); (* Blocca l' Avvisatore      *)
    Secondi := Time.Now() - Start + (TUsato * 60.0d0);      (*#############*)
    TempoUsato := LongReal(Secondi/60.0d0, Style.Fix, 0, FALSE); (* in minuti *)
       CUP(9,1); CSCDown();
       CUP(10,25);IO.Put("    Tempo Usato: " & TempoUsato & "   minuti ");
       CUP(11,1); CLRight();
       CUP(11,25);IO.Put("    Hai ancora   " & LongReal(Durate[GetChar(Tipo,0)]- Secondi/60.0d0 , Style.Fix, 0, FALSE) & "   minuti ");
   DBStore(CodH, Tipo & "N" & "P" & Sub(TempoUsato & "   ",0,2) & Tempo.DataT() );
   LOG("utex3:" & Tipo & "N" & "P" & Sub(TempoUsato & "   ",0,2) & Tempo.DataT() );
	    (* Sospende l'uso *)
END;
    ChiusuraTessera(CodTess);
       Thread.Pause(5.0d0);
END Chat;


PROCEDURE Addr2Text(addr:Address): TEXT=
VAR   Add : TEXT;
BEGIN
 Add := "";
FOR i := 0 TO 2 DO
    Add := Cat(Add,Fmt.Int(addr.a[i]) & ".");
END;
    Add := Cat(Add,Fmt.Int(addr.a[3]) );
 RETURN Add;
END Addr2Text;

PROCEDURE LOG(St:TEXT ) =
BEGIN
  (*  CUP(23,1); CLRight(); Putyx(23,1,DataCT() & OraT() & St); *)
      (* Scrittura sul file di Log *)
    Wr.PutText(FileL,DataCT() & OraT() & St & "\n");
    Wr.Flush(FileL);
END LOG;


PROCEDURE Ping():BOOLEAN=
VAR Contenuto, Messaggio : TEXT;
    TipoMessaggio : CHAR;
BEGIN
IF OK AND HandWr # NIL THEN
  TipoMessaggio := VAL(0, CHAR);
  Contenuto :=  nick & " " & Addr2Text(AddLocale) ;
  Messaggio := Cat(FromChar(TipoMessaggio), Contenuto);
 TRY
  LOCK MutCon  DO
   Wr.PutText(HandWr,Messaggio);
   HandWr.nextMsg();
  END;
 EXCEPT Wr.Failure => LOG("utex3: No Ping: Wr.Failure");
		      RETURN FALSE;
 END;
  RETURN TRUE;
ELSE
 LOG("utex3: No Ping: server non connesso ");
END;
RETURN FALSE;
END Ping;

PROCEDURE Presentazione()=
VAR Contenuto, Messaggio : TEXT;
    TipoMessaggio : CHAR;
BEGIN
  TipoMessaggio := VAL(2, CHAR);
  Contenuto :=  nick & " " & Addr2Text(AddLocale) ;
  Messaggio := Cat(FromChar(TipoMessaggio), Contenuto);
 TRY
  LOCK MutCon  DO
   Wr.PutText(HandWr,Messaggio);
   HandWr.nextMsg();
  END;
 EXCEPT Wr.Failure => LOG("utex3: No Presentazione: Wr.Failure");
		      RETURN ;
 END;
  RETURN ;
END Presentazione;


VAR DatiDb, Fatto : TEXT;
    MutDati, MutFatto : MUTEX;



PROCEDURE DBFetch(key:TEXT)=
VAR Contenuto, Messaggio : TEXT;
    TipoMessaggio : CHAR;
BEGIN
  DatiDb := NIL;
  TipoMessaggio := VAL(5, CHAR);
  Contenuto :=  key ;
  Messaggio := Cat(FromChar(TipoMessaggio), Contenuto);
 TRY
  LOCK MutCon  DO
   Wr.PutText(HandWr,Messaggio);
   HandWr.nextMsg();
  END;
 EXCEPT Wr.Failure => LOG("utex3: No DBFetch: Wr.Failure");
		      RETURN ;
 END;
  RETURN ;
END DBFetch;

PROCEDURE DBStore(Key,Value:TEXT)=
VAR Contenuto, Messaggio : TEXT;
    TipoMessaggio : CHAR;
BEGIN
  Fatto := NIL;
  TipoMessaggio := VAL(6, CHAR);
  Contenuto :=  Key & Value ;
  Messaggio := Cat(FromChar(TipoMessaggio), Contenuto);
 TRY
  LOCK MutCon  DO
   Wr.PutText(HandWr,Messaggio);
   HandWr.nextMsg();
  END;
 EXCEPT Wr.Failure => LOG("utex3: No DBStore: Wr.Failure");
		      RETURN ;
 END;
  RETURN ;
END DBStore;


PROCEDURE FetchDati():  TEXT=
VAR Rit:TEXT;
BEGIN
 LOOP
  LOCK MutDati DO
     Rit := DatiDb ;
  END;
  IF Rit # NIL THEN EXIT END;
 END;
  IF Equal(Rit,"Niente") THEN RETURN NIL
  ELSE RETURN Rit
  END;
END FetchDati;


PROCEDURE RispFetch(Value:TEXT)=
BEGIN
  LOCK MutDati DO
     DatiDb := Value;
  END;
END RispFetch;




PROCEDURE RispStore(Value:TEXT)=
BEGIN
  LOCK MutFatto DO
     Fatto := Value;
  END;
END RispStore;


		       (* :::::::::::: *)
VAR
    Indirizzo   : Address;
    EndPoiServ  : Endpoint;
    Connessione : ConnFD.T;
    HandRd      : MsgRd.T;
    HandWr      : MsgWr.T;
    Servente    : TEXT;
    OK : BOOLEAN;   (* Connessione col server attiva  'client' *)


PROCEDURE ConnettiClient() =
BEGIN
  EVAL Thread.Fork(NEW(Thread.Closure, apply := ConServ ));
END ConnettiClient;


PROCEDURE ConServ(<*UNUSED*> closure:Thread.Closure): REFANY=
BEGIN
IF GetHostByName(Servente, Indirizzo) THEN
   LOG("utex3: Indirizzo del client: " & Addr2Text(Indirizzo));
   EndPoiServ.addr := Indirizzo;
   EndPoiServ.port := 6669;

LOOP
    OK := FALSE;
    REPEAT
     TRY
       Connessione := Connect(EndPoiServ);     (*  *)
       OK := TRUE;
       Bell(); LOG("utex3: Connessione avvenuta  ");
     EXCEPT IP.Error => OK := FALSE;
     END;
    UNTIL OK;


    HandRd := ConnMsgRW.NewRd(Connessione);
    HandWr := ConnMsgRW.NewWr(Connessione);

    AttesaMessaggi(HandRd, HandWr);  (* processo *)

    Presentazione();
     WHILE  Ping() DO

	    Thread.Pause(10.0d0);
     END;
      HandWr := NIL;
      HandRd := NIL;
      LOG("utex3: Sconnessione avvenuta ");

  Close(Connessione);
END (* loop *);
ELSE LOG("utex3: Indirizzo del servente non trovato ! ");
END (* if *);
RETURN NIL;
END ConServ;

		       (* :::::::::::: *)

  TYPE ConClosure = Thread.Closure
			   OBJECT
			     Read : MsgRd.T;
			     Write: MsgWr.T;
			   METHODS END;

PROCEDURE AttesaMessaggi(Hrd: MsgRd.T; Hwr: MsgWr.T ) =
BEGIN
  EVAL Thread.Fork(NEW(ConClosure, apply := GestioneMessaggi,
				   Read  := Hrd,
				   Write := Hwr
		       ));
END AttesaMessaggi;

PROCEDURE GestioneMessaggi(clo:ConClosure):REFANY =
VAR
    NM : CARDINAL; (* Numero Messaggio (tipo) *)
    Fine : BOOLEAN;
    FineMessaggio : BOOLEAN;
    ch  : CHAR;
    Messaggio : TEXT;
    SelfT  : Thread.T;  (* se stesso *)

  PROCEDURE GetMessage()=                (* Procedura interna *)
  BEGIN
   LOOP                                   (* Recupera il messaggio *)
    TRY
     ch := Rd.GetChar(clo.Read); (* Legge i caratteri del messaggio *)
     Messaggio := Cat(Messaggio, FromChar(ch));
    EXCEPT   Rd.EndOfFile => FineMessaggio := TRUE; EXIT;
	   | Rd.Failure   => Fine := TRUE;          EXIT;
    END;
   END;
 END GetMessage;

BEGIN
 SelfT := Thread.Self();
 Fine := FALSE; FineMessaggio:=FALSE;

REPEAT
   TRY
     REPEAT
     UNTIL clo.Read.nextMsg();               (* Attende un messaggio *)
   EXCEPT  Rd.Failure => Fine := TRUE;
			 HandWr := NIL;   HandRd := NIL;
	                 LOG("utex3: (p1) Fine Connessione  " ); EXIT;
	   | Thread.Alerted   => Fine := TRUE;
   END;

   Messaggio := "";

    TRY
     ch := Rd.GetChar(clo.Read); (* Legge il primo carattere...tipo messaggio *)
    EXCEPT   Rd.EndOfFile => FineMessaggio := TRUE;
	   | Rd.Failure   => Fine := TRUE;
	   | Thread.Alerted   => Fine := TRUE;
    END;

    NM := ORD(ch); (* Numero di Messaggio *)
    CASE NM OF
	   0 => GetMessage(); (*RispondiPing(clo.Write, MutCon, Messaggio);*)
	|  1 => GetMessage(); (*RispostaAPing();*)
	|  3 => GetMessage(); (*Sconnessione(Messaggio);*)
	|  4 => GetMessage(); (*Avviso(Messaggio);*)
	| 15 => GetMessage(); RispFetch(Messaggio);
	| 16 => GetMessage(); RispStore(Messaggio);
    ELSE
	LOG("utex3: Ricevuto Messaggio di tipo sconosciuto");
    END;


    IF FineMessaggio THEN

    ELSE
	HandWr := NIL;   HandRd := NIL;
	LOG("utex3: (p2) Fine Connessione  ");
    END;

UNTIL Fine ;
RETURN NIL;
END GestioneMessaggi;
		       (* :::::::::::: *)
(*
PROCEDURE Lancio()=
VAR     Param : ARRAY[0..1] OF TEXT;
	sio, sout, ser : File.T;
BEGIN
	 Param[0] := "/root/.xinitrc2" ;
	 Param[1] := "-- /usr/X11R6/bin/X" ;
    Process.GetStandardFileHandles(sio,sout,ser);
    Processo := Process.Create("/usr/X11R6/bin/xinit", Param,  stdin:= sio, stdout := sout , stderr:= ser);
    id := Process.GetID(Processo) ;
END Lancio;
*)
PROCEDURE Lancio()=
VAR     Param : ARRAY[0..4] OF TEXT;
	sio, sout, ser : File.T;
BEGIN
	 Param[0] := "/usr/bar/X/xinitrc2" ;
	 Param[1] := "--" ;
	 Param[2] := "/usr/X11R6/bin/X" ;
	 Param[3] := "-s" ;
	 Param[4] := "0" ;
    Process.GetStandardFileHandles(sio,sout,ser);
    Processo := Process.Create("/usr/X11R6/bin/xinit", Param,  stdin:= sio, stdout := sout , stderr:= ser);
    id := Process.GetID(Processo) ;
END Lancio;

PROCEDURE f10m()=
VAR     Param : ARRAY[0..0] OF TEXT;
	sio, sout, ser : File.T;
	Proc :Process.T;
BEGIN
	 Param[0] := NIL ;
    Process.GetStandardFileHandles(sio,sout,ser);
    Proc := Process.Create("/usr/bar/10minuti.tcl", Param,  stdin:= sio, stdout := sout , stderr:= ser);
END f10m;

PROCEDURE f5m()=
VAR     Param : ARRAY[0..1] OF TEXT;
	sio, sout, ser : File.T;
	Proc :Process.T;
BEGIN
	 Param[0] := "-f" ;
	 Param[1] := "/usr/bar/5minuti.tcl" ;
    Process.GetStandardFileHandles(sio,sout,ser);
    Proc := Process.Create("/usr/local/bin/wish", Param,  stdin:= sio, stdout := sout , stderr:= ser);
END f5m;

PROCEDURE f1m()=
VAR     Param : ARRAY[0..1] OF TEXT;
	sio, sout, ser : File.T;
	Proc :Process.T;
BEGIN
	 Param[0] := "-f" ;
	 Param[1] := "/usr/bar/1minuto.tcl" ;
    Process.GetStandardFileHandles(sio,sout,ser);
    Proc := Process.Create("/usr/local/bin/wish", Param,  stdin:= sio, stdout := sout , stderr:= ser);
END f1m;

PROCEDURE f0m()=
VAR     Param : ARRAY[0..1] OF TEXT;
	sio, sout, ser : File.T;
	Proc :Process.T;
BEGIN
	 Param[0] := "-f" ;
	 Param[1] := "/usr/bar/t_scaduto.tcl" ;
    Process.GetStandardFileHandles(sio,sout,ser);
    Proc := Process.Create("/usr/local/bin/wish", Param,  stdin:= NIL, stdout := NIL , stderr:= NIL);
END f0m;



(*#########################################################################*)
BEGIN

	IF Params.Count = 1 THEN LocalHost := TRUE;
				 Servente := "localhost";
	ELSIF Equal(Params.Get(1), "CRAM") THEN LocalHost := FALSE;
				 Servente := "client";
	   ELSE LocalHost := TRUE;
		Servente := "localhost";
	END;


   FileR := IO.OpenRead("/etc/HOSTNAME");
   Str := IO.GetLine(FileR);
   Rd.Close(FileR);
     nick := Sub(Str,0, FindChar(Str,'.')) ;

	(* Inizializza il File di LOG *)
   IF LocalHost  THEN
       FileL := FileWr.OpenAppend("Utente.LOG");
   ELSE
       FileL := FileWr.OpenAppend("/usr/bar/" & nick & ".Utente.LOG");
   END;

   FileR := IO.OpenRead(FileBAR);
   Str := IO.GetLine(FileR);
   Rd.Close(FileR);
   CodiceC := Sub(Str,0,7);
   PassW   := Sub(Str,7,8);

(* Recupera il codice tessera *)
       FileTess := IO.OpenRead("/tmp/Utex2.Tess");
   CodTess := Rd.GetText(FileTess, 13);
   LOG("utex3: Tessera " & CodTess);

   CodH := ToHex(MD2Code(CodiceC & CodTess & PassW));

 MutCon   := NEW(MUTEX);
 MutDati  := NEW(MUTEX);
 MutFatto := NEW(MUTEX);

   AddLocale := GetHostAddr();
   ConnettiClient();

     Thread.Pause(5.0d0);
(* Lancio di X Windows con menu' completo *)
   Lancio();

     Chat();

LOG("utex3: Fine Chat ");
   Wr.Close(FileL);

END Utex3.
