MODULE Utex2 EXPORTS Main;


FROM IP IMPORT Address, Endpoint, GetHostByName, GetHostAddr ;
FROM TCP IMPORT  Connect, Close ;
FROM Text IMPORT GetChar, Length, SetChars, FromChars, Equal, Sub, FindChar,
		 Cat, FromChar;
FROM Convert IMPORT FromInt, ToLongFloat, FromLongFloat ;
FROM Tempo IMPORT  DataCT, OraT;
FROM MD2  IMPORT MD2Code;

IMPORT IO,  Wr, Stdio,  Process, OSError, RdUtils, ConnFD,
       ConnMsgRW, MsgRd, MsgWr ;
IMPORT Usignal, Convert;
IMPORT Tempo, Random, Params,  IP, File, FileWr;

IMPORT CalculatorBundle, FloatMode, Fmt, FormsVBT, Lex, Rd, Rsrc, Scan, Text,
       Thread, Trestle, TrestleComm, VBT;

<*FATAL IO.Error *>
<*FATAL Wr.Failure *>
<*FATAL IP.Error *>
<*FATAL Rd.EndOfFile *>
<*FATAL OSError.E *>
<*FATAL Convert.Failed *>

<* FATAL FormsVBT.Error, FormsVBT.Unimplemented *>
<* FATAL Rd.Failure, Rsrc.NotFound, Thread.Alerted, TrestleComm.Failure *>
<* FATAL Lex.Error, FloatMode.Trap *>


VAR OroHand : Thread.T;
    Str, CodiceC, PassW, CT, Tipo, CodH, CodTess : TEXT;
    FileR : Rd.T;
    FileL : Wr.T;
    AddLocale   : Address;
    MutCon : MUTEX; (* Per l'uso di Write *)
	id, id_utex1 : Process.ID;
	Codice : TEXT;
	TempoUsato : TEXT;
	TUsato : LONGREAL ;
	MaxT : LONGREAL ;
	LocalHost : BOOLEAN;
	nick : TEXT;
     fv      : FormsVBT.T;

CONST
      FileBAR =   (*  "BAR.BAR" *)  "/usr/bar/BAR.BAR"     ;
(*      Durate = ARRAY['A'..'D'] OF LONGREAL  {5.0d0, 5.0d0, 15.0d0, 10.0d0 };*)
	Durate = ARRAY['A'..'D'] OF LONGREAL  {30.0d0, 60.0d0, 15.0d0, 10.0d0 };

(*###########################################################################*)
TYPE
  Closure = REF RECORD
    memory:   INTEGER;
    operator: Text.T;
    building: BOOLEAN;
  END;


PROCEDURE NewForm (): FormsVBT.T =
  VAR
    form := NEW(FormsVBT.T).initFromRsrc(
	      "utex2.fv",
	      Rsrc.BuildPath(
		"$CALCULATORPATH", CalculatorBundle.Get()));
    cl := NEW(Closure);
  BEGIN
	       LOG("Begin NewForm");
  FormsVBT.AttachProc(form, "ok", Leggi);
	       LOG("Attach NewForm");
    cl.memory := 0;
    cl.operator := "NOOP";
    cl.building := FALSE;
    VBT.PutProp(form, cl);
    RETURN form;
  END NewForm;

PROCEDURE Leggi (
		 fvi      : FormsVBT.T;
    <* UNUSED *> event   : Text.T;
    <* UNUSED *> closure : REFANY;
    <* UNUSED *> time    : VBT.TimeStamp) =
 VAR Codice : TEXT;
  BEGIN
    fv := fvi ;
    Codice := FormsVBT.GetText(fv, "codice");
 (*   IO.Put(Codice); *)
    IF LogIn(Codice) THEN Chat() END;


 (*    FormsVBT.PutText(fv, "testo", Codice);*)
   (* Trestle.Delete (fv)*)
  END Leggi;

(*###########################################################################*)




PROCEDURE ToHex(Text:TEXT): TEXT =
TYPE
	BYTE = [0..255];

VAR	i : CARDINAL;
	X : ARRAY [0..15] OF BYTE;
  	CodeSt : ARRAY[1..32] OF CHAR;
  	CC     : ARRAY[0..15] OF CHAR;

(* ---------- Procedura Interna --------------------------*)
PROCEDURE NbHex (Nibble:BYTE):CHAR =
(* Azione: Converte un nibble in carattere esadecimale *)
BEGIN
	IF Nibble < 10 THEN
		RETURN VAL(Nibble+48, CHAR)  (* Cifra *)
	ELSE
		RETURN VAL(Nibble+87, CHAR); (* Lettera minuscola *)
	END;
END NbHex;
(* ----Fine   Procedura Interna --------------------------*)


BEGIN
	SetChars(CC,Text);
	(* Converti X[0..15] in una stringa esadecimale di 2*16 caratteri *)
	i := 0; (* Contatore *)
	WHILE i <= 15 DO
		       (* Converti da BYTE a Hex *)
		        X[i] := ORD(CC[i]);
			CodeSt[2*i+1] := NbHex (X[i] DIV 16);
			CodeSt[2*i+2] := NbHex (X[i] MOD 16);
			i := i + 1;
	END;
	RETURN  FromChars(CodeSt);
END ToHex;

(*
PROCEDURE RandBAR(<*UNUSED*> closure:Thread.Closure): REFANY =
VAR Y,X :INTEGER;
BEGIN
 WITH rand = NEW(Random.Default).init(TRUE) DO
  LOOP
     IF Thread.TestAlert() THEN RETURN NIL; END;
     Y := rand.integer(4,21);
     X := rand.integer(1,73);
	Bold();
	 Putyx(Y,X,"Bar.Net");
	Normal();
     CUPyx(23,18);
 Thread.Pause(1.3330d0);
    Putyx(Y,X,"       ");
  END;
 END;
END RandBAR;

PROCEDURE BARNET(): Thread.T =
BEGIN
 RETURN Thread.Fork(NEW(Thread.Closure, apply := RandBAR ));
END BARNET;


PROCEDURE Logo()=
VAR Dum : CHAR;
      Tr  : Thread.T;
BEGIN
       CLS(); Home();
			(*   CUP(1,3); IO.PutInt(id); *)
       CUP(2,2);Tempo.PutData();
     Tr := BARNET();
     IF LocalHost THEN
       CUPyx(23,1);IO.Put("Batti un tasto...");CUPyx(23,18);
     ELSE
       CUPyx(23,1);IO.Put("Batti INVIO...");CUPyx(23,18);
     END;
     Dum := Rd.GetChar(Stdio.stdin);
     Bell();
     Thread.Alert(Tr);
END Logo;
*)

PROCEDURE LogIn(CT:TEXT): BOOLEAN =
VAR (* Dum : CHAR;*)
    rc  : INTEGER;
BEGIN
IF HandWr # NIL THEN
     IF Equal(CT, "") THEN FormsVBT.PutText(fv, "testo", "Lunghezza nulla !");
     ELSIF Length(CT) # 16 THEN
			    FormsVBT.PutText(fv, "testo", "Lunghezza errata !");
     ELSE
	 rc :=  VerificaCT(CT);      LOG("Tessera " & Codice);
	 IF rc = 0 THEN NuovaTessera(CT);
			RETURN TRUE; (* Login OK *)
	 ELSIF rc = -1 THEN FormsVBT.PutText(fv, "testo","Manca il Data Base Tessere !");
	 ELSIF rc = 1  THEN FormsVBT.PutText(fv, "testo","Tessera inesistente !");
	 ELSIF rc = 2  THEN FormsVBT.PutText(fv, "testo","Tessera esaurita !");
	 ELSIF rc = 3  THEN FormsVBT.PutText(fv, "testo","Tessera in uso !");
	 ELSIF rc = 4  THEN FormsVBT.PutText(fv, "testo","Tessera parzialmente usata !");
			    NuovaTessera(CT);
			    RETURN TRUE;
	 END;
     END;

  RETURN FALSE; (* Login fallito *)
ELSE
  FormsVBT.PutText(fv, "testo","Spiacente... non sono connesso al servente del locale ");
  RETURN FALSE;
END;
END LogIn;


PROCEDURE VerificaCT(Cod:TEXT): INTEGER =
VAR Ap : ARRAY[0..12] OF CHAR;
    Dati, InUso, Esaurita : TEXT;
BEGIN
       Ap[0] := GetChar(Cod,0);  (* elimina gli spazi *)

       Ap[1] := GetChar(Cod,2);
       Ap[2] := GetChar(Cod,3);
       Ap[3] := GetChar(Cod,4);
       Ap[4] := GetChar(Cod,5);

       Ap[5] := GetChar(Cod,7);
       Ap[6] := GetChar(Cod,8);
       Ap[7] := GetChar(Cod,9);
       Ap[8] := GetChar(Cod,10);

       Ap[9] := GetChar(Cod,12);
       Ap[10] := GetChar(Cod,13);
       Ap[11] := GetChar(Cod,14);
       Ap[12] := GetChar(Cod,15);
   FOR i := 0 TO 12 DO
	    Ap[i] := RdUtils.ToUpperCaseASCII(Ap[i]);
   END;
   Cod := FromChars(Ap); (* Codice tessera introdotto dall'utente *)
   Codice := Cod;
  (* IF LocalHost = FALSE THEN CUP(6,1);IO.Put("CRAM Attiva") END;*) (* ################*)
 (*CUP(2,1); IO.Put(Cod); *)                     (* ----------############ *)
   CodH := ToHex(MD2Code(CodiceC & Cod & PassW));
  (* CodH := Cod ;*)
   CodTess := Cod;
 (*CUP(3,1); IO.Put(CodH);  *)                      (* ----------############ *)
   DBFetch(CodH);
   Dati := FetchDati();
   IF Dati = NIL THEN RETURN 1 ;
   ELSE
   (* CUP(4,1);IO.Put(Dati);  *)                     (* ----------############ *)
	(* Analizza i dati letti *)
       Tipo := Sub(Dati,0,1);
       Esaurita := Sub(Dati,1,1);
       InUso    := Sub(Dati,2,1);
       IF    Equal(Esaurita,"S") THEN RETURN 2;
       ELSIF Equal(InUso,"S")    THEN RETURN 3;
       ELSIF Equal(InUso,"P")    THEN RETURN 4;
       ELSE                           RETURN 0;
       END;
   END;
END VerificaCT;

(*--------------- Procedure X Chat -----------------------------------------*)

PROCEDURE T2L(st:TEXT): LONGREAL =
VAR Int : INTEGER;
    Buf : ARRAY[0..9] OF CHAR;
    Nch : INTEGER;
BEGIN
     IF GetChar(st,1) = ' ' THEN
	  Int := ORD(GetChar(st,0))-48 ;
     ELSE
	  Int := (ORD(GetChar(st,0))-48)*10 - (ORD(GetChar(st,1))-48);
     END;
	  Nch := FromInt(Buf,Int);
	  RETURN ToLongFloat(Buf,Nch);
END T2L;
(*--------------- Procedure X Chat -----------------------------------------*)
PROCEDURE PassaTessera()=
VAR    FileTess : Wr.T;
       Buf : ARRAY[0..12] OF CHAR;
BEGIN
       FileTess := FileWr.Open("/tmp/Utex2.Tess");
(*   IF LocalHost  THEN
       FileTess := FileWr.Open("Utex2.Tess");
   ELSE
       FileTess := FileWr.Open("/usr/bar/" & nick & ".Utex2.Tess");
   END;
*)
   SetChars(Buf,CodTess);
   Wr.PutString(FileTess, Buf);
   Wr.Close(FileTess);
END PassaTessera;


PROCEDURE Chat()=
 VAR
   Buf : ARRAY[0..2] OF CHAR;
BEGIN
    PassaTessera();  (* a utex3 *)
  (* TUsato := 0.0d0;*)
   MaxT := Durate[GetChar(Tipo,0)]; (* Se prima volta *)
   EVAL FromLongFloat(Buf,MaxT,3);
   DBFetch(CodH);
   Str := FetchDati();
   TempoUsato := Sub(Str,3,2);
IF Equal(TempoUsato, "00") THEN  (* Prima Volta *)
   DBStore(CodH, Tipo & "N" & "S" & "00" & Tempo.DataT());
   LOG("Utex2: "& Tipo & "N" & "S" & "00" & Tempo.DataT());
ELSE
   (*TUsato := T2L(TempoUsato);*)
   DBStore(CodH, Tipo & "N" & "S" & TempoUsato & Tempo.DataT());
   LOG("Utex2: " & Tipo & "N" & "S" & TempoUsato & Tempo.DataT());
END;
			       (* Inizia l'uso *)
      (* Thread.Pause(10.0d0);*) (* ###################----------------------*)
    (*  CLS(); Home();

       CUPyx(24,3);*)

       FormsVBT.PutText(fv, "testo","Tessera da " & FromChars(Buf) & " minuti");
      (* CUP(7,1); IO.Put("Connessione in corso, ...attendere qualche secondo");*)
IF NOT Equal(TempoUsato, "00") THEN  (* Non e' la Prima Volta *)
       FormsVBT.PutText(fv, "testo","Tessera gia' usata per " & TempoUsato & " minuti");
END;
       Thread.Pause(5.0d0);

  (*     Lancio_x3();  (* utex3 *)
       Thread.Pause(2.0d0);*)
			   (* SUICIDIO *)
	      EVAL Usignal.kill(id_utex1, Usignal.SIGTERM);
	      EVAL Usignal.kill(id+5, Usignal.SIGTERM);
	      EVAL Usignal.kill(id+3, Usignal.SIGTERM);
	      EVAL Usignal.kill(id+1, Usignal.SIGTERM);
	      EVAL Usignal.kill(id, Usignal.SIGTERM);

END Chat;


PROCEDURE Addr2Text(addr:Address): TEXT=
VAR   Add : TEXT;
BEGIN
 Add := "";
FOR i := 0 TO 2 DO
    Add := Cat(Add,Fmt.Int(addr.a[i]) & ".");
END;
    Add := Cat(Add,Fmt.Int(addr.a[3]) );
 RETURN Add;
END Addr2Text;

PROCEDURE LOG(St:TEXT ) =
BEGIN
  (*  CUP(23,1); CLRight(); Putyx(23,1,DataCT() & OraT() & St); *)
      (* Scrittura sul file di Log *)
    Wr.PutText(FileL,DataCT() & OraT() & St & "\n");
    Wr.Flush(FileL);
END LOG;


PROCEDURE Ping():BOOLEAN=
VAR Contenuto, Messaggio : TEXT;
    TipoMessaggio : CHAR;
BEGIN
IF OK AND HandWr # NIL THEN
  TipoMessaggio := VAL(0, CHAR);
  Contenuto :=  nick & " " & Addr2Text(AddLocale) ;
  Messaggio := Cat(FromChar(TipoMessaggio), Contenuto);
 TRY
  LOCK MutCon  DO
   Wr.PutText(HandWr,Messaggio);
   HandWr.nextMsg();
  END;
 EXCEPT Wr.Failure => LOG("No Ping: Wr.Failure");
		      RETURN FALSE;
 END;
  RETURN TRUE;
ELSE
 LOG("No Ping: server non connesso ");
END;
RETURN FALSE;
END Ping;

PROCEDURE Presentazione()=
VAR Contenuto, Messaggio : TEXT;
    TipoMessaggio : CHAR;
BEGIN
  TipoMessaggio := VAL(2, CHAR);
  Contenuto :=  nick & " " & Addr2Text(AddLocale) ;
  Messaggio := Cat(FromChar(TipoMessaggio), Contenuto);
 TRY
  LOCK MutCon  DO
   Wr.PutText(HandWr,Messaggio);
   HandWr.nextMsg();
  END;
 EXCEPT Wr.Failure => LOG("No Presentazione: Wr.Failure");
		      RETURN ;
 END;
  RETURN ;
END Presentazione;

PROCEDURE NuovaTessera(Tes:TEXT)=
VAR Contenuto, Messaggio : TEXT;
    TipoMessaggio : CHAR;
BEGIN
  TipoMessaggio := VAL(3, CHAR);
  Contenuto :=  Tes ;
  Messaggio := Cat(FromChar(TipoMessaggio), Contenuto);
 TRY
  LOCK MutCon  DO
   Wr.PutText(HandWr,Messaggio);
   HandWr.nextMsg();
  END;
 EXCEPT Wr.Failure => LOG("No Nuova Tessera: Wr.Failure");
		      RETURN ;
 END;
  RETURN ;
END NuovaTessera;

VAR DatiDb, Fatto : TEXT;
    MutDati, MutFatto : MUTEX;

PROCEDURE DBFetch(key:TEXT)=
VAR Contenuto, Messaggio : TEXT;
    TipoMessaggio : CHAR;
BEGIN
  DatiDb := NIL;
  TipoMessaggio := VAL(5, CHAR);
  Contenuto :=  key ;
  Messaggio := Cat(FromChar(TipoMessaggio), Contenuto);
 TRY
  LOCK MutCon  DO
   Wr.PutText(HandWr,Messaggio);
   HandWr.nextMsg();
  END;
 EXCEPT Wr.Failure => LOG("No DBFetch: Wr.Failure");
		      RETURN ;
 END;
  RETURN ;
END DBFetch;


PROCEDURE DBStore(Key,Value:TEXT)=
VAR Contenuto, Messaggio : TEXT;
    TipoMessaggio : CHAR;
BEGIN
  Fatto := NIL;
  TipoMessaggio := VAL(6, CHAR);
  Contenuto :=  Key & Value ;
  Messaggio := Cat(FromChar(TipoMessaggio), Contenuto);
 TRY
  LOCK MutCon  DO
   Wr.PutText(HandWr,Messaggio);
   HandWr.nextMsg();
  END;
 EXCEPT Wr.Failure => LOG("No DBStore: Wr.Failure");
		      RETURN ;
 END;
  RETURN ;
END DBStore;


PROCEDURE RispFetch(Value:TEXT)=
BEGIN
  LOCK MutDati DO
     DatiDb := Value;
  END;
END RispFetch;


PROCEDURE FetchDati():  TEXT=
VAR Rit:TEXT;
BEGIN
 LOOP
  LOCK MutDati DO
     Rit := DatiDb ;
  END;
  IF Rit # NIL THEN EXIT END;
 END;
  IF Equal(Rit,"Niente") THEN RETURN NIL
  ELSE RETURN Rit
  END;
END FetchDati;


PROCEDURE RispStore(Value:TEXT)=
BEGIN
  LOCK MutFatto DO
     Fatto := Value;
  END;
END RispStore;


		       (* :::::::::::: *)
VAR
    Indirizzo   : Address;
    EndPoiServ  : Endpoint;
    Connessione : ConnFD.T;
    HandRd      : MsgRd.T;
    HandWr      : MsgWr.T;
    Servente    : TEXT;
    OK : BOOLEAN;   (* Connessione col server attiva  'client' *)


PROCEDURE ConnettiClient() =
BEGIN
  EVAL Thread.Fork(NEW(Thread.Closure, apply := ConServ ));
END ConnettiClient;


PROCEDURE ConServ(<*UNUSED*> closure:Thread.Closure): REFANY=
BEGIN
IF GetHostByName(Servente, Indirizzo) THEN
   LOG("Indirizzo del client: " & Addr2Text(Indirizzo));
   EndPoiServ.addr := Indirizzo;
   EndPoiServ.port := 6669;

LOOP
    OK := FALSE;
    REPEAT
     TRY
       Connessione := Connect(EndPoiServ);     (*  *)
       OK := TRUE;
       (*Bell();*) LOG("Connessione avvenuta  ");
     EXCEPT IP.Error => OK := FALSE;
     END;
    UNTIL OK;


    HandRd := ConnMsgRW.NewRd(Connessione);
    HandWr := ConnMsgRW.NewWr(Connessione);

    AttesaMessaggi(HandRd, HandWr);  (* processo *)

    Presentazione();
     WHILE  Ping() DO

	    Thread.Pause(10.0d0);
     END;
      HandWr := NIL;
      HandRd := NIL;
      LOG("Sconnessione avvenuta ");

  Close(Connessione);
END (* loop *);
ELSE LOG("Indirizzo del servente non trovato ! ");
END (* if *);
RETURN NIL;
END ConServ;

		       (* :::::::::::: *)

  TYPE ConClosure = Thread.Closure
			   OBJECT
			     Read : MsgRd.T;
			     Write: MsgWr.T;
			   METHODS END;

PROCEDURE AttesaMessaggi(Hrd: MsgRd.T; Hwr: MsgWr.T ) =
BEGIN
  EVAL Thread.Fork(NEW(ConClosure, apply := GestioneMessaggi,
				   Read  := Hrd,
				   Write := Hwr
		       ));
END AttesaMessaggi;

PROCEDURE GestioneMessaggi(clo:ConClosure):REFANY =
VAR
    NM : CARDINAL; (* Numero Messaggio (tipo) *)
    Fine : BOOLEAN;
    FineMessaggio : BOOLEAN;
    ch  : CHAR;
    Messaggio : TEXT;
    SelfT  : Thread.T;  (* se stesso *)

  PROCEDURE GetMessage()=                (* Procedura interna *)
  BEGIN
   LOOP                                   (* Recupera il messaggio *)
    TRY
     ch := Rd.GetChar(clo.Read); (* Legge i caratteri del messaggio *)
     Messaggio := Cat(Messaggio, FromChar(ch));
    EXCEPT   Rd.EndOfFile => FineMessaggio := TRUE; EXIT;
	   | Rd.Failure   => Fine := TRUE;          EXIT;
    END;
   END;
 END GetMessage;

BEGIN
 SelfT := Thread.Self();
 Fine := FALSE; FineMessaggio:=FALSE;

REPEAT
   TRY
     REPEAT
     UNTIL clo.Read.nextMsg();               (* Attende un messaggio *)
   EXCEPT  Rd.Failure => Fine := TRUE;
			 HandWr := NIL;   HandRd := NIL;
	                 LOG("(p1) Fine Connessione  " ); EXIT;
	   | Thread.Alerted   => Fine := TRUE;
   END;

   Messaggio := "";

    TRY
     ch := Rd.GetChar(clo.Read); (* Legge il primo carattere...tipo messaggio *)
    EXCEPT   Rd.EndOfFile => FineMessaggio := TRUE;
	   | Rd.Failure   => Fine := TRUE;
	   | Thread.Alerted   => Fine := TRUE;
    END;

    NM := ORD(ch); (* Numero di Messaggio *)
    CASE NM OF
	   0 => GetMessage(); (*RispondiPing(clo.Write, MutCon, Messaggio);*)
	|  1 => GetMessage(); (*RispostaAPing();*)
	|  3 => GetMessage(); (*Sconnessione(Messaggio);*)
	|  4 => GetMessage(); (*Avviso(Messaggio);*)
	| 15 => GetMessage(); RispFetch(Messaggio);
	| 16 => GetMessage(); RispStore(Messaggio);
    ELSE
	LOG("Ricevuto Messaggio di tipo sconosciuto");
    END;


    IF FineMessaggio THEN

    ELSE
	HandWr := NIL;   HandRd := NIL;
	LOG("(p2) Fine Connessione  ");
    END;

UNTIL Fine ;
RETURN NIL;
END GestioneMessaggi;
		       (* :::::::::::: *)
(*
PROCEDURE Lancio_x3()=
VAR     Param : ARRAY[0..1] OF TEXT;
     Processo : Process.T;
     sio, sout, ser : File.T;
BEGIN
	 Param[0] := NIL ;
	 Param[1] := NIL ;
    Process.GetStandardFileHandles(sio,sout,ser);
    Processo := Process.Create("/usr/bar/utex3", Param,  stdin:= NIL, stdout := NIL , stderr:= NIL);
END Lancio_x3;
*)
VAR
    FileID : Rd.T;
    Buf : ARRAY[0..4] OF CHAR;
    IDtxt : TEXT;
    nchar : INTEGER;
    Par_stty : ARRAY[0..0] OF TEXT;
    sio, sout, ser : File.T;
    Processo : Process.T;
(*#########################################################################*)



BEGIN
  WITH z = NewForm() DO
			 LOG("In With");
    Trestle.Install(z);
     (* Disabilita il Ctl-C  *)
(*       Par_stty[0] := "-isig";
       Process.GetStandardFileHandles(sio,sout,ser);
       Processo := Process.Create("stty", Par_stty, stdin:= sio, stdout := sout, stderr:=ser);
*)

(*
	IF Params.Count = 1 THEN LocalHost := TRUE;
				 Servente := "localhost";
	ELSIF Equal(Params.Get(1), "CRAM") THEN LocalHost := FALSE;
				 Servente := "client";
	   ELSE LocalHost := TRUE;
		Servente := "localhost";
	END;


   FileR := IO.OpenRead("/etc/HOSTNAME");
   Str := IO.GetLine(FileR);
   Rd.Close(FileR);
     nick := Sub(Str,0, FindChar(Str,'.')) ;

	(* Inizializza il File di LOG *)
   IF LocalHost  THEN
       FileL := FileWr.OpenAppend("Utente.LOG");
   ELSE
       FileL := FileWr.OpenAppend("/usr/bar/" & nick & ".Utente.LOG");
   END;

   FileR := IO.OpenRead(FileBAR);
   Str := IO.GetLine(FileR);
   Rd.Close(FileR);
   CodiceC := Sub(Str,0,7);
   PassW   := Sub(Str,7,8);
*)

(* Recupera l' ID di X Windows *)
(*     FileID := IO.OpenRead("/tmp/Utex1.ID");
   IDtxt := Rd.GetText(FileID, 5);
   SetChars(Buf,IDtxt);
   id := Convert.ToInt(Buf,nchar);
   LOG("ID = " & IDtxt);
*)

(* Recupera l' ID di utex1 *)
  (*     FileID := IO.OpenRead("/tmp/Utex1.IDmio");*)
(*
   IDtxt := Rd.GetText(FileID, 5);
   SetChars(Buf,IDtxt);
   id_utex1 := Convert.ToInt(Buf,nchar);
   LOG("ID utex1 = " & IDtxt);




 MutCon   := NEW(MUTEX);
 MutDati  := NEW(MUTEX);
 MutFatto := NEW(MUTEX);
   AddLocale := GetHostAddr();
   ConnettiClient();
			 LOG("Fine inizializzazione");
			 LOG("Fine Install");

*)

(*  OroHand := OrologioR(2,70);
      Logo();
      Thread.Alert(OroHand); CUP(2,70); CLRight(); *)
(*
   IF   LogIn() THEN
		   (*  Thread.Alert(OroHand); CUP(2,70); CLRight();*)
		     Chat();
	            (* Thread.Pause(20.0d0);*)
		    (* EXIT;*)
   ELSE
	PutErr(4,30,"Connessione fallita !");
	Thread.Pause(5.0d0);
		     Thread.Alert(OroHand); CUP(2,70); CLRight();
   END;
*)
    Trestle.AwaitDelete(z);
  END
END Utex2.
