MODULE Input;

FROM vt100 IMPORT  CUP, CLRight, Bell ;
FROM Text IMPORT GetChar, Length, SetChars, FromChars, Equal, Sub;
IMPORT  Rd, IO,  Stdio,  Thread, File ;
IMPORT Tempo;
IMPORT Process, OSError;

<*FATAL IO.Error *>
<*FATAL Rd.Failure *>
<*FATAL Rd.EndOfFile *>
<*FATAL Thread.Alerted *>
<*FATAL OSError.E *> 

TYPE     ErrClosure = Thread.Closure OBJECT Y:CARDINAL;
				            X:CARDINAL;
					    Err:TEXT;
				     METHODS END;
	 OroClosure = Thread.Closure OBJECT Y:CARDINAL;
					    X:CARDINAL;
				     METHODS END;

VAR     Param : ARRAY[0..0] OF TEXT;
	Processo : Process.T;
	sio, sout, ser : File.T;
	myx : MUTEX ;
	x, y : CARDINAL; (* Coordinate del cursore *)



PROCEDURE InpLine():TEXT=
VAR  i : CARDINAL;
     Ch : CHAR; 
     Chars : ARRAY[0..79] OF CHAR;
BEGIN
 i := 0;
 WHILE NOT Rd.EOF(Stdio.stdin) DO
	Ch := Rd.GetChar(Stdio.stdin);
	IF Ch # VAL(10,CHAR) THEN Chars[i] := Ch;
	ELSE EXIT;
	END;  
	INC(i); INC(x);
 END; 
 RETURN Sub(FromChars(Chars),0,i); 
END InpLine;


PROCEDURE InpInt():INTEGER =
VAR Str : TEXT;
    i, l, n, int, Pot, Y,X : INTEGER;
    ch : CHAR;
    Cifra : BOOLEAN;
BEGIN
Y := y; X := x;
REPEAT
      CUPyx(Y,X); CLRight();
      Str := InpLine();
    (* cerca la cifra piu' a destra *)
      l := Length(Str) ;
      i := 0;
      REPEAT
       ch := GetChar(Str, i);
       IF  (ORD(ch) < 48) OR (ORD(ch)> 57) THEN
						Cifra := FALSE
					   ELSE Cifra := TRUE
       END;
       INC(i);
      UNTIL (i = l) OR NOT Cifra ;
      IF NOT Cifra THEN DEC(i); END; 
UNTIL i # 0;
(*  CUP(9,1); IO.Put("######################### ");IO.PutInt(i);*)
      int := 0;
      Pot := 1;
	n := i-1;
	REPEAT
	   int := int + (ORD(GetChar(Str,n))-48) * Pot;
	   Pot := Pot * 10;
	   DEC(n);
	UNTIL n = -1;
(*  CUP(9,1); IO.Put("######################### ");IO.PutInt(int);*)

 RETURN int;
END InpInt;


PROCEDURE CUPyx(a,b:CARDINAL)=
BEGIN
    LOCK myx DO
      y := a;
      x := b;
    END;
      CUP(a,b);
END CUPyx;

(*..........Non provata......................................*)

PROCEDURE InpChars(N:CARDINAL): TEXT  =
VAR  n, i, k  : CARDINAL; 
     Chars : ARRAY[0..79] OF CHAR;
BEGIN
	LOOP
	    n:=Rd.CharsReady(Stdio.stdin);
	    IF n = N THEN
		      FOR k := 0 TO N-1 DO
		       Chars[k] := Rd.GetChar(Stdio.stdin);
		      END;
		      EXIT;
	    END;
	END;
	RETURN FromChars(Chars) ;
END InpChars;
(*................................................*)


(*   Esempio: senza parametri passati
PROCEDURE Orologio(<*UNUSED*> closure:Thread.Closure): REFANY = 
BEGIN
END Orologio;
*)


PROCEDURE Rolorio(closure:OroClosure): REFANY =
BEGIN
    LOOP
     IF Thread.TestAlert() THEN RETURN NIL;
     ELSE
      LOCK myx DO 
       CUP(closure.Y, closure.X);
       Tempo.PutOra(); IO.Put("  ");  CUP(y,x);
      END;
       Thread.Pause(1.0d0);
     END;
  END;
END Rolorio;

PROCEDURE Orologio(Yy,Xx : CARDINAL) =
BEGIN
 EVAL Thread.Fork(NEW(OroClosure,apply := Rolorio, Y:=Yy, X:=Xx ));  
END Orologio;


PROCEDURE OrologioR(Yy,Xx : CARDINAL): Thread.T =
BEGIN
 RETURN Thread.Fork(NEW(OroClosure,apply := Rolorio, Y:=Yy, X:=Xx ));  
END OrologioR;


PROCEDURE ErrP(cl:ErrClosure): REFANY =
BEGIN
       Bell();
      LOCK myx DO 
       CUP(cl.Y,cl.X);IO.Put(cl.Err); CUP(y,x);
      END;
       Thread.Pause(3.0d0);
      LOCK myx DO 
       CUP(cl.Y,cl.X);CLRight(); CUP(y,x);
      END;
       RETURN NIL ;
END ErrP;

PROCEDURE PutErr(Yy,Xx:CARDINAL; Errore:TEXT) =
BEGIN
 EVAL Thread.Fork(NEW(ErrClosure,apply := ErrP, Y:=Yy, X:=Xx, Err:=Errore ));  
END PutErr;

BEGIN
       Param[0] := "-icanon";
       Process.GetStandardFileHandles(sio,sout,ser);
       Processo := Process.Create("stty", Param, stdin:= sio, stdout := sout, stderr:=ser);
       myx := NEW(MUTEX); 
       y := 0; x := 0;
END Input.
