UNSAFE MODULE Utente EXPORTS Main;

FROM IP IMPORT Port, Address, Endpoint, GetHostByName, GetCanonicalByName,
	       GetCanonicalByAddr, GetHostAddr, NullEndPoint, NullPort,
	       NullAddress ;
FROM TCP IMPORT Refused, Closed, Timeout, ConnLost, NewConnector, GetEndPoint,
		CloseConnector, Connect, Accept, Close, Connector ;
FROM vt100 IMPORT NL, NLn, Bell, CLS, CSCDown, Home, CUP, CUD, Bold, Blink,
		  UnderL, RevVideo, Normal, CLLeft, CLRight, CL ;
FROM Text IMPORT GetChar, Length, SetChars, FromChars, Equal, Sub, FindChar,
		 Cat, FromChar;
FROM MD2  IMPORT MD2Code;
FROM Fmt  IMPORT Style, LongReal;
IMPORT IO, Rd, Wr, Stdio, Thread, Process, File, OSError, RdUtils, ConnFD,
       ConnRW, ConnMsgRW, MsgRd, MsgWr ;
FROM Input IMPORT  CUPyx, Putyx, InpLine, OrologioR, PutErr;
FROM Convert IMPORT FromInt, ToLongFloat, FromLongFloat ;
FROM Tempo IMPORT  DataCT, OraT;
IMPORT Usignal, Convert;
IMPORT Tempo, Time, Random, Params, Fmt, IP, FileWr;

(* < > -_ \ | $ / ' ~ ` ^ *)

<*FATAL IO.Error *>
<*FATAL Rd.Failure *>
<*FATAL Wr.Failure *>
<*FATAL Rd.EndOfFile *>
<*FATAL Thread.Alerted *>
<*FATAL OSError.E *>
<*FATAL Convert.Failed *>

VAR OroHand : Thread.T;
    Str, CodiceC, PassW, CT, Tipo, CodH : TEXT;
    FileR : Rd.T;
    FileL : Wr.T;
    AddLocale   : Address;
    MutCon : MUTEX; (* Per l'uso di Write *)
	id : Process.ID;
	Codice : TEXT;
	TempoUsato : TEXT;
	Scaduta : BOOLEAN;
	Secondi : LONGREAL;
	Start, TUsato : LONGREAL ;
	MaxT, Passato : LONGREAL ;
	LocalHost : BOOLEAN;
	nick : TEXT;
	x : CHAR;
CONST
      FileBAR =    (* "BAR.BAR"*)  "/usr/bar/BAR.BAR" ;
      Spazi = "                                                                                ";
(*    Durate = ARRAY['A'..'D'] OF LONGREAL  {14.0d0, 14.0d0, 15.0d0, 10.0d0 }; *)
      Durate = ARRAY['A'..'D'] OF LONGREAL  {30.0d0, 60.0d0, 15.0d0, 10.0d0 };


PROCEDURE ToHex(Text:TEXT): TEXT =
TYPE
	BYTE = [0..255];

VAR	i : CARDINAL;
	X : ARRAY [0..15] OF BYTE;
  	CodeSt : ARRAY[1..32] OF CHAR;
  	CC     : ARRAY[0..15] OF CHAR;

(* ---------- Procedura Interna --------------------------*)
PROCEDURE NbHex (Nibble:BYTE):CHAR =
(* Azione: Converte un nibble in carattere esadecimale *)
BEGIN
	IF Nibble < 10 THEN
		RETURN VAL(Nibble+48, CHAR)  (* Cifra *)
	ELSE
		RETURN VAL(Nibble+87, CHAR); (* Lettera minuscola *)
	END;
END NbHex;
(* ----Fine   Procedura Interna --------------------------*)


BEGIN
	SetChars(CC,Text);
	(* Converti X[0..15] in una stringa esadecimale di 2*16 caratteri *)
	i := 0; (* Contatore *)
	WHILE i <= 15 DO
		       (* Converti da BYTE a Hex *)
		        X[i] := ORD(CC[i]);
			CodeSt[2*i+1] := NbHex (X[i] DIV 16);
			CodeSt[2*i+2] := NbHex (X[i] MOD 16);
			i := i + 1;
	END;
	RETURN  FromChars(CodeSt);
END ToHex;


PROCEDURE RandBAR(<*UNUSED*> closure:Thread.Closure): REFANY =
VAR Y,X :INTEGER;
BEGIN
 WITH rand = NEW(Random.Default).init(TRUE) DO
  LOOP
     IF Thread.TestAlert() THEN RETURN NIL; END;
     Y := rand.integer(4,21);
     X := rand.integer(1,73);
	Bold();
	 Putyx(Y,X,"Bar.Net");
	Normal();
     CUPyx(23,18);
 Thread.Pause(1.3330d0);
    Putyx(Y,X,"       ");
  END;
 END;
END RandBAR;

PROCEDURE BARNET(): Thread.T =
BEGIN
 RETURN Thread.Fork(NEW(Thread.Closure, apply := RandBAR ));
END BARNET;


PROCEDURE Logo()=
VAR Dum : CHAR;
      Tr  : Thread.T;
BEGIN
       CLS(); Home();
       CUP(2,2);Tempo.PutData();
     Tr := BARNET();
     IF LocalHost THEN
       CUPyx(23,1);IO.Put("Batti un tasto...");CUPyx(23,18);
     ELSE
       CUPyx(23,1);IO.Put("Batti INVIO...");CUPyx(23,18);
     END;
     Dum := Rd.GetChar(Stdio.stdin);
     Bell();
     Thread.Alert(Tr);
END Logo;


PROCEDURE LogIn(): BOOLEAN =
VAR Dum : CHAR;
    rc  : INTEGER;
BEGIN
       CLS(); Home();
IF HandWr # NIL THEN
	Bold();
     CUPyx(9,1);IO.Put("Benvenuto nel mondo della Comunicazione !");
	Normal();
 LOOP
     CSCDown();
     CUPyx(20,1);IO.Put("Introduci il Codice della Tessera...");
     CUPyx(21,37);IO.Put("^ ^^^^ ^^^^ ^^^^");
     CUPyx(20,54);IO.Put("... poi premi INVIO");
     CUPyx(23,1);IO.Put("o INVIO per terminare...");

     CUPyx(20,37);
	    CT :=  InpLine(1) ;  (*IO.GetLine() *)
     IF Equal(CT, "") THEN EXIT ;
     ELSIF Length(CT) # 16 THEN PutErr(6,30,"Lunghezza errata !");
     ELSE
	 rc :=  VerificaCT(CT);      LOG("Tessera " & Codice);
	 IF rc = 0 THEN NuovaTessera(CT);
			RETURN TRUE; (* Login OK *)
	 ELSIF rc = -1 THEN PutErr(6,30,"Manca il Data Base Tessere !");
	 ELSIF rc = 1  THEN PutErr(6,30,"Tessera inesistente !");
	 ELSIF rc = 2  THEN PutErr(6,30,"Tessera esaurita !");
	 ELSIF rc = 3  THEN PutErr(6,30,"Tessera in uso !");
	 ELSIF rc = 4  THEN PutErr(6,30,"Tessera parzialmente usata !");
			    NuovaTessera(CT);
			    RETURN TRUE;
	 END;
     END;
 END;
  RETURN FALSE; (* Login fallito *)
ELSE
  PutErr(6,20,"Spiacente...il servente del locale e' spento");
  RETURN FALSE;
END;
END LogIn;


PROCEDURE VerificaCT(Cod:TEXT): INTEGER =
VAR Ap : ARRAY[0..12] OF CHAR;
    i : CARDINAL;
    Dati, InUso, Esaurita : TEXT;
BEGIN
       Ap[0] := GetChar(Cod,0);  (* elimina gli spazi *)

       Ap[1] := GetChar(Cod,2);
       Ap[2] := GetChar(Cod,3);
       Ap[3] := GetChar(Cod,4);
       Ap[4] := GetChar(Cod,5);

       Ap[5] := GetChar(Cod,7);
       Ap[6] := GetChar(Cod,8);
       Ap[7] := GetChar(Cod,9);
       Ap[8] := GetChar(Cod,10);

       Ap[9] := GetChar(Cod,12);
       Ap[10] := GetChar(Cod,13);
       Ap[11] := GetChar(Cod,14);
       Ap[12] := GetChar(Cod,15);
   FOR i := 0 TO 12 DO
	    Ap[i] := RdUtils.ToUpperCaseASCII(Ap[i]);
   END;
   Cod := FromChars(Ap); (* Codice tessera introdotto dall'utente *)
   Codice := Cod;
  (* IF LocalHost = FALSE THEN CUP(6,1);IO.Put("CRAM Attiva") END;*) (* ################*)
   CUP(2,1); IO.Put(Cod);                        (* ----------############ *)
   Cod := ToHex(MD2Code(CodiceC & Cod & PassW));
   CodH := Cod ;
  CUP(3,1); IO.Put(Cod);                        (* ----------############ *)
   DBFetch(Cod);
   Dati := FetchDati();
   IF Dati = NIL THEN RETURN 1 ;
   ELSE
    CUP(4,1);IO.Put(Dati);                       (* ----------############ *)
	(* Analizza i dati letti *)
       Tipo := Sub(Dati,0,1);
       Esaurita := Sub(Dati,1,1);
       InUso    := Sub(Dati,2,1);
       IF    Equal(Esaurita,"S") THEN RETURN 2;
       ELSIF Equal(InUso,"S")    THEN RETURN 3;
       ELSIF Equal(InUso,"P")    THEN RETURN 4;
       ELSE                           RETURN 0;
       END;
   END;
END VerificaCT;

(*--------------- Procedure X Chat -----------------------------------------*)
PROCEDURE Avvisatore(): Thread.T =
BEGIN
 RETURN Thread.Fork(NEW(Thread.Closure, apply := Terminator ));
END Avvisatore;


PROCEDURE Terminator(<*UNUSED*> closure:Thread.Closure): REFANY =
VAR Avv10, Avv5, Avv1 : BOOLEAN;
BEGIN
 Avv10 := FALSE; Avv5  := FALSE; Avv1  := FALSE;
 IF MaxT - TUsato <= 10.0d0 THEN Avv10 := TRUE; END;
 IF MaxT - TUsato <= 5.0d0  THEN Avv5  := TRUE; END;
 IF MaxT - TUsato <= 1.0d0  THEN Avv1  := TRUE; END;
 LOOP
     Thread.Pause(10.0d0);
     IF Thread.TestAlert() THEN RETURN NIL ;
     ELSE
	Passato := Time.Now()- Start;
	  (* Controlla il tempo usato *)
	 IF  TUsato + Passato / 60.0d0 > MaxT THEN
	      PutErr(9,1,Spazi);
	      PutErr(11,1,Spazi);
	      PutErr(10,25,"Tempo scaduto..... a presto !"); Normal();
	       (* ed alla fine uccide IRC *)
	      EVAL Usignal.kill(id, Usignal.SIGTERM);
	      EXIT;
	 ELSIF MaxT - (TUsato + Passato / 60.0d0) <= 10.0d0 AND NOT Avv10 THEN
	       PutErr(1,50,"    10 minuti alla fine !!             ");
	       Avv10 := TRUE;
	 ELSIF MaxT - (TUsato + Passato / 60.0d0) <= 5.0d0 AND NOT Avv5 THEN
	       PutErr(1,50,"     5 minuti alla fine !!             ");
	       Avv5 := TRUE;
	 ELSIF MaxT - (TUsato + Passato / 60.0d0) <= 1.0d0 AND NOT Avv1 THEN
	       PutErr(1,50,"     1 minuto alla fine !!             ");
	       Avv1 := TRUE;
	 END;
     END;
 END;
 (*  marca la tessera come esaurita *)
   DBStore(CodH, Tipo & "S" & "S" & "00" & Tempo.DataT());
	    (* Tessera esaurita *)
   Scaduta := TRUE;
   Thread.Pause(4.0d0);
   RETURN NIL;
END Terminator;


PROCEDURE T2L(st:TEXT): LONGREAL =
VAR Int : INTEGER;
    Buf : ARRAY[0..9] OF CHAR;
    Nch : INTEGER;
BEGIN
     IF GetChar(st,1) = ' ' THEN
	  Int := ORD(GetChar(st,0))-48 ;
     ELSE
	  Int := (ORD(GetChar(st,0))-48)*10 - (ORD(GetChar(st,1))-48);
     END;
	  Nch := FromInt(Buf,Int);
	  RETURN ToLongFloat(Buf,Nch);
END T2L;
(*--------------- Procedure X Chat -----------------------------------------*)

PROCEDURE Chat()=
VAR     Param : ARRAY[0..1] OF TEXT;
	Processo : Process.T;
	sio, sout, ser : File.T;
	Av : Thread.T ;
	Buf : ARRAY[0..2] OF CHAR;

   PROCEDURE Lancio()=
   BEGIN
       IF LocalHost THEN
	    Param[0] := NIL ;
	    Param[1] := NIL ;
       ELSE
	    Param[0] := nick ;
	    Param[1] := "client" ;
       END;
       Process.GetStandardFileHandles(sio,sout,ser);
       Processo := Process.Create("/usr/local/bin/zircon", Param,  stdin:= sio, stdout := sout, stderr:=ser);
   (*  Processo := Process.Create("/usr/local/bin/irc", Param,  stdin:= sio, stdout := sout, stderr:=ser);*)
   (*  Processo := Process.Create("/usr/ns20/netscape", Param,  stdin:= sio, stdout := sout, stderr:=ser);*)
       id := Process.GetID(Processo);
  END Lancio;

BEGIN
   TUsato := 0.0d0;
   MaxT := Durate[GetChar(Tipo,0)]; (* Se prima volta *)
   EVAL FromLongFloat(Buf,MaxT,3);
   DBFetch(CodH);
   Str := FetchDati();
   TempoUsato := Sub(Str,3,2);
IF Equal(TempoUsato, "00") THEN  (* Prima Volta *)
   DBStore(CodH, Tipo & "N" & "S" & "00" & Tempo.DataT());
ELSE
   TUsato := T2L(TempoUsato);
   DBStore(CodH, Tipo & "N" & "S" & TempoUsato & Tempo.DataT());
END;
			       (* Inizia l'uso *)
      (* Thread.Pause(10.0d0);*) (* ###################----------------------*)
      CLS(); Home();
      Lancio();
(*     IF LocalHost THEN
	    Param[0] := NIL ;
	    Param[1] := NIL ;
       ELSE
	    Param[0] := nick ;
	    Param[1] := "server" ;
       END;
       Process.GetStandardFileHandles(sio,sout,ser);
       Processo := Process.Create("irc", Param,  stdin:= sio, stdout := sout, stderr:=ser);
       id := Process.GetID(Processo);
*)
       Thread.Pause(1.0d0);
       CUPyx(24,3);
       CUP(3,30); IO.Put("Tessera da " & FromChars(Buf) & " minuti");
       CUP(7,1); IO.Put("Connessione in corso, ...attendere qualche secondo");
IF NOT Equal(TempoUsato, "00") THEN  (* Non e' la Prima Volta *)
       CUP(5,1); IO.Put("Tessera gia' usata per " & TempoUsato & " minuti");
END;
     Start := Time.Now();
       Av := Avvisatore();
       EVAL Process.Wait(Processo);
IF NOT Scaduta THEN   (* Registra il tempo usato e *)
    Thread.Alert(Av); (* Blocca l' Avvisatore      *)
    Secondi := Time.Now() - Start + TUsato;      (*#############*)
    TempoUsato := LongReal(Secondi/60.0d0, Style.Fix, 0, FALSE); (* in minuti *)
       CUP(9,1); CSCDown();
       CUP(10,25);IO.Put("    Tempo Usato: " & TempoUsato & "   minuti ");
       CUP(11,1); CLRight();
       CUP(11,25);IO.Put("    Hai ancora   " & LongReal(Durate[GetChar(Tipo,0)]- Secondi/60.0d0 , Style.Fix, 0, FALSE) & "   minuti ");
   DBStore(CodH, Tipo & "N" & "P" & Sub(TempoUsato & "   ",0,2) & Tempo.DataT() );
	    (* Sospende l'uso *)
END;
    ChiusuraTessera(CT);
       Thread.Pause(5.0d0);
END Chat;


PROCEDURE Addr2Text(addr:Address): TEXT=
VAR i :CARDINAL;
    Add : TEXT;
BEGIN
 Add := "";
FOR i := 0 TO 2 DO
    Add := Cat(Add,Fmt.Int(addr.a[i]) & ".");
END;
    Add := Cat(Add,Fmt.Int(addr.a[3]) );
 RETURN Add;
END Addr2Text;

PROCEDURE LOG(St:TEXT ) =
BEGIN
  (*  CUP(23,1); CLRight(); Putyx(23,1,DataCT() & OraT() & St); *)
      (* Scrittura sul file di Log *)
    Wr.PutText(FileL,DataCT() & OraT() & St & "\n");
    Wr.Flush(FileL);
END LOG;


PROCEDURE Ping():BOOLEAN=
VAR Contenuto, Messaggio : TEXT;
    TipoMessaggio : CHAR;
BEGIN
IF OK AND HandWr # NIL THEN
  TipoMessaggio := VAL(0, CHAR);
  Contenuto :=  nick & " " & Addr2Text(AddLocale) ;
  Messaggio := Cat(FromChar(TipoMessaggio), Contenuto);
 TRY
  LOCK MutCon  DO
   Wr.PutText(HandWr,Messaggio);
   HandWr.nextMsg();
  END;
 EXCEPT Wr.Failure => LOG("No Ping: Wr.Failure");
		      RETURN FALSE;
 END;
  RETURN TRUE;
ELSE
 LOG("No Ping: server non connesso ");
END;
RETURN FALSE;
END Ping;

PROCEDURE Presentazione()=
VAR Contenuto, Messaggio : TEXT;
    TipoMessaggio : CHAR;
BEGIN
  TipoMessaggio := VAL(2, CHAR);
  Contenuto :=  nick & " " & Addr2Text(AddLocale) ;
  Messaggio := Cat(FromChar(TipoMessaggio), Contenuto);
 TRY
  LOCK MutCon  DO
   Wr.PutText(HandWr,Messaggio);
   HandWr.nextMsg();
  END;
 EXCEPT Wr.Failure => LOG("No Presentazione: Wr.Failure");
		      RETURN ;
 END;
  RETURN ;
END Presentazione;

PROCEDURE NuovaTessera(Tes:TEXT)=
VAR Contenuto, Messaggio : TEXT;
    TipoMessaggio : CHAR;
BEGIN
  TipoMessaggio := VAL(3, CHAR);
  Contenuto :=  Tes ;
  Messaggio := Cat(FromChar(TipoMessaggio), Contenuto);
 TRY
  LOCK MutCon  DO
   Wr.PutText(HandWr,Messaggio);
   HandWr.nextMsg();
  END;
 EXCEPT Wr.Failure => LOG("No Nuova Tessera: Wr.Failure");
		      RETURN ;
 END;
  RETURN ;
END NuovaTessera;

PROCEDURE ChiusuraTessera(Tes:TEXT)=
VAR Contenuto, Messaggio : TEXT;
    TipoMessaggio : CHAR;
BEGIN
  TipoMessaggio := VAL(4, CHAR);
  Contenuto :=  Tes ;
  Messaggio := Cat(FromChar(TipoMessaggio), Contenuto);
 TRY
  LOCK MutCon  DO
   Wr.PutText(HandWr,Messaggio);
   HandWr.nextMsg();
  END;
 EXCEPT Wr.Failure => LOG("No Chiusura Tessera: Wr.Failure");
		      RETURN ;
 END;
  RETURN ;
END ChiusuraTessera;


VAR DatiDb, Fatto : TEXT;
    MutDati, MutFatto : MUTEX;

PROCEDURE DBFetch(key:TEXT)=
VAR Contenuto, Messaggio : TEXT;
    TipoMessaggio : CHAR;
BEGIN
  DatiDb := NIL;
  TipoMessaggio := VAL(5, CHAR);
  Contenuto :=  key ;
  Messaggio := Cat(FromChar(TipoMessaggio), Contenuto);
 TRY
  LOCK MutCon  DO
   Wr.PutText(HandWr,Messaggio);
   HandWr.nextMsg();
  END;
 EXCEPT Wr.Failure => LOG("No DBFetch: Wr.Failure");
		      RETURN ;
 END;
  RETURN ;
END DBFetch;


PROCEDURE DBStore(Key,Value:TEXT)=
VAR Contenuto, Messaggio : TEXT;
    TipoMessaggio : CHAR;
BEGIN
  Fatto := NIL;
  TipoMessaggio := VAL(6, CHAR);
  Contenuto :=  Key & Value ;
  Messaggio := Cat(FromChar(TipoMessaggio), Contenuto);
 TRY
  LOCK MutCon  DO
   Wr.PutText(HandWr,Messaggio);
   HandWr.nextMsg();
  END;
 EXCEPT Wr.Failure => LOG("No DBStore: Wr.Failure");
		      RETURN ;
 END;
  RETURN ;
END DBStore;


PROCEDURE RispFetch(Value:TEXT)=
BEGIN
  LOCK MutDati DO
     DatiDb := Value;
  END;
END RispFetch;


PROCEDURE FetchDati():  TEXT=
VAR Rit:TEXT;
BEGIN
 LOOP
  LOCK MutDati DO
     Rit := DatiDb ;
  END;
  IF Rit # NIL THEN EXIT END;
 END;
  IF Equal(Rit,"Niente") THEN RETURN NIL
  ELSE RETURN Rit
  END;
END FetchDati;


PROCEDURE RispStore(Value:TEXT)=
BEGIN
  LOCK MutFatto DO
     Fatto := Value;
  END;
END RispStore;


PROCEDURE StoreFatto():  TEXT=
VAR Rit:TEXT;
BEGIN
 LOOP
  LOCK MutFatto DO
     Rit := Fatto ;
  END;
  IF Rit # NIL THEN EXIT END;
 END;
  IF Equal(Rit,"Niente") THEN RETURN NIL
  ELSE RETURN Rit
  END;
END StoreFatto;


PROCEDURE Errore(Tes:TEXT)=
VAR Contenuto, Messaggio : TEXT;
    TipoMessaggio : CHAR;
BEGIN
  TipoMessaggio := VAL(10, CHAR);
  Contenuto :=  Tes ;
  Messaggio := Cat(FromChar(TipoMessaggio), Contenuto);
 TRY
  LOCK MutCon  DO
   Wr.PutText(HandWr,Messaggio);
   HandWr.nextMsg();
  END;
 EXCEPT Wr.Failure => LOG("No Errore: Wr.Failure");
		      RETURN ;
 END;
  RETURN ;
END Errore;


		       (* :::::::::::: *)
VAR
    Indirizzo   : Address;
    EndPoiServ  : Endpoint;
    Connettore  : Connector;
    Connessione : ConnFD.T;
    HandRd      : MsgRd.T;
    HandWr      : MsgWr.T;
    Servente    : TEXT;
    OK : BOOLEAN;   (* Connessione col server attiva  'client' *)


PROCEDURE ConnettiClient() =
BEGIN
  EVAL Thread.Fork(NEW(Thread.Closure, apply := ConServ ));
END ConnettiClient;


PROCEDURE ConServ(<*UNUSED*> closure:Thread.Closure): REFANY=
BEGIN
IF GetHostByName(Servente, Indirizzo) THEN
   LOG("Indirizzo del client: " & Addr2Text(Indirizzo));
   EndPoiServ.addr := Indirizzo;
   EndPoiServ.port := 6669;

LOOP
    OK := FALSE;
    REPEAT
     TRY
       Connessione := Connect(EndPoiServ);     (*  *)
       OK := TRUE;
       Bell(); LOG("Connessione avvenuta  ");
     EXCEPT IP.Error => OK := FALSE;
     END;
    UNTIL OK;


    HandRd := ConnMsgRW.NewRd(Connessione);
    HandWr := ConnMsgRW.NewWr(Connessione);

    AttesaMessaggi(HandRd, HandWr);  (* processo *)

    Presentazione();
     WHILE  Ping() DO

	    Thread.Pause(10.0d0);
     END;
      HandWr := NIL;
      HandRd := NIL;
      LOG("Sconnessione avvenuta ");

  Close(Connessione);
END (* loop *);
ELSE LOG("Indirizzo del servente non trovato ! ");
END (* if *);
RETURN NIL;
END ConServ;

		       (* :::::::::::: *)

  TYPE ConClosure = Thread.Closure
			   OBJECT
			     Read : MsgRd.T;
			     Write: MsgWr.T;
			   METHODS END;

PROCEDURE AttesaMessaggi(Hrd: MsgRd.T; Hwr: MsgWr.T ) =
BEGIN
  EVAL Thread.Fork(NEW(ConClosure, apply := GestioneMessaggi,
				   Read  := Hrd,
				   Write := Hwr
		       ));
END AttesaMessaggi;

PROCEDURE GestioneMessaggi(clo:ConClosure):REFANY =
VAR
    NM : CARDINAL; (* Numero Messaggio (tipo) *)
    Fine : BOOLEAN;
    FineMessaggio : BOOLEAN;
    ch  : CHAR;
    Messaggio : TEXT;
    SelfT  : Thread.T;  (* se stesso *)

  PROCEDURE GetMessage()=                (* Procedura interna *)
  BEGIN
   LOOP                                   (* Recupera il messaggio *)
    TRY
     ch := Rd.GetChar(clo.Read); (* Legge i caratteri del messaggio *)
     Messaggio := Cat(Messaggio, FromChar(ch));
    EXCEPT   Rd.EndOfFile => FineMessaggio := TRUE; EXIT;
	   | Rd.Failure   => Fine := TRUE;          EXIT;
    END;
   END;
 END GetMessage;

BEGIN
 SelfT := Thread.Self();
 Fine := FALSE; FineMessaggio:=FALSE;

REPEAT
   TRY
     REPEAT
     UNTIL clo.Read.nextMsg();               (* Attende un messaggio *)
   EXCEPT  Rd.Failure => Fine := TRUE;
			 HandWr := NIL;   HandRd := NIL;
	                 LOG("(p1) Fine Connessione  " ); EXIT;
	   | Thread.Alerted   => Fine := TRUE;
   END;

   Messaggio := "";

    TRY
     ch := Rd.GetChar(clo.Read); (* Legge il primo carattere...tipo messaggio *)
    EXCEPT   Rd.EndOfFile => FineMessaggio := TRUE;
	   | Rd.Failure   => Fine := TRUE;
	   | Thread.Alerted   => Fine := TRUE;
    END;

    NM := ORD(ch); (* Numero di Messaggio *)
    CASE NM OF
	   0 => GetMessage(); (*RispondiPing(clo.Write, MutCon, Messaggio);*)
	|  1 => GetMessage(); (*RispostaAPing();*)
	|  3 => GetMessage(); (*Sconnessione(Messaggio);*)
	|  4 => GetMessage(); (*Avviso(Messaggio);*)
	| 15 => GetMessage(); RispFetch(Messaggio);
	| 16 => GetMessage(); RispStore(Messaggio);
    ELSE
	LOG("Ricevuto Messaggio di tipo sconosciuto");
    END;


    IF FineMessaggio THEN

    ELSE
	HandWr := NIL;   HandRd := NIL;
	LOG("(p2) Fine Connessione  ");
    END;

UNTIL Fine ;
RETURN NIL;
END GestioneMessaggi;
		       (* :::::::::::: *)


VAR FileW : Wr.T;
(*#########################################################################*)
BEGIN
	IF Params.Count = 1 THEN LocalHost := TRUE;
				 Servente := "localhost";
	ELSIF Equal(Params.Get(1), "CRAM") THEN LocalHost := FALSE;
				 Servente := "client";
	   ELSE LocalHost := TRUE;
		Servente := "localhost";
	END;


   FileR := IO.OpenRead("/etc/HOSTNAME");
   Str := IO.GetLine(FileR);
   Rd.Close(FileR);
     nick := Sub(Str,0, FindChar(Str,'.')) ;

	(* Inizializza il File di LOG *)
   IF LocalHost  THEN
       FileL := FileWr.OpenAppend("Utente.LOG");
   ELSE
       FileL := FileWr.OpenAppend("/usr/bar/" & nick & ".Utente.LOG");
   END;

   FileR := IO.OpenRead(FileBAR);
   Str := IO.GetLine(FileR);
   Rd.Close(FileR);
   CodiceC := Sub(Str,0,7);
   PassW   := Sub(Str,7,8);

 MutCon   := NEW(MUTEX);
 MutDati  := NEW(MUTEX);
 MutFatto := NEW(MUTEX);
   AddLocale := GetHostAddr();
   ConnettiClient();
 LOOP
  OroHand := OrologioR(2,70);
      Logo();
      Thread.Alert(OroHand); CUP(2,70); CLRight();
   IF   LogIn() THEN
		   (*  Thread.Alert(OroHand); CUP(2,70); CLRight();*)
		     Chat();
   ELSE
	PutErr(4,30,"Connessione fallita !");
	Thread.Pause(5.0d0);
		     Thread.Alert(OroHand); CUP(2,70); CLRight();
   END;

 END;
END Utente.
