MODULE Tempo;

IMPORT IO, Date;
FROM Time IMPORT Now ;
FROM Date IMPORT FromTime;
FROM Fmt IMPORT Int;

VAR
       Data : Date.T;

CONST Mese = ARRAY [0..11] OF TEXT
	  (* {"GEN","FEB","MAR","APR","MAG","GIU","LUG","AGO","SET","OTT",
	      "NOV","DIC"}; *)
	     {"GENNAIO","FEBBRAIO","MARZO","APRILE","MAGGIO","GIUGNO",
	      "LUGLIO","AGOSTO","SETTEMBRE","OTTOBRE", "NOVEMBRE","DICEMBRE"};

      Giorno = ARRAY [0..6] OF TEXT
	  (*   {"Dom","Lun","Mar","Mer","Gio","Ven","Sab"};  *)
	     {"Domenica","Lunedi'","Martedi'","Mercoledi'","Giovedi'",
	      "Venerdi'","Sabato"};

      MeseC = ARRAY [0..11] OF TEXT
	      {"1","2","3","4","5","6","7","8","9","10","11","12"}; 
      GiornoC = ARRAY [0..6] OF TEXT
	        {"Dom","Lun","Mar","Mer","Gio","Ven","Sab"};  


PROCEDURE PutData() =
BEGIN
     Data := FromTime(Now() );
 IO.PutInt(Data.day);IO.Put(" ");
 IO.Put(Mese[ORD(Data.month)]);IO.Put(" ");
 IO.PutInt(Data.year);IO.Put(" ; ");
 IO.Put(Giorno[ORD(Data.weekDay)]); 
END PutData; 
 

PROCEDURE PutOra() =
BEGIN
     Data := FromTime(Now() );
			   IO.PutInt(Data.hour);IO.Put(":");
			   IO.PutInt(Data.minute);IO.Put(":");  
			   IO.PutInt(Data.second);
END PutOra;

(*
 IO.Put("Offset   : ");       IO.PutInt(Data.offset);IO.Put("\n");
 IO.Put("Zona     : ");       IO.Put(Data.zone);IO.Put(" ");
*)

PROCEDURE DataT():TEXT =

BEGIN
     Data := FromTime(Now() );
 RETURN Int(Data.day) & (" ") & Mese[ORD(Data.month)] & " " & Int(Data.year)
 & " ; " & Giorno[ORD(Data.weekDay)] & " "; 
END DataT;

PROCEDURE DataCT():TEXT =

BEGIN
     Data := FromTime(Now() );
 RETURN Int(Data.day) & ("/") & MeseC[ORD(Data.month)] & "/" & Int(Data.year)
 & " " & GiornoC[ORD(Data.weekDay)] & " "; 
END DataCT;


PROCEDURE OraT():TEXT =
BEGIN
     Data := FromTime(Now() );
     RETURN Int(Data.hour) & ":" & Int(Data.minute) & ":" & Int(Data.second) & " ";
END OraT;








BEGIN
END Tempo.

