MODULE Server EXPORTS Main;
FROM IP IMPORT Port, Address, Endpoint, GetHostByName, GetCanonicalByName,
	       GetCanonicalByAddr, GetHostAddr, NullEndPoint, NullPort,
	       NullAddress ;
FROM TCP IMPORT Refused, Closed, Timeout, ConnLost, NewConnector, GetEndPoint,
		CloseConnector, Connect, Accept, Close, Connector ;
FROM Input IMPORT CUPyx, Putyx, InpLine, InpInt, Orologio, PutErr ;
FROM vt100 IMPORT NL, NLn, Bell, CLS, CSCDown, Home, CUP, CUD, Bold, Blink,
		  UnderL, RevVideo, Normal, CLLeft, CLRight ;
FROM Text IMPORT Cat, Equal, Sub, GetChar, FromChar, FromChars,
		 FindChar, SetChars ;
FROM Tempo IMPORT PutData, DataCT, OraT;
FROM MD2 IMPORT MD2Code;
IMPORT IO, IP, Thread, Wr, Rd, ConnFD, ConnRW, ConnMsgRW, MsgRd, MsgWr;
IMPORT Stdio, FileWr, File, FS, Fmt, Time, InfConTbl, Random, Scan ; 
IMPORT Dbase;

(* < > -_ \ | $ / ' ~ ` ^ *)

<*FATAL IP.Error *>
<*FATAL Thread.Alerted *>
(* <*FATAL Rd.EndOfFile *> *)
<*FATAL Rd.Failure *>
<*FATAL Rd.EndOfFile *>



VAR AddLocale   : Address;
    EndPoiLoc   : Endpoint;
    Connettore  : Connector;
    Connessione : ConnFD.T;
    HandRd      : MsgRd.T;
    HandWr      : MsgWr.T;
    Testo : TEXT ;
    Nu : CHAR ;
    FileL : Wr.T;

CONST      FileCli =  "/usr/bar/Clienti/Clienti.dbm";
	   FileLog =  "/usr/bar/Server/Server.LOG"  ;
	   PathTessere = "/usr/bar/Lotti/";

PROCEDURE ToHex(Text:TEXT): TEXT =
TYPE
	BYTE = [0..255];

VAR	i : CARDINAL;
	X : ARRAY [0..15] OF BYTE;
  	CodeSt : ARRAY[1..32] OF CHAR;
  	CC     : ARRAY[0..15] OF CHAR;
(* ---------- Procedura Interna --------------------------*)
PROCEDURE NbHex (Nibble:BYTE):CHAR =
(* Azione: Converte un nibble in carattere esadecimale *)
BEGIN
	IF Nibble < 10 THEN
		RETURN VAL(Nibble+48, CHAR)  (* Cifra *)
	ELSE  
		RETURN VAL(Nibble+87, CHAR); (* Lettera minuscola *)
	END;
END NbHex;
(* ----Fine   Procedura Interna --------------------------*)
BEGIN
	SetChars(CC,Text);
	(* Converti X[0..15] in una stringa esadecimale di 2*16 caratteri *)
	i := 0; (* Contatore *)
	WHILE i <= 15 DO
		       (* Converti da BYTE a Hex *)
		        X[i] := ORD(CC[i]);
			CodeSt[2*i+1] := NbHex (X[i] DIV 16);
			CodeSt[2*i+2] := NbHex (X[i] MOD 16);
			i := i + 1;
	END;
	RETURN  FromChars(CodeSt);
END ToHex;


PROCEDURE PrintAddr(addr:Address)=
VAR i :CARDINAL;
BEGIN
FOR i := 0 TO 2 DO
    IO.PutInt(addr.a[i]); IO.Put(".");
END;
    IO.PutInt(addr.a[3]);
END PrintAddr;


PROCEDURE LOG(St:TEXT ) =
BEGIN
    CUP(23,1); CLRight(); Putyx(23,1,DataCT() & OraT() & St); 
      (* Scrittura sul file di Log *)
    Wr.PutText(FileL,DataCT() & OraT() & St & "\n");
    Wr.Flush(FileL);
END LOG;


PROCEDURE PingChi()=
VAR N : INTEGER;
    Inf : InfoConnessione;
    TipoMessaggio : CHAR;
    Contenuto, Messaggio : TEXT;
BEGIN   
REPEAT
CUP(6,2); CSCDown();
RevVideo();
IO.Put(" Ping a quale connessione ? :"); NLn(2); Normal();
 IO.Put(" Scegli ! : ");
 CUPyx(8,13); N:=InpInt();
 IF N = 0 THEN RETURN END; 
UNTIL  TabCon.get(N,Inf);

 Inf.PingIniz  := Time.Now();  (* Legge l'ora *)
 LOCK MutTab DO                  (* e la salva in tabella *)
     EVAL  TabCon.put(N, Inf);
 END;
EVAL Ping(Inf.CanWr,Inf.Mt);

(*#########*)
  TipoMessaggio := VAL(14, CHAR);
  Contenuto := " "  ;
  Messaggio := Cat(FromChar(TipoMessaggio), Contenuto);
 TRY
  LOCK Inf.Mt DO
     Wr.PutText(Inf.CanWr,Messaggio);
     Inf.CanWr.nextMsg();
  END;
 EXCEPT Wr.Failure => LOG("No UtentiChi: Wr.failure");
 END;
(*#########*)
  TipoMessaggio := VAL(17, CHAR);
  Contenuto := " "  ;
  Messaggio := Cat(FromChar(TipoMessaggio), Contenuto);
 TRY
  LOCK Inf.Mt DO
     Wr.PutText(Inf.CanWr,Messaggio);
     Inf.CanWr.nextMsg();
  END;
 EXCEPT Wr.Failure => LOG("No SchedeChi: Wr.failure");
 END;
END PingChi;   

PROCEDURE UtentiChi()=
VAR N : INTEGER;
    Inf : InfoConnessione;
    TipoMessaggio : CHAR;
    Contenuto, Messaggio : TEXT;
BEGIN
REPEAT
CUP(6,2); CSCDown();
RevVideo();
IO.Put(" Utenti a quale connessione ? :"); NLn(2); Normal();
 IO.Put(" Scegli ! : ");
 CUPyx(8,13); N:=InpInt();
 IF N = 0 THEN RETURN END; 
UNTIL  TabCon.get(N,Inf);

  TipoMessaggio := VAL(14, CHAR);
  Contenuto := " "  ;
  Messaggio := Cat(FromChar(TipoMessaggio), Contenuto);
 TRY
  LOCK Inf.Mt DO
     Wr.PutText(Inf.CanWr,Messaggio);
     Inf.CanWr.nextMsg();
  END;
 EXCEPT Wr.Failure => LOG("No UtentiChi: Wr.failure");
 END;

END UtentiChi; 

PROCEDURE SchedeChi()=
VAR N : INTEGER;
    Inf : InfoConnessione;
    TipoMessaggio : CHAR;
    Contenuto, Messaggio : TEXT;
BEGIN
REPEAT
CUP(6,2); CSCDown();
RevVideo();
IO.Put(" Schede a quale connessione ? :"); NLn(2); Normal();
 IO.Put(" Scegli ! : ");
 CUPyx(8,13); N:=InpInt();
 IF N = 0 THEN RETURN END; 
UNTIL  TabCon.get(N,Inf);

  TipoMessaggio := VAL(17, CHAR);
  Contenuto := " "  ;
  Messaggio := Cat(FromChar(TipoMessaggio), Contenuto);
 TRY
  LOCK Inf.Mt DO
     Wr.PutText(Inf.CanWr,Messaggio);
     Inf.CanWr.nextMsg();
  END;
 EXCEPT Wr.Failure => LOG("No SchedeChi: Wr.failure");
 END;
END SchedeChi;

PROCEDURE LOGChi()=
VAR N : INTEGER;
    Inf : InfoConnessione;
    TipoMessaggio : CHAR;
    Contenuto, Messaggio : TEXT;
BEGIN
REPEAT
CUP(6,2); CSCDown();
RevVideo();
IO.Put(" LOG a quale connessione ? :"); NLn(2); Normal();
 IO.Put(" Scegli ! : ");
 CUPyx(8,13); N:=InpInt();
 IF N = 0 THEN RETURN END; 
UNTIL  TabCon.get(N,Inf);
  TipoMessaggio := VAL(12, CHAR);
  Contenuto := " "  ;
  Messaggio := Cat(FromChar(TipoMessaggio), Contenuto);
 TRY
  LOCK Inf.Mt DO
     Wr.PutText(Inf.CanWr,Messaggio);
     Inf.CanWr.nextMsg();
  END;
 EXCEPT Wr.Failure => LOG("No LOGChi: Wr.failure");
 END;
END LOGChi; 

PROCEDURE KillChi()=
VAR N : INTEGER;
    Inf : InfoConnessione;
BEGIN
REPEAT
CUP(6,2); CSCDown();
RevVideo();
IO.Put(" Chiudi quale connessione ? :"); NLn(2); Normal();
 IO.Put(" Scegli ! : ");
 CUPyx(8,13); N:=InpInt();
 IF N = 0 THEN RETURN END; 
UNTIL  TabCon.get(N,Inf);
     LOG("Forzata sconnessione per " & Inf.NomeBAR);
     Thread.Alert(Inf.ThrCon);
     Close(Inf.Connes);
END KillChi; 

(*------------------------ Tabella Connessioni -----------------------------*)

  TYPE InfoConnessione = RECORD
			      NomeBAR : TEXT;
			      IndBAR  : TEXT;
			      PassW   : TEXT;
			      Chall   : TEXT;
			      DataIn  : TEXT;
			      OraIn   : TEXT;
			      UtentiAt: INTEGER;
			      TermAt  : INTEGER;
			      TessInu : INTEGER;
			      PingIniz: LONGREAL;
			      PingFin : LONGREAL;
			      CanRd   : MsgRd.T ;
			      CanWr   : MsgWr.T ;
			      Mt      : MUTEX ;
			      ThrCon  : Thread.T;
			      Connes  : ConnFD.T;
			      AutentOK: BOOLEAN;
			      ThrTim  : Thread.T
			 END;
  VAR  N_Connessione : INTEGER ;
       InfoC : InfoConnessione ;
       MutTab : MUTEX ; (* per l'accesso a Tabella *)

       TabCon := NEW(InfConTbl.Default).init(); (* Tabella delle Connessioni *)
      
 PROCEDURE StampaTabellaConnessioni()=
  VAR N, c : INTEGER;
      it : InfConTbl.Iterator;
      Key : INTEGER;
      Con : InfoConnessione;
       PROCEDURE Pulizia()=
       BEGIN
	    FOR i := 8 TO 21 DO
	      CUP(i,1);CLRight();
	    END;
       END Pulizia;
 BEGIN
 FOR x:=6 TO 22 DO
  CUP(x,1);CLRight();
 END;
CUPyx(8,2); 
   N := TabCon.size() ; 
   IO.Put("Ci sono "); Bold(); IO.PutInt(N); Normal();
   IO.Put(" connessioni attive"); NLn(2);

    it := TabCon.iterate();
    c := 1;
    FOR z := 1 TO N BY 10 DO
     FOR y := 1 TO 10 DO
       EVAL it.next(Key,Con); INC(c);
       CUPyx(8+y,1); IO.PutInt(Key);
       CUPyx(8+y,7); IO.Put(Con.NomeBAR);
       CUPyx(8+y,15); IO.Put(Con.IndBAR);
       CUPyx(8+y,40); IO.Put(Con.DataIn & " " & Con.OraIn);
       CUPyx(8+y,64); IO.Put("U/T " & Fmt.Int(Con.UtentiAt) & "/" & Fmt.Int(Con.TermAt));
       CUPyx(8+y,72); IO.Put("Ts " & Fmt.Int(Con.TessInu )); 
	IF c=N+1 THEN EXIT END;
     END;
     IF c=N+1 THEN EXIT END;
     CUP(22,2); IO.Put(" Ancora: batti invio : ");
     CUPyx(22,25); Nu:=Rd.GetChar(Stdio.stdin); 
     Pulizia();
    END;   

   CUP(22,2); IO.Put(" Batti invio : ");
   CUPyx(22,17); CLRight(); Nu:=Rd.GetChar(Stdio.stdin); 
 END StampaTabellaConnessioni;

(*-----------------------Fine Tabella Connessioni --------------------------*)

(*------------------------- Ping -------------------------------------------*)

PROCEDURE Ping(hwr:MsgWr.T; M:MUTEX):BOOLEAN=
VAR Contenuto, Messaggio : TEXT;
    TipoMessaggio : CHAR;
BEGIN
  TipoMessaggio := VAL(0, CHAR);
  Contenuto := "Prove tecniche di trasmissione in TCP/IP : " (* & DataCT() & OraT()*)  ; 
  Messaggio := Cat(FromChar(TipoMessaggio), Contenuto);
 TRY
  LOCK M DO
     Wr.PutText(hwr,Messaggio);
     hwr.nextMsg();
  END;
 EXCEPT Wr.Failure => RETURN FALSE;
 END;
  RETURN TRUE;
END Ping;


		       (* :::::::::::: *)

  TYPE CloWri = Thread.Closure
			   OBJECT
			     Wri: MsgWr.T;
			     Mt : MUTEX;
			     Mg : TEXT;
			   METHODS END;

PROCEDURE RispondiPing(H:MsgWr.T; Mx:MUTEX; Ms:TEXT) =
BEGIN
  EVAL Thread.Fork(NEW(CloWri, apply := RispPing, Wri:=H, Mt := Mx, Mg:=Ms ));
END RispondiPing;


PROCEDURE RispPing(clo:CloWri):REFANY =
VAR Contenuto, Messaggio : TEXT;
    TipoMessaggio : CHAR;
BEGIN
  LOG("Ping: " & clo.Mg);
  TipoMessaggio := VAL(1, CHAR);
  Contenuto := "Risposta al Ping .." & DataCT() & OraT()  ; (*\n*)
  Messaggio := Cat(FromChar(TipoMessaggio), Contenuto);
 TRY
  LOCK clo.Mt DO
     Wr.PutText(clo.Wri,Messaggio);
     clo.Wri.nextMsg();
  END;
 EXCEPT Wr.Failure => RETURN NIL (* FALSE*);
 END;
  RETURN NIL (*TRUE*);
END RispPing;

		       (* :::::::::::: *)


PROCEDURE RispostaAPing(N:INTEGER)=  (* Acquisisce l'evento *)
VAR Tb : InfoConnessione;
    Ritorno : LONGREAL;
BEGIN 
    Ritorno := Time.Now();
    LOCK MutTab DO
      EVAL  TabCon.get(N,Tb);
      Tb.PingFin := Ritorno;
      EVAL  TabCon.put(N,Tb);
    END;
  (*CUP(24,1); CLRight(); *)
  LOG("Ping a " & Tb.NomeBAR & " in " & Fmt.LongReal(Ritorno - Tb.PingIniz, Fmt.Style.Fix, 3) & " Secondi " );
END RispostaAPing;       

(*------------------------- Fine Ping --------------------------------------*)

PROCEDURE AltroBAR(C:INTEGER; Mess:TEXT)=
VAR Messaggio, Contenuto:TEXT; (* Un altro BAR si e' connesso e si presenta *)
    TipoMessaggio:CHAR;               
    ok : BOOLEAN;
BEGIN                          
    LOG("Presentazione su c. " & Fmt.Int(C) & " " & Mess);
 LOCK MutTab DO
  ok := TabCon.get(C,InfoC) ;
 END;
  IF ok THEN
     InfoC.NomeBAR := Sub(Mess,0,FindChar(Mess,' ')); (* e' il Codice Cliente *)
     InfoC.IndBAR := Sub(Mess,8);
      (* Aperuta Data Base Clienti per ottenere la Password *)
     InfoC.PassW := GetPassw(InfoC.NomeBAR);  
      (* Generazione stringa di Challange *)
     InfoC.Chall := Challange();
 
     LOCK MutTab DO
      EVAL  TabCon.put(C,InfoC);
     END;     
       TipoMessaggio := VAL(3, CHAR);
       Contenuto := "OK" ;
       Messaggio := Cat(FromChar(TipoMessaggio), Contenuto);
      TRY
       LOCK InfoC.Mt DO 
	  Wr.PutText(InfoC.CanWr,Messaggio);
	  InfoC.CanWr.nextMsg();
       END; 
      EXCEPT Wr.Failure => LOG("Wr.Failure in AltroBAR"); 
      END;
       RichiestaAutenticazione(C); 

  ELSE
     LOG("Presentazione su canale inesistente");
  END;
END AltroBAR;       

PROCEDURE GetPassw(Nome:TEXT):TEXT =
VAR    DBCL : Dbase.T;
       Dati : TEXT;
BEGIN
    	DBCL := Dbase.Open(FileCli);
	Dati := Dbase.Fetch(DBCL, Nome);
	Dbase.Close(DBCL);
   IF Dati # NIL THEN RETURN Sub(Dati,    361, 8);
   ELSE LOG("NomeBAR assente sul Data Dase Clienti"); RETURN "";
   END;
END GetPassw;


VAR rand : Random.T;

PROCEDURE Challange():TEXT =
VAR Ac : ARRAY[0..11] OF CHAR;
BEGIN
      FOR i := 0 TO 11 DO
	 Ac[i]:=VAL(rand.integer(0,255),CHAR);
      END;
 RETURN FromChars(Ac); 
END Challange;


PROCEDURE RichiestaAutenticazione(Can:INTEGER)=
VAR Contenuto, Messaggio : TEXT;
    TipoMessaggio : CHAR;
    HCan : MsgWr.T;
    MutCan : MUTEX;
    Inf : InfoConnessione;
BEGIN
 LOCK MutTab DO
  EVAL TabCon.get(Can,Inf) ;  (* senza controllo *)
  Contenuto := Inf.Chall;
  MutCan := Inf.Mt;
  HCan := Inf.CanWr;
 END;
      (* Invio *)
  TipoMessaggio := VAL(4, CHAR);
  Messaggio := Cat(FromChar(TipoMessaggio), Contenuto);
  LOG("Richiesta Autenticazione a " & Inf.NomeBAR);
 TRY
  LOCK MutCan DO
     Wr.PutText(HCan,Messaggio);
     HCan.nextMsg();
  END;
 EXCEPT Wr.Failure => LOG("Wr.Failure in RichiestaAutenticazione");RETURN ;
 END;
    (* Lancia processo timer di attesa Autenticazione *)
    Inf.ThrTim := TimerAutentica(Can);
    LOCK MutTab DO
     EVAL TabCon.put(Can,Inf);
    END;
  RETURN ;
END RichiestaAutenticazione;


PROCEDURE Autentica(C:INTEGER; Mess:TEXT)= (* Acquisisce il messaggio di autenticazione *)     
VAR Inf : InfoConnessione;
BEGIN 
 LOCK MutTab DO
  EVAL TabCon.get(C,Inf) ;  (* senza controllo *)
 END;
  IF Equal(ToHex(Mess), ToHex(MD2Code(Inf.NomeBAR & Inf.Chall & Inf.PassW ))) THEN
      LOG("Autenticazione OK da " & Inf.NomeBAR);
      (* Mette a TRUE AutentOK *) 
      Inf.AutentOK := TRUE;
      LOCK MutTab DO
	  EVAL TabCon.put(C,Inf) ;  (* senza controllo *)
       END; 
      (* Uccide il processo timer *)
	Thread.Alert(Inf.ThrTim); 
      InvioTessere(C);
  ELSE
      LOG("Autenticazione ERRATA da " & Inf.NomeBAR);
      LOG(Inf.NomeBAR & " " & ToHex(Inf.Chall) & " " & Inf.PassW );
      LOG(ToHex(Mess));
      (* Uccide il processo timer *)
       Thread.Alert(Inf.ThrTim);
      (* Chiude la connessione *)
       Thread.Alert(Inf.ThrCon);
      Close(Inf.Connes);
  END;
END Autentica;      

		       (* :::::::::::: *)

  TYPE CloTim = Thread.Closure
			   OBJECT
			     Canale: INTEGER;
			   METHODS END;

PROCEDURE TimerAutentica(Can:INTEGER):Thread.T =
BEGIN
  RETURN Thread.Fork(NEW(CloTim, apply := TimerA, Canale:=Can ));
END TimerAutentica;

PROCEDURE TimerA(clo:CloTim):REFANY =
VAR Inf : InfoConnessione;
    Ancora : BOOLEAN;
BEGIN
    TRY 
      Thread.Pause(60.0d0);
    EXCEPT  Thread.Alerted   => RETURN NIL;
    END; 
   (* Se AutentOK e' vero ...tutto bene, altrimenti chiude la connessione *)
 LOCK MutTab DO
  Ancora := TabCon.get(clo.Canale,Inf) ; 
 END;
  IF Ancora = FALSE THEN RETURN NIL END;(* Potrebbe essere gia' stato eliminato*)
  IF Inf.AutentOK = FALSE THEN
     LOG("Autenticazione non arrivata in tempo per " & Inf.NomeBAR);
     Thread.Alert(Inf.ThrCon);
     Close(Inf.Connes);
  END;
 RETURN NIL;
END TimerA;

		       (* :::::::::::: *)

PROCEDURE InvioTessere(C:INTEGER)= 
VAR Contenuto, Messaggio : TEXT;
    TipoMessaggio : CHAR;
    Inf : InfoConnessione;
    FileTess : TEXT;
    Hf : Rd.T;
    OK : BOOLEAN;
    ch : CHAR;
BEGIN 
 LOCK MutTab DO
  EVAL TabCon.get(C,Inf) ;  
 END;
     FileTess := PathTessere & Inf.NomeBAR & "/" & Inf.NomeBAR & ".tgz" ;
     (* se il file esite *)
	(* Apri il file in lettura *)
	Hf := IO.OpenRead(FileTess);
     IF Hf = NIL THEN
	 LOG("Nessun file Tessere da spedire a " & Inf.NomeBAR);
     ELSE
	 LOG("Invio Tessere a " & Inf.NomeBAR);
    
       LOCK Inf.Mt DO
	  Wr.PutChar(Inf.CanWr,VAL(8,CHAR));
	   WHILE NOT IO.EOF(Hf) DO
	      ch := IO.GetChar(Hf);
	       TRY
	          Wr.PutChar(Inf.CanWr, ch);
		  EXCEPT Wr.Failure => LOG("Wr.Failure in Invio Tessere");RETURN ;
	       END;
	   END;
	   Inf.CanWr.nextMsg();
	   Rd.Close(Hf);
	 LOG("Inviate Tessere a " & Inf.NomeBAR);
       END;
     END;
 RETURN;
END InvioTessere;   

 
PROCEDURE TessereOK(C:INTEGER; OK:TEXT)=      (* Acquisisce l'evento *)
VAR Inf : InfoConnessione;
    FileTess, FileRin : TEXT;
BEGIN 
 LOCK MutTab DO
  EVAL TabCon.get(C,Inf) ;  
 END;
   FileTess := PathTessere & Inf.NomeBAR & "/" & Inf.NomeBAR & ".tgz" ;
   IF Equal(OK, "1") THEN
     LOG("Conferma Ric. Tessere da " & Inf.NomeBAR & " OK");
   ELSE
     LOG("Conferma Ric. Tessere da " & Inf.NomeBAR & " NON OK");
   END;
 (* Rinomina il file delle tessere *)   
   FileRin := PathTessere & Inf.NomeBAR & "/" & Inf.NomeBAR & "." & Fmt.LongReal(Time.Now()) ;
   FS.Rename(FileTess, FileRin );
END TessereOK;      


PROCEDURE TessereAgg(C:INTEGER; Msg:TEXT)=      (* Acquisisce l'evento *)
VAR Inf : InfoConnessione;
BEGIN 
 LOCK MutTab DO
  EVAL TabCon.get(C,Inf) ;  
 END;
 LOG(Msg & " da " & Inf.NomeBAR);
END TessereAgg;

PROCEDURE Sconnessione(C:INTEGER; M:TEXT)= (* Operazioni alla sconnessione di un BAR *) 
VAR Inf : InfoConnessione;
BEGIN
 LOCK MutTab DO
  EVAL TabCon.get(C,Inf) ;  
 END;
     LOG("Richiesta di sconnessione da " & Inf.NomeBAR);
     Thread.Alert(Inf.ThrCon);
     Close(Inf.Connes);
END Sconnessione;  


PROCEDURE OraDataOK(C:INTEGER; M:TEXT)=      (* Acquisisce l'evento *) 
BEGIN 
END OraDataOK;      
		  
PROCEDURE UtentiAttivi(C:INTEGER; M:TEXT)=   (* Aggiorna la tabella *) 
VAR Inf : InfoConnessione;
    Utenti, Terminali : INTEGER;
BEGIN 
 Terminali := Scan.Int(Sub(M,0,FindChar(M,' ')));
 Utenti    := Scan.Int(Sub(M,FindChar(M,' ')+1));
 LOCK MutTab DO
  EVAL TabCon.get(C,Inf) ;  
 END;
  Inf.UtentiAt := Utenti;
  Inf.TermAt   := Terminali;
 LOCK MutTab DO
  EVAL TabCon.put(C,Inf) ;  
 END;
END UtentiAttivi;   

PROCEDURE TessereInusate(C:INTEGER; M:TEXT)= (* Aggiorna il DataBase *)
VAR Inf : InfoConnessione;
    Tessere : INTEGER;
BEGIN 
    Tessere := Scan.Int(M);
 LOCK MutTab DO
  EVAL TabCon.get(C,Inf) ;  
   Inf.TessInu := Tessere;
  EVAL TabCon.put(C,Inf) ;  
 END;
END TessereInusate; 

PROCEDURE GetLOG(C:INTEGER)=          (* File transfer del LOG *)
BEGIN
END GetLOG;

(* ------------------ Thread di Nuova Connessione --------------------------*)

		       (* :::::::::::: *)

  TYPE ConClosure = Thread.Closure
			   OBJECT
			     Read : MsgRd.T;
			     Write: MsgWr.T;
			     N_C  : INTEGER;
			     Con : ConnFD.T;
			   METHODS END;
  
PROCEDURE NuovaConnessione(Hrd: MsgRd.T; Hwr: MsgWr.T; NCon:INTEGER;
			   Cons : ConnFD.T;
			   ) =
BEGIN
  EVAL Thread.Fork(NEW(ConClosure, apply := GestioneConnessione,
				   Read  := Hrd, 
				   Write := Hwr,
				   N_C   := NCon,
				   Con   := Cons
		       ));
END NuovaConnessione;

PROCEDURE GestioneConnessione(clo:ConClosure):REFANY =
VAR
    NM : CARDINAL; (* Numero Messaggio (tipo) *)
    Fine : BOOLEAN;
    FineMessaggio : BOOLEAN;
    ch  : CHAR;
    Messaggio : TEXT;
    InfoCon : InfoConnessione ;
    MutCon : MUTEX; (* Per l'uso di Write *)
    SelfT  : Thread.T;  (* se stesso *)

  PROCEDURE GetMessage()=                (* Procedura interna *)
  BEGIN
   LOOP                                   (* Recupera il messaggio *)
    TRY
     ch := Rd.GetChar(clo.Read); (* Legge i caratteri del messaggio *)
     Messaggio := Cat(Messaggio, FromChar(ch));
    EXCEPT   Rd.EndOfFile => FineMessaggio := TRUE; EXIT;
	   | Rd.Failure   => Fine := TRUE;          EXIT;
    END; 
   END; 
 END GetMessage;

BEGIN
 SelfT := Thread.Self();
 Fine := FALSE; FineMessaggio:=FALSE;
 MutCon := NEW(MUTEX);
 InfoCon.NomeBAR := "";  (* Ancora non si sa *)
 InfoCon.DataIn := DataCT();
 InfoCon.OraIn  := OraT();
 InfoCon.UtentiAt  := -1; (* Ancora non ottenuto *)
 InfoCon.TessInu   := -1; (* Ancora non ottenuto *)
 InfoCon.PingIniz  := 0.0d0;
 InfoCon.PingFin   := 0.0d0;
 InfoCon.CanRd  := clo.Read;
 InfoCon.CanWr  := clo.Write;
 InfoCon.Mt     := MutCon;    (* Per serializzare CanWr *)
 InfoCon.ThrCon := SelfT;
 InfoCon.Connes := clo.Con;
 InfoCon.AutentOK := FALSE;   (* Non ancora autenticato *)

 LOCK MutTab DO 
     EVAL  TabCon.put(clo.N_C, InfoCon);
 END;
  
REPEAT
   TRY
     REPEAT
     UNTIL clo.Read.nextMsg();               (* Attende un messaggio *)
   EXCEPT  Rd.Failure => Fine := TRUE;
	     LOG("(p1) Fine Connessione n. " & Fmt.Int(clo.N_C )); EXIT;
	   | Thread.Alerted   => Fine := TRUE;         
	     LOG("(p3) Alerted con. n. " & Fmt.Int(clo.N_C )); EXIT;
   END; 

   Messaggio := "";

    TRY
     ch := Rd.GetChar(clo.Read); (* Legge il primo carattere...tipo messaggio *)
    EXCEPT   Rd.EndOfFile => FineMessaggio := TRUE;
	   | Rd.Failure   => Fine := TRUE;         
	   | Thread.Alerted   => Fine := TRUE;         
	     LOG("(p4) Alerted con. n. " & Fmt.Int(clo.N_C )); EXIT;
    END; 

    NM := ORD(ch); (* Numero di Messaggio *)
    CASE NM OF
	   0 => GetMessage(); RispondiPing(clo.Write, MutCon, Messaggio);
	|  1 => GetMessage(); RispostaAPing(clo.N_C);
	|  2 => GetMessage(); AltroBAR(clo.N_C, Messaggio);
	|  5 => GetMessage(); Autentica(clo.N_C,Messaggio);
	|  6 => GetMessage(); Sconnessione(clo.N_C,Messaggio);
	|  9 => GetMessage(); TessereOK(clo.N_C, Messaggio);
	| 19 => GetMessage(); TessereAgg(clo.N_C, Messaggio);
	| 11 => GetMessage(); OraDataOK(clo.N_C, Messaggio);
	| 13 => GetLOG(clo.N_C); 
	| 15 => GetMessage(); UtentiAttivi(clo.N_C, Messaggio);
	| 18 => GetMessage(); TessereInusate(clo.N_C, Messaggio);
    ELSE
	LOG("Ricevuto Messaggio di tipo sconosciuto");
    END;
 

    IF FineMessaggio THEN
      (*     ElaboraMessaggio(Messaggio,clo.Write); *)
    ELSE
	LOG("(p2) Fine Connessione n. " & Fmt.Int(clo.N_C )); 
    END;

UNTIL Fine ;
 LOCK MutTab DO 
     EVAL  TabCon.delete(clo.N_C, InfoCon);
 END;

RETURN NIL;
END GestioneConnessione;

		       (* :::::::::::: *)
(* ------------------ Fine Thread di Nuova Connessione ----------------------*)


(* ------------------ Thread di Attesa Connessioni --------------------------*)
PROCEDURE AttesaConnessioni() =
BEGIN
  EVAL Thread.Fork(NEW(Thread.Closure, apply := ConnSetUp ));
END AttesaConnessioni;


PROCEDURE ConnSetUp(<*UNUSED*> closure:Thread.Closure): REFANY=
BEGIN
 N_Connessione := 0;              (* Numero della connessione *)
 EndPoiLoc.addr := NullAddress;
 EndPoiLoc.port := 6668;
(* Connettore := NewConnector(NullEndPoint);*) (* Qualunque IP su qualunque porta *)
 Connettore := NewConnector(EndPoiLoc); 
 EndPoiLoc := GetEndPoint(Connettore);
 LOG("Attesa connessioni sulla Porta : " & Fmt.Int(EndPoiLoc.port));

LOOP
  Connessione := Accept(Connettore);(* va in pausa attendendo una connessione *)
  INC(N_Connessione);
    Bell(); LOG("Avvenuta connessione  n. " & Fmt.Int(N_Connessione));

  HandRd := ConnMsgRW.NewRd(Connessione);
  HandWr := ConnMsgRW.NewWr(Connessione);

  NuovaConnessione(HandRd,HandWr,N_Connessione,Connessione);(* E' un processo *)
END;

(*   Close(Connessione);  *)
RETURN NIL;
END ConnSetUp;
		       (* :::::::::::: *)
(* ------------------ Fine Thread di Attesa Connessioni ---------------------*)

PROCEDURE Scelta()=
BEGIN
 FOR x:=6 TO 22 DO
  CUP(x,1);CLRight();
 END;
CUP(6,2); 
RevVideo();
IO.Put(" Cosa vuoi fare ? :"); NLn(2); Normal();
IO.Put("       1)  Lista Connessioni"); NLn(2); 
IO.Put("       2)  Ping, Utenti e Tessere"); NLn(2); 
IO.Put("       3)  Messaggio ai BAR *"); NLn(2);
IO.Put("       4)  Messaggio agli Utenti *"); NLn(2);
IO.Put("       5)  Richiesta LOG *"); NLn(2);
IO.Put("       6)  Chiudi Connessione"); NLn(2);
IO.Put("       7)  Fine"); NLn(2);

 IO.Put(" Scegli ! : ");
 CUPyx(22,13); Nu:=Rd.GetChar(Stdio.stdin); 
END Scelta;

(* --------------------Programma Principale -------------------------------- *)
BEGIN
      rand := NEW(Random.Default).init(TRUE) ;
	(* Inizializza il File di LOG *)
   FileL := FileWr.OpenAppend(FileLog);

       CLS(); Home();
       CUP(1,23);
	Bold();
     IO.Put("Programma per la gestione di BAR.NET");
	Normal();

     CUP(3,2); PutData(); 
     Orologio(3,70);

AddLocale := GetHostAddr();
CUP(4,2);PrintAddr(AddLocale);

MutTab := NEW(MUTEX);

AttesaConnessioni();


REPEAT                   (* Loop principale *)
Scelta();
	CASE Nu OF
		 '1'  =>   StampaTabellaConnessioni();
		|'2'  =>   PingChi();
		|'3'  =>    
		|'4'  =>   
		|'5'  =>   LOGChi();
		|'6'  =>   KillChi();
		|'7'  => CUP(10,2); CSCDown(); 
	
		ELSE  Bell(); PutErr(7,40,"Bho! "); 
	END;
UNTIL Nu = '7' ;

CUP(10,2); CSCDown();
CUP(15,38); IO.Put("FINE");NLn(3);

LOG("Fine Server");
Wr.Close(FileL);

END Server.

