
PROCEDURE ToHex(Text:TEXT): TEXT =
TYPE
	BYTE = [0..255];

VAR	i : CARDINAL;
	X : ARRAY [0..15] OF BYTE;
  	CodeSt : ARRAY[1..32] OF CHAR;
  	CC     : ARRAY[0..15] OF CHAR;

(* ---------- Procedura Interna --------------------------*)
PROCEDURE NbHex (Nibble:BYTE):CHAR =
(* Azione: Converte un nibble in carattere esadecimale *)
BEGIN
	IF Nibble < 10 THEN
		RETURN VAL(Nibble+48, CHAR)  (* Cifra *)
	ELSE  
		RETURN VAL(Nibble+87, CHAR); (* Lettera minuscola *)
	END;
END NbHex;
(* ----Fine   Procedura Interna --------------------------*)


BEGIN
	SetChars(CC,Text);
	(* Converti X[0..15] in una stringa esadecimale di 2*16 caratteri *)
	i := 0; (* Contatore *)
	WHILE i <= 15 DO
		       (* Converti da BYTE a Hex *)
		        X[i] := ORD(CC[i]);
			CodeSt[2*i+1] := NbHex (X[i] DIV 16);
			CodeSt[2*i+2] := NbHex (X[i] MOD 16);
			i := i + 1;
	END;
	RETURN  FromChars(CodeSt);
END ToHex;
