UNSAFE MODULE G_Lotti EXPORTS Main;

FROM vt100 IMPORT NL, NLn, Bell, CLS, CSCDown, Home, CUP, CUD, Bold, Blink,
		  UnderL, RevVideo, Normal, CLLeft, CLRight ;
FROM Text IMPORT GetChar, Length, SetChars, FromChars, FromChar, Equal, Sub;
FROM MD2 IMPORT MD2Code ;
FROM CodiceTessera IMPORT Codice ;
FROM Input IMPORT CUPyx, InpLine, InpInt, Orologio, PutErr ;
IMPORT IO, Rd, Wr, Stdio, Fmt, Thread, File, FS, Process  ;
IMPORT Tempo;
IMPORT Dbase;

(* < > -_ \ | $ / ' ~ ` ^ *)

<*FATAL IO.Error *>
<*FATAL Rd.Failure *>
<*FATAL Wr.Failure *>
<*FATAL Rd.EndOfFile *>
<*FATAL Thread.Alerted *>

EXCEPTION FineLotti;

TYPE CAR = ARRAY[0..35] OF CHAR;
     TRadice  = ARRAY[0..15] OF CHAR ;
     L300 = ARRAY[0..nA] OF TEXT;
     L150 = ARRAY[0..nB] OF TEXT;
     R300 =  RECORD
	         key : TEXT;
	         vet : L300;
	        END;
     R150 =  RECORD
	         key : TEXT;
	         vet : L150;
	        END;

VAR
   Str, Nt : TEXT;
   Radice  : TRadice ;
   Lotto, TLotto   : TEXT;
   N, Nl  : CARDINAL ; (* N numero tessere per lotto; Nl numero di lotti *)
   i, j   : CARDINAL;
   Nu, cr     : CHAR ;
   FileW : Wr.T;
   FileR : Rd.T;
   DBL : Dbase.T;
   Lotto300 :  R300;
   Lotto150 :  R150;

CONST
      FileRadice =  "/usr/bar/Lotti/RADICE.BAR" ;
      FileDB =      "/usr/bar/Lotti/Lotti.dbm" ;
      FileAcq =     "/usr/bar/Lotti/Acquisti.dbm";
      FileCli =     "/usr/bar/Clienti/Clienti.dbm";
      PathTess=     "/usr/bar/Lotti/" ;
      AlfaBeto = CAR {'0','1','2','3','4','5','6','7','8','9',
		       'A','B','C','D','E','F','G','H','I','J','K',
		       'L','M','N','O','P','Q','R','S','T','U','V',
		       'W','X','Y','Z'
		     };
      Spazi = "                                                           ";
      nA = 300;
      nB = 150;
      dis = 2 ; (* X Windows *)

(*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*)

PROCEDURE INCR(el:CARDINAL)= (* Incrementa l'elemento el di Radice *)
VAR n : INTEGER;	     (*	 secondo AlfaBeto *)
BEGIN
     FOR i := 0 TO 34 DO
	n := i;
	IF Radice[el] = AlfaBeto[i] THEN EXIT
	END;
     END;
     Radice[el] := AlfaBeto[n+1];
END INCR;


PROCEDURE IncrementaRadice()  RAISES {FineLotti} =
VAR p : INTEGER;
BEGIN
LeggiRadice(); (* la radice e' nella variabile globale Str di 16 caratteri *)

SetChars(Radice, Str); (* converte Str in array Radice *)
 p := 15;
 WHILE p # 0 DO
       IF    Radice[p] # AlfaBeto[35] THEN
	       INCR(p); p := 0;
       ELSE Radice[p] := AlfaBeto[0] ; DEC(p);
	    IF p = 0 THEN
		       Bell();  RAISE FineLotti
	    END;
       END;
 END;
Str := FromChars(Radice);
SalvaRadice();
END IncrementaRadice;


PROCEDURE PrintLotto(n:INTEGER)=
  PROCEDURE Sp(t:TEXT):TEXT =
    VAR Cin : ARRAY[0..12] OF CHAR;
	Cout : ARRAY[0..15] OF CHAR;
   BEGIN
     SetChars(Cin,t);
     Cout[0] := Cin[0]; Cout[1] := VAL(32,CHAR);Cout[6] := VAL(32,CHAR);
     Cout[11] := VAL(32,CHAR);
     FOR i := 1 TO 4 DO
       Cout[i+1] := Cin[i];
     END;
     FOR i := 5 TO 8 DO
       Cout[i+2] := Cin[i];
     END;
     FOR i := 9 TO 12 DO
       Cout[i+3] := Cin[i];
     END;
     RETURN FromChars(Cout);
  END Sp;
VAR i : CARDINAL;
    DA : TEXT := FromChar(VAL(27,CHAR)) & "[@" & FromChar(VAL(4,CHAR)) & FromChar(VAL(0,CHAR)) & FromChar(VAL(0,CHAR)) & FromChar(VAL(0,CHAR))& FromChar(VAL(34,CHAR)) & FromChar(VAL(1,CHAR));
    AN : TEXT := FromChar(VAL(27,CHAR)) & "[@" & FromChar(VAL(4,CHAR)) & FromChar(VAL(0,CHAR)) & FromChar(VAL(0,CHAR)) & FromChar(VAL(0,CHAR))& FromChar(VAL(17,CHAR)) & FromChar(VAL(1,CHAR));
    ENF : TEXT := FromChar(VAL(27,CHAR)) & "E";
    FENF : TEXT := FromChar(VAL(27,CHAR)) & "F";
    S18 : TEXT := "                  ";
    S20 : TEXT := "                    ";
    S22 : TEXT := "                      ";
    N6 : TEXT := "\n\n\n\n\n\n";
     Param : ARRAY[0..0] OF TEXT;
     Processo : Process.T;
     sio, sout, ser : File.T;
BEGIN
   FileW := IO.OpenWrite("Lotto.txt");
   IF n = nA THEN
	    FOR i := 1 TO nA BY 10 DO
	    IO.Put(AN &  "\n\n\n\n\n\n", FileW);
	    IO.Put(DA & ENF & S22 & Lotto300.key & AN & "\n\n\n\n\n" & DA, FileW);
	      FOR j := 0 TO 9 BY 2 DO
		IO.Put(S20 & Sp(Lotto300.vet[i+j]) & S18 & Sp(Lotto300.vet[i+j+1]) & N6, FileW);
	      END;
	      IO.Put(AN &  "\n", FileW);
	    END;
	    IO.Put(FENF,FileW);
   ELSE
	    FOR i := 1 TO nB BY 10 DO
	    IO.Put(AN &  "\n\n\n\n\n\n", FileW);
	    IO.Put(DA & ENF & S22 & Lotto150.key & AN & "\n\n\n\n\n" & DA, FileW);
	      FOR j := 0 TO 9 BY 2 DO
		IO.Put(S20 & Sp(Lotto150.vet[i+j]) & S18 & Sp(Lotto150.vet[i+j+1]) & N6, FileW);
	      END;
	      IO.Put(AN &  "\n", FileW);
	    END;
	    IO.Put(FENF,FileW);
   END;

   Wr.Close(FileW);

       Param[0] := "Lotto.txt" ;
       Process.GetStandardFileHandles(sio,sout,ser);
       Processo := Process.Create("lpr", Param,  stdin:= sio, stdout := sout, stderr:=ser);
 (*    FS.DeleteFile("Lotto.txt"); *)

END PrintLotto;


PROCEDURE Generazione()=

VAR Unicita : BOOLEAN;
(* -------------------------  Procedure Interne -------------------------*)

PROCEDURE Unico(n:INTEGER):BOOLEAN =
 (* VAR i, j : CARDINAL;*)
BEGIN
  IF n = nA THEN
     FOR i := 1 TO nA-1 DO
       FOR j := i+1 TO nA DO
	   IF Equal(Lotto300.vet[i], Lotto300.vet[j]) THEN
	      Bell();
	      CUP(6,37);IO.Put("Scartato il lotto ");IO.Put(Str); NL();
	      RETURN FALSE
	    END;
       END;
     END;
  ELSE
     FOR i := 1 TO nB-1 DO
       FOR j := i+1 TO nB DO
	   IF Equal(Lotto150.vet[i], Lotto150.vet[j]) THEN
	      Bell();
	      CUP(6,37);IO.Put("Scartato il lotto ");IO.Put(Str); NL();
	      RETURN FALSE
	   END;
       END;
     END;
  END;
  RETURN TRUE ;
END Unico;


PROCEDURE Archivia(n:INTEGER) =
BEGIN
	   V2T(n);
	   Dbase.Store(DBL, Lotto, TLotto  );
END Archivia;

(* ------------------------- Fine Procedure Interne ---------------------*)

BEGIN
CUP(10,2); CSCDown();
IO.Put("Generazione di "); IO.PutInt(Nl); IO.Put(" Lotti di Tessere da ");
			 IF N=150 THEN IO.Put("un'ora");
				  ELSE IO.Put("mezz'ora");
			 END;
			 NL();
i := 0;
 DBL := Dbase.Open(FileDB);
WHILE i # Nl DO

 TRY
    IncrementaRadice();
    CUP(8,37);IO.Put(Str); NL();
 EXCEPT
  | FineLotti => CUP(12,12); CSCDown();Blink();IO.Put("Fine LOTTI ");Normal();
			       cr := Rd.GetChar(Stdio.stdin);
			       EXIT;
 END;
    IF N=nA THEN
       Lotto :="A-"& Str ;
       Lotto300.key    := Lotto;
       Lotto300.vet[0] := "1234567890123";
       FOR j := 1 TO N DO
	  (*   IO.Put(Codice(MD2Code(Lotto & Fmt.Int(j) ))); NL();*)
	  Lotto300.vet[j] := Codice(MD2Code(Lotto & Fmt.Int(j) ));
       END;
       (* Controllo di unicita', Se OK incrementa i *)
       Unicita := Unico(N);
       (* Archivia Lotto300 *)
    ELSE
       Lotto := "B-"& Str ;      (* 18 caratteri *)
       Lotto150.key    := Lotto;
       Lotto150.vet[0] := "1234567890123";  (* Per usi futuri *)
       FOR j := 1 TO N DO
	  (*   IO.Put(Codice(MD2Code(Lotto & Fmt.Int(j) ))); NL();*)
	  Lotto150.vet[j] := Codice(MD2Code(Lotto & Fmt.Int(j) ));
       END;
       (* Controllo di unicita', Se OK incrementa i *)
       Unicita := Unico(N);
    END;

    IF Unicita THEN
	       Archivia(N);
	       PrintLotto(N);
	       INC(i)       (* Se unicita' OK *)
    END;                    (* Altrimenti il blocco viene scartato *)
END;
  Dbase.Close(DBL);
END Generazione;


PROCEDURE NuoviLotti()=
BEGIN
LeggiRadice();
MostraRadice();
REPEAT
CUP(10,2); CSCDown();
RevVideo();IO.Put(" Che tipo di lotti vuoi generare ? :"); NLn(2); Normal();
   IO.Put("       1)  1 Ora"); NLn(2);
   IO.Put("       2)  1/2 Ora"); NLn(2);
   IO.Put("       3)  Fine"); NLn(2);

   IO.Put(" Scegli ! : ");
   CUPyx(18,13); Nu:=Rd.GetChar(Stdio.stdin);

	CASE Nu OF
		 '1'  => N := nB;
			 IO.Put(" Quanti lotti di "); IO.PutInt(nB);
			 IO.Put(" tessere da un'ora ? : ");
			 CUPyx(18,57);	 Nl := InpInt();
			 Generazione();
		|'2'  => N := nA;
			 IO.Put(" Quanti lotti di ");IO.PutInt(nA);
			 IO.Put(" tessere da mezz'ora ? : ");
			 CUPyx(18,57);	 Nl := InpInt();
			 Generazione();
		|'3'  => CUP(10,2); CSCDown();
		ELSE     PutErr(7,40,"Bho! ");
	END;
UNTIL Nu = '3' ;
END NuoviLotti;



(*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*)

PROCEDURE GestisciDB() =
VAR    Chiave : TEXT;
(* -------------------------  Procedure Interne -------------------------*)
PROCEDURE PrimoLotto()=
BEGIN
     Chiave :=  Dbase.FirstKey(DBL );
CUP(6,37);
	 IF Chiave # NIL THEN IO.Put(Chiave);
			 ELSE IO.Put(" Nessuna Chiave     ");
	 END;


END PrimoLotto;


PROCEDURE NextLotto()=
BEGIN
     Chiave :=  Dbase.NextKey(DBL );
CUP(6,37);
	 IF Chiave # NIL THEN IO.Put(Chiave);
	            	 ELSE IO.Put(" Nessuna Chiave     ");
	 END;
END NextLotto;


PROCEDURE FileLotto(n:INTEGER)=
VAR i : CARDINAL;
BEGIN
   FileW := IO.OpenWrite("Lotto.txt");
   IF n = nA THEN
	    IO.Put(Lotto300.key & "\n\n", FileW);
	    IO.Put(Lotto300.vet[0] & "\n", FileW);
	    FOR i := 1 TO nA BY 5 DO
			  IO.Put(Lotto300.vet[i]   & "   ", FileW);
			  IO.Put(Lotto300.vet[i+1] & "   " , FileW);
			  IO.Put(Lotto300.vet[i+2] & "   " , FileW);
			  IO.Put(Lotto300.vet[i+3] & "   " , FileW);
			  IO.Put(Lotto300.vet[i+4] & "\n" , FileW);
	    END;
   ELSE
	    IO.Put(Lotto150.key & "\n\n", FileW);
	    IO.Put(Lotto150.vet[0] & "\n", FileW);
	    FOR i := 1 TO nB BY 5 DO
			  IO.Put(Lotto150.vet[i]   & "   ", FileW);
			  IO.Put(Lotto150.vet[i+1] & "   " , FileW);
			  IO.Put(Lotto150.vet[i+2] & "   " , FileW);
			  IO.Put(Lotto150.vet[i+3] & "   " , FileW);
			  IO.Put(Lotto150.vet[i+4] & "\n" , FileW);
	    END;
   END;

   Wr.Close(FileW);

END FileLotto;


PROCEDURE VisLotto()=
BEGIN
  IF Chiave # NIL THEN
     TLotto := Dbase.Fetch(DBL, Chiave);
IF TLotto # NIL THEN
     IF GetChar(Chiave,0) = 'A' THEN
				  T2V(nA);
				  Lotto300.key := Chiave;
				  FileLotto(nA);
				  CUP(8,1);
				  IO.Put(Lotto300.vet[0] & ", ");
				  IO.Put(Lotto300.vet[1] & ", ");
				  IO.Put(Lotto300.vet[2] & ", ");
				  IO.Put(Lotto300.vet[3] & ", ");
				  IO.Put(Lotto300.vet[4] & ", ");
     ELSE
				  T2V(nB);
				  Lotto150.key := Chiave;
				  FileLotto(nB);
				  CUP(8,1);
				  IO.Put(Lotto150.vet[0] & ", ");
				  IO.Put(Lotto150.vet[1] & ", ");
				  IO.Put(Lotto150.vet[2] & ", ");
				  IO.Put(Lotto150.vet[3] & ", ");
				  IO.Put(Lotto150.vet[4] & ", ");
     END;
ELSE
 Bell();
END;
  ELSE Bell();
  END;
END VisLotto;

PROCEDURE DelLotto()=
BEGIN
      IF Chiave # NIL THEN
			  Dbase.Delete(DBL, Chiave);
      END;
END DelLotto;
(* ------------------------- Fine Procedure Interne ---------------------*)
BEGIN
 DBL := Dbase.Open(FileDB);
REPEAT
CUP(10,2); CSCDown();
RevVideo();
IO.Put(" Cosa vuoi fare ? :"); NLn(2); Normal();
IO.Put("       1)  Visualizzare la prima chiave"); NLn(2);
IO.Put("       2)  Visualizzare la chiave successiva"); NLn(2);
IO.Put("       3)  Visualizzare il lotto di tessere"); NLn(2);
IO.Put("       4)  Eliminare il lotto di tessere"); NLn(2);
IO.Put("       5)  Compattare il Data Base"); NLn(2);
IO.Put("       6)  Fine"); NLn(2);

 IO.Put(" Scegli ! : ");
 CUPyx(24,13); Nu:=Rd.GetChar(Stdio.stdin);

	CASE Nu OF
		 '1'  => PrimoLotto();
		|'2'  => NextLotto();
		|'3'  => VisLotto();
		|'4'  => DelLotto();
		|'5'  => Dbase.Reorganize(DBL);
		|'6'  => CUP(8,1); CSCDown();  CUP(6,37); CLRight();
		ELSE     PutErr(7,40,"Bho! ");
	END;
UNTIL Nu = '6' ;
Nu := '0';
 Dbase.Close(DBL);
END GestisciDB;


PROCEDURE V2T(n:INTEGER) = (* Vettore Lotto a TLotto *)
VAR i : CARDINAL;
BEGIN
      TLotto := "";
  IF n = nB THEN
      FOR i := 0 TO nB DO
	TLotto := TLotto & Lotto150.vet[i] ;
      END;
  ELSE
      FOR i := 0 TO nA DO
	TLotto := TLotto & Lotto300.vet[i] ;
      END;
  END;
END V2T;


PROCEDURE T2V(n:INTEGER) =  (* TLotto a vettore *)
VAR i : CARDINAL;
BEGIN
	IF n = nB THEN
	   FOR i := 0 TO nB DO
		Lotto150.vet[i] := Sub(TLotto, i*13, 13);
	   END;
	ELSE
	   FOR i := 0 TO nA DO
		Lotto300.vet[i] := Sub(TLotto, i*13, 13);
	   END;
	END;
END T2V;

(*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*)

PROCEDURE LeggiRadice() =
BEGIN
   FileR := IO.OpenRead(FileRadice);
   Str := IO.GetLine(FileR);
   Rd.Close(FileR);
END LeggiRadice;


PROCEDURE SalvaRadice()=
BEGIN
   FileW := IO.OpenWrite(FileRadice);
   IO.Put(Str, FileW);
   Wr.Close(FileW);
END SalvaRadice;

PROCEDURE MostraRadice() =
BEGIN
   LeggiRadice();
CUP(8,37);IO.Put(Str);
END MostraRadice;


PROCEDURE CheckOK(): BOOLEAN =
VAR c,p : INTEGER;
    Cha : CHAR ;
    NellInsieme, OK : BOOLEAN;
BEGIN
IF Length(Str)=16 THEN
  FOR c := 0 TO 15 DO
  NellInsieme := FALSE;
      Cha := GetChar(Str,c);
      FOR p := 0 TO 35 DO
	  IF Cha = AlfaBeto[p] THEN NellInsieme := TRUE; EXIT  END;
      END;
      IF NellInsieme = FALSE THEN EXIT END;
  END;

  RETURN   NellInsieme
ELSE
 RETURN FALSE;
END;
END CheckOK;


PROCEDURE CambiaRadice()=
BEGIN
REPEAT
CUP(10,2); CSCDown();
   LeggiRadice();
CUP(12,10);IO.Put(" Aggiornamento della Radice             ");
CUP(14,32);IO.Put(Str);
CUP(16,32);IO.Put("----------------");
CUPyx(15,32);
	  Str := InpLine(dis);
(*	  Str := IO.GetLine(Stdio.stdin); *)
      (*  Str := Rd.GetText(Stdio.stdin, 16); *)
UNTIL CheckOK();
   SalvaRadice();
CUP(8,37);IO.Put(Str);
END CambiaRadice;


PROCEDURE NuovaRadice()=
BEGIN
REPEAT
CUP(10,2); CSCDown();
CUP(12,10);IO.Put(" Introduci una stringa da 16 caratteri: ");
CUP(14,32);IO.Put("________________");
CUP(16,32);IO.Put("----------------");
CUPyx(15,32);
	  Str := InpLine(dis);
    (*	  Str := IO.GetLine(Stdio.stdin); *)
      (*  Str := Rd.GetText(Stdio.stdin, 16); *)
UNTIL CheckOK();
   SalvaRadice();
CUP(8,37);IO.Put(Str);
END NuovaRadice;


PROCEDURE GestisciRadice()=
BEGIN
REPEAT
CUP(10,2); CSCDown();
RevVideo();
IO.Put(" Cosa vuoi fare ? :"); NLn(2); Normal();
IO.Put("       1)  Introdurre una nuova Radice"); NLn(2);
IO.Put("       2)  Cambiare la Radice esistente"); NLn(2);
IO.Put("       3)  Mostrare la Radice esistente"); NLn(2);
IO.Put("       4)  Fine"); NLn(2);

 IO.Put(" Scegli ! : ");
 CUPyx(20,13); Nu:=Rd.GetChar(Stdio.stdin);

	CASE Nu OF
		|'1'  =>    NuovaRadice();
		|'2'  =>    CambiaRadice();
		|'3'  =>    MostraRadice();
		|'4'  => CUP(10,2); CSCDown();

		ELSE  Bell(); CUP(7,40);IO.Put("Bho! ");
	END;
UNTIL Nu = '4' ;
Nu := '0';
END GestisciRadice;

(*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*)

PROCEDURE Acquisti()=
BEGIN
REPEAT
CUP(10,2); CSCDown();
RevVideo();
IO.Put(" Cosa vuoi fare ? :"); NLn(2); Normal();
IO.Put("       1)  Altro Cliente"); NLn(2);
IO.Put("       2)  Fine"); NLn(2);

 IO.Put(" Scegli ! : ");
 CUPyx(16,13); Nu:=Rd.GetChar(Stdio.stdin);

	CASE Nu OF
		 '1'  => AltroCliente();
		|'2'  => CUP(10,2); CSCDown();

		ELSE  PutErr(7,40,"Bho! ");
	END;
UNTIL Nu = '2' ;
END Acquisti;


PROCEDURE GetPassW(CC:TEXT):TEXT =  (* Dal Data Base Clienti *)
VAR        DBCli : Dbase.T;
	   Dati : TEXT;
BEGIN

DBCli := Dbase.Open(FileCli);
Dati := Dbase.Fetch(DBCli, CC);
Dbase.Close(DBCli);
  IF Dati = NIL THEN
		RETURN NIL;
  ELSE
      RETURN Sub(Dati,    361, 8);
  END;
END GetPassW;


PROCEDURE AltroCliente()=
VAR CodiceC, Chiave, PassW, Acquisto, TipoLotto, Path : TEXT;
    DBCL, DBB : Dbase.T;
    OK   : BOOLEAN;
	Param : ARRAY[0..3] OF TEXT;
	Processo : Process.T;
	sio, sout, ser : File.T;
BEGIN
     REPEAT
	OK := FALSE;
	CUP(21,32); IO.Put("-------");
	CUP(20,2); IO.Put("Introduci il codice cliente : ");
	CUPyx(20,32);
	CodiceC := InpLine(dis);
(* Rd.GetLine(Stdio.stdin);                             *)
		IF Equal(CodiceC,"") THEN CUP(6,40); CLRight(); RETURN END;
	(* Controllo validita' e di esistenza nel DB Clienti *)
	IF Length(CodiceC) # 7 THEN
		PutErr(6,40,"Codice Cliente errato !");
	ELSE
		OK := TRUE;
	END;
	(* Ottiene la Password dal Data Base Clienti *)
	PassW := GetPassW(CodiceC);
	IF PassW # NIL THEN
	        OK := TRUE;
	ELSE
		OK := FALSE;
		PutErr(6,40,"Cliente sconosciuto !");
	END;
     UNTIL OK;
	CUP(6,40); CLRight();

	DBCL := Dbase.Open(FileAcq); (* Acquisti *)
	IF DBCL = NIL THEN DBCL := Dbase.Create(FileAcq) END;

	DBL := Dbase.Open(FileDB);   (* Lotti *)

REPEAT
    REPEAT
	Bell(); OK := FALSE;
	CUP(23,23); IO.Put("------------------");
	CUP(22,2); IO.Put("Introduci il lotto : ");
	CUPyx(22,23);
	Chiave := InpLine(dis);
(* Rd.GetLine(Stdio.stdin);   *)
		(* Controllo validita' e di non esistenza nel DB Acquisti *)
 	IF Length(Chiave)= 18 THEN
	    TLotto := Dbase.Fetch(DBCL, Chiave); (* Nel DB Acquisti *)
	    IF TLotto # NIL THEN
			PutErr(6,40,"Lotto gia' assegnato !");
			OK := FALSE
	    ELSE
			OK := TRUE;
			CUP(6,40); CLRight();
	    END;

	ELSE
	      IF Equal(Chiave, "") THEN  (* Per uscire *)
		OK := TRUE;
		CUP(6,40); CLRight();
	      ELSE
		OK := FALSE;
		PutErr(6,40,"Lotto errato !");
	      END;
 	END;

	CUP(22,2); CLRight();
    UNTIL OK ;

IF Chiave # NIL THEN
     TLotto := Dbase.Fetch(DBL, Chiave);  (* Lotti *)
 IF TLotto # NIL THEN   (* Il Lotto esiste *)
     CUP(7,37);IO.Put(Chiave);
     TipoLotto := Sub(Chiave,0,1); (* A o B o ... *)
     Path := PathTess & CodiceC & "/" ;
     DBB := Dbase.Open("BAR_" & CodiceC & ".dbm");
     IF DBB = NIL THEN DBB := Dbase.Create("BAR_" & CodiceC & ".dbm") ; END;
     IF GetChar(Chiave,0) = 'A' THEN
				  T2V(nA);
				  Lotto300.key := Chiave;
				  CUP(8,1);
				  IO.Put(Lotto300.vet[0] & ", ");
				  IO.Put(Lotto300.vet[1] & ", ");
				  IO.Put(Lotto300.vet[2] & ", ");
				  IO.Put(Lotto300.vet[3] & ", ");
				  IO.Put(Lotto300.vet[4] & ", ");


	FOR i:= 1 TO nA DO
   Dbase.Store(DBB,ToHex(MD2Code(CodiceC & Lotto300.vet[i] & PassW)),TipoLotto);
	END;

     ELSE
				  T2V(nB);
				  Lotto150.key := Chiave;
				  CUP(8,1);
				  IO.Put(Lotto150.vet[0] & ", ");
				  IO.Put(Lotto150.vet[1] & ", ");
				  IO.Put(Lotto150.vet[2] & ", ");
				  IO.Put(Lotto150.vet[3] & ", ");
				  IO.Put(Lotto150.vet[4] & ", ");
	FOR i:= 1 TO nB DO
   Dbase.Store(DBB,ToHex(MD2Code(CodiceC & Lotto150.vet[i] & PassW)),TipoLotto);
	END;
     END;
     Dbase.Close(DBB);

     Acquisto := Sub(CodiceC & Tempo.DataT() & " " &  Spazi ,0,32 );
     Dbase.Store(DBCL, Chiave, Acquisto);
 ELSE
  Bell();  (* Lotto inesistente *)
  CUP(6,40); IO.Put("Lotto inesistente !");
 END;
ELSE Bell(); (* Chiave Nulla *)
END;
UNTIL Equal(Chiave, "");
CUP(1,1);

	    Param[0] := "czf" ;
	    Param[1] := Path & CodiceC & ".tgz" ;
	    Param[2] :=  "BAR_" & CodiceC & ".dbm.dir" ;
	    Param[3] :=  "BAR_" & CodiceC & ".dbm.pag" ;

       Process.GetStandardFileHandles(sio,sout,ser);
       Processo := Process.Create("tar", Param,  stdin:= sio, stdout := sout, stderr:=ser);
       EVAL Process.Wait(Processo);
       FS.DeleteFile("BAR_" & CodiceC & ".dbm.dir");
       FS.DeleteFile("BAR_" & CodiceC & ".dbm.pag");

 CUP(6,40); CLRight();
 CUP(7,37);CLRight(); CUP(8,1);CLRight();
 Dbase.Close(DBL);
 Dbase.Close(DBCL);
END AltroCliente;


PROCEDURE ToHex(Text:TEXT): TEXT =
TYPE
	BYTE = [0..255];

VAR	i : CARDINAL;
	X : ARRAY [0..15] OF BYTE;
  	CodeSt : ARRAY[1..32] OF CHAR;
  	CC     : ARRAY[0..15] OF CHAR;

(* ---------- Procedura Interna --------------------------*)
PROCEDURE NbHex (Nibble:BYTE):CHAR =
(* Azione: Converte un nibble in carattere esadecimale *)
BEGIN
	IF Nibble < 10 THEN
		RETURN VAL(Nibble+48, CHAR)  (* Cifra *)
	ELSE
		RETURN VAL(Nibble+87, CHAR); (* Lettera minuscola *)
	END;
END NbHex;
(* ----Fine   Procedura Interna --------------------------*)


BEGIN
	SetChars(CC,Text);
	(* Converti X[0..15] in una stringa esadecimale di 2*16 caratteri *)
	i := 0; (* Contatore *)
	WHILE i <= 15 DO
		       (* Converti da BYTE a Hex *)
		        X[i] := ORD(CC[i]);
			CodeSt[2*i+1] := NbHex (X[i] DIV 16);
			CodeSt[2*i+2] := NbHex (X[i] MOD 16);
			i := i + 1;
	END;
	RETURN  FromChars(CodeSt);
END ToHex;

(*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*)
PROCEDURE Scelta()=
BEGIN
CUP(10,2); CSCDown();
RevVideo();
IO.Put(" Cosa vuoi fare ? :"); NLn(2); Normal();
IO.Put("       1)  Generare lotti di tessere"); NLn(2);
IO.Put("       2)  Gestire acquisti di tessere"); NLn(2);
IO.Put("       3)  Modificare la Radice"); NLn(2);
IO.Put("       4)  Gestire il Data Base"); NLn(2);
IO.Put("       5)  Fine"); NLn(2);

 IO.Put(" Scegli ! : ");
 CUPyx(22,13); Nu:=Rd.GetChar(Stdio.stdin);


END Scelta;
(*--------------------------
Procedure:   SalvaRadice()
	     LeggiRadice()
	     MostraRadice()

*)
(*#########################################################################*)

BEGIN
       CLS(); Home();
       CUP(4,15);
	Bold();
     IO.Put("Programma per la generazione di lotti di tessere");
	Normal();

     CUP(7,2);Tempo.PutData();
     Orologio(7,70);

REPEAT
Scelta();
	CASE Nu OF
		 '1'  =>    NuoviLotti();
		|'2'  =>    Acquisti();
		|'3'  =>    GestisciRadice();
		|'4'  =>    GestisciDB();
		|'5'  => CUP(10,2); CSCDown();

		ELSE  Bell(); PutErr(7,40,"Bho! ");
	END;
UNTIL Nu = '5' ;

CUP(10,2); CSCDown();
CUP(15,38); IO.Put("FINE");NLn(3);
(*#########################################################################*)

END G_Lotti.
