MODULE CodiceTessera;

IMPORT Fingerprint ,  Word ;
FROM Word IMPORT Extract, Insert, RightShift  ;
FROM Text IMPORT FromChars ;

PROCEDURE Codice(Str:TEXT): TEXT =

TYPE  BIT5 = [0..32];

VAR 
    Impronta : Fingerprint.T;
    i : INTEGER;
    Vet : ARRAY [1..4] OF Word.T ; (* Contiene i 64 bit in 4 Word *)
    tmp, tmp1 : Word.T ;
    Vet5bit : ARRAY [0..12] OF BIT5 ; (* Contiene i 13 caratteri definiti *)
				      (* definiti su 5 bit *)
    Char12 : ARRAY [0..12] OF CHAR ;  (* Contiene i 13 caratteri *)

CONST VetChar = ARRAY [0..31] OF CHAR
	       {VAL(65,CHAR), (* A *)
		VAL(66,CHAR),
		VAL(67,CHAR),
		VAL(68,CHAR),
		VAL(69,CHAR),
		VAL(70,CHAR),
		VAL(71,CHAR),
		VAL(72,CHAR),
		VAL(73,CHAR),
		VAL(74,CHAR),
		VAL(75,CHAR),
		VAL(76,CHAR),
		VAL(77,CHAR),
		VAL(78,CHAR),
		VAL(55,CHAR), (* 7 *) (* per evitare O simile a 0 *)
		VAL(80,CHAR),
		VAL(81,CHAR),
		VAL(82,CHAR),
		VAL(83,CHAR),
		VAL(84,CHAR),
		VAL(85,CHAR),
		VAL(86,CHAR),
		VAL(87,CHAR),
		VAL(88,CHAR),
		VAL(89,CHAR),
		VAL(90,CHAR), (* Z *)
		VAL(49,CHAR), (* 1 *)
		VAL(50,CHAR),
		VAL(51,CHAR),
		VAL(52,CHAR),
		VAL(53,CHAR),
		VAL(54,CHAR)  (* 6 *)
	       };

BEGIN
    Impronta := Fingerprint.FromText(Str);


    FOR i := 0 TO 7 BY 2 DO (* Due byte in ogni Word *)
	       Vet[(i DIV 2)+1] := Impronta.byte[i]+ Impronta.byte[i+1] * 256;
    END;

  
    Vet5bit[0] := Extract(Vet[1], 0, 5);
    Vet5bit[1] := Extract(Vet[1], 5, 5);
    Vet5bit[2] := Extract(Vet[1], 10, 5);

   tmp := RightShift( Vet[2], 1) ; (* Shift a destra per liberare il primo bit*)
   tmp1:= Extract(Vet[1],15,1);     (* Estrae l' ultimo bit *)
   tmp := Insert( tmp,tmp1, 0, 1);    
    
    Vet5bit[3] := Extract(tmp, 0, 5);
    Vet5bit[4] := Extract(tmp, 5, 5);
    Vet5bit[5] := Extract(tmp, 10, 5);

   tmp := RightShift( Vet[3], 2) ; (* Shift a destra per liberare i primi 2 bit*)
   tmp1:= Extract(Vet[2],14,2);     (* Estrae gli ultimi 2 bit *)
   tmp := Insert( tmp,tmp1, 0, 2);    

    Vet5bit[6] := Extract(tmp, 0, 5);
    Vet5bit[7] := Extract(tmp, 5, 5);
    Vet5bit[8] := Extract(tmp, 10, 5);

   tmp := RightShift( Vet[4], 3) ; (* Shift a destra per liberare i primi 3 bit*)
   tmp1:= Extract(Vet[3],13,3);     (* Estrae gli ultimi 3 bit *)
   tmp := Insert( tmp,tmp1, 0, 3);

    Vet5bit[9] := Extract(tmp, 0, 5);
    Vet5bit[10] := Extract(tmp, 5, 5);
    Vet5bit[11] := Extract(tmp, 10, 5);

    Vet5bit[12] := Extract(Vet[4], 12, 4);

FOR i:= 0 TO 12 DO (* Assegna i caratteri dal vettore che li contiene *)
    Char12[i] := VetChar[Vet5bit[i]];
END;

   RETURN  FromChars(Char12);
END Codice;

BEGIN
END CodiceTessera.
