UNSAFE MODULE G_Lotti EXPORTS Main;

FROM vt100 IMPORT NL, NLn, Bell, CLS, CSCDown, Home, CUP, CUD, Bold, Blink,
		  UnderL, RevVideo, Normal, CLLeft, CLRight ;
FROM Text IMPORT GetChar, Length, SetChars, FromChars, Equal, Sub;
FROM MD2 IMPORT MD2Code ;
FROM CodiceTessera IMPORT Codice ;
IMPORT IO, Rd, Wr, Stdio, Fmt, Thread  ;
IMPORT Tempo;
IMPORT Dbase;

(* < > -_ \ | $ / ' ~ ` ^ *)

<*FATAL IO.Error *>
<*FATAL Rd.Failure *>
<*FATAL Wr.Failure *>
<*FATAL Rd.EndOfFile *>
<*FATAL Thread.Alerted *>

EXCEPTION FineLotti;

TYPE CAR = ARRAY[0..35] OF CHAR;
     TRadice  = ARRAY[0..15] OF CHAR ; 
     L300 = ARRAY[0..300] OF TEXT;
     L150 = ARRAY[0..150] OF TEXT;
     R300 =  RECORD
	         key : TEXT;
	         vet : L300;
	        END;
     R150 =  RECORD
	         key : TEXT;
	         vet : L150;
	        END;
	    
VAR 
   Str, Nt : TEXT;
   Radice  : TRadice ; 
   Lotto, TLotto   : TEXT;
   N, Nl  : CARDINAL ; (* N numero tessere per lotto; Nl numero di lotti *)
   i, j   : CARDINAL;
   Nu, cr     : CHAR ;
   File  : Wr.T;
   FileR : Rd.T;
   DBL : Dbase.T;
   Lotto300 :  R300;
   Lotto150 :  R150;

CONST
      FileRadice =  "RADICE.BAR" ;
      FileDB =      "Lotti.dbm" ;
      FileAcq =     "Acquisti.dbm";
      FileCli =     "Clienti.dbm";
      AlfaBeto = CAR {'0','1','2','3','4','5','6','7','8','9',
		       'A','B','C','D','E','F','G','H','I','J','K',
		       'L','M','N','O','P','Q','R','S','T','U','V',
		       'W','X','Y','Z'                      
		     };
      Spazi = "                                                           ";


(*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*)

PROCEDURE INCR(el:CARDINAL)= (* Incrementa l'elemento el di Radice *)
VAR n : INTEGER;	     (*	 secondo AlfaBeto *) 
BEGIN
     FOR i := 0 TO 34 DO
	n := i;
	IF Radice[el] = AlfaBeto[i] THEN EXIT
	END;
     END;
     Radice[el] := AlfaBeto[n+1];
END INCR;


PROCEDURE IncrementaRadice()  RAISES {FineLotti} = 
VAR p : INTEGER;
BEGIN
LeggiRadice(); (* la radice e' nella variabile globale Str di 16 caratteri *)

SetChars(Radice, Str); (* converte Str in array Radice *)
 p := 15;
 WHILE p # 0 DO
       IF    Radice[p] # AlfaBeto[35] THEN
	       INCR(p); p := 0;                    
       ELSE Radice[p] := AlfaBeto[0] ; DEC(p);
	    IF p = 0 THEN
		       Bell();  RAISE FineLotti
	    END;
       END;
 END;
Str := FromChars(Radice);
SalvaRadice();
END IncrementaRadice;




PROCEDURE Generazione()=

VAR Unicita : BOOLEAN;
(* -------------------------  Procedure Interne -------------------------*)

PROCEDURE Unico(n:INTEGER):BOOLEAN =
VAR i, j : CARDINAL;
BEGIN
  IF n = 300 THEN 
     FOR i := 1 TO 299 DO
       FOR j := i+1 TO 300 DO
	   IF Equal(Lotto300.vet[i], Lotto300.vet[j]) THEN
	      Bell();
	      CUP(6,37);IO.Put("Scartato il lotto ");IO.Put(Str); NL();
	      RETURN FALSE 
	    END;
       END;
     END;
  ELSE
     FOR i := 1 TO 149 DO
       FOR j := i+1 TO 150 DO
	   IF Equal(Lotto150.vet[i], Lotto150.vet[j]) THEN
	      Bell();
	      CUP(6,37);IO.Put("Scartato il lotto ");IO.Put(Str); NL();
	      RETURN FALSE
	   END;
       END;
     END;
  END;
  RETURN TRUE ;
END Unico;


PROCEDURE Archivia(n:INTEGER) =
BEGIN
	   V2T(n);
	   Dbase.Store(DBL, Lotto, TLotto  ); 
END Archivia;

(* ------------------------- Fine Procedure Interne ---------------------*)

BEGIN
CUP(10,2); CSCDown();
IO.Put("Generazione di "); IO.PutInt(Nl); IO.Put(" Lotti di Tessere da ");
			 IF N=150 THEN IO.Put("un'ora");
				  ELSE IO.Put("mezz'ora");
			 END;
			 NL();    
i := 0;
 DBL := Dbase.Open(FileDB);   
WHILE i # Nl DO

 TRY
    IncrementaRadice(); 
    CUP(8,37);IO.Put(Str); NL();
 EXCEPT
  | FineLotti => CUP(12,12); CSCDown();Blink();IO.Put("Fine LOTTI ");Normal();
			       cr := Rd.GetChar(Stdio.stdin);
			       EXIT;                
 END;
    IF N=300 THEN
       Lotto :="A-"& Str ;
       Lotto300.key    := Lotto;
       Lotto300.vet[0] := "1234567890123";
       FOR j := 1 TO N DO
	  (*   IO.Put(Codice(MD2Code(Lotto & Fmt.Int(j) ))); NL();*)
	  Lotto300.vet[j] := Codice(MD2Code(Lotto & Fmt.Int(j) ));
       END;
       (* Controllo di unicita', Se OK incrementa i *)
       Unicita := Unico(N);
       (* Archivia Lotto300 *)
    ELSE
       Lotto := "B-"& Str ;      (* 18 caratteri *)
       Lotto150.key    := Lotto;
       Lotto150.vet[0] := "1234567890123";  (* Per usi futuri *)
       FOR j := 1 TO N DO
	  (*   IO.Put(Codice(MD2Code(Lotto & Fmt.Int(j) ))); NL();*)
	  Lotto150.vet[j] := Codice(MD2Code(Lotto & Fmt.Int(j) ));
       END;
       (* Controllo di unicita', Se OK incrementa i *)
       Unicita := Unico(N); 
    END;

    IF Unicita THEN  
	       Archivia(N);
	       INC(i)       (* Se unicita' OK *)
    END;                    (* Altrimenti il blocco viene scartato *)
END;
  Dbase.Close(DBL);
END Generazione;


PROCEDURE NuoviLotti()=
BEGIN
LeggiRadice();
MostraRadice();
REPEAT
CUP(10,2); CSCDown();
RevVideo();IO.Put(" Che tipo di lotti vuoi generare ? :"); NLn(2); Normal();
   IO.Put("       1)  1 Ora"); NLn(2); 
   IO.Put("       2)  1/2 Ora"); NLn(2);
   IO.Put("       3)  Fine"); NLn(2);

   IO.Put(" Scegli ! : "); Nt:=Rd.GetLine(Stdio.stdin);
	  		   Nu := GetChar(Nt,0);

	CASE Nu OF
		 '1'  => N := 150;
			 IO.Put(" Quanti lotti di 150 tessere da un'ora ? : ");
			 Nl := IO.GetInt(Stdio.stdin); 
			       cr := Rd.GetChar(Stdio.stdin);
			 Generazione();
		|'2'  => N := 300;
			 IO.Put(" Quanti lotti di 300 tessere da mezz'ora ? : ");
			 Nl := IO.GetInt(Stdio.stdin); 
			       cr := Rd.GetChar(Stdio.stdin);
			 Generazione();
		|'3'  => CUP(10,2); CSCDown();  
		ELSE  Bell(); CUP(7,40);IO.Put("Bho! "); 
	END;
UNTIL Nu = '3' ;
END NuoviLotti;



(*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*)

PROCEDURE GestisciDB() =
VAR    Chiave : TEXT;
(* -------------------------  Procedure Interne -------------------------*)
PROCEDURE PrimoLotto()=
BEGIN
     Chiave :=  Dbase.FirstKey(DBL ); 
CUP(6,37);   
	 IF Chiave # NIL THEN IO.Put(Chiave);
			 ELSE IO.Put(" Nessuna Chiave     ");
	 END; 


END PrimoLotto;


PROCEDURE NextLotto()=
BEGIN
     Chiave :=  Dbase.NextKey(DBL ); 
CUP(6,37);   
	 IF Chiave # NIL THEN IO.Put(Chiave);
	            	 ELSE IO.Put(" Nessuna Chiave     ");
	 END; 
END NextLotto;

PROCEDURE FileLotto(n:INTEGER)=
VAR i : CARDINAL;
BEGIN
   File := IO.OpenWrite("Lotto.txt");
   IF n = 300 THEN
	    IO.Put(Lotto300.key & "\n\n", File);
	    IO.Put(Lotto300.vet[0] & "\n", File);
	    FOR i := 1 TO 300 BY 5 DO 
			  IO.Put(Lotto300.vet[i]   & "   ", File);
			  IO.Put(Lotto300.vet[i+1] & "   " , File);
			  IO.Put(Lotto300.vet[i+2] & "   " , File);
			  IO.Put(Lotto300.vet[i+3] & "   " , File);
			  IO.Put(Lotto300.vet[i+4] & "\n" , File);
	    END;
   ELSE
	    IO.Put(Lotto150.key & "\n\n", File);
	    IO.Put(Lotto150.vet[0] & "\n", File);
	    FOR i := 1 TO 150 BY 5 DO 
			  IO.Put(Lotto150.vet[i]   & "   ", File);
			  IO.Put(Lotto150.vet[i+1] & "   " , File);
			  IO.Put(Lotto150.vet[i+2] & "   " , File);
			  IO.Put(Lotto150.vet[i+3] & "   " , File);
			  IO.Put(Lotto150.vet[i+4] & "\n" , File);
	    END;
   END;

   Wr.Close(File);

END FileLotto;

PROCEDURE VisLotto()=
BEGIN
  IF Chiave # NIL THEN
     TLotto := Dbase.Fetch(DBL, Chiave); 
IF TLotto # NIL THEN 
     IF GetChar(Chiave,0) = 'A' THEN 
				  T2V(300);
				  Lotto300.key := Chiave;
				  FileLotto(300);
				  CUP(8,1);                       
				  IO.Put(Lotto300.vet[0] & ", ");
				  IO.Put(Lotto300.vet[1] & ", ");
				  IO.Put(Lotto300.vet[2] & ", ");
				  IO.Put(Lotto300.vet[3] & ", ");
				  IO.Put(Lotto300.vet[4] & ", ");
     ELSE
				  T2V(150);
				  Lotto150.key := Chiave;
				  FileLotto(150);
				  CUP(8,1);                      
				  IO.Put(Lotto150.vet[0] & ", ");
				  IO.Put(Lotto150.vet[1] & ", ");
				  IO.Put(Lotto150.vet[2] & ", ");
				  IO.Put(Lotto150.vet[3] & ", ");
				  IO.Put(Lotto150.vet[4] & ", ");
     END;
ELSE
 Bell();
END;
  ELSE Bell();
  END;
END VisLotto;

PROCEDURE DelLotto()=
BEGIN
      IF Chiave # NIL THEN
			  Dbase.Delete(DBL, Chiave);
      END;
END DelLotto;
(* ------------------------- Fine Procedure Interne ---------------------*)
BEGIN
 DBL := Dbase.Open(FileDB);   
REPEAT
CUP(10,2); CSCDown();
RevVideo();
IO.Put(" Cosa vuoi fare ? :"); NLn(2); Normal();
IO.Put("       1)  Visualizzare la prima chiave"); NLn(2); 
IO.Put("       2)  Visualizzare la chiave successiva"); NLn(2); 
IO.Put("       3)  Visualizzare il lotto di tessere"); NLn(2); 
IO.Put("       4)  Eliminare il lotto di tessere"); NLn(2); 
IO.Put("       5)  Fine"); NLn(2);

 IO.Put(" Scegli ! : "); Nt:=Rd.GetLine(Stdio.stdin);
			 Nu := GetChar(Nt,0);

	CASE Nu OF
		 '1'  => PrimoLotto();
		|'2'  => NextLotto();
		|'3'  => VisLotto();
		|'4'  => DelLotto();
		|'5'  => CUP(8,1); CSCDown();  CUP(6,37); CLRight();
		ELSE  Bell(); CUP(7,40);IO.Put("Bho! "); 
	END;
UNTIL Nu = '5' ;
Nu := '0';
 Dbase.Close(DBL);
END GestisciDB;


PROCEDURE V2T(n:INTEGER) = (* Vettore Lotto a TLotto *)
VAR i : CARDINAL;
BEGIN
      TLotto := "";
  IF n = 150 THEN
      FOR i := 0 TO 150 DO
	TLotto := TLotto & Lotto150.vet[i] ;
      END; 
  ELSE
      FOR i := 0 TO 300 DO
	TLotto := TLotto & Lotto300.vet[i] ;
      END;
  END;
END V2T;


PROCEDURE T2V(n:INTEGER) =  (* TLotto a vettore *)
VAR i : CARDINAL;
BEGIN
	IF n = 150 THEN
	   FOR i := 0 TO 150 DO
		Lotto150.vet[i] := Sub(TLotto, i*13, 13);
	   END;
	ELSE
	   FOR i := 0 TO 300 DO
		Lotto300.vet[i] := Sub(TLotto, i*13, 13);
	   END;
	END;
END T2V;

(*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*)
 
PROCEDURE LeggiRadice() =
BEGIN
   FileR := IO.OpenRead(FileRadice);
   Str := IO.GetLine(FileR);
   Rd.Close(FileR);
END LeggiRadice;


PROCEDURE SalvaRadice()=
BEGIN
   File := IO.OpenWrite(FileRadice);
   IO.Put(Str, File);
   Wr.Close(File);
END SalvaRadice;

PROCEDURE MostraRadice() =
BEGIN
   LeggiRadice();
CUP(8,37);IO.Put(Str);
END MostraRadice;


PROCEDURE CheckOK(): BOOLEAN =
VAR c,p : INTEGER;
    Cha : CHAR ;
    NellInsieme, OK : BOOLEAN;
BEGIN
IF Length(Str)=16 THEN
  FOR c := 0 TO 15 DO
  NellInsieme := FALSE;
      Cha := GetChar(Str,c);
      FOR p := 0 TO 35 DO
	  IF Cha = AlfaBeto[p] THEN NellInsieme := TRUE; EXIT  END;
      END;
      IF NellInsieme = FALSE THEN EXIT END;
  END;
 
  RETURN   NellInsieme 
ELSE
 RETURN FALSE;
END;
END CheckOK;


PROCEDURE CambiaRadice()=
BEGIN
REPEAT
CUP(10,2); CSCDown();
   LeggiRadice();
CUP(12,10);IO.Put(" Aggiornamento della Radice             ");
CUP(14,32);IO.Put(Str);
CUP(16,32);IO.Put("----------------");
CUP(15,32);
	  Str := IO.GetLine(Stdio.stdin); 
      (*  Str := Rd.GetText(Stdio.stdin, 16); *)
UNTIL CheckOK();
   SalvaRadice();
CUP(8,37);IO.Put(Str);
END CambiaRadice;


PROCEDURE NuovaRadice()=
BEGIN
REPEAT
CUP(10,2); CSCDown();
CUP(12,10);IO.Put(" Introduci una stringa da 16 caratteri: ");
CUP(14,32);IO.Put("________________");
CUP(16,32);IO.Put("----------------");
CUP(15,32);
	  Str := IO.GetLine(Stdio.stdin); 
      (*  Str := Rd.GetText(Stdio.stdin, 16); *)
UNTIL CheckOK();
   SalvaRadice();
CUP(8,37);IO.Put(Str);
END NuovaRadice;


PROCEDURE GestisciRadice()=
BEGIN
REPEAT
CUP(10,2); CSCDown();
RevVideo();
IO.Put(" Cosa vuoi fare ? :"); NLn(2); Normal();
IO.Put("       1)  Introdurre una nuova Radice"); NLn(2);
IO.Put("       2)  Cambiare la Radice esistente"); NLn(2);
IO.Put("       3)  Mostrare la Radice esistente"); NLn(2);
IO.Put("       4)  Fine"); NLn(2);

 IO.Put(" Scegli ! : "); Nt:=Rd.GetLine(Stdio.stdin);
			 Nu := GetChar(Nt,0);

	CASE Nu OF
		|'1'  =>    NuovaRadice(); 
		|'2'  =>    CambiaRadice();
		|'3'  =>    MostraRadice();
		|'4'  => CUP(10,2); CSCDown(); 
	
		ELSE  Bell(); CUP(7,40);IO.Put("Bho! "); 
	END;
UNTIL Nu = '4' ;
Nu := '0';
END GestisciRadice;

(*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*)

PROCEDURE Acquisti()=
BEGIN
REPEAT
CUP(10,2); CSCDown();
RevVideo();
IO.Put(" Cosa vuoi fare ? :"); NLn(2); Normal();
IO.Put("       1)  Altro Cliente"); NLn(2);
IO.Put("       2)  Fine"); NLn(2);

 IO.Put(" Scegli ! : "); Nt:=Rd.GetLine(Stdio.stdin);
			 Nu := GetChar(Nt,0);

	CASE Nu OF
		 '1'  => AltroCliente();
		|'2'  => CUP(10,2); CSCDown(); 
	
		ELSE  Bell(); CUP(7,40);IO.Put("Bho! "); 
	END;
UNTIL Nu = '2' ;
END Acquisti;


PROCEDURE GetPassW(CC:TEXT):TEXT =  (* Dal Data Base Clienti *)
VAR        DBCli : Dbase.T;
	   Dati : TEXT;
CONST      FileCli =  "Clienti.dbm";
BEGIN

DBCli := Dbase.Open(FileCli);
Dati := Dbase.Fetch(DBCli, CC);
Dbase.Close(DBCli);
  IF Dati = NIL THEN
		RETURN NIL;
  ELSE
      RETURN Sub(Dati,    361, 8);
  END;      
END GetPassW;


PROCEDURE AltroCliente()=
VAR CodiceC, Chiave, PassW : TEXT;
    DBCL : Dbase.T;
    OK   : BOOLEAN;
BEGIN
     REPEAT
	OK := FALSE;
	CUP(21,32); IO.Put("-------");
	CUP(20,2); IO.Put("Introduci il codice cliente : ");
	CodiceC := Rd.GetLine(Stdio.stdin);                                                       
		IF Equal(CodiceC,"") THEN CUP(6,40); CLRight(); RETURN END;
	(* Controllo validita' e di esistenza nel DB Clienti *)
	IF Length(CodiceC) # 7 THEN
		Bell();
		CUP(6,40); IO.Put("Codice Cliente errato !");
	ELSE
		OK := TRUE;
	END;
	(* Ottiene la Password dal Data Base Clienti *)
	PassW := GetPassW(CodiceC);
	IF PassW # NIL THEN OK := TRUE; END;
     UNTIL OK;
	CUP(6,40); CLRight();

	     (*	DBCL := Dbase.Create(FileAcq);*)
	DBCL := Dbase.Open(FileAcq);
      
 DBL := Dbase.Open(FileDB);   

REPEAT
    REPEAT
	Bell(); OK := FALSE;
	CUP(23,23); IO.Put("------------------");
	CUP(22,2); IO.Put("Introduci il lotto : ");
	Chiave := Rd.GetLine(Stdio.stdin);                                                       
		(* Controllo validita' e di non esistenza nel DB Acuisti *)
 	IF Length(Chiave)= 18 THEN
	    TLotto := Dbase.Fetch(DBCL, Chiave); 
	    IF TLotto # NIL THEN
			Bell();
			CUP(6,40); IO.Put("Lotto gia' assegnato !");
			OK := FALSE 
	    ELSE
			OK := TRUE;
			CUP(6,40); CLRight();
	    END;
		
	ELSE
	      IF Equal(Chiave, "") THEN  (* Per uscire *)
		OK := TRUE;
		CUP(6,40); CLRight();
	      ELSE
		OK := FALSE;
		CUP(6,40); IO.Put("Lotto errato !");
	      END;
 	END;

	CUP(22,2); CLRight();
    UNTIL OK ;

IF Chiave # NIL THEN
     TLotto := Dbase.Fetch(DBL, Chiave); 
 IF TLotto # NIL THEN 
     CUP(7,37);IO.Put(Chiave);
     IF GetChar(Chiave,0) = 'A' THEN 
				  T2V(300);
				  Lotto300.key := Chiave;
				  CUP(8,1);                       
				  IO.Put(Lotto300.vet[0] & ", ");
				  IO.Put(Lotto300.vet[1] & ", ");
				  IO.Put(Lotto300.vet[2] & ", ");
				  IO.Put(Lotto300.vet[3] & ", ");
				  IO.Put(Lotto300.vet[4] & ", ");
	TLotto := Sub(CodiceC & " NO " & Tempo.DataT() & " " &  Spazi ,0,32 );
	       FOR i:= 1 TO 300 DO
		    TLotto := TLotto & MD2Code(CodiceC & Lotto300.vet[i] & PassW) ;
	       END;
     ELSE
				  T2V(150);
				  Lotto150.key := Chiave;
				  CUP(8,1);                      
				  IO.Put(Lotto150.vet[0] & ", ");
				  IO.Put(Lotto150.vet[1] & ", ");
				  IO.Put(Lotto150.vet[2] & ", ");
				  IO.Put(Lotto150.vet[3] & ", ");
				  IO.Put(Lotto150.vet[4] & ", ");
	TLotto := Sub(CodiceC & " NO " & Tempo.DataT() & " " &  Spazi ,0,32 );
	       FOR i:= 1 TO 150 DO
		TLotto := TLotto & MD2Code(CodiceC & Lotto150.vet[i] & PassW) ;
	       END;
     END;
     Dbase.Store(DBCL, Chiave, TLotto);
 ELSE
  Bell();  (* TLotto inesistente *)
  CUP(6,40); IO.Put("Lotto inesistente !");
 END;
ELSE Bell(); (* Chiave Nulla *)
END;
UNTIL Equal(Chiave, "");
 CUP(6,40); CLRight();
 CUP(7,37);CLRight(); CUP(8,1);CLRight();
 Dbase.Close(DBL);
 Dbase.Close(DBCL);
END AltroCliente;



(*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*)
PROCEDURE Scelta()=
BEGIN
CUP(10,2); CSCDown();
RevVideo();
IO.Put(" Cosa vuoi fare ? :"); NLn(2); Normal();
IO.Put("       1)  Generare lotti di tessere"); NLn(2); 
IO.Put("       2)  Gestire acquisti di tessere"); NLn(2); 
IO.Put("       3)  Modificare la Radice"); NLn(2);
IO.Put("       4)  Gestire il Data Base"); NLn(2);
IO.Put("       5)  Fine"); NLn(2);

 IO.Put(" Scegli ! : "); Nt:=Rd.GetLine(Stdio.stdin);
			 Nu := GetChar(Nt,0);

END Scelta;
(*--------------------------
Procedure:   SalvaRadice()
	     LeggiRadice()
	     MostraRadice() 

*)
(*#########################################################################*)

BEGIN
       CLS(); Home();
       CUP(4,15);
	Bold();
     IO.Put("Programma per la generazione di lotti di tessere");
	Normal();

     CUP(7,2);
Tempo.PutData(); 
     CUP(7,70);
Tempo.PutOra();

REPEAT
Scelta();
	CASE Nu OF
		 '1'  =>    NuoviLotti();
		|'2'  =>    Acquisti(); 
		|'3'  =>    GestisciRadice(); 
		|'4'  =>    GestisciDB();
		|'5'  => CUP(10,2); CSCDown(); 
	
		ELSE  Bell(); CUP(7,40);IO.Put("Bho! "); 
	END;
UNTIL Nu = '5' ;

CUP(10,2); CSCDown();
CUP(15,38); IO.Put("FINE");NLn(3);
(*#########################################################################*)

END G_Lotti.
