UNSAFE MODULE Dbase;

(* This module offers a cleaner interface to the ndbm functions.
   It converts arguments and results between Modula-3 TEXT and
   C character pointers. All the pointers to structures returned by
   C functions (DBM and datum) are UNTRACED REFs because they should
   not be managed by the Modula-3 garbage collector. *)

IMPORT Text, Dbm, Ctypes, M3toC, Cstring (*, TextF *) ;

REVEAL
  T = BRANDED REF RECORD
      d: Dbm.T;
    END;

CONST
  Mode = 8_77777;


PROCEDURE Create(file: TEXT): T =
  VAR
    db := NEW(T);
  BEGIN
    db.d := Dbm.Open(M3toC.CopyTtoS(file), Dbm.O_RDWR + Dbm.O_CREAT, Mode);
    IF db.d = NIL THEN RETURN NIL; END;
    RETURN db;
  END Create;


PROCEDURE Open(file: TEXT): T =
  VAR
    db := NEW(T);
  BEGIN
    db.d := Dbm.Open(M3toC.CopyTtoS(file), Dbm.O_RDWR, Mode);
    IF db.d = NIL THEN RETURN NIL; END;
    RETURN db;
  END Open;

PROCEDURE OpenRW(file: TEXT): T =
  VAR
    db := NEW(T);
  BEGIN
    db.d := Dbm.Open(M3toC.CopyTtoS(file), Dbm.O_RDWR, Mode);
    IF db.d = NIL THEN RETURN NIL; END;
    RETURN db;
  END OpenRW;

PROCEDURE OpenR (file: TEXT): T =
  VAR
    db := NEW(T);
  BEGIN
    db.d := Dbm.Open(M3toC.CopyTtoS(file), Dbm.O_RDONLY, Mode);
    IF db.d = NIL THEN RETURN NIL; END;
    RETURN db;
  END OpenR;

PROCEDURE OpenW (file: TEXT): T =
  VAR
    db := NEW(T);
  BEGIN
    db.d := Dbm.Open(M3toC.CopyTtoS(file), Dbm.O_WRONLY, Mode);
    IF db.d = NIL THEN RETURN NIL; END;
    RETURN db;
  END OpenW;


PROCEDURE Close(db: T) =
  BEGIN
    Dbm.Close(db.d);
  END Close;


PROCEDURE Fetch(db: T; key: TEXT): TEXT =
  VAR
    in: Dbm.Datum;
    out: UNTRACED REF Dbm.Datum;
  BEGIN
    in.dptr := M3toC.CopyTtoS(key);
    in.dsize := Text.Length(key);
    out := Dbm.Fetch(db.d,in);
    IF out.dptr = NIL THEN RETURN NIL; END;
    RETURN CopyStrNtoT(out.dptr,out.dsize);
  END Fetch;


PROCEDURE Store(db: T; key, content: TEXT) =
  VAR
    k, c: Dbm.Datum;
  BEGIN
    k.dptr := M3toC.CopyTtoS(key);
    k.dsize := Text.Length(key);
    c.dptr := M3toC.CopyTtoS(content);
    c.dsize := Text.Length(content);
    EVAL Dbm.Store(db.d, k, c, Dbm.DBM_REPLACE); 
(*    EVAL Dbm.Store(db.d, k, c, Dbm.DBM_INSERT);*)
  END Store;





PROCEDURE FetchR(db: T; key: TEXT; a:ADDRESS): INTEGER =
  VAR
    in: Dbm.Datum;
    out: UNTRACED REF Dbm.Datum;
  BEGIN
    in.dptr := M3toC.CopyTtoS(key);
    in.dsize := Text.Length(key);
    out := Dbm.Fetch(db.d,in);
    IF out.dptr # NIL THEN   
			EVAL Cstring.memcpy(a, out.dptr, out.dsize);
			RETURN out.dsize ;
		      ELSE
			RETURN -1;
    END;
  END FetchR;


PROCEDURE StoreR(db: T; key: TEXT; content: ADDRESS ; lg: INTEGER) =
  VAR
    k, c: Dbm.Datum;
  BEGIN
    k.dptr := M3toC.CopyTtoS(key);
    k.dsize := Text.Length(key);
    c.dptr := content;
    c.dsize := lg ;
    EVAL Dbm.Store(db.d, k, c, Dbm.DBM_REPLACE);
  END StoreR;


PROCEDURE Delete(db: T; key: TEXT) =
  VAR
    k: Dbm.Datum;
  BEGIN
    k.dptr := M3toC.CopyTtoS(key);
    k.dsize := Text.Length(key);
    EVAL Dbm.Delete(db.d, k);
  END Delete;


PROCEDURE FirstKey(db: T): TEXT  =
  VAR
    out: UNTRACED REF Dbm.Datum;
  BEGIN
    out := Dbm.FirstKey(db.d);
    IF out.dptr = NIL THEN RETURN NIL; END;
    RETURN CopyStrNtoT(out.dptr,out.dsize);
  END FirstKey;


PROCEDURE NextKey(db: T): TEXT =
  VAR
    out: UNTRACED REF Dbm.Datum;
  BEGIN
    out := Dbm.NextKey(db.d);
    IF out.dptr = NIL THEN RETURN NIL; END;
    RETURN CopyStrNtoT(out.dptr,out.dsize);
  END NextKey;


(* This procedure relies on the internal representation of TEXT
   elements. *)

PROCEDURE CopyStrNtoT (s: Ctypes.char_star; n: INTEGER): TEXT =
  VAR
    t := NEW (TEXT, n + 1);
  BEGIN
    EVAL Cstring.memcpy (ADR (t[0]), s, n);
    t[n] := '\000';
    RETURN t;
  END CopyStrNtoT;



PROCEDURE Reorganize(db: T)=
BEGIN
    EVAL Dbm.Reorganize(db.d);

END Reorganize;


(*
PROCEDURE FirstKey(db: T; a:ADDRESS): INTEGER =
  VAR
    out: UNTRACED REF Dbm.Datum;
  BEGIN
    out := Dbm.FirstKey(db.d);
    IF out.dptr # NIL THEN   
			EVAL Cstring.memcpy(a, out.dptr, out.dsize);
			RETURN out.dsize ;
		      ELSE
			RETURN -1;
    END;  
  END FirstKey;


PROCEDURE NextKey(db: T; a:ADDRESS): INTEGER =
  VAR
    out: UNTRACED REF Dbm.Datum;
  BEGIN
    out := Dbm.NextKey(db.d);
    IF out.dptr # NIL THEN   
			EVAL Cstring.memcpy(a, out.dptr, out.dsize);
			RETURN out.dsize ;
		      ELSE
			RETURN -1;
    END;  
  END NextKey;
*)



BEGIN
END Dbase.

