INTERFACE Dbase;

(* A Dbase.T is a handle on a dbm database. *)

TYPE
  T <: REFANY;

(* Create opens the named file as a new database. *)

PROCEDURE Create(file: TEXT): T;


(* Open opens the existing named file as a database. *)

PROCEDURE Open  (file: TEXT): T;
PROCEDURE OpenRW(file: TEXT): T;
PROCEDURE OpenR (file: TEXT): T;
PROCEDURE OpenW (file: TEXT): T;


(* Close releases the program resources associated with the database. *)

PROCEDURE Close(db: T);

(* Fetch retrieves an item in the database given its key. NIL is returned
   if not found. *)

PROCEDURE Fetch(db: T; key: TEXT): TEXT;

(* Store puts a content under the given key in the database. *)

PROCEDURE Store(db: T; key, content: TEXT);



(* FetchR retrieves an item in the database given its key. NIL is returned
   if not found. *)

PROCEDURE FetchR(db: T; key: TEXT; a:ADDRESS): INTEGER;

(* StoreR puts a content under the given key in the database. *)

PROCEDURE StoreR(db: T; key: TEXT; content: ADDRESS ; lg: INTEGER);



(* Delete removes the specified key and its content from the database. *)

PROCEDURE Delete(db: T; key: TEXT);

(* FirstKey and NextKey may be used to iterate through all the
   keys of the database entries. NIL is returned when there are no more
   entries. *)


PROCEDURE FirstKey(db: T): TEXT ;

PROCEDURE NextKey(db: T): TEXT;

PROCEDURE Reorganize(db: T);

END Dbase.

