MODULE Cypher EXPORTS Main;

IMPORT IO, Lex, Params, Process, Text, TextRd;

TYPE
  Key = INTEGER;
  Code = ARRAY CHAR OF CHAR;
  Range = RECORD low, high: CHAR END;
  Ranges = ARRAY OF Range;

CONST
  ranges = Ranges {Range {'A', 'Z'}, Range {'a', 'z'}, Range {'0', '9'}};


PROCEDURE GetKey (): Key =
  BEGIN
    TRY
      IF Params.Count = 2 THEN
        RETURN Lex.Int (TextRd.New (Params.Get (1)))
      ELSE
        RAISE Lex.Error;
      END;
    EXCEPT
      Lex.Error => IO.Put ("Usage: Cypher n\n"); Process.Exit (1);
    END;
  END GetKey;


PROCEDURE MakeCode (shift: Key := 0): Code =
  VAR code: Code;
  BEGIN
    (* By default, each character maps to itself. *)
    FOR c := FIRST (code) TO LAST (code) DO code [c] := c; END;
    (* Characters in the specified ranges are permuted. *)
    FOR r := FIRST (ranges) TO LAST (ranges) DO
      WITH lo = ORD (ranges [r].low),
           hi = ORD (ranges [r].high) DO
        FOR c := lo TO hi DO
          code [VAL (c, CHAR)] :=
            VAL (lo + (c - lo + shift) MOD (hi - lo + 1), CHAR);
        END;
      END;
    END;
    RETURN code;
  END MakeCode;


PROCEDURE Rotate (key: Key) =
  BEGIN
    WITH code = MakeCode (key) DO
      LOOP
        TRY
          WITH ch = IO.GetChar () DO
            IO.Put (Text.FromChar (code [ch]));
          END;
        EXCEPT
          IO.Error => EXIT;
        END;
      END;
    END;
  END Rotate;


BEGIN                            (* Cypher *)
  Rotate (GetKey ());

END Cypher.
