MODULE Client EXPORTS Main;
FROM IP IMPORT Port, Address, Endpoint, GetHostByName, GetCanonicalByName,
	       GetCanonicalByAddr, GetHostAddr, NullEndPoint, NullPort,
	       NullAddress ;
FROM TCP IMPORT Refused, Closed, Timeout, ConnLost, NewConnector, GetEndPoint,
		CloseConnector, Connect, Accept, Close, Connector ;
FROM vt100 IMPORT NL, NLn, Bell, CLS, CSCDown, Home, CUP, CUD, Bold, Blink,
		  UnderL, RevVideo, Normal, CLLeft, CLRight ;
FROM Tempo IMPORT PutData, DataCT, OraT;
FROM Text  IMPORT Equal, GetChar, FindChar, Cat, Sub, FromChar,
		  FromChars, SetChars ;
FROM Input IMPORT CUPyx, Putyx, InpLine, InpInt, Orologio, PutErr ;
FROM MD2 IMPORT MD2Code;
IMPORT IO, IP, Thread, Wr, Rd, ConnFD, ConnRW, ConnMsgRW, MsgRd, MsgWr, Fmt;
IMPORT Stdio, FileWr, Time, Process, File, FS, InfConTbl ;
IMPORT Dbase;

(* < > -_ \ | $ / ' ~ ` ^ *)

<*FATAL IP.Error *>
<*FATAL Thread.Alerted *>
<*FATAL Rd.EndOfFile *>
<*FATAL Rd.Failure *>

VAR AddLocale   : Address;
    Indirizzo   : Address;
    EndPoiServ  : Endpoint;
    Connettore  : Connector;
    Connessione : ConnFD.T;
    HandRd      : MsgRd.T;
    HandWr      : MsgWr.T;
    Testo : TEXT ;
    OK : BOOLEAN;   (* Connessione col server attiva *)
    FileR : Rd.T;
    FileL : Wr.T;
    host, Str  : TEXT;
    CodiceC, PassW : TEXT;
    Nu : CHAR;
    MutCon : MUTEX; (* Per l'uso di Write *)
    MutDB  : MUTEX; (* Per il Data Base Tessere *)
    dbt : Dbase.T;

CONST Servente = (*"localhost"*)  "server" ;  (* "server" alla fine dei test *)
      FileBAR = (* "BAR.BAR"*) "/usr/bar/BAR.BAR" ; (* alla fine dei test *)
      FileTessere = (*"Tessere.dbm"*)   "/usr/bar/Tessere.dbm" ;


PROCEDURE ToHex(Text:TEXT): TEXT =
TYPE
	BYTE = [0..255];

VAR	i : CARDINAL;
	X : ARRAY [0..15] OF BYTE;
  	CodeSt : ARRAY[1..32] OF CHAR;
  	CC     : ARRAY[0..15] OF CHAR;

(* ---------- Procedura Interna --------------------------*)
PROCEDURE NbHex (Nibble:BYTE):CHAR =
(* Azione: Converte un nibble in carattere esadecimale *)
BEGIN
	IF Nibble < 10 THEN
		RETURN VAL(Nibble+48, CHAR)  (* Cifra *)
	ELSE
		RETURN VAL(Nibble+87, CHAR); (* Lettera minuscola *)
	END;
END NbHex;
(* ----Fine   Procedura Interna --------------------------*)


BEGIN
	SetChars(CC,Text);
	(* Converti X[0..15] in una stringa esadecimale di 2*16 caratteri *)
	i := 0; (* Contatore *)
	WHILE i <= 15 DO
		       (* Converti da BYTE a Hex *)
		        X[i] := ORD(CC[i]);
			CodeSt[2*i+1] := NbHex (X[i] DIV 16);
			CodeSt[2*i+2] := NbHex (X[i] MOD 16);
			i := i + 1;
	END;
	RETURN  FromChars(CodeSt);
END ToHex;

PROCEDURE PrintAddr(addr:Address)=
VAR i :CARDINAL;
BEGIN
FOR i := 0 TO 2 DO
    IO.PutInt(addr.a[i]); IO.Put(".");
END;
    IO.PutInt(addr.a[3]);
END PrintAddr;


PROCEDURE Addr2Text(addr:Address): TEXT=
VAR i :CARDINAL;
    Add : TEXT;
BEGIN
 Add := "";
FOR i := 0 TO 2 DO
    Add := Cat(Add,Fmt.Int(addr.a[i]) & ".");
END;
    Add := Cat(Add,Fmt.Int(addr.a[3]) );
 RETURN Add;
END Addr2Text;



PROCEDURE LOG(St:TEXT ) =
BEGIN
    CUP(23,1); CLRight(); Putyx(23,1,DataCT() & OraT() & St);
      (* Scrittura sul file di Log *)
    Wr.PutText(FileL,DataCT() & OraT() & St & "\n");
    Wr.Flush(FileL);
END LOG;


PROCEDURE SendLOG()=
BEGIN

END SendLOG;


		       (* :::::::::::: *)

  TYPE ConClosure = Thread.Closure
			   OBJECT
			     Read : MsgRd.T;
			     Write: MsgWr.T;
			   METHODS END;

PROCEDURE AttesaMessaggi(Hrd: MsgRd.T; Hwr: MsgWr.T ) =
BEGIN
  EVAL Thread.Fork(NEW(ConClosure, apply := GestioneMessaggi,
				   Read  := Hrd,
				   Write := Hwr
		       ));
END AttesaMessaggi;

PROCEDURE GestioneMessaggi(clo:ConClosure):REFANY =
VAR
    NM : CARDINAL; (* Numero Messaggio (tipo) *)
    Fine : BOOLEAN;
    FineMessaggio : BOOLEAN;
    ch  : CHAR;
    Messaggio : TEXT;
    SelfT  : Thread.T;  (* se stesso *)

  PROCEDURE GetMessage()=                (* Procedura interna *)
  BEGIN
   LOOP                                   (* Recupera il messaggio *)
    TRY
     ch := Rd.GetChar(clo.Read); (* Legge i caratteri del messaggio *)
     Messaggio := Cat(Messaggio, FromChar(ch));
    EXCEPT   Rd.EndOfFile => FineMessaggio := TRUE; EXIT;
	   | Rd.Failure   => Fine := TRUE;          EXIT;
    END;
   END;
 END GetMessage;

BEGIN
 SelfT := Thread.Self();
 Fine := FALSE; FineMessaggio:=FALSE;

REPEAT
   TRY
     REPEAT
     UNTIL clo.Read.nextMsg();               (* Attende un messaggio *)
   EXCEPT  Rd.Failure => Fine := TRUE;
	     LOG("(p1) Fine Connessione  " ); EXIT;
	   | Thread.Alerted   => Fine := TRUE;
   END;

   Messaggio := "";

    TRY
     ch := Rd.GetChar(clo.Read); (* Legge il primo carattere...tipo messaggio *)
    EXCEPT   Rd.EndOfFile => FineMessaggio := TRUE;
	   | Rd.Failure   => Fine := TRUE;
	   | Thread.Alerted   => Fine := TRUE;
    END;

    NM := ORD(ch); (* Numero di Messaggio *)
    CASE NM OF
	   0 => GetMessage(); RispondiPing(clo.Write, MutCon, Messaggio);
	|  1 => GetMessage(); RispostaAPing();
	|  3 => GetMessage(); RispostaPres(Messaggio);
	|  4 => GetMessage(); Autenticazione(clo.Write,MutCon,Messaggio);
	|  7 => GetMessage();
	|  8 => GetTessere(clo.Read);
	| 11 => GetMessage();
	| 12 => SendLOG();
	| 14 => GetMessage(); UtentiAttivi();
	| 17 => GetMessage(); TessereInusate();
    ELSE
	LOG("Ricevuto Messaggio di tipo sconosciuto");
    END;


    IF FineMessaggio THEN
      (*     ElaboraMessaggio(Messaggio,clo.Write); *)
    ELSE
	LOG("(p2) Fine Connessione  ");
    END;

UNTIL Fine ;
RETURN NIL;
END GestioneMessaggi;

(*----------------------- Presentazione ---------------------------------*)

VAR PresOK : BOOLEAN;

PROCEDURE Presentazione()=
VAR Contenuto, Messaggio : TEXT;
    TipoMessaggio : CHAR;
BEGIN
   PresOK := FALSE;

IF OK THEN
  TipoMessaggio := VAL(2, CHAR);
  Contenuto := CodiceC & " " & host & " " & Addr2Text(AddLocale) ;
  Messaggio := Cat(FromChar(TipoMessaggio), Contenuto);
 TRY
  LOCK MutCon  DO
   Wr.PutText(HandWr,Messaggio);
   HandWr.nextMsg();
  END;
 EXCEPT Wr.Failure => LOG("No Presentazione: Wr.Failure");
		      RETURN ;
 END;
  RETURN ;
ELSE
 LOG("No Presentazione: server non connesso ");
END;
RETURN ;
END Presentazione;


PROCEDURE RispostaPres(Mess:TEXT)=
BEGIN
     PresOK := TRUE;
  LOG("Risposta a Presentazione " & Mess);
END RispostaPres;

(*----------------------- Fine Presentazione -----------------------------*)

(*------------------------------- Ping -----------------------------------*)
VAR  Ritorno, Andata : LONGREAL;

PROCEDURE Ping():BOOLEAN=
VAR Contenuto, Messaggio : TEXT;
    TipoMessaggio : CHAR;
BEGIN
IF OK THEN
  TipoMessaggio := VAL(0, CHAR);
  Contenuto := "Ping da " & CodiceC & " " & host & " " & Addr2Text(AddLocale) ;
  Messaggio := Cat(FromChar(TipoMessaggio), Contenuto);
  Andata := Time.Now();
 TRY
  LOCK MutCon  DO
   Wr.PutText(HandWr,Messaggio);
   HandWr.nextMsg();
  END;
 EXCEPT Wr.Failure => LOG("No Ping: Wr.Failure");
		      RETURN FALSE;
 END;
  RETURN TRUE;
ELSE
 LOG("No Ping: server non connesso ");
END;
RETURN FALSE;
END Ping;


PROCEDURE RispostaAPing()=  (* Acquisisce l'evento *)
BEGIN
    Ritorno := Time.Now();
    CUP(23,1); CLRight(); Putyx(23,1,DataCT() & OraT() & "Ping in " & Fmt.LongReal(Ritorno - Andata, Fmt.Style.Fix, 3) & " Secondi");
 (* LOG("Ping in " & Fmt.LongReal(Ritorno - Andata, Fmt.Style.Fix, 3) & " Secondi" ); *)
END RispostaAPing;

		       (* :::::::::::: *)

  TYPE CloWri = Thread.Closure
			   OBJECT
			     Wri: MsgWr.T;
			     Mt : MUTEX;
			     Mg : TEXT ;
			   METHODS END;

PROCEDURE RispondiPing(H:MsgWr.T; Mx:MUTEX; Ms:TEXT) =
BEGIN
  EVAL Thread.Fork(NEW(CloWri, apply := RispPing, Wri:=H, Mt := Mx, Mg:=Ms  ));
END RispondiPing;


PROCEDURE RispPing(clo:CloWri):REFANY =
VAR Contenuto, MesRisp : TEXT;
    TipoMessaggio : CHAR;
BEGIN
  LOG("Ping: " & clo.Mg);
  TipoMessaggio := VAL(1, CHAR);
  Contenuto := "Risposta al Ping .." & DataCT() & OraT()  ; (*\n*)
  MesRisp := Cat(FromChar(TipoMessaggio), Contenuto);
 TRY
  LOCK clo.Mt DO
     Wr.PutText(clo.Wri,MesRisp);
     clo.Wri.nextMsg();
  END;
 EXCEPT Wr.Failure => RETURN NIL (* FALSE*);
 END;
  RETURN NIL (*TRUE*);
END RispPing;

		       (* :::::::::::: *)

(*----------------------------- Fine Ping ---------------------------------*)

PROCEDURE Autenticazione(H:MsgWr.T; Mx:MUTEX; Chal:TEXT) =
VAR Contenuto, MesRisp : TEXT;
    TipoMessaggio : CHAR;
BEGIN

  LOG("Autenticazione " & ToHex(Chal) ); (*---------- *)
  TipoMessaggio := VAL(5, CHAR);
  Contenuto := MD2Code(CodiceC & Chal & PassW);
    (* LOG (ToHex(Contenuto)); *)
  MesRisp := Cat(FromChar(TipoMessaggio), Contenuto);
 TRY
  LOCK Mx DO
     Wr.PutText(H,MesRisp);
     H.nextMsg();
  END;
 EXCEPT Wr.Failure => LOG("Wr.Failure in Autenticazione"); RETURN ;
 END;

  RETURN ;
END Autenticazione;


PROCEDURE GetTessere(CanRd:MsgRd.T)=
  VAR FineFile, Errore1, Errore2 : BOOLEAN;
      ch : CHAR;
      Hf : Wr.T;
BEGIN
   Errore1 := FALSE; Errore2 := FALSE;
   LOG("Inizio ricezione file Tessere");
   Hf := IO.OpenWrite("Tessere.tgz");     (* Apre il file du disco *)
   LOOP                                   (* Recupera il file dalla rete *)
    TRY
     ch := Rd.GetChar(CanRd); (* Legge i caratteri del messaggio *)
     Wr.PutChar(Hf, ch);      (* e li scrive nel file *)
    EXCEPT   Rd.EndOfFile => FineFile := TRUE; EXIT;
	   | Rd.Failure   => Errore1   := TRUE; EXIT;
	   | Wr.Failure   => Errore2   := TRUE; EXIT;
    END;
   END;
   IF FineFile THEN
      Wr.Close(Hf);      (* Chiudi il file *)
      ConfermaTessere(TRUE); (* Invia messaggio di conferma *)
     LOG("File Tessere ricevuto");
     AggiornaDB(); (* Aggiorna il data base tessere *)
   ELSIF Errore1 THEN LOG("Rd.Failure nella ricezione Tessere");
		 ConfermaTessere(FALSE); (* Invia messaggio di conferma negativa *)
   ELSIF Errore2 THEN LOG("Wr.Failure nella scrittura di Tessere");
		 ConfermaTessere(FALSE); (* Invia messaggio di conferma negativa *)
   END;
END GetTessere;


PROCEDURE ConfermaTessere(OK:BOOLEAN)=
VAR Contenuto, MesChiu : TEXT;
    TipoMessaggio : CHAR;
BEGIN
  TipoMessaggio := VAL(9, CHAR);
  IF OK THEN Contenuto := "1"
  ELSE       Contenuto := "0"
  END;
  MesChiu := Cat(FromChar(TipoMessaggio), Contenuto);
 TRY
  LOCK MutCon  DO
   Wr.PutText(HandWr,MesChiu);
   HandWr.nextMsg();
  END;
 EXCEPT Wr.Failure => LOG("No Conferma Tessere:  Wr.Failure");
 END;
END ConfermaTessere;


PROCEDURE AggiornaDB()=              (* farne un processo *)
VAR     Param : ARRAY[0..1] OF TEXT;
	Processo : Process.T;
	sio, sout, ser : File.T;
	DBT,DBTnew : Dbase.T;
	Aggiornamento : TEXT;
	InfoT : TEXT := "NN00";
	TipoL, CodTes : TEXT;

   PROCEDURE Ripristino(n:TEXT)=
   BEGIN
	LOG("Chiave db gia' esistente "  & n);
	Dbase.Close(DBT);
	Dbase.Close(DBTnew);
	FS.DeleteFile("Tessere.tgz");
	FS.DeleteFile("BAR_" & CodiceC & ".dbm.dir");
	FS.DeleteFile("BAR_" & CodiceC & ".dbm.pag");
	ConfermaAggiornamentoDB(FALSE);
   END Ripristino;
BEGIN
	    Param[0] := "xzf" ;
	    Param[1] := "Tessere.tgz" ;
       Process.GetStandardFileHandles(sio,sout,ser);
       Processo := Process.Create("tar", Param,  stdin:= sio, stdout := sout, stderr:=ser);
       EVAL Process.Wait(Processo);
   LOCK MutDB DO
       Aggiornamento := "BAR_" & CodiceC & ".dbm" ;
       DBT    := Dbase.Open(FileTessere);
	 IF DBT = NIL THEN DBT := Dbase.Create(FileTessere) END;
       DBTnew := Dbase.Open(Aggiornamento);
	 IF DBTnew = NIL THEN
			   LOG("Arrivato Data Base sbagliato");
			   RETURN;
	 END;
       CodTes := Dbase.FirstKey(DBTnew);
	   IF  Dbase.Fetch(DBT, CodTes) # NIL THEN (* c'e' gia' *)
					 Ripristino("1"); RETURN
	   END;
      TipoL := Dbase.Fetch(DBTnew,CodTes); (* Ottiene il tipo di lotto A, B ecc. *)
      Dbase.Store(DBT,CodTes, TipoL & InfoT) ;
       LOOP                                       (* agg. verifica duplicati *)
	    CodTes := Dbase.NextKey(DBTnew);
	    IF CodTes = NIL THEN EXIT;
	    ELSE
	        IF  Dbase.Fetch(DBT, CodTes) # NIL THEN (* c'e' gia' *)
					 Ripristino("2"); RETURN
		END;
		TipoL := Dbase.Fetch(DBTnew, CodTes);
		Dbase.Store(DBT,CodTes, TipoL & InfoT) ;
	    END;
       END;
	LOG("Data Base Aggiornato ");
       Dbase.Close(DBT);
       Dbase.Close(DBTnew);
   END; (* LOCK *)
       FS.DeleteFile("Tessere.tgz");
       FS.DeleteFile("BAR_" & CodiceC & ".dbm.dir");
       FS.DeleteFile("BAR_" & CodiceC & ".dbm.pag");
	ConfermaAggiornamentoDB(TRUE);
END AggiornaDB;


PROCEDURE  ConfermaAggiornamentoDB(T:BOOLEAN)=
VAR Contenuto, MesChiu : TEXT;
    TipoMessaggio : CHAR;
BEGIN
  TipoMessaggio := VAL(19, CHAR);
  IF T THEN Contenuto := "DB Tessere Aggiornato"
  ELSE      Contenuto := "Attenzione: Aggiornamento Tessere DUPLICATO"
  END;
  MesChiu := Cat(FromChar(TipoMessaggio), Contenuto);
 TRY
  LOCK MutCon  DO
   Wr.PutText(HandWr,MesChiu);
   HandWr.nextMsg();
  END;
 EXCEPT Wr.Failure => LOG("No ConfermaAggiornamentoDB:  Wr.Failure");
 END;
END ConfermaAggiornamentoDB;


PROCEDURE UtentiAttivi()=
VAR Contenuto, MesChiu : TEXT;
    TipoMessaggio : CHAR;
BEGIN
IF HandWr # NIL THEN
  TipoMessaggio := VAL(15, CHAR);
  Contenuto := Fmt.Int(TerminaliAttivi()) & " " & Fmt.Int(TessereAttive()) ;
  MesChiu := Cat(FromChar(TipoMessaggio), Contenuto);
 TRY
  LOCK MutCon  DO
   Wr.PutText(HandWr,MesChiu);
   HandWr.nextMsg();
  END;
 EXCEPT Wr.Failure => LOG("No UtentiAttivi:  Wr.Failure");
 END;
END;
END UtentiAttivi;


PROCEDURE TessereInusate()=
VAR Contenuto, MesChiu : TEXT;
    TipoMessaggio : CHAR;
BEGIN
IF HandWr # NIL THEN
  TipoMessaggio := VAL(18, CHAR);
  Contenuto := Fmt.Int(ScanTessere() )  ;
  MesChiu := Cat(FromChar(TipoMessaggio), Contenuto);
 TRY
  LOCK MutCon  DO
   Wr.PutText(HandWr,MesChiu);
   HandWr.nextMsg();
  END;
 EXCEPT Wr.Failure => LOG("No TessereInusate:  Wr.Failure");
 END;
END;
END TessereInusate;

PROCEDURE ScanTessere():INTEGER=
  VAR DBT : Dbase.T;
      N : INTEGER;
      Key, Dati, Esaurita : TEXT;
BEGIN
  N := 0;
 LOCK MutDB DO
     DBT := Dbase.OpenR(FileTessere);
     Key := Dbase.FirstKey(DBT);

   LOOP
       Dati := Dbase.Fetch(DBT, Key);
       IF Dati = NIL THEN EXIT
       ELSE
	   Esaurita := Sub(Dati,1,1);
	   IF  NOT Equal(Esaurita, "S")  THEN INC(N) END;
       END;
       Key := Dbase.NextKey(DBT);
       IF Key = NIL THEN EXIT END;
   END;
   Dbase.Close(DBT);
 END; (* LOCK *)
   LOG("Tessere disponibili " & Fmt.Int(N));
 RETURN N ;
END ScanTessere;


PROCEDURE Chiusura()=
VAR Contenuto, MesChiu : TEXT;
    TipoMessaggio : CHAR;
BEGIN
  LOG("Chiusura Connessione col server");
IF HandWr # NIL THEN
  TipoMessaggio := VAL(6, CHAR);
  Contenuto := "Chiusura " & CodiceC ;
  MesChiu := Cat(FromChar(TipoMessaggio), Contenuto);
 TRY
  LOCK MutCon  DO
   Wr.PutText(HandWr,MesChiu);
   HandWr.nextMsg();
  END;
 EXCEPT Wr.Failure => LOG("No Chiusura:  Wr.Failure");
 END;
  (* Sconnetti, chiudi file ecc.  *)
 RETURN;
ELSE
  LOG("Server non connesso");
END;
END Chiusura;


PROCEDURE Spegni()=
VAR Par : ARRAY[0..0] OF TEXT;
    Processo : Process.T;
    sio, sout, ser : File.T ;
BEGIN
Chiusura();
Thread.Pause(5.0d0);
CUP(10,2); CSCDown();
LOG("Shut Down ---------------------------------------------");
CUP(11,38); IO.Put("FINE");NLn(3);
	   IO.Put("Attendi il messaggio < The system is halted >");NLn(2);
	   IO.Put("prima di spegnere il computer");NLn(3);
Wr.Close(FileL);
Thread.Pause(5.0d0);
     (* ShutDown  *)
       Par[0] := "-q";
       Process.GetStandardFileHandles(sio,sout,ser);
       Processo := Process.Create("/sbin/halt", Par, stdin:= sio, stdout := sout, stderr:=ser);

Thread.Pause(10.0d0);
END Spegni;

		       (* :::::::::::: *)

PROCEDURE ConnettiServer() =
BEGIN
  EVAL Thread.Fork(NEW(Thread.Closure, apply := ConServ ));
END ConnettiServer;


PROCEDURE ConServ(<*UNUSED*> closure:Thread.Closure): REFANY=
BEGIN
IF GetHostByName(Servente, Indirizzo) THEN
   LOG("Indirizzo del servente: " & Addr2Text(Indirizzo));
   EndPoiServ.addr := Indirizzo;
   EndPoiServ.port := 6668;

LOOP
    OK := FALSE;
    REPEAT
     TRY
       Connessione := Connect(EndPoiServ);     (*  *)
       OK := TRUE;
       Bell(); LOG("Connessione avvenuta  ");
     EXCEPT IP.Error => OK := FALSE;
     END;
    UNTIL OK;


    HandRd := ConnMsgRW.NewRd(Connessione);
    HandWr := ConnMsgRW.NewWr(Connessione);

    AttesaMessaggi(HandRd, HandWr);  (* processo *)

    Presentazione();

     WHILE  Ping() DO

	    Thread.Pause(30.0d0);
     END;
      LOG("Sconnessione avvenuta ");

  Close(Connessione);

END (* loop *);
ELSE LOG("Indirizzo del servente non trovato ! ");
END (* if *);
RETURN NIL;
END ConServ;

(*###########################################################################*)

		       (* :::::::::::: *)  (* Sezione  UTENTE *)

  VAR  N_Connessione : INTEGER ;
       ConnettoreU  : Connector;
       ConnessioneU : ConnFD.T;
       EndPoiLoc   : Endpoint;
       HandRdU      : MsgRd.T;
       HandWrU      : MsgWr.T;

(* ------------------ Thread di Attesa Connessioni  da Utente ---------------*)
PROCEDURE AttesaConnessioni() =
BEGIN
  EVAL Thread.Fork(NEW(Thread.Closure, apply := ConnSetUp ));
END AttesaConnessioni;


PROCEDURE ConnSetUp(<*UNUSED*> closure:Thread.Closure): REFANY=
BEGIN
 N_Connessione := 0;              (* Numero della connessione *)
 EndPoiLoc.addr := NullAddress;
 EndPoiLoc.port := 6669 ;
(* Connettore := NewConnector(NullEndPoint);*) (* Qualunque IP su qualunque porta *)
 ConnettoreU := NewConnector(EndPoiLoc);
 EndPoiLoc := GetEndPoint(ConnettoreU);
 LOG("Attesa connessioni sulla Porta : " & Fmt.Int(EndPoiLoc.port));

LOOP
  ConnessioneU := Accept(ConnettoreU);(* va in pausa attendendo una connessione *)
  INC(N_Connessione);
    Bell(); LOG("# Connessione da utente  n. " & Fmt.Int(N_Connessione));

  HandRdU := ConnMsgRW.NewRd(ConnessioneU);
  HandWrU := ConnMsgRW.NewWr(ConnessioneU);

  NuovaConnessione(HandRdU,HandWrU,N_Connessione,ConnessioneU);(* E' un processo *)
END;

(*   Close(Connessione);  *)
RETURN NIL;
END ConnSetUp;
		       (* :::::::::::: *)
(* ------------------ Fine Thread di Attesa Connessioni da utente---------------------*)
		       (* :::::::::::: *)
(* ------------------ Thread di Nuova Connessione di utente-----------------*)
  TYPE InfoConnessione = RECORD
			      NomeUt  : TEXT;
			      IndUt   : TEXT;
			      DataIn  : TEXT;
			      OraIn   : TEXT;
			      TessNum : TEXT;
			      PingIniz: LONGREAL;
			      PingFin : LONGREAL;
			      CanRd   : MsgRd.T ;
			      CanWr   : MsgWr.T ;
			      Mt      : MUTEX ;
			      ThrCon  : Thread.T;
			      Connes  : ConnFD.T;
			      ThrTim  : Thread.T
			 END;
  VAR  InfoC : InfoConnessione ;
       MutTab : MUTEX ; (* per l'accesso a Tabella *)

       TabCon := NEW(InfConTbl.Default).init(); (* Tabella delle Connessioni *)

  TYPE ConClosureU = Thread.Closure
			   OBJECT
			     Read : MsgRd.T;
			     Write: MsgWr.T;
			     N_C  : INTEGER;
			     Con : ConnFD.T;
			   METHODS END;

PROCEDURE NuovaConnessione(Hrd: MsgRd.T; Hwr: MsgWr.T; NCon:INTEGER;
			   Cons : ConnFD.T;
			   ) =
BEGIN
  EVAL Thread.Fork(NEW(ConClosureU, apply := GestioneConnessione,
				   Read  := Hrd,
				   Write := Hwr,
				   N_C   := NCon,
				   Con   := Cons
		       ));
END NuovaConnessione;

PROCEDURE GestioneConnessione(clo:ConClosureU):REFANY =
VAR
    NM : CARDINAL; (* Numero Messaggio (tipo) *)
    Fine : BOOLEAN;
    FineMessaggio : BOOLEAN;
    ch  : CHAR;
    Messaggio : TEXT;
    InfoCon : InfoConnessione ;
    MutConU : MUTEX;     (* Per l'uso di Write *)
    SelfT  : Thread.T;  (* se stesso *)

  PROCEDURE GetMessage()=                (* Procedura interna *)
  BEGIN
   LOOP                                   (* Recupera il messaggio *)
    TRY
     ch := Rd.GetChar(clo.Read); (* Legge i caratteri del messaggio *)
     Messaggio := Cat(Messaggio, FromChar(ch));
    EXCEPT   Rd.EndOfFile => FineMessaggio := TRUE; EXIT;
	   | Rd.Failure   => Fine := TRUE;          EXIT;
    END;
   END;
 END GetMessage;

BEGIN
 SelfT := Thread.Self();
 Fine := FALSE; FineMessaggio:=FALSE;
 MutConU := NEW(MUTEX);

 InfoCon.NomeUt := "";  (* Ancora non si sa *)
 InfoCon.DataIn := DataCT();
 InfoCon.OraIn  := OraT();
 InfoCon.TessNum   := NIL; (* Ancora non ottenuto *)
 InfoCon.PingIniz  := 0.0d0;
 InfoCon.PingFin   := 0.0d0;
 InfoCon.CanRd  := clo.Read;
 InfoCon.CanWr  := clo.Write;
 InfoCon.Mt     := MutConU;    (* Per serializzare CanWr *)
 InfoCon.ThrCon := SelfT;
 InfoCon.Connes := clo.Con;


 LOCK MutTab DO
     EVAL  TabCon.put(clo.N_C, InfoCon);
 END;

REPEAT
   TRY
     REPEAT
     UNTIL clo.Read.nextMsg();               (* Attende un messaggio *)
   EXCEPT  Rd.Failure => Fine := TRUE;
	     LOG("(u1) Fine Connessione n. " & Fmt.Int(clo.N_C )); EXIT;
	   | Thread.Alerted   => Fine := TRUE;
	     LOG("(u3) Alerted con. n. " & Fmt.Int(clo.N_C )); EXIT;
   END;

   Messaggio := "";

    TRY
     ch := Rd.GetChar(clo.Read); (* Legge il primo carattere...tipo messaggio *)
    EXCEPT   Rd.EndOfFile => FineMessaggio := TRUE;
	   | Rd.Failure   => Fine := TRUE;
	   | Thread.Alerted   => Fine := TRUE;
	     LOG("(u4) Alerted con. n. " & Fmt.Int(clo.N_C )); EXIT;
    END;

    NM := ORD(ch); (* Numero di Messaggio *)
    CASE NM OF
	   0 => GetMessage(); PingU(clo.N_C, Messaggio);
	|  1 => GetMessage(); (*RispostaAPing(clo.N_C);*)
	|  2 => GetMessage(); AltroUt(clo.N_C, Messaggio);
	|  3 => GetMessage(); AltraTessera(clo.N_C,Messaggio);
	|  4 => GetMessage(); FineTessera(clo.N_C,Messaggio);
	|  5 => GetMessage(); DBFetch(clo.N_C,Messaggio);
	|  6 => GetMessage(); DBStore(clo.N_C,Messaggio);
	| 10 => GetMessage(); ErroreUt(clo.N_C, Messaggio);
    ELSE
	LOG("Ricevuto Messaggio di tipo sconosciuto da utente");
    END;


    IF FineMessaggio THEN

    ELSE
	LOG("(u2) Fine Connessione n. " & Fmt.Int(clo.N_C ));
    END;

UNTIL Fine ;
 LOCK MutTab DO
     EVAL  TabCon.delete(clo.N_C, InfoCon);
 END;
 DispTesAt();      (* Sul Video *)
 DispUtAt();       (* Sul Video *)
 UtentiAttivi();   (* Al server *)
RETURN NIL;
END GestioneConnessione;

PROCEDURE PingU(n:INTEGER; Ms:TEXT)=
VAR Inf : InfoConnessione;
BEGIN
 LOCK MutTab DO
  EVAL TabCon.get(n,Inf) ;
 END;
(* LOG("# Ping da " & Inf.NomeUt & " : " & Ms);        <--------------------*)
END PingU;

PROCEDURE AltroUt(n:INTEGER; Ms:TEXT)=  (* Altro terminale acceso *)
VAR Inf : InfoConnessione;
BEGIN
 LOCK MutTab DO
  EVAL TabCon.get(n,Inf) ;
 END;
  Inf.NomeUt := Sub(Ms,0,FindChar(Ms,' '));
  Inf.IndUt  := Sub(Ms,FindChar(Ms,' ')+1);
 LOCK MutTab DO
  EVAL TabCon.put(n,Inf) ;
 END;
 LOG("# Utente: " & Ms);
 DispUtAt();     (* Sul Video *)
 UtentiAttivi(); (* Al server *)
END AltroUt;

PROCEDURE AltraTessera(n:INTEGER; Ms:TEXT)=
VAR Inf : InfoConnessione;
BEGIN
 LOCK MutTab DO
  EVAL TabCon.get(n,Inf) ;
 END;
  Inf.TessNum := Ms;
 LOCK MutTab DO
  EVAL TabCon.put(n,Inf) ;
 END;
 LOG("# Tessera " & Ms & " da " & Inf.NomeUt);
 DispTesAt();      (* Sul Video *)
 UtentiAttivi(); (* Al server *)
  TessereInusate();  (* Al server *)
END AltraTessera;

PROCEDURE FineTessera(n:INTEGER; Ms:TEXT)=
VAR Inf : InfoConnessione;
BEGIN
 LOCK MutTab DO
  EVAL TabCon.get(n,Inf) ;
 END;
 LOG("# Fine Tessera " & Ms & " da " & Inf.NomeUt);
  Inf.TessNum := NIL;
 LOCK MutTab DO
  EVAL TabCon.put(n,Inf) ;
 END;
 DispTesAt();
 UtentiAttivi(); (* Al server *)
  TessereInusate(); (* Al server *)
END FineTessera;

PROCEDURE DBFetch(n:INTEGER; Ms:TEXT)=
VAR Inf : InfoConnessione;
    Value:TEXT;
    DBT : Dbase.T;
    Contenuto, Messaggio : TEXT;
    TipoMessaggio : CHAR;
BEGIN
 LOCK MutTab DO
  EVAL TabCon.get(n,Inf) ;
 END;
 LOCK MutDB DO
     DBT := Dbase.OpenR(FileTessere);
     Value:=Dbase.Fetch(DBT,Ms);
     Dbase.Close(DBT);
 END;
  IF Value = NIL THEN Value := "Niente" END;

  TipoMessaggio := VAL(15, CHAR);
  Contenuto := Value;
  Messaggio := Cat(FromChar(TipoMessaggio), Contenuto);
 TRY
  LOCK Inf.Mt DO
     Wr.PutText(Inf.CanWr  ,Messaggio);
     Inf.CanWr.nextMsg();
  END;
 EXCEPT Wr.Failure => LOG(" # Wr.Failure in DBFetch ");
 END;
END DBFetch;

PROCEDURE DBStore(n:INTEGER; Ms:TEXT)=
VAR Inf : InfoConnessione;
    Value, Key, Dat :TEXT;
    DBT : Dbase.T;
    Contenuto, Messaggio : TEXT;
    TipoMessaggio : CHAR;
BEGIN
 LOCK MutTab DO
  EVAL TabCon.get(n,Inf) ;
 END;
 Key := Sub(Ms,0,32); (* La chiave e' sempre lunga 32 in hex *)
 Dat := Sub(Ms,32);
 (*  LOG(Key & "#" & Dat); *)
 LOCK MutDB DO
     DBT := Dbase.Open(FileTessere);
     Dbase.Store(DBT,Key,Dat);
     Dbase.Close(DBT);
 END;
  Value := "Fatto";

  TipoMessaggio := VAL(16, CHAR);
  Contenuto := Value;
  Messaggio := Cat(FromChar(TipoMessaggio), Contenuto);
 TRY
  LOCK Inf.Mt DO
     Wr.PutText(Inf.CanWr  ,Messaggio);
     Inf.CanWr.nextMsg();
  END;
 EXCEPT Wr.Failure => LOG(" # Wr.Failure in DBStore ");
 END;
END DBStore;


PROCEDURE ErroreUt(n:INTEGER; Ms:TEXT)=
VAR Inf : InfoConnessione;
BEGIN
 LOCK MutTab DO
  EVAL TabCon.get(n,Inf) ;
 END;
  LOG("# Errore da " & Inf.NomeUt & " : " & Ms);
END ErroreUt;

PROCEDURE TessereAttive():INTEGER=  (* Utenti attivi *)
VAR      it : InfConTbl.Iterator;
	 NT : INTEGER;
	 Key : INTEGER;
	 Inf : InfoConnessione;
BEGIN
    NT := 0;
    it := TabCon.iterate();
    FOR i := 1 TO  TabCon.size() DO
     EVAL it.next(Key,Inf);
     IF Inf.TessNum # NIL THEN INC(NT) END;
    END;
 RETURN NT;
END TessereAttive;

PROCEDURE TerminaliAttivi():INTEGER=
BEGIN
   RETURN  TabCon.size() ;
END TerminaliAttivi;

PROCEDURE DispTesAt()=
BEGIN
     Putyx(4,45, "C. In Uso: " & Fmt.Int(TessereAttive() ) );
END DispTesAt;

PROCEDURE DispUtAt()=
BEGIN
     Putyx(4,27, "C. Pronti: " & Fmt.Int(TerminaliAttivi()));
END DispUtAt;


		       (* :::::::::::: *)
(* ------------------ Fine Thread di Nuova Connessione da utente-------------*)
		       (* :::::::::::: *)
PROCEDURE Scelta()=
BEGIN
  FOR x:=6 TO 22 DO
    CUP(x,1);CLRight();
  END;
  CUP(6,2);
RevVideo();
IO.Put(" Cosa vuoi fare ? :"); NLn(2); Normal();
IO.Put("       1)  Ping al Servente Principale"); NLn(2);
IO.Put("       2)  Computer Pronti"); NLn(2);
IO.Put("       3)  Computer in Uso"); NLn(2);
IO.Put("       4)  Avviso agli utenti  *"); NLn(2);
IO.Put("       5)  Sconnessione utente *"); NLn(2);
IO.Put("       6)  Chiusura della connessione col Servente Principale *"); NLn(2);
IO.Put("       7)  SPEGNIMENTO del Servente Locale (cioe' questo computer)"); NLn(2);

 IO.Put(" Scegli ! : ");
 CUPyx(22,13); Nu:=Rd.GetChar(Stdio.stdin);
END Scelta;
(* ----------------------------------------------------------------------- *)
(*############################ MAIN ##########################################*)
BEGIN

   MutCon := NEW(MUTEX);
   MutDB  := NEW(MUTEX);

	(* Inizializza il File di LOG *)
   FileL := FileWr.OpenAppend("/usr/bar/Client.LOG");

   FileR := IO.OpenRead("/etc/HOSTNAME");
   Str := IO.GetLine(FileR);
   Rd.Close(FileR);
   host := Sub(Str,0, FindChar(Str,'.')) ;
    LOG("HOST : " & host);

   FileR := IO.OpenRead(FileBAR);
   Str := IO.GetLine(FileR);
   Rd.Close(FileR);
   CodiceC := Sub(Str,0,7);
   PassW   := Sub(Str,7,8);
   LOG("Codice Cliente: " & CodiceC);

AddLocale := GetHostAddr();
LOG("Indirizzo locale " & Addr2Text(AddLocale));

       dbt    := Dbase.Open(FileTessere);
       IF dbt = NIL THEN dbt := Dbase.Create(FileTessere);
		    LOG("Creato Data Base Tessere");
       END;
       Dbase.Close(dbt);

       CLS(); Home();
       CUP(1,27);
	Bold();
		 IO.Put("Programma Client di BAR.NET");
	Normal();

     CUP(3,2); PutData();
     Orologio(3,70);

AddLocale := GetHostAddr();
CUP(4,2);IO.Put("Loc: ");PrintAddr(AddLocale);
CUP(4,67);IO.Put("Host: " & host);

 MutTab := NEW(MUTEX);
 ConnettiServer();
 AttesaConnessioni(); (* da Utente *)

(* REPEAT *)                  (* Loop principale *)
LOOP
Scelta();
	CASE Nu OF
		 '1'  =>  EVAL Ping();
		|'2'  =>  DispUtAt();
		|'3'  =>  DispTesAt();
		|'4'  =>
		|'5'  =>
		|'6'  => (* Chiusura(); *)
		|'7'  => Spegni() (* CUP(10,2); CSCDown() *)  ;

		ELSE  Bell(); PutErr(7,40,"Bho! ");
	END;
(* UNTIL Nu = '7' ;*)
END;


END Client.
