(* Copyright (C) 1992, Digital Equipment Corporation                         *)
(* All rights reserved.                                                      *)
(* See the file COPYRIGHT for a full description.                            *)
(*                                                                           *)
(* Last modified on Tue May 17 14:59:39 PDT 1994 by mhb        *)
(*      modified on Tue Jun 16 18:26:35 PDT 1992 by muller     *)

MODULE Utex2 EXPORTS Main;

IMPORT CalculatorBundle, FloatMode, Fmt, FormsVBT, Lex, Rd, Rsrc, Scan, Text,
       Thread, Trestle, TrestleComm, VBT;

IMPORT IO ;

<* FATAL FormsVBT.Error, FormsVBT.Unimplemented *>
<* FATAL Rd.Failure, Rsrc.NotFound, Thread.Alerted, TrestleComm.Failure *>
<* FATAL Lex.Error, FloatMode.Trap *>

TYPE
  Closure = REF RECORD
    memory:   INTEGER;
    operator: Text.T;
    building: BOOLEAN;
  END;

PROCEDURE NewForm (): FormsVBT.T =
  VAR
    form := NEW(FormsVBT.T).initFromRsrc(
	      "utex2.fv",
	      Rsrc.BuildPath(
		"$CALCULATORPATH", CalculatorBundle.Get()));
    cl := NEW(Closure);
  BEGIN
  FormsVBT.AttachProc(form, "ok", Leggi);
    cl.memory := 0;
    cl.operator := "NOOP";
    cl.building := FALSE;
    VBT.PutProp(form, cl);
    RETURN form;
  END NewForm;



PROCEDURE Leggi (
		 fv      : FormsVBT.T;
    <* UNUSED *> event   : Text.T;
    <* UNUSED *> closure : REFANY;
    <* UNUSED *> time    : VBT.TimeStamp) =
 VAR Codice : TEXT;
  BEGIN
    Codice := FormsVBT.GetText(fv, "codice");
    IO.Put(Codice);

    FormsVBT.PutText(fv, "testo", Codice);
   (* Trestle.Delete (fv)*)
  END Leggi;


BEGIN
  WITH z = NewForm() DO
    Trestle.Install(z);
    Trestle.AwaitDelete(z);
  END
END Utex2.
