UNSAFE INTERFACE Dbm;

(* The functions and types offered by the ndbm library are declared
in Modula-3 terms to make them accessible to Modula-3 procedures. *)

IMPORT Ctypes;

TYPE
  Datum = RECORD
      dptr: Ctypes.char_star;
      dsize: Ctypes.int;
    END;

  T = UNTRACED ROOT;

CONST
  DBM_INSERT = 0;
  DBM_REPLACE = 1;
  O_RDONLY = 0;
  O_WRONLY = 1;
  O_RDWR = 2;
  O_CREAT = 16_0200;

<*EXTERNAL dbm_open*>
PROCEDURE Open(file: Ctypes.char_star; flags, mode: INTEGER): T;

<*EXTERNAL dbm_close*>
PROCEDURE Close(db: T);

<*EXTERNAL dbm2_fetch*>
PROCEDURE Fetch(db: T; key: Datum): UNTRACED REF Datum;

<*EXTERNAL dbm_store*>
PROCEDURE Store(db: T; key, content: Datum; flags: INTEGER): INTEGER;

<*EXTERNAL dbm_delete*>
PROCEDURE Delete(db: T; key: Datum): INTEGER;

<*EXTERNAL dbm2_firstkey*>
PROCEDURE FirstKey(db: T): UNTRACED REF Datum;

<*EXTERNAL dbm2_nextkey*>
PROCEDURE NextKey(db: T): UNTRACED REF Datum;

END Dbm.

