(* ---------------------------------------------
File       : MD2Code.PAS
Azione     : Genera il codice MD2 di una stringa
Linguaggio : TurboPASCAL
Autore     : Dal Borgo Antonio - I4DBC
Data       : 07/10/93
Note       : TAB =3
Convertito in Modula-3 da I2KFX
----------------------------------------------- *)

MODULE  MD2 ;

FROM Word IMPORT Xor;
FROM Text IMPORT Length, GetChar, SetChars, FromChars ;

TYPE
    BYTE = [0..255];

PROCEDURE NbHex (Nibble:BYTE):CHAR =


(* Azione: Converte un nibble in carattere esadecimale *)
BEGIN
	IF Nibble < 10 THEN
		RETURN VAL(Nibble+48, CHAR)  (* Cifra *)
	ELSE  
		RETURN VAL(Nibble+87, CHAR); (* Lettera minuscola *)
	END;
END NbHex;



PROCEDURE MD2Code (Message:TEXT):TEXT =
(* Azione: Genera MD2 dalla stringa Message *)


(* Tabella permutazioni ricavata dalle cifre di pi_greco *)

TYPE
    BYTE = (* SET OF *) [0..255];
    Pi_Subst = ARRAY [0..255] OF BYTE;

CONST  S = Pi_Subst  
	{ 41, 46, 67, 201, 162, 216, 124, 1, 61, 54, 84, 161, 236, 240, 6,
	19, 98, 167, 5, 243, 192, 199, 115, 140, 152, 147, 43, 217, 188,
	76, 130, 202, 30, 155, 87, 60, 253, 212, 224, 22, 103, 66, 111, 24,
	138, 23, 229, 18, 190, 78, 196, 214, 218, 158, 222, 73, 160, 251,
	245, 142, 187, 47, 238, 122, 169, 104, 121, 145, 21, 178, 7, 63,
	148, 194, 16, 137, 11, 34, 95, 33, 128, 127, 93, 154, 90, 144, 50,
	39, 53, 62, 204, 231, 191, 247, 151, 3, 255, 25, 48, 179, 72, 165,
	181, 209, 215, 94, 146, 42, 172, 86, 170, 198, 79, 184, 56, 210,
	150, 164, 125, 182, 118, 252, 107, 226, 156, 116, 4, 241, 69, 157,
	112, 89, 100, 113, 135, 32, 134, 91, 207, 101, 230, 45, 168, 2, 27,
	96, 37, 173, 174, 176, 185, 246, 28, 70, 97, 105, 52, 64, 126, 15,
	85, 71, 163, 35, 221, 81, 175, 58, 195, 92, 249, 206, 186, 197,
	234, 38, 44, 83, 13, 110, 133, 40, 132, 9, 211, 223, 205, 244, 65,
	129, 77, 82, 106, 220, 55, 200, 108, 193, 171, 250, 36, 225, 123,
	8, 12, 189, 177, 74, 120, 136, 149, 139, 227, 99, 232, 109, 233,
	203, 213, 254, 59, 0, 29, 57, 242, 239, 183, 14, 102, 88, 208, 228,
	166, 119, 114, 248, 235, 117, 75, 10, 49, 68, 80, 180, 143, 237,
	31, 26, 219, 153, 141, 51, 159, 17, 131, 20 } ;

VAR     i, xchr, LastC       : BYTE;
		StrPnt,MsgLen,PadLen : CARDINAL;
		C                    : ARRAY [0..15] OF BYTE;
		X                    : ARRAY [0..47] OF BYTE;
	CodeSt : ARRAY[1..32] OF CHAR;
	CodeTxt : TEXT ;

   (* -----  procedure  interne ----- *)


PROCEDURE EncryptBlock () =
(* Const    : S[]
   InOutVar : X[]
   Azione   : Cripta un blocco *)
VAR j,k,t : BYTE;
BEGIN
	     t := 0;
	     FOR  j:= 0 TO 17 DO
		    
			     FOR k := 0 TO 47 DO
				     
				     X[k] :=  Xor(X[k], S[t]); t := X[k]; 
			     END; (* loop k *)
			     t := (t+j) MOD 256;
			     
	     END; (* loop j *)
	     
END EncryptBlock;


   (* --- Fine  procedure interne --- *)


BEGIN (* Procedure: MD2Code *)

	MsgLen := Length(Message) ;        (* Lunghezza Message *)
	PadLen := 16 - MsgLen MOD 16;      (* Lunghezza padding *)

(* IO.Put("Stringa lunga : "); IO.PutInt(MsgLen); IO.Put("\n"); *)
	(* Inizializza *)
	FOR i := 0 TO 15 DO (* Reset X[0..15] e C[0..15] *)
	
			C[i] := 0;  X[i] := 0;
	
	END;
       
 StrPnt :=  0  ; (* Puntatore stringa Message *)
	LastC := 0; (* Buffer ultimo valore di C[] calcolato *)

	(* Elabora la stringa Message in blocchi da 16-Byte *)
	REPEAT
	 
		(* Elabora un blocco *)
		FOR i := 0 TO 15 DO
			
			   IF StrPnt + i <= MsgLen-1 THEN (* Preleva un carattere dal messaggio *)
	 		            xchr := ORD(GetChar(Message, StrPnt + i ));  
			   ELSE (* Esegui il padding del blocco terminale *)
				   xchr := PadLen;
			   END;
			  
			   (* Trasferisci xchr in X[16+i] e X[32+i] *)
			   X[16+i] := xchr;  X[32+i] :=  Xor(xchr,  X[i]);

			   (* Aggiorna C[] con il carattere xchr *)
			   C[i] :=  Xor( C[i], S[Xor(xchr, LastC) MOD 256]);
			   LastC := C[i]; (* Salva l'ultimo valore di C[] calcolato *)

		END; (* loop i *)
	       
		EncryptBlock() ; (* Cripta un blocco *)
		StrPnt := StrPnt + 16; (* Aggiorna StrPnt *)
	 
	UNTIL StrPnt - 1 > MsgLen;
	(* Aggiorna X[] con i valori di C[] *)
	FOR i := 0 TO 15 DO
		   X[16+i] := C[i]; X[32+i] :=  Xor(C[i], X[i]);
		   C[i] := Xor(C[i], S[Xor(C[i], LastC) MOD 256]); (* Aggiorna C[] *)
		   LastC := C[i]; (* Salva l'ultimo valore di C[] calcolato *)
	END; (* loop i *)

   EncryptBlock(); (* Cripta un blocco *)

	(* Converti X[0..15] in una stringa esadecimale di 2*16 caratteri *)
	i := 0; (* Contatore *)
	WHILE i <= 15 DO
	       	        (* Converti da Interi BYTE a CHAR *)
			CodeSt[i+1] := VAL(X[i], CHAR)  ;
			i := i + 1;
	END;


	CodeTxt := FromChars(CodeSt);

	RETURN CodeTxt;

END MD2Code;


PROCEDURE MD2CodeH (Message:TEXT):TEXT =
TYPE
	BYTE =  [0..255];

VAR	CodeSt : ARRAY[1..32] OF CHAR;
  	CodeC  : ARRAY[0..15] OF CHAR;
	CodeTxt : TEXT ;
	MD2Text : TEXT;
	i : CARDINAL;
	X : ARRAY [0..15] OF BYTE;

BEGIN
       MD2Text := MD2Code(Message);
       SetChars(CodeC,MD2Text);
    
	(* Converti X[0..15] in una stringa esadecimale di 2*16 caratteri *)
	i := 0; (* Contatore *)
	WHILE i <= 15 DO
		       (* Converti da BYTE a Hex *)
		        X[i] := ORD(CodeC[i]);
			CodeSt[2*i+1] := NbHex (X[i] DIV 16);
			CodeSt[2*i+2] := NbHex (X[i] MOD 16);
			i := i + 1;
	END;

	CodeTxt := FromChars(CodeSt);

	RETURN CodeTxt;

END MD2CodeH;

BEGIN
END MD2.

