// RPi Rotator X4 with MCP3008
// 25.09.2016. Author: Goran Stankovic dipl.ing.el. (goranstank@gmail.com)
//
// gcc -o rotator4 -l rt rotator4.c -l bcm2835
// sudo ./rotator4

#include <bcm2835.h>
#include <stdio.h>
#include <stdlib.h>


int main(int argc, char **argv)
{

    FILE * fp;

    if (!bcm2835_init())
	return 1;

    bcm2835_spi_begin();
    bcm2835_spi_setBitOrder(BCM2835_SPI_BIT_ORDER_MSBFIRST);
    bcm2835_spi_setDataMode(BCM2835_SPI_MODE0);
//    bcm2835_spi_setClockDivider(BCM2835_SPI_CLOCK_DIVIDER_65536); // 250Mhz/65536=3.8kHz
    bcm2835_spi_setClockDivider(BCM2835_SPI_CLOCK_DIVIDER_256);     // 250MHz/256=976.5kHz
    bcm2835_spi_chipSelect(BCM2835_SPI_CS0);                        // Slave on CS0
    bcm2835_spi_setChipSelectPolarity(BCM2835_SPI_CS0, LOW);

    bcm2835_gpio_fsel( 4, BCM2835_GPIO_FSEL_OUTP);
    bcm2835_gpio_fsel(17, BCM2835_GPIO_FSEL_OUTP);
    bcm2835_gpio_fsel(18, BCM2835_GPIO_FSEL_OUTP);
    bcm2835_gpio_fsel(22, BCM2835_GPIO_FSEL_OUTP);
    bcm2835_gpio_fsel(23, BCM2835_GPIO_FSEL_OUTP);
    bcm2835_gpio_fsel(24, BCM2835_GPIO_FSEL_OUTP);
    bcm2835_gpio_fsel(25, BCM2835_GPIO_FSEL_OUTP);
    bcm2835_gpio_fsel(27, BCM2835_GPIO_FSEL_OUTP);


    char buf[] = { 0x01, 0x80, 0x00 }; // Data to send
    int adc1, adc2, adc3, adc4;
    int p1, p2, p3, p4;
    int set=1;		// Start pozicioniranja
    int delta=2;	// min ugao za koji rotator ne reaguje
    int out1=0, out2=0, out3=0, out4=0;
    int ps1=100, ps2=200, ps3=300, ps4=340;
    int time1=0, time2=0, time3=0, time4=0;
    int time_max1=60*4, time_max2=60*4, time_max3=60*4, time_max4=60*4;
    int pmin1=0, pmax1=1023, pmin2=0, pmax2=1023, pmin3=0, pmax3=1023, pmin4=0, pmax4=1023;
    int op1, op2, op3, op4;

    char c;
    char buffer[100];
    long length;
    int i=0, j=0;
    int buffer2[16];
// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
    printf("*** RPi Rotator for 4 antennas system ***  YT2FSG  ***\n");
    printf("by: Goran Stankovic dipl.ing.el. (goranstank@gmail.com)\n\n");
	printf("Parameters:   Ant1 Ant2 Ant3 Ant4\n");
// Ucitavanje parametara iz file 'time_max'
    if ((fp = fopen("time_max","r")) == NULL)
    {
       printf("file 'time_max' not found! \n");
    }
    else
    {
       while(1)
       {
         c = fgetc(fp);
         if (feof(fp)) { break; }
         if (c==',') { buffer[i] = 0; i = 0;  buffer2[j] = atoi(buffer); j++; }
         else { buffer[i] = c; i++; }
       }
         buffer[i] = 0;
         buffer2[j] = atoi(buffer);

		printf("time_max (sec): %3d %3d %3d %3d \n", buffer2[0], buffer2[1], buffer2[2], buffer2[3]);

        time_max1 = buffer2[0] * 4;
        time_max2 = buffer2[1] * 4;
        time_max3 = buffer2[2] * 4;
        time_max4 = buffer2[3] * 4;
    }
    fclose(fp);
// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
// Ucitavanje parametara iz file 'calibration'
    i=0; j=0;
    if ((fp = fopen("calibration","r")) == NULL)
    {
       printf("file 'calibration' not found! \n");
    }
    else
    {
       while(1)
       {
         c = fgetc(fp);
         if (feof(fp)) { break; }
         if (c==',') { buffer[i] = 0; i = 0;  buffer2[j] = atoi(buffer); j++; }
         else { buffer[i] = c; i++; }
       }
         buffer[i] = 0;
         buffer2[j] = atoi(buffer);

		printf("cal_min  (   ): %3d %3d %3d %3d \n", buffer2[0], buffer2[2], buffer2[4], buffer2[6]);
		printf("cal_max  (   ): %3d %3d %3d %3d \n", buffer2[1], buffer2[3], buffer2[5], buffer2[7]);

		pmin1 = buffer2[0]; pmax1 = buffer2[1];
		pmin2 = buffer2[2]; pmax2 = buffer2[3];
		pmin3 = buffer2[4]; pmax3 = buffer2[5];
		pmin4 = buffer2[6]; pmax4 = buffer2[7];
     }
    fclose(fp);

//    exit(0);
// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  while (1)
  {
    // Citanje pozicije antena - potenciometri (MCP3008)
    // CH0
    buf[0] = 0x01; buf[1] = 0x80; buf[2] = 0x00;
    bcm2835_spi_transfern(buf, sizeof(buf));
    adc1 = buf[1] & 0b00000011;
    adc1 = (adc1 << 8) | buf[2];

    // CH1
    buf[0] = 0x01; buf[1] = 0x90; buf[2] = 0x00;
    bcm2835_spi_transfern(buf, sizeof(buf));
    adc2 = buf[1] & 0b00000011;
    adc2 = (adc2 << 8) | buf[2];

    // CH2
    buf[0] = 0x01; buf[1] = 0xA0; buf[2] = 0x00;
    bcm2835_spi_transfern(buf, sizeof(buf));
    adc3 = buf[1] & 0b00000011;
    adc3 = (adc3 << 8) | buf[2];

    // CH3
    buf[0] = 0x01; buf[1] = 0xB0; buf[2] = 0x00;
    bcm2835_spi_transfern(buf, sizeof(buf));
    adc4 = buf[1] & 0b00000011;
    adc4 = (adc4 << 8) | buf[2];

// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
// Calibration
    op1 = pmax1 - pmin1;
	if (op1 < 1 ) { p1 = adc1 * 360 / 1023; }
	else { p1 = (adc1 - pmin1) * 360 / op1; }
    op2 = pmax2 - pmin2;
	if (op2 < 1 ) { p2 = adc2 * 360 / 1023; }
	else { p2 = (adc2 - pmin2) * 360 / op2; }
    op3 = pmax3 - pmin3;
	if (op3 < 1 ) { p3 = adc3 * 360 / 1023; }
	else { p3 = (adc3 - pmin3) * 360 / op3; }
    op4 = pmax4 - pmin4;
	if (op4 < 1 ) { p4 = adc4 * 360 / 1023; }
	else { p4 = (adc4 - pmin4) * 360 / op4; }

//    printf("Position: %d=%d %d=%d %d=%d %d=%d \n", adc1, p1, adc2, p2, adc3, p3, adc4, p4);

// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
// Ucitavanje parametara iz FLASH-DISK file 'pos_set'
    i=0; j=0;
    if ((fp = fopen("/var/www/pos_set","r")) == NULL)
    {
       printf("file '/var/www/pos_set' not found! \n");
    }
    else
    {
       while(1)
       {
         c = fgetc(fp);
         if (feof(fp)) { break; }
         if (c==',') { buffer[i] = 0; i = 0;  buffer2[j] = atoi(buffer); j++; }
         else { buffer[i] = c; i++; }
       }
         buffer[i] = 0;
         buffer2[j] = atoi(buffer);

//	printf("pos_set : %3d %3d %3d %3d \n", buffer2[0], buffer2[1], buffer2[2], buffer2[3]);

        ps1 = buffer2[0];
        ps2 = buffer2[1];
        ps3 = buffer2[2];
        ps4 = buffer2[3];
    }
    fclose(fp);
//    exit(0);
// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
// Ucitavanje parametara iz FLASH-DISK file 'set'
    i=0; j=0;
    if ((fp = fopen("/var/www/set","r")) == NULL)
    {
       printf("file '/var/www/set' not found! \n");
    }
    else
    {
       while(1)
       {
         c = fgetc(fp);
         if (feof(fp)) { break; }
         buffer[i] = c; i++;
       }
       buffer[1] = 0;
       set = atoi(buffer);
//       printf("set : %d \n", set);
    }
    fclose(fp);

//    exit(0);

// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

	// Obrada - pozicioniranje antena na zadatu poziciju

    if (set==1)
    {
      set = 0;

	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
    //Upisi '0' u FLASH-DISK file 'set'
    if ((fp = fopen("/var/www/set","w")) == NULL)
    {
       printf("file '/var/www/set' not open! \n");
    }
    else
    {
       fputc( '0', fp);
    }
    fclose(fp);


      if      (p1 < ps1 - delta) { out1 = 1; }
      else if (p1 > ps1 + delta) { out1 = 2; }
      else { out1 = 0; }

      if      (p2 < ps2 - delta) { out2 = 1; }
      else if (p2 > ps2 + delta) { out2 = 2; }
      else { out2 = 0; }

      if      (p3 < ps3 - delta) { out3 = 1; }
      else if (p3 > ps3 + delta) { out3 = 2; }
      else { out3 = 0; }

      if      (p4 < ps4 - delta) { out4 = 1; }
      else if (p4 > ps4 + delta) { out4 = 2; }
      else { out4 = 0; }
    }
    else
    {
      if ((p1 >= ps1) && (out1==1)) { out1 = 0; }
      if ((p1 <= ps1) && (out1==2)) { out1 = 0; }
      if (out1 !=0)
      {
        time1++;
        if (time1 > time_max1) { out1 = 0; }
      }

      if ((p2 >= ps2) && (out2==1)) { out2 = 0; }
      if ((p2 <= ps2) && (out2==2)) { out2 = 0; }
      if (out2 !=0)
      {
        time2++;
        if (time2 > time_max2) { out2 = 0; }
      }

      if ((p3 >= ps3) && (out3==1)) { out3 = 0; }
      if ((p3 <= ps3) && (out3==2)) { out3 = 0; }
      if (out3 !=0)
      {
        time3++;
        if (time3 > time_max3) { out3 = 0; }
      }

      if ((p4 >= ps4) && (out4==1)) { out4 = 0; }
      if ((p4 <= ps4) && (out4==2)) { out4 = 0; }
      if (out4 !=0)
      {
        time4++;
        if (time4 > time_max4) { out4 = 0; }
      }
    }

// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
// Postavnjanje izlaza
    if (out1 == 1)
    {
      bcm2835_gpio_write( 4,1);
      bcm2835_gpio_write(17,0);
    }
    else if (out1 == 2)
    {
      bcm2835_gpio_write( 4,0);
      bcm2835_gpio_write(17,1);
    }
    else
    {
      time1 = 0;
      bcm2835_gpio_write( 4,0);
      bcm2835_gpio_write(17,0);
    }

    if (out2 == 1)
    {
      bcm2835_gpio_write(18,1);
      bcm2835_gpio_write(22,0);
    }
    else if (out2 == 2)
    {
      bcm2835_gpio_write(18,0);
      bcm2835_gpio_write(22,1);
    }
    else
    {
      time2 = 0;
      bcm2835_gpio_write(18,0);
      bcm2835_gpio_write(22,0);
    }

    if (out3 == 1)
    {
      bcm2835_gpio_write(23,1);
      bcm2835_gpio_write(24,0);
    }
    else if (out3 == 2)
    {
      bcm2835_gpio_write(23,0);
      bcm2835_gpio_write(24,1);
    }
    else
    {
      time3 = 0;
      bcm2835_gpio_write(23,0);
      bcm2835_gpio_write(24,0);
    }

    if (out4 == 1)
    {
      bcm2835_gpio_write(25,1);
      bcm2835_gpio_write(27,0);
    }
    else if (out4 == 2)
    {
      bcm2835_gpio_write(25,0);
      bcm2835_gpio_write(27,1);
    }
    else
    {
      time4 = 0;
      bcm2835_gpio_write(25,0);
      bcm2835_gpio_write(27,0);
    }
// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
    //Upisi podatke u RAM-DISK file 'position'
    if ((fp = fopen("/var/tmp/position","w")) == NULL)
    {
       printf("file '/var/tmp/position' not open! \n");
    }
    else
    {
       fprintf(fp,"%3d,%3d,%3d,%3d\n",p1,p2,p3,p4);
    }
    fclose(fp);
// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
    printf("%d = Out1: %3d %3d %d %3d - Out2: %3d %3d %d %3d - Out3: %3d %3d %d %3d - Out4: %3d %3d %d %3d \n",set,ps1,p1,out1,time1,ps2,p2,out2,time2,ps3,p3,out3,time3,ps4,p4,out4,time4);

    bcm2835_delay(250);  // delay 0.25sec

  }
    bcm2835_spi_end();
    bcm2835_close();
    return 0;
}

