module top(

 input clk,
 input x_res,
 output wire x_sync,
 output wire x_r,
 output wire x_g,
 output wire x_b
);


//-----------------------------------------------------------------------------

 wire csync, ball, left_bat, right_bat, field_and_score;

 tennis game( .glb_clk(clk),
              .reset(~x_res),
              .csync(csync),
              .ball(ball),
              .left_bat(left_bat),
              .right_bat(right_bat),
              .field_and_score(field_and_score)
            );

	assign x_g = (ball || left_bat || right_bat || field_and_score);	
	assign x_r = (ball || right_bat);
	assign x_b = (ball || left_bat);
   assign x_sync = csync;

//-----------------------------------------------------------------------------

endmodule
