module tennis(
 input wire glb_clk,		// 2MHz
 input wire reset,
 output wire csync,          // Warning!
 output wire ball,           // Resync all output outside
 output wire left_bat,       // by glb_clk 
 output wire right_bat,      //
 output wire field_and_score //
);

//-----------------------------------------------------------------------------

// -- -- image -- --

 reg [6:0] hcount;
 reg [8:0] vcount;
 reg vfield, hfield;
 wire hsync, nsync, vsync;
 wire tborder, bborder, vborder, midline, v_lbat, v_rbat, vcnt_res;
 wire lineend, pixlineend, lastline, lastlineend, pixlastlineend;

 assign lineend = (hcount==7'd127);
 assign pixlineend = lineend;
 assign lastline = (vcount==9'd311);
 assign lastlineend = lastline & lineend;
 assign pixlastlineend = lineend & lastline;
 assign vcnt_res = (vcount==9'd312);
 assign v_lbat = ~(above_lbat|below_lbat);
 assign v_rbat = ~(above_rbat|below_rbat);
 assign tborder = (vcount[8:1]==8'd24); // 48...49
 assign bborder = (vcount[8:1]==8'd139); // 278...279
 assign vborder = tborder | bborder;
 assign midline = (hcount==7'd64);
 assign nsync = (hcount[6:3]==4'hE); // 112...119
 assign hsync = (hcount[6:3]==4'hF); // 120...127
 assign vsync = (vcount[8:1]==8'd155); // 310...311
 assign csync = nsync | (~vsync&~hsync);
 assign ball = hfield & vfield & vb & (hcount==ball_xpos);
 assign left_bat = vfield & v_lbat & (hcount==7'd26);
 assign right_bat = vfield & v_rbat & (hcount==7'd102);
 assign field_and_score = ( ( hfield & vborder & ~hcount[0] )
                            |
                            ( vfield & midline & ~(vcount[2]^vcount[1]) )
                          );

 always @(posedge glb_clk)
 begin
   hcount <= hcount+7'd1;
 end

 always @(posedge glb_clk)
 begin
  if      (hcount[6:0]==7'd23)   hfield <= 1'b1;
  else if (hcount[6:0]==7'd105)  hfield <= 1'b0;
 end

 always @(posedge glb_clk or posedge vcnt_res)
 begin
  if (vcnt_res)
   vcount <= 9'd0;
  else if ( pixlineend )
   vcount <= vcount+9'd1;
 end

 always @(negedge bborder or posedge tborder)
 begin
  if (tborder)
   vfield <= 1'b1;
  else
   vfield <= 1'b0;
 end

// -- -- ball & bat position -- --

 reg [8:0] lbat_ypos, rbat_ypos, ball_ypos;
 reg [6:0] ball_xpos;
 reg ball_ydir, ball_xdir, ball_yspd;

 always @(posedge glb_clk or posedge reset)
 begin
  if (reset)
   ball_ypos <= 9'd128;
  else if (pixlineend)
  begin

   if ( (vcount==9'd0) | (vsync&ball_yspd) )
   begin
    if (vcoll^ball_ydir)
     ball_ypos <= ball_ypos+9'd1;
    else
     ball_ypos <= ball_ypos-9'd1;
   end

  end
 end


 always @(posedge glb_clk or posedge reset)
 begin
  if (reset)
  begin
   lbat_ypos <= 9'd64;
   rbat_ypos <= 9'd192;
   ball_xpos <= 7'd64;
   ball_ydir <= 1'd0;
   ball_xdir <= 1'd0;
   ball_yspd <= 1'd1;
  end
  else if (pixlastlineend)
  begin

   if (hcoll) ball_xdir <= ~ball_xdir;

   if (hcoll)
   begin
    if (ball_ydir^(ball_xdir?rbat_ydir:lbat_ydir))
     ball_yspd <= 1'd1;
    else
     ball_yspd <= 1'd0;
   end

   if (hcoll^ball_xdir)
    ball_xpos <= ball_xpos+7'd1;
   else
    ball_xpos <= ball_xpos-7'd1;

   if (vcoll) ball_ydir <= ~ball_ydir;

   if (~ball_xdir)
   begin
    if (lbat_ydir)
     lbat_ypos <= lbat_ypos+9'd4;
    else
     lbat_ypos <= lbat_ypos-9'd4;
   end
   else
   begin
    if (lbat_ydir)
     lbat_ypos <= lbat_ypos+9'd1;
    else
     lbat_ypos <= lbat_ypos-9'd1;
   end

   if (ball_xdir)
   begin
    if (rbat_ydir)
     rbat_ypos <= rbat_ypos+9'd4;
    else
     rbat_ypos <= rbat_ypos-9'd4;
   end
   else
   begin
    if (rbat_ydir)
     rbat_ypos <= rbat_ypos+9'd2;
    else
     rbat_ypos <= rbat_ypos-9'd2;
   end

  end
 end

// -- -- ball & bat size; collision event; autoplayer -- --

 reg [1:0] vbcnt;
 reg [3:0] vlcnt, vrcnt;
 reg prev_ball, prev_lbat, hcoll, vcoll, newline, vb;

 reg above_lbat, below_lbat, above_rbat, below_rbat, lbat_ydir, rbat_ydir;

 always @(posedge glb_clk)
 begin
  if (vb)
  begin
   if      (above_lbat)  lbat_ydir <= 1'b0;
   else if (below_lbat)  lbat_ydir <= 1'b1;
   if      (above_rbat)  rbat_ydir <= 1'b0;
   else if (below_rbat)  rbat_ydir <= 1'b1;
  end
 end

 always @(posedge glb_clk)
 begin
   newline <= lineend;
   prev_lbat <= left_bat;
   prev_ball <= ball;
 end

 always @(posedge glb_clk)
 begin
   if (lastlineend)
   begin
    hcoll <= 1'b0;
    vcoll <= 1'b0;
   end
   else
   begin
    if ( ( prev_lbat & ball & ~ball_xdir ) |
         ( prev_ball & right_bat & ball_xdir ) )  hcoll <= 1'b1;
    if ( vborder & vb )  vcoll <= 1'b1;
   end
 end

 always @(posedge glb_clk)
 begin
   if (newline)
   begin

    if (vcount==ball_ypos)  vb <= 1'b1;
    if (vb)
    begin
     vbcnt <= vbcnt+2'd1;
     if (vbcnt==2'd3)  vb <= 1'b0;
    end

    if (vcount==lbat_ypos)  above_lbat <= 1'b0;
    if (v_lbat)
    begin
     vlcnt <= vlcnt+4'd1;
     if (vlcnt==4'd15)  below_lbat <= 1'b1;
    end

    if (vcount==rbat_ypos)  above_rbat <= 1'b0;
    if (v_rbat)
    begin
     vrcnt <= vrcnt+4'd1;
     if (vrcnt==4'd15)  below_rbat <= 1'b1;
    end

   end // newline

   if (lineend)
   begin
    if (lastline)
    begin
     above_lbat <= 1'b1;
     below_lbat <= 1'b0;
     above_rbat <= 1'b1;
     below_rbat <= 1'b0;
     vbcnt <= 2'd0;
     vlcnt <= 4'd0;
     vrcnt <= 4'd0;
    end // lastline
   end // lineend
 end

//-----------------------------------------------------------------------------

endmodule
