/*Reference:  http://srukami.inf.ua/pultoscop_v25110.html 
* PULTOSCOPE cu afisaj LCD NOKIA5110
* Meniuri principale la pornire: PULTOSCOPE, GENERATOR
* Actualizat YO6PIR - 04.04.2024
* Intrare semnal oscilo = A0
* Optimizare software si traducere din ucraineana->eng
* Indicator sincronizare de tip Sageata pe partea dreapta 
* Adaptare comenzi de la encoder cu Push-Button:
* BUTTON_LEFT --> Enc_A
* BUTTON_RIGHT --> Enc_B
* BUTTON_OK --> PUSH_BUTTON
* Rutina encoder preluata din ANTUINO Snipper
*/

#include <Adafruit_GFX.h>
#include <Adafruit_PCD8544.h>
#include <FreqCount.h> 
#include <PWM.h>

/* I/O ports to read the tuning mechanism */
#define ENC_A 11
#define ENC_B 12
#define FBUTTON 8
#define SignalPIN  9                                    //pin for the SignalPIN generator (do not change)
#define BattPIN A4                                      //any single analog pin for measuring Battery voltage
#define ArduFreq 16                                     //Frequency at which Arduino operates

Adafruit_PCD8544 display = Adafruit_PCD8544(6,7,4,3,2); //pins to which your display is connected         
/*Initializare variabile*/
byte Contrast=52;                                       //display Contrastrast
byte sinc_level=30;                                     //sync level 0 to 255
int PWM = 128;                                          //start PWM value from 0 to 255             
int32_t frequency = 500;                                //start frequency value in Hz
float VCC=5.0;                                          //supply voltage, measured with a multimeter
byte pwmMENU=0;
int FreqMulti=0;
boolean flag=0;
byte mass[256];
byte x=0; 
byte menu=1;                                            //menu selection variable
bool RefvFlag=1;                                        //reference voltage flag
bool paus=0;                                            //pause mode flag
bool pultoskop=0;            //flag for selecting a generator or oscilloscope
byte divizor=4;  
unsigned long contor =0;
int Vmax=0;// maximum voltage
byte sinhMASS=0;
int enc_prev_state = 3;

/*Rutina software Timer********************************************************************/
void active_delay(int delay_by){
  unsigned long timeStart = millis();
  while (millis() - timeStart <= delay_by) {
      //Background Work      
  }
}
/*Rutina de apasare a butonului************************************************************/
int btnDown(){
  if (digitalRead(FBUTTON) == HIGH)
    return 0;
  else
    return 1;
}
/*return state of encoder pins*/
byte enc_state (void) {
    return (digitalRead(ENC_A) ? 1 : 0) + (digitalRead(ENC_B) ? 2: 0);
}
/******************* Encoder routine ******************************************************/
int enc_read(void) {
  int result = 0; 
  byte newState;
  
  long stop_by = millis() + 100;  
  while (millis() < stop_by) { // check if the previous state was stable
    newState = enc_state(); // Get current state  
    if (newState != enc_prev_state)
      delay (1);
    
    if (enc_state() != newState || newState == enc_prev_state)
      continue; 
    //these transitions point to the encoder being rotated anti-clockwise
    if ((enc_prev_state == 0 && newState == 2) || 
      (enc_prev_state == 2 && newState == 3) || 
      (enc_prev_state == 3 && newState == 1) || 
      (enc_prev_state == 1 && newState == 0)){
        result--;
      }
    //these transitions point o the enccoder being rotated clockwise
    if ((enc_prev_state == 0 && newState == 1) || 
      (enc_prev_state == 1 && newState == 3) || 
      (enc_prev_state == 3 && newState == 2) || 
      (enc_prev_state == 2 && newState == 0)){
        result++;
      }
    enc_prev_state = newState; // Record state for next pulse interpretation
    //enc_speed++;
    active_delay(1);
  }
    return(result/2);
}
/******************* MODE Generator*******************************/
void Generator(){
  int i=enc_read();                         //citeste encoder
  display.clearDisplay();  
 
  if (flag==0){   /*Selectie modificare frecventa*/
     if(i<0)if(frequency>FreqMulti)frequency-=FreqMulti;  /*Modificare frecventa DOWN*/
     if(i>0)frequency+=FreqMulti;                         /*Modificare frecventa UP*/
     bool success = SetPinFrequencySafe(SignalPIN, frequency);
  }

if (flag==1){    /*Selectie modificare factor de umplere*/
     if(i<0)if(PWM>6)PWM-=3;                     /*Modificare pwm DOWN limitat la 1%*/
     if(i>0)if(PWM<255-3) PWM+=3;                /*Modificare pwm UP limitat la 99%*/
}      
 
if(btnDown()){                              /*switching the frequency selection bit*/
    pwmMENU++; while(btnDown());
    if(pwmMENU>=5){pwmMENU=0;}
} 
////////////
display.setTextSize(1);
display.setCursor(0,5);
display.print("PWM=");
display.print(PWM*100/255);
display.print(" %");
display.drawLine(0,0,83*PWM/255.0,0, BLACK);
display.drawLine(0,1,83*PWM/255.0,1, BLACK);
display.drawLine(0,2,83*PWM/255.0,2, BLACK);
display.drawLine(0,15,83*PWM/255.0,15, BLACK);
display.drawLine(0,16,83*PWM/255.0,16, BLACK);
display.drawLine(0,17,83*PWM/255.0,17, BLACK);
///////////    
display.setCursor(5,20);
 display.setTextSize(2);
long frequencyX=frequency*(ArduFreq/16.0);
if(frequencyX<1000){display.print(frequencyX);display.setTextSize(1);display.println("Hz");}
if(frequencyX>=1000){if(frequencyX<10000){display.print((frequencyX/1000.0),2);display.setTextSize(1);display.println("KHz");}}
if(frequencyX>=10000){if(frequencyX<100000){display.print((frequencyX/1000.0),1);display.setTextSize(1);display.println("KHz");}}
if(frequencyX>=100000){display.print((frequencyX/1000.0),0);display.setTextSize(1);display.println("KHz");}
display.setCursor(0,40);
display.setTextSize(1);
display.print(">>x ");    
      if(pwmMENU==0){/*frequency multiplier x1 selection*/
        
          display.print(1*(ArduFreq/16.0),1); 
          FreqMulti=1;
          flag=0;
      }
      if(pwmMENU==1){/*frequency multiplier x10 selection*/
          display.print(10*(ArduFreq/16.0),0); 
          FreqMulti=10;
      }
      if(pwmMENU==2){/*frequency multiplier x100 selection*/
          display.print(100*(ArduFreq/16.0),0); 
          FreqMulti=100;
      }
      if(pwmMENU==3){/*frequency multiplier x1000 selection*/
          display.print(1000*(ArduFreq/16.0),0); 
          FreqMulti=1000;
      } 
      if(pwmMENU==4){/*pwm selection*/
          display.print("PWM ");
          display.print(PWM*100/255);
          display.print("%"); 
          flag=1;
      } 
display.print("<<");        
pwmWrite(SignalPIN, PWM);  
display.display();
}
/******************* SETUP Routine *************************/
void setup(){
display.begin();
display.setContrast(Contrast); 
//keep clear of any previous button press
  while (btnDown()){
  active_delay(100);}
   
 pinMode(ENC_A, INPUT_PULLUP);
 pinMode(ENC_B, INPUT_PULLUP);
 pinMode(FBUTTON, INPUT_PULLUP);
 
 /*verifica apasarea butonului in ecranul prioncipal*/
 while(!btnDown()){   
    int i = enc_read();
    display.clearDisplay();
    /*Display Antet*/
    display.setCursor(8,00);
    display.setTextColor(BLACK); 
    display.println("YO6PIR-2024"); 
  
    if(pultoskop==0){
      display.setCursor(8,15);
      display.setTextColor(WHITE, BLACK); // 'inverted' text
      display.println(" PULTOSCOPE");
      display.setCursor(11,25);
      display.setTextColor(BLACK); 
      display.println(" GENERATOR ");
      display.setCursor(0,40);
      display.print("Battery= ");
      display.print(analogRead(BattPIN)*5.0/1024);
      display.println("V");
    }
    if(pultoskop==1){
      display.setCursor(8,15);
      display.setTextColor(BLACK); 
      display.println(" PULTOSCOPE");
      display.setCursor(11,25);
      display.setTextColor(WHITE, BLACK); // 'inverted' text
      display.println(" GENERATOR ");
      display.setCursor(0,40);
      display.setTextColor(BLACK); 
      display.print("Battery= ");
      display.print(analogRead(BattPIN)*5.0/1024);
      display.println("V");  
    }
    display.setCursor(0,40);
    display.print("Battery= ");
    display.print(analogRead(BattPIN)*5.0/1024);
    display.println("V");
   
    display.drawLine(0,23,96,23, BLACK);   
    if(i<0)pultoskop=0;
    if(i>0)pultoskop=1;
    delay(100);  
    display.display(); 
    }  
    if(pultoskop==0)FreqCount.begin(1000);   
    if(pultoskop==1){
       InitTimersSafe(); 
       bool success = SetPinFrequencySafe(SignalPIN, frequency); 
    }
    delay(300); 
    }   
/********************* Draw Arrow Sincro *************************************************/
void Arrow(byte *level){/*deseneaza sageata pe ecran in functie de nivelul sincro*/
  char x=80;  //pozitia Hor pe ecran
  char y=47-*level/7;   //nivelul de sincro                               O
      display.fillCircle(x,y,1,BLACK);// cruce formata din 5 pixeli     O
      display.drawPixel(x+1,y+2,BLACK);//px(sus)                      O O O O
      display.drawPixel(x+2, y,BLACK);//px(mid)                         O
      display.drawPixel(x+1,y-2,BLACK);//px(jos)                          O
}
/************************** Time Base ****************************************************/      
void Sincro(){
  if (divizor>=6){ADCSRA = 0b11100010;}   //Prescaler 4
  if (divizor==5){ADCSRA = 0b11100011;}   //Prescaler 8
  if (divizor==4){ADCSRA = 0b11100100;}   //Prescaler 16
  if (divizor==3){ADCSRA = 0b11100101;}   //Prescaler 32
  if (divizor==2){ADCSRA = 0b11100110;}   //Prescaler 64
  if (divizor<2){ADCSRA = 0b11100111;}    //Prescaler 128
  if (divizor==0){
      for(byte i=0;i<255;i++){ 
          while ((ADCSRA & 0x10)==0);
          ADCSRA|=0x10;
          delayMicroseconds(500);
          mass[i]=ADCH;
      }
  }
  if (divizor>0){
      for(byte i=0;i<255;i++){ 
          while ((ADCSRA & 0x10)==0);
          ADCSRA|=0x10;
          mass[i]=ADCH;
      }
  }
}
/******************************************************************************************
******************************** MAIN LOOP PROGRAM ****************************************
******************************************************************************************/
void loop() {
  int i=enc_read();
  
  if(pultoskop==0){ /*Executa programul Pultoskop*/  
    if(RefvFlag==0){ADMUX = 0b11100000;} //Input ADC0, Vref=intern 1,1V, ADC Left Adjust Result
    if(RefvFlag==1){ADMUX = 0b01100000;} //Input ADC0, Vref=extern Vcc, ADC Left Adjust Result
    delay(5);
    if(paus==0)Sincro();
/*******Determinare synchronization point******************/
    bool flag_sincro=0;
    bool flag_sincro_null=0;
    for(int y=1;y<255;y++){
      if(flag_sincro==0){
        if(mass[y]<sinc_level)flag_sincro_null=1;
        if(flag_sincro_null==1){
          if(mass[y]>sinc_level)flag_sincro=1;sinhMASS=y;
        }
      }
    }

    Vmax=0; 
    for(int y=1;y<255;y++){ 
      if(Vmax<mass[y])Vmax=mass[y];        
    }
/************************ drawing graphic *********************************/
    display.clearDisplay();
    Arrow(sinc_level);  //deseneaza sageata pe ecran in functie de nivel sincro
    x=3;
        /*Traseaza oscilograma pe ecran*/
    for(int y=sinhMASS;y<sinhMASS+80;y++){
      if(divizor<7){x++;}
      if(divizor==7){x=x+2;}
      if(divizor==8){x=x+3;}
      display.drawLine(x, 47-mass[y]/7, x+1, 47-mass[y+1]/7-1, BLACK);
      display.drawLine(x+1, 47-mass[y]/7+1, x+2, 47-mass[y+1]/7-1, BLACK);        
    }
    sinhMASS=0;
/************** Deseneaza markeri pe partea stanga a ecranului ***********/
for(byte i=33;i>5;i=i-7){display.drawPixel(0,i, BLACK);display.drawPixel(1,i, BLACK);display.drawPixel(2,i, BLACK);}  
/********************* draw vertical grid ********************************/
for(byte i=47;i>5;i=i-3){display.drawPixel(21,i, BLACK);display.drawPixel(42,i, BLACK);display.drawPixel(63,i, BLACK);}
/******************** draw horizontal grid *******************************/
for(byte i=3;i<84;i=i+3){display.drawPixel(i,33, BLACK);display.drawPixel(i,19, BLACK);}

if(menu==0){  /**drawing menu****/
    display.setCursor(0,0);
    display.setTextColor(WHITE,BLACK);
    if(RefvFlag==0){display.print("1.1");}
    if(RefvFlag==1){display.print(VCC,1);}
    display.setTextColor(BLACK); 
    display.print(" ");
    display.print(divizor);
    display.print(" P");
    if(i<0){RefvFlag=0;}
    if(i>0){RefvFlag=1;}    
}
if(menu==1){
    display.setCursor(0,0);
    display.setTextColor( BLACK);
    if(RefvFlag==0){display.print("1.1");}
    if(RefvFlag==1){display.print(VCC,1);}
    display.setTextColor(WHITE, BLACK); // 'inverted' text 
    display.print(" ");display.print(divizor);
    display.setTextColor( BLACK); 
    display.print(" P");
    if(i<0){divizor=divizor-1;if(divizor==255){divizor=0;}}
    if(i>0){divizor=divizor+1;if(divizor==9){divizor=8;}}
}
if(menu==2){
    display.setCursor(0,0);
    display.setTextColor( BLACK);
    if(RefvFlag==0){display.print("1.1");}
    if(RefvFlag==1){display.print(VCC,1);}
    display.print(" ");
    display.print(divizor);
    display.setTextColor(WHITE, BLACK); // 'inverted' text 
    display.print(" P");
    paus=1;
    if(i<0){Sincro();}
    if(i>0){Sincro();}    
}
if(menu==3){
    paus=0;
    display.setCursor(0,0);
    display.setTextColor( BLACK);
    if(RefvFlag==0){display.print("1.1");}
    if(RefvFlag==1){display.print(VCC,1);}
    display.print(" ");
    display.print(divizor);
    display.setTextColor(BLACK);
    display.print(" P");
    if(i>0){sinc_level=sinc_level-20;if(sinc_level<20){sinc_level=20;}}
    if(i<0){sinc_level=sinc_level+20;if(sinc_level>230){sinc_level=230;}}     
    display.setTextColor(BLACK); 
    display.setCursor(73,44-sinc_level/7);
    display.println(">");
    /******************** draw horizontal grid *******************************/
    for(byte i=3;i<75;i=i+3){display.drawPixel(i,47-sinc_level/7, BLACK);}
}
    if(btnDown()){  //menu search
      menu++; //incrementeaza variabila menu
      while(btnDown());   //asteapta eliberarea butonului
      if(menu==4){menu=0;paus=0;}   //limita interval menu[0,4]
      }           
    if (FreqCount.available()) { contor = FreqCount.read();}       //frequency output when the contor is ready
    display.setCursor(48,0);
    display.setTextColor( BLACK);
    long contorX=contor*(ArduFreq/16.0);
    
    if(contorX<1000){display.print(" ");display.print(contorX,1);display.print("Hz");}
    if(contorX>1000 && contorX<10000){float contorXK=contorX/1000.0;display.print(contorXK,3);display.print("K");}
    if(contorX>10000 && contorX<100000){float contorXK=contorX/1000.0;display.print(contorXK,2);display.print("K");}
    if(contorX>100000 && contorX<1000000){float contorXK=contorX/1000.0;display.print(contorXK,1);display.print("K");}
    if(contorX>1000000){float contorXK=contorX/1000000.0;display.print(contorXK,1);display.print("MHz");}
    
    if(RefvFlag==1){display.setCursor(0,40);display.setTextColor(BLACK);
    display.print(Vmax*VCC/255,1);}
    if(RefvFlag==0){display.setCursor(0,40);display.setTextColor(BLACK);
    display.print(Vmax*1.1/255,1);}
    display.print("V");
    /********************** Drawing Menu********************************/
    delay(50);  
    display.display();
    }
    if(pultoskop==1)Generator();    /*Executa programul generator*/
}
