/*
 * si5351example.ino - Simple example of using Si5351Arduino library
 *
 * Copyright (C) 2015 Jason Milldrum <milldrum@gmail.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
 

#include "si5351.h"
#include "Wire.h"

Si5351 si5351;

void setup()
{
  // Start serial and initialize the Si5351
  Serial.begin(57600);
  si5351.init(SI5351_CRYSTAL_LOAD_8PF, 27000000); // Crystal = 27MHz
  
  si5351.set_correction(0); // Frequency Correction - value found by "si5351calibration" sketch at 10MHz

  // Set CLK0 to output 14 MHz with a fixed PLL frequency
  si5351.set_pll(SI5351_PLL_FIXED, SI5351_PLLA);
  si5351.set_freq(1400000000ULL, SI5351_PLL_FIXED, SI5351_CLK0);

  // Set CLK1 to output 20 MHz
  si5351.set_freq(2000000000ULL, 0ULL, SI5351_CLK1);
  
  // Set CLK2 to output 30 MHz (Delete // to enable)
  //si5351.set_freq(3000000000ULL, 0ULL, SI5351_CLK2); 
  
  si5351.drive_strength(SI5351_CLK0, SI5351_DRIVE_4MA); //SET Output_0 Current Drive (2mA=3dBm; 8mA=10dBm)
  
  si5351.drive_strength(SI5351_CLK1, SI5351_DRIVE_4MA); //SET Output_1 Current Drive (2mA=3dBm; 8mA=10dBm)
  
  // si5351.drive_strength(SI5351_CLK2, SI5351_DRIVE_4MA); //SET Output_2 Current Drive (2mA=3dBm; 8mA=10dBm)(Delete // to enable)


 // Available values: 2, 4, 6 or 8mA

}

void loop()
{
  while(1){ }; // sit and wait
}
