;
;     ESR  
;	  C/ESR meter
;     
;    1.01
;  	 20/04/2007
;
;        FLC
;   , ., 
;
;     
;    1.17
;  	 18/10/2019

;      PIC16F873A
;***************************************************************************************
;* *        *   
;***************************************************************************************

; 1   *	 MCLR/Vpp     *	 
; 2   *	 RA0/AN0       *    (=330)
; 3   *	 RA1/AN1       *    (=33)
; 4   *	 RA2/AN2/Vref-	   *  . Set coeff./Set "0"
; 5   *	 RA3/AN3/Vref+	   *   
; 6   *	 RA4/T0CKI     *  .+/Test
; 7   *	 RA5/AN4/SS	*  .-
; 8   *	 Vss	   * GND
; 9   *	 OSC1/CLKIN	*  20 
; 10   *  OSC2/CLKOUT	  *  20 
; 11   *  RC0/T1OSO/T1CKI  *  , I=10mA
; 12   *  RC1/T1OSI/CCP2   *  
; 13   *  RC2/CCP1     *     
; 14   *  RC3/SCK/SCL	  * ."-"  

; 15   *  RC4/SDI/SDA	  * ."+"  
; 16   *  RC5/SDO	* ."-"  
; 17   *  RC6/TX/CK	*     
; 18   *  RC7/RX/DT	*
; 19   *  Vss	    * +5V
; 20   *  Vdd	    * GND
; 21   *  RB0/INT	* LCD_D4
; 22   *  RB1	    * LCD_D5
; 23   *  RB2	    * LCD_D6
; 24   *  RB3/PGM	* LCD_D7
; 25   *  RB4	    * LCD_R/S
; 26   *  RB5	    * LCD_E
; 27   *  RB6/PGC	*
; 28   *  RB7/PGD	*

;****************************************************************************************
Port_A_Config	equ b'11111111'
Port_B_Config	equ b'11000000'
Port_C_Config	equ b'11000100'

; Port A bit equates
Kn_Set		equ  2
Kn_Plus		equ  4
Kn_Minus	equ  5
KEY_FAST	equ .3 ;        , 

;  Flags
TIMEOUT		equ 0 ;       
INSIGZERO	equ 1 ; 
POINT		equ 2 ; 
DISCHARGE	equ 3 ; .   
CHECK10OM	equ 4 ;10 
SAVECONST	equ 5 ;  

;  Flag_Key
STARTSETKEY	equ 0 ;  SET    


_BAT_MAX	equ 3
_BAT_1		equ 4
_BAT_2		equ 5
_BAT_3		equ 6
_BAT_MIN	equ 7


; Port C bit equates
Cap_Charge	equ 0
Cap_Discharge	equ 1
Comp_Up		equ 2
In_N_Gnd	equ 3
In_P_Cx		equ 4
In_N_Cx		equ 5
Comp_Low	equ 6

ESR_ready	equ b'00110011'	;. , "+"  "-"   
ESR_start	equ b'00110000'	;. , "+"  "-"   
Cap_ready	equ b'00011011'	;. , "-"   , "+"  
Cap_start	equ b'00011000'	;. , "-"   , "+"  
Cap_start2	equ b'00110000'	;. , "-"   Cx, "+"  

Max_Count	equ .50 ;  (1 ,   256)  TMR0  
			 ;  - 0.2 , 65536*0.2=13107.2  -  
			 ;  I=10mA 15 / 65536/15=4369  -  
			 ;  =150000, 150000/4369=34
			 ;        


;****************************************************************************************


	list	p=PIC16F873a
	#include P16F873a.inc	;  ; 20.000 MHz
	__CONFIG _CP_OFF & _BODEN_OFF & _HS_OSC & _WRT_OFF & _WDT_OFF & _PWRTE_ON & _DEBUG_OFF & _CPD_OFF & _LVP_OFF

;  #define  _BAT  PORTA,1    ; 0- low bat

	#define		_RS	PORTB,4
	#define		_E	PORTB,5


	cblock	0x35	;0x20-0x34 for FLOATING POINT LIBRARY
  U330_L		;   , =330,  
  U330_H		;   , =330,  
  U33_L			;   , =33,  
  U33_H			;   , =33,  
  TMR1_Count		;  TMR1
  TMR0_Count		;  TMR0
  Max_ADC_Count		;  >=0x300    ESR
  Key_Press_Time	;    
  Bat_sign		;     
  Flags
  Flag_Key		; 
 			;0x40

  ;  


  Dly0			;Stores 3 bytes of data for the delay count
  Dly1			;Dly0 is the least significant byte
  Dly2			;while Dly3 is the most significant byte

  Temp
  Temp1
  Temp2
  Temp3
  Temp4

  Count1
  Count2

  T0
  T1

  ;   
  T2			;  
  T3
  T4
  T5			;  

  AX			;  
  A0
  A1
  A2			;  

  A3
  A4
  A5

  BCD0			;  
  BCD1
  BCD2
  BCD3
  BCD4			;  

  EE_ADR		;     EEPROM
  EE_DATA
  NZ			;      
  NC			; 
  Const_ADR		;   EEPROM

  Index_Buf_Cx		;        Buf_Cx
  Buf_Cx_1 :3		;  
  Buf_Cx_2 :3
  Buf_Cx_3 :3
  
	endc
	
;  Cx 
BUF_Cx_COUNT_MAX equ 3 ;    Buf_Cx
BUF_CX_END	equ Buf_Cx_1+(BUF_Cx_COUNT_MAX*3)


;  ESR   
FILTER_CYCLE_MAX equ 4		;    (  2) 
Filter_cycle	equ Temp1

BUF_COUNT_MAX	equ 5		;      
Buf_Count	equ Temp2

BUF_START_U330	equ 0x20
BUF_START_U33	equ 0x2A
MEDIAN_U330	equ BUF_START_U330+BUF_COUNT_MAX
MEDIAN_U33	equ BUF_START_U33+BUF_COUNT_MAX




  ;      (    0x70...0x7F)
	cblock	0x7F-3
  W_TEMP		;   
  STATUS_TEMP
  PCLATH_TEMP
	endc
;=========================
;    
;=========================
bank0	macro
	bcf	STATUS, RP0
	endm

;----------------------------------------------------------------
bank1	macro
	bsf	STATUS, RP0
	endm

;----------------------------------------------------------------
Dly24	MACRO	DLY
;Take the delay value argument from the macro, precalculate
;the required 3 RAM values and load the The RAM values Dly2,Dly1
;and Dly0.
	banksel Dly0
	movlw  DLY & H'FF'
	movwf  Dly0
	movlw  DLY >>D'08' & H'FF'
	movwf  Dly1
	movlw  DLY >>D'16' & H'FF'
	movwf  Dly2
;Bytes are shifted and anded by the assembler to make user
;calculations easier.
	endm

;==========================

	ORG	0x2100		;  EEPROM
;        ; 	 EEPROM

;   :
USR_1		DE 0x00, 0x00, 0x03, 0xE8 ; 1.000 -  1 
USR_10		DE 0x00, 0x00, 0x03, 0xE8 ; 1.000 -  10 
USR_Cx		DE 0x00, 0x00, 0x03, 0xE8 ; 1.000 -  
USR_1_Cx	DE 0x00, 0x00, 0x03, 0xE8 ; 1.000 -   1 

;K_ESR_1  DE  0x7F, 0x00, 0x00, 0x00 ; 1 -  1 
;K_ESR_10  DE  0x7F, 0x00, 0x00, 0x00 ; 1 -  10 
;K_Cx	 DE  0x7F, 0x00, 0x00, 0x00 ; 1 -  

;numbers in FLOATING POINT LIBRARY format
U0_ESR_1	DE 0x81, 0x40, 0x00, 0x00 ; 75=85160000 - "0"   1 
U0_ESR_10	DE 0x7F, 0x00, 0x00, 0x00 ;  7=81600000 - "0"   10 

;   :
M_ESR_1		DE 0x75, 0x40, 0x30, 0x0C ; 1/682=7540300C
M_ESR_10	DE 0x78, 0x74, 0x89, 0x8D ; 1/67=7874898D       (  Microchip 24-bit)
M_Cx		DE 0x74, 0x2E, 0xC3, 0x3E ; 1/(15*100)=742EC33E (  Microchip 24-bit)
					  ;  , , 10000 

; sub_Cx	DE 0x80, 0x40, 0x00, 0x00 ; 3=80400000 -    TMR1 (  Microchip 24-bit)
add_Cx		DE 0x88, 0x7A, 0x00, 0x00 ; 1.000    1 

;==========================
	org	0x700		;  256  1-   
Table	addwf	PCL,F
omega	dt	b'00000000'	; 
	dt	b'00001110'
	dt	b'00010001'
	dt	b'00010001'
	dt	b'00010001'
	dt	b'00001010'
	dt	b'00011011'
	dt	b'00000000'

mu	dt	b'00000000'
	dt	b'00000000'
	dt	b'00010010'
	dt	b'00010010'
	dt	b'00010010'
	dt	b'00011110'
	dt	b'00010001'
	dt	b'00010000'

bat_max dt	b'00000000'	; . .
	dt	b'00001110'
	dt	b'00011111'
	dt	b'00011111'
	dt	b'00011111'
	dt	b'00011111'
	dt	b'00011111'
	dt	b'00000000'

bat_1	dt	b'00000000'	; .
	dt	b'00001110'
	dt	b'00010001'
	dt	b'00011111'
	dt	b'00011111'
	dt	b'00011111'
	dt	b'00011111'
	dt	b'00000000'

bat_2	dt	b'00000000'	; .
	dt	b'00001110'
	dt	b'00010001'
	dt	b'00010001'
	dt	b'00011111'
	dt	b'00011111'
	dt	b'00011111'
	dt	b'00000000'

bat_3	dt	b'00000000'	; .
	dt	b'00001110'
	dt	b'00010001'
	dt	b'00010001'
	dt	b'00010001'
	dt	b'00011111'
	dt	b'00011111'
	dt	b'00000000'

bat_min dt	b'00000000'	; .
	dt	b'00001110'
	dt	b'00010001'
	dt	b'00010001'
	dt	b'00010001'
	dt	b'00010001'
	dt	b'00011111'
	dt	b'00000000'

_Const		dt "Coeff. for",0
_ESR		dt "ESR",0
_Cx		dt " Cx ",0
_Time_out	dt " Cx ---",0
_1_ohm		dt " 1 ",1,0
_10_ohm		dt " 10 ",1,0
_tst_1		dt "1",1,"=",0
_tst_10		dt " 10",1,"=",0
_write_U0	dt "U0 ---> EEPROM	 ",0
;_ready		dt "It is ready!",0
_save_const	dt "Save Constant",0
_1_Cx		dt " C min",0

;*******************************************************************************
;     
;*******************************************************************************
	org	0x00
	nop			;for MPLAB-ICD2
	goto	init
;------------------ Interrupt ------------------
	org	0x004

	movwf	W_TEMP		;save W
	swapf	STATUS,W	;swap STATUS, W
	clrf	STATUS
	movwf	STATUS_TEMP	;save status
	movf	PCLATH,W
	movwf	PCLATH_TEMP	;save PCLFTH
	bank0
TMR0_INT
	btfss	INTCON,T0IF
	goto	TMR1_INT
	bcf	INTCON,T0IF	;clear interrupt flag
	decfsz	TMR0_Count
	goto	restore_context
	goto	Time_out
TMR1_INT
	btfss	PIR1,TMR1IF
	goto	restore_context
	bcf	PIR1, TMR1IF	;   
	incfsz	TMR1_Count,F
	goto	restore_context
Time_out
	bcf	T1CON, TMR1ON	; TMR1
	bcf	INTCON,GIE	; 
	bsf	Flags,TIMEOUT	;Time out        
	clrf	TMR1_Count
restore_context
	movf	PCLATH_TEMP,W
	movwf	PCLATH
	swapf	STATUS_TEMP,W	;fetch status, reswap nibbles
	movwf	STATUS		;restore status
	swapf	W_TEMP,F	;swap nibbles in preparation
	swapf	W_TEMP,W	;for the swap restoration of w
	retfie			;return from interrupt
;-----------------------------------------------
init
	bank0
	clrf	Flags
	clrf	Flag_Key
	clrf	INTCON
	clrf	PCLATH
	clrf	PORTA
	clrf	PORTB
	movlw	ESR_ready	;. , "+"  "-"   
	movwf	PORTC

	bank1
	movlw	Port_A_Config
	movwf	TRISA

  ; 
	movlw	b'10000100'	; , Vdd, Vss, AN0, AN1, AN3
	movwf	ADCON1

	movlw	Port_B_Config
	movwf	TRISB
	movlw	Port_C_Config
	movwf	TRISC

;   LCD  4-  
InitLCD
	call	Delay_5_ms
	call	Delay_5_ms
	call	Delay_5_ms	; 15    
	bank0
	movlw  3
	movwf	Count1
	movwf	PORTB
SetLoop
	bsf	_E		;  LCD 3    0x30
	nop
	nop
	nop
	bcf	_E
	call	Delay_5_ms
	decfsz	Count1,f
	goto	SetLoop

	movlw	2		; 4-x 
	movwf	PORTB
	call	Send
	movlw	28		; 4- , 2 , 57
	call	CmdLCD
	movlw	0C		;  
	call	CmdLCD
	movlw	6
	call	CmdLCD
	call	Load_ZG		;     
	call	ClrDSP		;  
;--------------------------------------------------
	clrf	Key_Press_Time
	btfsc	PORTA, Kn_Set	; SET    ?
	goto	Main
;------------    ------------
	movlw	3
	movwf	NC
Const_Loop

C_Kn_Set
	btfsc	PORTA, Kn_Set
	goto	C_Kn_Set_open	;   SET
	btfsc	Flag_Key,STARTSETKEY
	goto	C_Kn_Set
  ;    SET
	bsf	Flag_Key,STARTSETKEY
	btfsc	Flags,SAVECONST	;  
	goto	C_Kn_Set_save	; ,  
  ;  
	; incf	NC,w
	; xorlw	b'00000011'
	; btfss	STATUS,Z
	; xorlw	b'00000011'	; 3 
	; movwf	NC

	incf	NC,f
	btfsc	NC,2
	bcf	NC,2		; 4 
	goto	c_1
C_Kn_Set_save
	call	Save_Const	; ,  
	call	ClrDSP
	movlw	LOW _save_const	 ;  
	call	Read_String
	call	Delay_1_sec
	goto	c_1
C_Kn_Set_open
	bcf	Flag_Key,STARTSETKEY

C_Kn_Plus
	movlw	KEY_FAST*2
	movwf	Key_Press_Time	;    
C_Kn_Plus_L1
	btfsc	PORTA, Kn_Plus
	goto	C_Kn_Minus
	call	IncB
	goto	C_Kn_Plus_L1

C_Kn_Minus
	movlw	KEY_FAST*2
	movwf	Key_Press_Time	;    
C_Kn_Minus_L1
	btfsc	PORTA, Kn_Minus
	goto	Const_Loop
	call	DecB
	goto	C_Kn_Minus_L1
	goto	Const_Loop
;-------------------------------------------------------
c_1
	bcf	Flags,SAVECONST	 ;   
	call	ClrDSP		;  
	movlw	LOW _Const
	call	Read_String
	movlw	HIGH $
	movwf	PCLATH
	movf	NC,W
	addwf	PCL,F		; 
	goto	const_1_ohm	;+0
	goto	const_10_ohm	;+1
	goto	const_Cx	;+2
	goto	const_1_Cx	;+3
c_2
	call	ShowX
	goto	Const_Loop
;-------------------------------------------------------
const_1_ohm
	movlw	LOW USR_1
	movwf	Const_ADR
	call	EEPROM_To_B
	movlw	LOW _1_ohm
	call	Read_String
	goto	c_2
;-------------------------------------------------------
const_10_ohm
	movlw	LOW USR_10
	movwf	Const_ADR
	call	EEPROM_To_B
	movlw	LOW _10_ohm
	call	Read_String
	goto	c_2
;-------------------------------------------------------
const_1_Cx
	movlw	LOW USR_1_Cx
	movwf	Const_ADR
	call	EEPROM_To_B
	movlw	LOW _1_Cx
	call	Read_String
	goto	c_2
;-------------------------------------------------------
const_Cx
	movlw	LOW USR_Cx
	movwf	Const_ADR
	call	EEPROM_To_B
	movlw	LOW _Cx
	call	Read_String
	goto	c_2

;===========================================================
Main
	call	TMR1_init
	call	TMR0_init	; TMR0      

	call	Cx_clear	;  Cx
	
;------------
ESR_measure
	clrf	U330_H
	clrf	U330_L
	clrf	U33_H
	clrf	U33_L
	clrf	Max_ADC_Count
	movlw	FILTER_CYCLE_MAX
	movwf	Filter_cycle
	
	btfsc	PORTA, Kn_Plus
	goto	ADC_Start
	
	;   ''
	; ESR  ,   
	movlw	ESR_start	;. , "+"  "-"   
	movwf	PORTC

	movlw	0x4		; 3.6 (18 )   . - !!!
	call	Delay_go

	bcf	PORTC, In_P_Cx	;   
	nop			;???
	bsf	PORTC, Cap_Charge ;. I.
	
	call	ADC_U330
	movf	ADRESH,w
	movwf	U330_H
	bank1
	movf	ADRESL,W
	bank0
	movwf	U330_L	
	
	call	ADC_U33	
	movlw	Cap_ready	;. , "-"   , "+"  
	movwf	PORTC
	movf	ADRESH,w
	movwf	U33_H
	bank1
	movf	ADRESL,W
	bank0
	movwf	U33_L
	
	goto	ADC_L3
	
ADC_Start	
	movlw	BUF_COUNT_MAX
	movwf	Buf_Count
	
	;  U330  U33
	movlw	.20	
	movwf	Temp
	movlw	BUF_START_U330+.20	
	movwf	FSR
ADC_clear	
	decf	FSR,f
	clrf	INDF
	decfsz	Temp,f
	goto	ADC_clear
	
;------------  ESR ------------
ADC_L1
	movlw	ESR_start	;. , "+"  "-"   
	movwf	PORTC

	movlw	0x4		; 3.6 (18 )   . - !!!
	call	Delay_go

	bcf	PORTC, In_P_Cx	;   
	nop			;???
	bsf	PORTC, Cap_Charge ;. I.

;------------
	;   
	call	ADC_U330
	;     
	movlw	BUF_START_U330
	movwf	FSR
	movf	ADRESH,w
	movwf	INDF
	incf	FSR,f
	bank1
	movf	ADRESL,W
	bank0
	movwf	INDF

	call	ADC_U33	
	movlw	Cap_ready	;. , "-"   , "+"  
	movwf	PORTC
	;     
	movlw	BUF_START_U33
	movwf	FSR
	movf	ADRESH,w
	movwf	INDF
	incf	FSR,f
	bank1
	movf	ADRESL,W
	bank0
	movwf	INDF

	;  U330
	movlw	BUF_START_U330
	call	Buf_Sorting

	;  U33
	movlw	BUF_START_U33
	call	Buf_Sorting

	call	Delay_200_us
	call	Delay_200_us

	;        U330  U33
	decfsz	Buf_Count,f
	goto	ADC_L1


	;   U330  
	movlw	LOW MEDIAN_U330
	movwf	FSR
	movf	INDF,w	;INDF(LOW MEDIAN_U330)
	decf	FSR,f
	addwf	U330_L,f
	movf	INDF,w	;INDF(HIGH MEDIAN_U330)
	btfsc	STATUS,C
	incfsz	INDF,w	;INDF(HIGH MEDIAN_U330)
	addwf	U330_H,f
	

	;   U33  
	movlw	LOW MEDIAN_U33
	movwf	FSR
	movf	INDF,w	;INDF(LOW MEDIAN_U33)
	decf	FSR,f
	addwf	U33_L,f
	movf	INDF,w	;INDF(HIGH MEDIAN_U33)
	btfsc	STATUS,C
	incfsz	INDF,w	;INDF(HIGH MEDIAN_U33)
	addwf	U33_H,f

	decfsz	Filter_cycle,f
	goto	ADC_Start

;------------
	;   U330   
	bcf	STATUS,C
	movlw	b'11110000'
	andwf	U330_L,f
	rrf	U330_H,f	;  2
	rrf	U330_L,f
	rrf	U330_H,f	;  4
	rrf	U330_L,f
	btfss	STATUS,C
	goto	ADC_L2
	incf	U330_H,f	;, +1  U330
	incfsz	U330_L,f
	decf	U330_H,f
ADC_L2
	;   U33   
	bcf	STATUS,C
	movlw	b'11110000'
	andwf	U33_L,f
	rrf	U33_H,f		;  2
	rrf	U33_L,f
	rrf	U33_H,f		;  4
	rrf	U33_L,f
	btfss	STATUS,C
	goto	ADC_L3
	incf	U33_H,f		;, +1  U33
	incfsz	U33_L,f
	decf	U33_H,f
ADC_L3

;------------  ESR>10 ,     ------------
	clrf	Flags
	movlw	0x03
	subwf	U33_H,W		;  >=0x300 (768)
	btfss	STATUS,C
	goto	Cx_0		;   
	bsf	Flags,TIMEOUT	;  Time Out
	goto	Cx_3
;------------    ------------
Cx_0
	movlw	Cap_ready	;. , "-"   , "+"  
	movwf	PORTC


  ;    
	clrf	TMR0
	movlw	Max_Count
	movwf	TMR0_Count	;    TMR0
	clrf	TMR1L
	clrf	TMR1H
	clrf	TMR1_Count
	bsf	INTCON,GIE	; 

Cx_0_wite
	btfsc	Flags,TIMEOUT	;  Time Out
	goto	Cx_3
	btfss	PORTC, Comp_Low	 ; 1 - Cx 
	goto	Cx_0_wite	;  200 
	call	Delay_200_us	;   
	call	Delay_200_us

	movlw	0x03
	subwf	U330_H,W	;  >=0x300 (768)
	btfss	STATUS,C	;.. ESR>1 ,     ESR
	goto	Cx_1

	movlw	Cap_start2	;. , "-"   Cx, "+"  
	movwf	PORTC
	movlw	0x4		; 3.6 (18 )     "-"  
	call	Delay_go
	bcf	PORTC,In_N_Cx	; "-"    
	goto	Cx_2
Cx_1
	movlw	Cap_start	;. , "-"   , "+"  
	movwf	PORTC
Cx_2
	btfsc	Flags,TIMEOUT	;  Time Out
	goto	Cx_3
	btfsc	PORTC, Comp_Low ; 0 - Cx    
	goto	Cx_2
	bsf	T1CON, TMR1ON	;   TMR1
Cx_4
	btfss	PORTC,Comp_Up	; 0 - Cx    
	bcf	T1CON, TMR1ON	; TMR1
	btfss	PORTC,Comp_Up	; 0 - Cx    
	bcf	T1CON, TMR1ON	; TMR1
	btfss	PORTC,Comp_Up	; 0 - Cx    
	bcf	T1CON, TMR1ON	; TMR1
	btfss	PORTC,Comp_Up	; 0 - Cx    
	bcf	T1CON, TMR1ON	; TMR1
	btfss	PORTC,Comp_Up	; 0 - Cx    
	bcf	T1CON, TMR1ON	; TMR1

	btfsc	Flags,TIMEOUT	;  Time Out
	goto	Cx_3
	btfsc	PORTC,Comp_Up	; 0 - Cx    
	goto	Cx_4
	bcf	T1CON, TMR1ON	; TMR1
;--------------------------------------------------------
Cx_3
	bcf	INTCON,GIE	; 
	movlw	Cap_ready	;. , "-"   , "+"  
	movwf	PORTC
	
;--------------------------------------------------------
;   
;  call	 CursorHome
	call	ClrDSP		;  

;Timeout
	btfss	Flags,TIMEOUT
	goto	Disp_Cx
	movlw	LOW _Time_out
	call	Read_String
	call	Cx_clear	;  Cx
	goto	Disp_ESR
	
;--------------------------------------------------------
Disp_Cx
	
	;       Cx,    
	movf	Index_Buf_Cx,w
	movwf	FSR
	movf	TMR1_Count,w
	movwf	INDF
	incf	FSR,f
	movf	TMR1H,w
	movwf	INDF
	incf	FSR,f
	movf	TMR1L,w
	movwf	INDF
	
	;     
	movlw	.3	;   
	addwf	Index_Buf_Cx,f
	movlw	BUF_CX_END
	subwf	Index_Buf_Cx,w
	movlw	Buf_Cx_1	
	btfsc	STATUS,C
	movwf	Index_Buf_Cx	;    ( )
	
	;      TMR1_Count, TMR1H, TMR1L
	call	Buf_Sorting_Cx

;------------
	movlw	LOW _Cx
	call	Read_String

	movlw	LOW USR_1_Cx
	call	EEPROM_To_A
	call	FLO2424		;Integer to float conversion	
	movlw	LOW add_Cx
	call	EEPROM_To_B	
	call	FPS24		;A=A-B
	call	BEQUA		;B=A

	clrf	AEXP
	movf	TMR1_Count,W
	movwf	AARGB0
	movf	TMR1H,W
	movwf	AARGB1
	movf	TMR1L,W
	movwf	AARGB2

	btfsc	PORTA, Kn_Plus
	goto	Calc_Cx

	call	BCD		;   ,   
	movlw	BCD4		;  
	call	Disp_Full
	goto	Disp_ESR
Calc_Cx
	call	FLO2424		;Integer to float conversion

	; movlw	low sub_Cx
	; call	EEPROM_To_B
	; call	FPS24		;A=A-3

	call	FPA24		;A=A+B
	
	
	movlw	low M_Cx
	call	EEPROM_To_B
	call	FPM24		;A=A*M_Cx

	movlw	low USR_Cx
	call	X_To_B
	

	;
	movlw	0x7E
	movwf	BEXP
	movlw	0x00
	movwf	BARGB0
	movlw	0x00
	movwf	BARGB1		;B=0.5
	bcf	FPFLAGS,RND
	call	FPA24		;A=A+0.5 (Round)
	call	INT2424		;Float  INT c     

	clrf	AEXP
	call	BCD
	bsf	Flags,INSIGZERO	 ;   
	movlw	3
	movwf	NZ		;  ,   0
	bsf	Flags,DISCHARGE	 ;  .   

	movlw	BCD3
	call	DispBCD
	movlw	BCD3		;   10 ,
	call	DispBCD		;   

	movlw	BCD2		;  
	call	DispBCD
	movlw	BCD2		; 
	call	DispBCD

  ;     ,   
	btfsc	Flags,INSIGZERO
	goto	next_1
	movlw	" "		; 
	call	CharLCD
next_1
	movlw	BCD1		; 
	call	DispBCD
	btfsc	Flags,INSIGZERO	 ;    ,
	bsf	Flags,POINT	;    
	movlw	BCD1		; 
	call	DispBCD

	bcf	Flags,INSIGZERO	 ;  =0  ,   
	movlw	BCD0		; 
	call	DispBCD

	btfss	Flags,POINT	;    
	goto	next_2		;
	bcf	Flags,POINT	;
	call	DispDot		; 
	movlw	BCD0		; 
	call	DispBCD
next_2
	call	DispSP
	movlw	2		; 
	call	CharLCD
	movlw	"F"
	call	CharLCD

;----------------------------

Disp_ESR
	btfss	PORTA, Kn_Plus
	goto	tst_ESR

	bcf	Flags,CHECK10OM	 ;   10 
	movlw	0x03
	subwf	U330_H,W	;  >=0x300 (768)
	btfsc	STATUS,C	;   (10 )
	goto	chk_10

;  1 
	call	ClrA
	movf	U330_H,W	; =330,  1 
	movwf	AARGB0
	movf	U330_L,W
	movwf	AARGB1
	call	FLO1624		;to 24 bit floating point

	movlw	low U0_ESR_1
	call	EEPROM_To_B
	call	FPS24		;A=A-U0 -   

	movlw	low M_ESR_1
	call	EEPROM_To_B
	call	FPM24		;A=A*M_ESR_1

	movlw	low USR_1
	call	X_To_B
	goto	ESR_to_LCD

chk_10
	movlw	0x03
	subwf	U33_H,W		;  >=0x300 (768)
	btfsc	STATUS,C
	bsf	Flags,CHECK10OM	 ; 10 

; 10 
	call	ClrA
	movf	U33_H,W		; =33,  10 
	movwf	AARGB0
	movf	U33_L,W
	movwf	AARGB1
	call	FLO1624		;to 24 bit floating point
	movlw	low U0_ESR_10
	call	EEPROM_To_B
	call	FPS24		;A=A-U0 -   
	movlw	low M_ESR_10
	call	EEPROM_To_B
	call	FPM24		;A=A*M_ESR_10
	movlw	low USR_10
	call	X_To_B

ESR_to_LCD
	call	SecLine
	movlw	LOW _ESR
	call	Read_String

	btfss	Flags,CHECK10OM	 ;>10 ohm?
	goto	next_3
	movlw	">"
	call	CharLCD
	goto	next_4
next_3
	call	DispSP

next_4
	movlw	0x80
	andwf	AARGB0,W	;  "-"
	btfsc	STATUS,Z
	goto	next_5		; > 0
	call	ClrA		; < 0,   
	goto	next_6
next_5
	;
	movlw	0x7E
	movwf	BEXP
	movlw	0x00
	movwf	BARGB0
	movlw	0x00
	movwf	BARGB1		;B=0.5
	bcf	FPFLAGS,RND
	call	FPA24		;A=A+0.5 (Round)
	call	INT2424		;Float  INT c     
				;  AARG
next_6
	bcf	Flags,DISCHARGE	 ;  .   
	bsf	Flags,INSIGZERO	 ;   
	clrf	AEXP
	call	BCD

	movlw	BCD2
	call	DispBCD
	movlw	BCD2
	call	DispBCD		; 

	bcf	Flags,INSIGZERO	 ;  =0  ,   
	movlw	BCD1		; 
	call	DispBCD
	call	DispDot
	movlw	BCD1
	call	DispBCD

	movlw	BCD0
	call	DispBCD
	movlw	BCD0
	call	DispBCD

	call	DispSP
	movlw	1		; 
	call	CharLCD

end_disp
	bsf	PORTC,Cap_Discharge ;.  

	btfsc	PORTA, Kn_Plus
	call	DispUbat	;   

	call	Delay_05_sec

	bcf	PORTC, Cap_Discharge ;.  

	goto	ESR_measure

;  -    
; 2-  (1  10 )
tst_ESR
	call	SecLine

  ; 1 
	movlw	LOW _tst_1
	call	Read_String
	call	ClrA
	movf	U330_H,W	; =330,  1 
	movwf	AARGB1
	movf	U330_L,W
	movwf	AARGB2
	call	BCD
	movlw	BCD1
	call	Disp_Full

  ; 10 
	movlw	LOW _tst_10
	call	Read_String
	call	ClrA
	movf	U33_H,W		; =33,  10 
	movwf	AARGB1
	movf	U33_L,W
	movwf	AARGB2
	call	BCD
	movlw	BCD1
	call	Disp_Full
	btfsc	PORTA, Kn_Set	;   
	goto	tst_Kn_Set_open

	btfsc	Flag_Key,STARTSETKEY
	goto	end_disp	;   SET
  ;    SET
	bsf	Flag_Key,STARTSETKEY
	goto	tst_save
tst_Kn_Set_open
	bcf	Flag_Key,STARTSETKEY
	goto	end_disp
tst_save
  ; U0  EEPROM ------------------------
	call	CursorHome
	movlw	LOW _write_U0
	call	Read_String

  ;U0  l 
	call	ClrA
	movf	U330_H,W	; =330,  1 
	movwf	AARGB0
	movf	U330_L,W
	movwf	AARGB1
	call	FLO1624		;to 24 bit floating point
	call	BEQUA
	movlw	LOW U0_ESR_1
	movwf	Const_ADR
	call	Save_Const

  ;U0  l0 
	call	ClrA
	movf	U33_H,W		; =33,  10 
	movwf	AARGB0
	movf	U33_L,W
	movwf	AARGB1
	call	FLO1624		;to 24 bit floating point
	call	BEQUA
	movlw	LOW U0_ESR_10
	movwf	Const_ADR
	call	Save_Const

	call	Delay_1_sec
	call	ClrDSP
	movlw	LOW _save_const	 ;  _ready
	call	Read_String
	call	Delay_1_sec
	goto	end_disp
	
;------------------------- Buffer Sorting Cx -------------------------
; ,   
;:   TMR1_Count, TMR1H, TMR1L
Buf_Sorting_Cx	
	; 1  2 
	call	Buf_Cx_Comp_1_2
	btfsc	STATUS,Z
	goto	Buf_Sort_Median_2 ;1=2
	btfsc	STATUS,C
	goto	Buf_Sort_L1 ;1<2	
	;1>2
	; 1  3 
	call	Buf_Cx_Comp_1_3
	btfss	STATUS,Z
	btfsc	STATUS,C
	goto	Buf_Sort_Median_1 ;1<3, 1=3
	;1>3
	; 2  3 
	call	Buf_Cx_Comp_2_3
	btfss	STATUS,Z
	btfsc	STATUS,C
	goto	Buf_Sort_Median_3 ;2<3		
	goto	Buf_Sort_Median_2 ;2>3
Buf_Sort_L1	;1<2
	; 2  3 
	call	Buf_Cx_Comp_2_3
	btfss	STATUS,Z
	btfsc	STATUS,C
	goto	Buf_Sort_Median_2 ;2<3, 2=3
	goto	Buf_Sort_Median_3 ;2>3
	
Buf_Sort_Median_1	
	;1 - 
	movlw	Buf_Cx_1
	movwf	FSR
	goto	Buf_Sort_Copy
	
Buf_Sort_Median_2
	;2 - 
	movlw	Buf_Cx_2
	movwf	FSR
	goto	Buf_Sort_Copy
	
Buf_Sort_Median_3
	;3 - 
	movlw	Buf_Cx_3
	movwf	FSR
	goto	Buf_Sort_Copy
	
Buf_Sort_Copy	
	movf	INDF,w
	movwf	TMR1_Count
	incf	FSR,f
	movf	INDF,w
	movwf	TMR1H
	incf	FSR,f
	movf	INDF,w
	movwf	TMR1L	
	return
	
;-------------------------
Buf_Cx_Comp_1_2
	movlw	Buf_Cx_1
	movwf	FSR
	call	Buf_Cx_Temp
	movlw	Buf_Cx_2
	movwf	FSR
	goto	Buf_Cx_Compare
	
Buf_Cx_Comp_1_3
	movlw	Buf_Cx_1
	movwf	FSR
	call	Buf_Cx_Temp
	movlw	Buf_Cx_3
	movwf	FSR
	goto	Buf_Cx_Compare	
	
Buf_Cx_Comp_2_3
	movlw	Buf_Cx_2
	movwf	FSR
	call	Buf_Cx_Temp
	movlw	Buf_Cx_3
	movwf	FSR
	goto	Buf_Cx_Compare
	
;-------------------------
Buf_Cx_Temp	
	movf	INDF,w
	movwf	Temp+0
	incf	FSR,f	
	movf	INDF,w
	movwf	Temp+1
	incf	FSR,f	
	movf	INDF,w
	movwf	Temp+2
	return

;-------------------------
Buf_Cx_Compare
	;  
	movf	Temp+0,w	
	subwf	INDF,w       
	btfss	STATUS,Z
	return       

	;  
	incf	FSR,f	
	movf	Temp+1,w	
	subwf	INDF,w        
	btfss	STATUS,Z
	return       

	;  
	incf	FSR,f	
	movf	Temp+2,w	
	subwf	INDF,w 
	return
	
;------------------------- Clear Buffer Cx -------------------------
;  Cx
Cx_clear
	movlw	Buf_Cx_1
	movwf	Index_Buf_Cx
	movwf	FSR
	movlw	BUF_Cx_COUNT_MAX*3
	movwf	Temp
Cx_clear_L1
	incf	FSR,f
	clrf	INDF
	decfsz	Temp,f
	goto	Cx_clear_L1
	return

;------------------------- Buffer Sorting ESR -------------------------
; ,   
;  (   -   )
;: W -  
Buf_Sorting
	movwf	FSR
	movlw	BUF_COUNT_MAX-1
	movwf	Temp
Buf_Sort_start
	;  	
	movf	INDF,w	;INDF(Prev_H)
	incf	FSR,f
	incf	FSR,f
	subwf	INDF,w	;INDF(Next_H)
	btfss	STATUS,C
	goto	Buf_Sort_swap2
	btfss	STATUS,Z
	goto	Buf_Sort_Wait1	
	;Prev_H = Next_H
	incf	FSR,f
	movf	INDF,w	;INDF(Next_L)
	decf	FSR,f
	decf	FSR,f
	subwf	INDF,w	;INDF(Prev_L)
	btfss	STATUS,C
	goto	Buf_Sort_Wait2
	decf	FSR,f	
Buf_Sort_swap1
	;Prev_HL > Next_HL 
	;   , 
	;Prev_HL <--> Next_HL	
	movf	INDF,w	;INDF(Prev_H)
	incf	FSR,f
	incf	FSR,f
	xorwf	INDF,w	;INDF(Next_H)
	xorwf	INDF,f	;INDF(Next_H)
	xorwf	INDF,w	;INDF(Next_H)
	decf	FSR,f
	decf	FSR,f
	movwf	INDF	;INDF(Prev_H)
	
	incf	FSR,f	
	movf	INDF,w	;INDF(Prev_L)
	incf	FSR,f
	incf	FSR,f
	xorwf	INDF,w	;INDF(Next_L)
	xorwf	INDF,f	;INDF(Next_L)
	xorwf	INDF,w	;INDF(Next_L)
	decf	FSR,f
	decf	FSR,f
	movwf	INDF	;INDF(Prev_L)
	incf	FSR,f	;    		
	
	decfsz	Temp,f
	goto	Buf_Sort_start
	return

;-------------------------
Buf_Sort_swap2
	decf	FSR,f		
	decf	FSR,f		
	nop
	nop
	nop
	nop
	nop
	goto	Buf_Sort_swap1
	
;-------------------------
Buf_Sort_Wait1	;      
	incf	FSR,f
	nop
	nop
	nop
	nop	
	nop
	nop
Buf_Sort_Wait2	
	decf	FSR,f
	movlw	0x03
	call	Delay_go
	nop		
Buf_Sort_Wait3	
	movlw	0x08
	call	Delay_go
	nop
	nop
	decfsz	Temp,f
	goto	Buf_Sort_Wait3	
	return
	
;------------------------- Copy ADC Buffer -------------------------
;     
Copy_ADC_Buf
	addwf	Buf_Count,w
	movwf	FSR
	movf	ADRESH,W
	movwf	INDF
	decf	FSR,f
	bank1
	movf	ADRESL,W
	bank0
	movwf	INDF
	return

;------------------------- ADC_U330 -------------------------
;    .  =330
ADC_U330
	movlw	b'10000001'	;Fosc/32,  0,   .
	movwf	ADCON0
	movlw	0x21		; 20 
	movwf	Dly0
	decfsz	Dly0,F
	goto	$-1
	bsf	ADCON0,GO	; - 
	btfsc	ADCON0,GO
	goto	$-1		;   
	bcf	ADCON0,ADON	; 
	return
;------------------------- ADC_U33 -------------------------
;    .  =33
ADC_U33
	movlw	b'10001001'	;Fosc/32,  1,   .
	movwf	ADCON0
	movlw	0x21		; 20 
	movwf	Dly0
	decfsz	Dly0,F
	goto	$-1
	bsf	ADCON0,GO	; - 
	btfsc	ADCON0,GO
	goto	$-1		;   
	bcf	ADCON0,ADON	; 
	return
;------------------------- TMR1 -------------------------
;  TMR1,   = 0.2 
TMR1_init
  bank1
	bsf	PIE1, TMR1IE	;   TMR1
  bank0
	clrf	TMR1L
	clrf	TMR1H
	clrf	TMR1_Count
	bcf	PIR1, TMR1IF
	movlw	b'00000000'	; 1:1-Fosc/4, TMR1-.
	movwf	T1CON
	bcf	INTCON,GIE
	bsf	INTCON,PEIE
	return

;------------------------- TMR0 -------------------------
;  TMR0,   = 0.2 
TMR0_init
	movlw	Max_Count
	movwf	TMR0_Count	;    TMR0
	clrf	TMR0		;clear timer
	movlw	OPTION_REG	;Work around the OPTION
	movwf	FSR		;address OPTION_REG -> FSR
	movlw	b'00000111'	; set up timer. 1:256 presc
	movwf	INDF

	clrf	TMR0
	bcf	INTCON,T0IF	;clear tmr0 int flag
	bsf	INTCON,T0IE	;enable TMR0 int
	bcf	INTCON,GIE	;global interrupts
	return

;------------------------- DispUbat ---------------------------------------------;
;   
DispUbat
	call	Ubat		;  

	movlw	0x8F		;    - 1  16 
	call	CmdLCD
	movf	Bat_sign,w	;   
	call	CharLCD
	return

;------------------------- Ubat ---------------------------------------------;
;  
;Bat_sign -     
Ubat
	bank1
	movlw	b'00000100'	; , Vdd, Vss, AN0, AN1, AN3
	movwf	ADCON1
	bank0

	movlw	b'10011001'	;Fosc/32,  AN3,   .
	movwf	ADCON0
	movlw	0x42		; 40 
	movwf	Dly0
	decfsz	Dly0,F
	goto	$-1
	bsf	ADCON0,GO	; - 
	btfsc	ADCON0,GO
	goto	$-1		;   
	bcf	ADCON0,ADON	; 
	bank1
	movlw	b'10000100'	; , Vdd, Vss, AN0, AN1, AN3
	movwf	ADCON1
	bank0

Ubat_Min
	movlw	.106		;    .128,  Bat max.
	subwf	ADRESH,W
	btfsc	STATUS,C
	goto	Ubat_3		;Ubat >= 7v
	movlw	_BAT_MIN	;Ubat < 7v
	movwf	Bat_sign
	return
Ubat_3
	movlw	.113
	subwf	ADRESH,W
	btfsc	STATUS,C
	goto	Ubat_2		;Ubat >= 7.5v
	movlw	_BAT_3		;Ubat < 7.5v
	movwf	Bat_sign
	return
Ubat_2
	movlw	.121
	subwf	ADRESH,W
	btfsc	STATUS,C
	goto	Ubat_1		;Ubat >= 8v
	movlw	_BAT_2		;Ubat < 8v
	movwf	Bat_sign
	return
Ubat_1
	movlw	.128
	subwf	ADRESH,W
	movlw	_BAT_1		;Ubat < 8.5v
	btfsc	STATUS,C
	movlw	_BAT_MAX	;Ubat >= 8.5v
	movwf	Bat_sign
	return

;------------------------- Delay -------------------------
;   
Delay_3_sec			; 3 
  Dly24	 D'937499'		; 3/(4/20000000)/16=937500-1=937499
	goto	DoDly24

Delay_2_sec			; 2 
  Dly24	 D'624999'		; 2/(4/20000000)/16=625000-1=624999
	goto	DoDly24

Delay_1_sec			; 1 
  Dly24	 D'312499'		; 1/(4/20000000)/16=312500-1=312499
	goto	DoDly24

Delay_05_sec			; 0.5 
  Dly24	 D'156249'		; 0.5/(4/20000000)/16=156250-1=156249
	goto	DoDly24

Delay_01_sec			; 0.1 
  Dly24	 D'31249'		; 0.1/(4/20000000)/16=31250-1=31249
	goto	DoDly24

Delay_5_ms			; 5 
  Dly24	 D'1562'		; 0.005/(4/20000000)/16=1562.5=1562
	goto	DoDly24

Delay_200_us			; 200 
  Dly24	 D'62'			; 0.0002/(4/20000000)/16=62.5=62
	goto	DoDly24

DoDly24				;16 Tcy per loop
	movlw	H'FF'		;Start with -1 in W
	addwf	Dly0,F		;LSB decrement
	btfsc	STATUS,C	;was the carry flag set?
	clrw			;If so, 0 is put in W
	addwf	Dly1,F		;Else, we continue.
	btfsc	STATUS,C
	clrw			;0 in W
	addwf	Dly2,F
	btfsc	STATUS,C
	clrw			;0 in W
	iorwf	Dly0,W		;Inclusive-OR all variables
	iorwf	Dly1,W		;together to see if we have reached
	iorwf	Dly2,W		;0 on all of them.
	btfss	STATUS,Z	;Test if result of Inclusive-OR's is 0
	goto	DoDly24
	return

Delay_20_us
	movlw	0x1F		; 20 
Delay_go
	movwf	Dly0
	decfsz	Dly0,F
	goto	$-1
	nop
	nop
	return

;---------------------- LCD ---------------------
;          
SecLine
	movlw	0xC0

;   
CmdLCD
	movwf	Temp4
;  bcf	_RS
	swapf	Temp4, W
	andlw	0x0F
	movwf	PORTB
	bsf	_E
	nop
	nop
	nop
	bcf	_E
	movf	Temp4, W
	andlw	0x0F
	movwf	PORTB
	bsf	_E
	nop
	nop
	nop
	bcf	_E
;  clrf	 PORTB
	call	Delay_200_us
	return


;    ASCII  
NumLCD
	andlw	0x0F		; 
	iorlw	0x30		; ASCII
;   ASCII 
CharLCD
	movwf	Temp4
SendLCD
	swapf	Temp4, W
	andlw	0x0F
	iorlw	b'00010000'	; RS=1
	movwf	PORTB
	bsf	_E
	nop
	nop
	nop
	bcf	_E
	movf	Temp4, W
	andlw	0x0F
	iorlw	b'00010000'	; RS=1
	movwf	PORTB
Send	bsf	_E
	nop
	nop
	nop
	bcf	_E
	clrf	PORTB
	call	Delay_200_us
	return



CursorHome
	movlw	0x02		;    
	goto	LongSend
ClrDSP
	movlw	1		;  
LongSend
	call	CmdLCD
	goto	Delay_5_ms

DispDot
	movlw	"."
	goto	CharLCD

Disp0
	movlw	"0"
	goto	CharLCD

DispSP
	movlw	" "
	goto	CharLCD

;-----------------------------------------------------------
;       LCD
Read_String
	movwf	Count1
	decf	Count1,F	;  
	movlw	HIGH Table
	movwf	PCLATH
get_next_s
	movf	Count1,W
	call	Table
	andlw	0xFF		;    
	btfsc	STATUS, Z
	return
	call	CharLCD
	incf	Count1,F
	goto	get_next_s

;---------------------- Load CGRAM LCD ---------------------
;   
Load_ZG
	movlw	b'01001000'	; AC in CGRAM=8
	call	CmdLCD
	movlw	HIGH Table
	movwf	PCLATH
	movlw	.7 *.8		;7   8 
	movwf	Count1
	movlw	LOW  omega-1
	movwf	Count2		;  

get_s
	call	Table		;   
	call	CharLCD
	incf	Count2,F
	movf	Count2,W
	decfsz	Count1,F
	goto	get_s
	return

;----------------------------------------------------------
;    W   BCD0...4
; 
Disp_Full
	movwf	FSR		;     LCD
next_byte
	swapf	INDF,W
	call	NumLCD
	movf	INDF,W
	call	NumLCD
  ;,     BCD0
	movlw	BCD0
	subwf	FSR,W
	btfsc	STATUS,Z
	return
	decf	FSR,F
	goto	next_byte

;---------------------- BCD to LCD ---------------------
;      
DispBCD
	movwf	FSR
NextNibble
	swapf	INDF,F
	movf	INDF,W
	btfss	Flags,INSIGZERO	 ;1 -    
	goto	chk_NZ
	andlw	0x0F
	btfsc	STATUS,Z
	return			; 
	bcf	Flags,INSIGZERO	 ;      
chk_NZ
	btfss	Flags,DISCHARGE	 ; 1-   NZ ,  - 0
	goto	NumLCD
	movf	NZ,F
	btfsc	STATUS,Z	;=0?
	goto	Disp0		;,  0
	decf	NZ,F		;,    
	call	NumLCD
	return

;---------------------- BCD ---------------------
;      
BCD
	movlw	0x20
	movwf	T1
	clrf	BCD0
	clrf	BCD1
	clrf	BCD2
	clrf	BCD3
	clrf	BCD4

BcdLoop rlf	AARGB2, F
	rlf	AARGB1, F
	rlf	AARGB0, F
	rlf	AEXP, F

	rlf	BCD0, F
	rlf	BCD1, F
	rlf	BCD2, F
	rlf	BCD3, F
	rlf	BCD4, F
	decfsz	T1, F
	goto	Adjust
	return

Adjust
	movlw	.5
	movwf	Count2

	movlw	BCD0
	movwf	FSR
	goto	ADloop+1

ADloop	incf	FSR, F
	call	Adjbcd
	decfsz	Count2, F
	goto	ADloop
	goto	BcdLoop

Adjbcd
	movlw	0x03
	addwf	INDF, W
	movwf	T0
	btfsc	T0, 3
	movwf	INDF
	movlw	0x30
	addwf	INDF, W
	movwf	T0
	btfsc	T0, 7
	movwf	INDF
	return

;-------------------------------------------------------
;   " "  (4 ) 
; Temp1 =   -    
; Temp2 =   -    

;CEQUA	movlw  CX    ; C=A
Copy_From_A
	movwf	Temp1		; Xw=A
	movlw	AEXP
	movwf	Temp2
	goto	Copy

BEQUA
	movlw	AEXP		; B=A
Copy_To_B
	movwf	Temp2		; B=Xw
	movlw	BEXP
	goto	Copy_B

;AEQUF	movlw  FX    ; A=F
Copy_To_A
	movwf	Temp2		; A=Xw
	movlw	AEXP

Copy_B
	movwf	Temp1
Copy
	movlw	4		;  
	movwf	Count1
Copy_Loop
	movf	Temp2, W
	movwf	FSR
	movf	INDF, W
	movwf	Temp3
	movf	Temp1, W
	movwf	FSR
	movf	Temp3, W
	movwf	INDF
	decf	Temp1, F	;    
	decf	Temp2, F	; 
	decfsz	Count1, F
	goto	Copy_Loop
	return

;-------------------------------------------------------
X_To_B
	call	EEPROM_To_B	;   X
	call	ASwapB
	call	FLO2424
	call	FPM24
	return

ASwapB
	movlw	T5
	call	Copy_From_A
	movlw	BEXP
	call	Copy_To_A
	movlw	T5
	call	Copy_To_B
	return
;-------------------------------------------------------
;      
ClrB
	movlw	BEXP		;   
	goto	ClrA+1

ClrA
	movlw	AEXP		;   
	movwf	FSR
	movlw	4		; 
	movwf	Count1

ClrLoop
	clrf	INDF		;  
	decf	FSR, F		;  
	decfsz	Count1, F
	goto	ClrLoop
	return
;-------------------------------------------------------
;     EEPROM   A
EEPROM_To_A
	movwf	EE_ADR		;    EEPROM
	movlw	AEXP
	goto	EEPROM_To_L1
;     EEPROM   B
EEPROM_To_B
	movwf	EE_ADR		;    EEPROM
	movlw	BEXP
EEPROM_To_L1
	movwf	FSR
	movlw	4		; 
	movwf	Count1
EE_read_loop
	call	ReadEEPROM
	banksel BEXP
	movwf	INDF
	incf	EE_ADR, F
	decf	FSR, F
	decfsz	Count1, F
	goto	EE_read_loop
	return

;   EEPROM
ReadEEPROM
	movf	EE_ADR,W	;
	banksel EEADR		;  2
	movwf	EEADR		;   EEPROM
	banksel EECON1		; 3
	bcf	EECON1,EEPGD	; EEPROM
	bsf	EECON1,RD	; 
	banksel EEDATA		; 2
	movf	EEDATA,W	; W = EEDATA
	return

;-------------------------------------------------------
;    BARG  EEPROM
;   EEPROM   Const_ADR
Save_Const
	movf	Const_ADR,W
	movwf	EE_ADR
	movlw	BEXP
	movwf	FSR
	movlw	4		; 
	movwf	Count1
EE_write_loop
	movf	INDF,W
	movwf	EE_DATA
	call	WriteEEPROM
	banksel BEXP
	incf	EE_ADR, F
	decf	FSR, F
	decfsz	Count1, F
	goto	EE_write_loop
	return

;   EEPROM
WriteEEPROM
	banksel EECON1		;3
	btfsc	EECON1,WR
	goto	$-1
	banksel EE_ADR
	movf	EE_ADR,W
	banksel EEADR		;2
	movwf	EEADR
	banksel EE_DATA
	movf	EE_DATA,W
	banksel EEDATA		;2
	movwf	EEDATA
	banksel EECON1		;3
	bcf	EECON1,EEPGD
	bsf	EECON1,WREN
	movlw	0x55
	movwf	EECON2
	movlw	0xAA
	movwf	EECON2
	bsf	EECON1,WR
	nop
	bcf	EECON1,WREN
	return
;-------------------------------------------------------
;    B
IncB
	bsf	Flags,SAVECONST	 ;   
	incf	BARGB2, F
	btfsc	STATUS, Z
	incf	BARGB1, F
	goto	ShowX

;    B
DecB
	bsf	Flags,SAVECONST	 ;   
	movf	BARGB2, F
	btfsc	STATUS, Z
	decf	BARGB1, F
	decf	BARGB2, F

ShowX
	movlw	BEXP
	call	Copy_To_A

	call	BCD
	call	SecLine
	movlw	BCD1
	call	DispBCD
	call	DispDot
	movlw	BCD1
	call	DispBCD
	movlw	BCD0
	call	DispBCD
	movlw	BCD0
	call	DispBCD

	movf	Key_Press_Time,f  ;   
	btfss	STATUS,Z
	goto	ShowX_L1
	call	Delay_01_sec	;  
	return
ShowX_L1
	decf	Key_Press_Time,f
	call	Delay_05_sec
	return

;=======================================================
;  PIC16 24 BIT FLOATING POINT LIBRARY

	#define P16_MAP1 0
	#define P16_MAP2 1
	include "math16.inc"
	include "fp24.a16"


	END

