Program LED_T1_T2_T3;
Uses
  Crt,DOS;
Var
  Position,I,
  Max,T1,T2,T3,Z        : Byte;

  Expected,InReality,
  Fx,Correction         : Real;

  N,Result,M            : LongInt;

  Error                 : Integer;

  OK                    : Boolean;

  S                     : String;

Label    Finito;

Begin
  ClrScr;Correction:=1;
  If ParamCount=0 Then
    Begin
      WriteLn('====================== (C) OM3CPH 2000 ========================');
      WriteLn;
      WriteLn('Program to calculate T1, T2, T3 and Z coefficients for LED display');
      WriteLn('PIC frequency meter.');
      WriteLn;
      WriteLn;
      WriteLn('Usage:    LED_T123 [Xtal [expected in_reality]]');
      WriteLn('                    Xtal       is Xtal frequency in MHz');
      WriteLn('                    expected   equals to frequency of the standard');
      WriteLn('                    in_reality obtained frequency');
      WriteLn;
      WriteLn;
      WriteLn('Examples: LED_T123 8.8         to calculate T1, T2, T3 and Z for 8.8 MHz Xtal');
      WriteLn;
      WriteLn('          LED_T123 8.8 20 19.9995 to recalculate T1, T2, T3 and Z for 8.8 MHz');
      WriteLn('                               Xtal if after first PIC programming different');
      WriteLn('                               value is displayed (19.9995) than expected (20).)');
      WriteLn;
      WriteLn;
      WriteLn('Press any key to continue...');
      Repeat Until KeyPressed;
      Halt;
    End;

  Val(ParamStr(1),Fx,Error);

  If ((Fx<0.5) Or (Fx>20)) Then
    Begin
      WriteLn;
      WriteLn('Xtal frequency should be larger than 500 kHz and smaller than 20 MHz!');
      WriteLn;
      WriteLn('Press any key to continue...');
      Repeat Until KeyPressed;
      Halt;
    End;

  If ParamCount=3 Then
    Begin
      Val(ParamStr(2),Expected,Error);
      Val(ParamStr(3),InReality,Error);
      Correction:=Expected/InReality;
    End;

  If ((Correction<0.5) Or (Correction>2)) Then
    Begin
      WriteLn;
      WriteLn('Do you really have ',Fx,' MHz Xtal?');
      WriteLn;
      WriteLn('Press any key to continue...');
      Repeat Until KeyPressed;
      Halt;
    End;

  N:=Round(25000*Fx);
  N:=Round(N*Correction);

  Max:=255;
  GoToXY(19,21);Write(' Please wait ...Ŀ');
  GoToXY(19,22);Write('                                        ');
  GoToXY(19,23);Write('');

{ 25 000*Fx=60*[7*(37+3*T1)+6+3*T2]+6+9*T3+Z }

  For T1:=Max DownTo 1 Do
    Begin
      S:='';
      For Position:=1 To (Round(40*((1+Max-T1)/Max))) Do S:=S+Chr(178);
      GoToXY(20,22);Write(S);
      For T2:=1 To Max Do
        For T3:=1 To Max Do
          For Z:=0 To 8 Do
            Begin
              Result:=37+3*T1;
              Result:=7*Result;
              Result:=Result+6+3*T2;
              Result:=Result*60;
              Result:=Result+6+9*T3;
              Result:=Result+Z;
              If Result=N Then Begin OK:=True;GoTo Finito;End;
            End;
    End;
Finito:
  If OK Then
    Begin
      GoToXY(19,19);Write('Ŀ');
      GoToXY(19,20);Write('        Calculation completed.          ');
      GoToXY(19,21);Write('              T1  T2  T3   Z            ');
      GoToXY(19,22);Write('    Values: ',T1:4,T2:4,T3:4,Z:4,'            ');
      GoToXY(19,23);Write('');
    End
  Else
    Begin
      GoToXY(19,19);Write('Ŀ');
      GoToXY(19,20);Write('        Calculation completed.          ');
      GoToXY(19,21);Write('        No solution found... :-(        ');
      GoToXY(19,22);Write('');
    End;
  WriteLn;
  WriteLn('Press any key to continue...');
  Repeat Until KeyPressed;
  ReadKey;
End.