  {.PL66}
  {.IN+}
  {.PO5}
  {.CC#15}
  {.PW132}
  {.HE Split/Screen Terminalprogram for the TNC-2}
  {.FO Page #}
  {//////////////////////////////////////////////////////////////////////////}
  {/////         Split/Screen Terminalprogram for the TNC-2           ///////}
  {//////////////////////////////////////////////////////////////////////////}
  { This program was written by HB9CVV, most of the code (windowing, and     }
  { the asynchronous Com-port server) has been adopted from existing sources }
  {                                                                          }
  { This module contains the TNC device-specific part                        }
  {--------------------------------------------------------------------------}

PROGRAM TNC_TAPR;

    {$C-}
    {$U-}

  CONST logo = '<<<<<<<<<< TNC-2 - Terminal Server *** Sep/86 HB9CVV >>>>>>>>>>';

  CONST parfilnam = 'TNC2RIG.PAR';      { filename of rig-parameter file }
  CONST cmdchr = ^C;                    { get command-mode char is ctrl/c}
  CONST Send_ok = True;                 { Send file feature enabled }

    { For the TNC-2 you can set Tnc_echo_on to TRUE or FALSE, however no echo  }
    { is recommended. File-sends require ECHO off from the TNC, so if you have }
    { Tnc_echo_on TRUE, so we give the ECHO OFF directive to the TNC prior to  }
    { a file-transmit, and an ECHO ON afterwards.                              }
    { The TNC2 is NOT able to echo a CONTINUOUS input flow properly (!)        }

    { If Tnc_echo_on is OFF, then during TNC device init (when the program is  }
    { started) this program sends a ECHO OFF command to the TNC and ECHO ON    }
    { command during shutdown.                                                 }
    { In this case the text                                                    }
    { from the lower window - when a CR causes to send it to the TNC - is      }
    { moved to the upper window in high-intensity mode. Nice to distinguish    }
    { between your text and incoming text !                                    }

  CONST Tnc_echo_on = False;            { get no echo from tnc }

  CONST DefPort = 2;                    { Default Com Port}
  CONST DefBaud = 2400;                 { Default Baudrate}

  CONST PTOOLWIN_Number_of_Windows = 4; { Number of pop-up windows }

    {$I SSS_DECL.PAS }
    {$I SSS_ASYN.PAS }                  {I/O Routines for Comm-port}
    {$I SSS_PWIN.PAS }                  {PTOOLWIN functions and parameters }
    {$I SSS_SUBR.PAS }                  {Common subroutines}

    {=============================================================================+
    |                                                                             |
    |  This Module contains device dependant routines                             |
    |                                                                             |
    |-----------------------------------------------------------------------------|
    |                                                                             |
    |  InitHelpwindows     -- define size of the three helpwindows                |
    |  HelpWindow1         -- write the first helpwindow                          |
    |  HelpWindow2         -- write the second helpwindow                         |
    |  HelpWindow3         -- write the third helpwindow                          |
    |  ResetParam          -- send commands to reset the params of the device     |
    |  InitDevice          -- Initialize the device                               |
    |  ShutdownDevice      -- Shut down the device                                |
    |                                                                             |
    +-----------------------------------------------------------------------------}

    {-----------------------------------------------------------------------------+
    | Define three pop-up help windows                                            |
    +-----------------------------------------------------------------------------}

  PROCEDURE InitHelpWindows;

    BEGIN
      PTOOLWIN_Screen_Type := 'X';
      PTWSet(1, 12, 2, 60, 24, 1, 0, 12);
      PTWSet(2, 35, 1, 75, 23, 2, 0, 14);
      PTWSet(3, 25, 3, 60, 23, 2, 0, 10);
    END;

    {-----------------------------------------------------------------------------+
    | Define Help window number ONE                                               |
    +-----------------------------------------------------------------------------}

  PROCEDURE HelpWindow1;

    BEGIN
      PTWOpen(1);
      ClrScr;
      GoToXY(2, 1); Write('C call1 v [call2 ... call9] Connect');
      GoToXY(2, 2); Write('D              Disconnect');
      GoToXY(2, 3); Write('CTE text       Connect Text');
      GoToXY(2, 4); Write('CMSG ON|OFF    Enable/disable Ctext');
      GoToXY(2, 5); Write('BTE text       Beacon text');
      GoToXY(2, 6); Write('B E n          Beacon every n*10 sec');
      GoToXY(2, 7); Write('CHeck n        Connect timeout, n*10 sec');
      GoToXY(2, 8); Write('CONOk ON|OFF   Accept/discard connects');
      GoToXY(2, 9); Write('DIGI ON|OFF    Digipeater on/off');
      GoToXY(2, 10); Write('DISPLay        Parameters');
      GoToXY(2, 11); Write('DWait n        Default wait time, n*10mS');
      GoToXY(2, 12); Write('MCOM ON|OFF    Monitor control frames');
      GoToXY(2, 13); Write('MCON ON|OFF    Monitor while connected');
      GoToXY(2, 14); Write('MAXFrame 1..7  Maximum unacked frames');
      GoToXY(2, 15); Write('MHeard         Display heard stations');
      GoToXY(2, 16); Write('MRPT ON|OFF    Monitor repeaters');
      GoToXY(2, 17); Write('MON ON|OFF     Monitor on/off');
      GoToXY(2, 19); Write('RESptime n     Delaytime for acks n*100mS');
      GoToXY(2, 20); Write('TXDelay n      Keying delaytime n*10mS');

      GoToXY(2, 21); Waitreturn(20000.0);
      PTWClose;
      TextColor(15);
      TextBackground(0);
    END;

    {-----------------------------------------------------------------------------+
    | Define Help window number TWO                                               |
    +-----------------------------------------------------------------------------}

  PROCEDURE HelpWindow2;

    BEGIN
      Helpwindow3;
    END;

    {-----------------------------------------------------------------------------+
    | Reset the parameters of the TNC-2. When we do this, we at least assume      |
    | that the communication to the TNC-2 is working.                             |
    +-----------------------------------------------------------------------------}

  PROCEDURE RESETTNC (Filename : Maxstring);

    VAR line : Maxstring; SFile : Text;
      IOR, ic, ic0, ic1 : Integer;

    PROCEDURE Comwrite(s : MaxString);  { emit a command }
      VAR chx: Char;
      BEGIN
        Async_Send_String(s);           { send the string }
        Delay(200);                     { wait for the response }
        WHILE Async_Receive(chx) DO BEGIN Write (chx); Delay(2); END;
      END;

    BEGIN
      Assign(Sfile, Filename);
      {$I-} Reset(Sfile); IOR := IOResult; {$I+}
      IF IOR <> 0 THEN BEGIN
        WriteLn('*** TNC-Parameter File "'+Filename+'" not found ***');
        Delay(2000);
      END ELSE BEGIN
        Comwrite(^C);
        WriteLn('Resetting TNC parameters...');
        WriteLn;
        WHILE (NOT EoF(Sfile)) DO BEGIN
          {$I-} ReadLn(Sfile, line); IOR := IOResult; {$I+}
          IF IOR <> 0 THEN Exit;
          ComWrite (line+cr);
        END;
      END;
      Close(SFile);
    END;

    {-----------------------------------------------------------------------------+
    | Init the TNC-2.                                                             |
    +-----------------------------------------------------------------------------}

  PROCEDURE InitDevice;

    VAR daycmdstr : STRING[40]; cha : Char;
    BEGIN
      IF Async_CTS_On THEN BEGIN
        Async_Send_String(^Q^X);        {unlock it from possible locks}
        {Wait for return strings and flush}
        Delay(500);
        IF ParamStr(1) = 'R' THEN
          RESETTNC('TNC2.PAR');
        daycmdstr := ^C'DAYTIME '+qdate+qtime+^M; {set TNC's date & time}
        Async_Send_String(daycmdstr);
        Delay(1000);
        Async_Send_String(^C'STREAMSW $02'^M); {Streamswitch char is ^B}
        Delay(500);
        Async_Send_String(^C'XFLOW OFF'^M); {HW flow control for file-send}
        Delay(500);
        IF (NOT TNC_echo_on) THEN BEGIN
          Async_Send_String(^C'ECHO OFF'^M); {HW flow control for file-send}
          Delay(500);
        END;
      END ELSE BEGIN
        WriteLn('**** Cannot sense RTS from TNC **** Init failed, use ^X to exit ***');
        Delay(3000);
      END;
    END;

    {-----------------------------------------------------------------------------+
    | Shutdown the TNC-2.                                                         |
    +-----------------------------------------------------------------------------}

  PROCEDURE Shutdowndevice;

    BEGIN
      IF Async_CTS_On THEN BEGIN
        Async_Purge_Buffer;             { and flush it }
        Async_Send_String(^S);
        Delay(200);
        Async_Send_String(^C'ECHO ON'^M);
        Delay(500);
      END;
    END;

    {------------------------------------------------------------------------+
    | DEVICE SPECIAL FUNCTIONS                                               |
    +------------------------------------------------------------------------}

  PROCEDURE DEV_SPC_FUN(fn: Integer);
    BEGIN
    END;

  PROCEDURE SWITCH_DEV_MODE;              {ALT/F1...ALT/F10}
    BEGIN                                 {dummy, nothing to switch}
    END;

    {$I SSS_MAIN.PAS }
