  {.PL66}
  {.IN+}
  {.PO5}
  {.CC#15}
  {.PW132}
  {.HE Split/Screen Terminalprogram for the TNC-1/WA8DED}
  {.FO Page #}
  {//////////////////////////////////////////////////////////////////////////}
  {/////         Split/Screen Terminalprogram for the TNC-1/WA8DED    ///////}
  {//////////////////////////////////////////////////////////////////////////}
  { This program was written by HB9CVV, most of the code (windowing, and     }
  { the asynchronous Com-port server) has been adopted from existing sources }
  {                                                                          }
  { This module contains the TNC device-specific part                        }
  {--------------------------------------------------------------------------}

PROGRAM TNC_TAPR;

    {$C-}
    {$U-}

  CONST logo = '<<<<<<<<<< TNC-1/WA8DED - Terminal Server *** Sep/86 HB9CVV >>>>>>>>>>';

  CONST parfilnam = 'TNC1WRIG.PAR';     { filename of rig-parameter file }
  CONST cmdchr = ^[;                    { get command-mode char is escape}
  CONST Tnc_echo_on = True;             { echoing on }
  CONST Send_ok = False;                { Send file feature disabled - NO HW-handshake availabe ! }

  CONST DefPort = 2;                    { Default Com Port}
  CONST DefBaud = 4800;                 { Default Baudrate}

  CONST PTOOLWIN_Number_of_Windows = 4; { Number of pop-up windows }

    {$I SSS_DECL.PAS }
    {$I SSS_ASYN.PAS }                  {I/O Routines for Comm-port}
    {$I SSS_PWIN.PAS }                  {PTOOLWIN functions and parameters }
    {$I SSS_SUBR.PAS }                  {Common subroutines}

    {=============================================================================+
    |                                                                             |
    |  This Module contains device dependant routines                             |
    |                                                                             |
    |-----------------------------------------------------------------------------|
    |                                                                             |
    |  InitHelpwindows     -- define size of the three helpwindows                |
    |  HelpWindow1         -- write the first helpwindow                          |
    |  HelpWindow2         -- write the second helpwindow                         |
    |  HelpWindow3         -- write the third helpwindow                          |
    |  ResetParam          -- send commands to reset the params of the device     |
    |  InitDevice          -- Initialize the device                               |
    |  ShutdownDevice      -- Shut down the device                                |
    |                                                                             |
    +-----------------------------------------------------------------------------}

    {-----------------------------------------------------------------------------+
    | Define three pop-up help windows                                            |
    +-----------------------------------------------------------------------------}

  PROCEDURE InitHelpWindows;

    BEGIN
      PTOOLWIN_Screen_Type := 'X';
      PTWSet(1, 12, 2, 64, 24, 1, 0, 12);
      PTWSet(2, 35, 1, 75, 23, 2, 0, 14);
      PTWSet(3, 25, 1, 60, 20, 2, 0, 10);
    END;

    {-----------------------------------------------------------------------------+
    | Define Help window number ONE                                               |
    +-----------------------------------------------------------------------------}

  PROCEDURE HelpWindow1;

    BEGIN
      PTWOpen(1);
      ClrScr;
      GoToXY(2, 1); Write('C call1 [call2 ... call9] Connect');
      GoToXY(2, 2); Write('D         Disconnect');
      GoToXY(2, 3); Write('L [0..4]  Display status');
      GoToXY(2, 4); Write('F 1..15   Frame Ack time (s)');
      GoToXY(2, 5); Write('N 0..255  Retry Count');
      GoToXY(2, 6); Write('O 1..7    Maxframes');
      GoToXY(2, 7); Write('R 0/1     Digipeater on/off');
      GoToXY(2, 8); Write('S 0..4    Select Channel');
      GoToXY(2, 9); Write('V 1/2     Protocoll version 1/2');
      GoToXY(2, 10); Write('Y 0..4    Enable channels');
      GoToXY(2, 12); Write('U 0 text     No untattended mode');
      GoToXY(2, 13); Write('U 1 ctext    Unattended mode');
      GoToXY(2, 14); Write('U 2 int text Beacon mode');
      GoToXY(2, 16); Write('M NIUSCRT    Monitor mode');
      GoToXY(2, 17); Write('          N: No packets      I: Info packets');
      GoToXY(2, 18); Write('          U: Unproto packets S: Control packets');
      GoToXY(2, 19); Write('          R: Packets for us  T: Packets from us');
      GoToXY(2, 20); Write('          C: When connected');

      GoToXY(2, 21); Waitreturn(20000.0);
      PTWClose;
      TextColor(15);
      TextBackground(0);
    END;

    {-----------------------------------------------------------------------------+
    | Define Help window number TWO                                               |
    +-----------------------------------------------------------------------------}

  PROCEDURE HelpWindow2;

    BEGIN
      PTWOpen(2);
      ClrScr;
      GoToXY(2, 1); Write('A 0/1      AutoLF on/off');
      GoToXY(2, 2); Write('B 1..15    Terminal Baudrate');
      GoToXY(2, 3); Write('E 0/1      Echo on/off');
      GoToXY(2, 4); Write('H 50..9600 HDLC Baudrate');
      GoToXY(2, 5); Write('I call     Station call');
      GoToXY(2, 6); Write('K 1..2     Calibration');
      GoToXY(2, 7); Write('PERM       Store permanent');
      GoToXY(2, 8); Write('QRES       Reset');
      GoToXY(2, 9); Write('T 0..127   Transmit Delay (10mS)');
      GoToXY(2, 10); Write('W 0..127   Digipeater Delay (10mS)');
      GoToXY(2, 11); Write('X 0/1      TX disable/enable');
      GoToXY(2, 12); Write('Z 0        Flow off, Xon/Xoff off');
      GoToXY(2, 13); Write('Z 1        Flow on,  Xon/Xoff off');
      GoToXY(2, 14); Write('Z 2        Flow off, Xon/Xoff on');
      GoToXY(2, 15); Write('Z 3        Flow on,  Xon/Xoff on');
      GoToXY(2, 16); Write('@B         Display number of buffers');
      GoToXY(2, 17); Write('@S         Display link status');
      GoToXY(2, 18); Write('@T2        Ack timer (10mS)');
      GoToXY(2, 19); Write('@T3        Timeout timer (10mS)');
      GoToXY(2, 21); Waitreturn(20000.0);
      PTWClose;
      TextColor(15);
      TextBackground(0);
    END;


    {-----------------------------------------------------------------------------+
    | Reset the parameters of the TNC-1. When we do this, we at least assume      |
    | that the communication to the TNC-1 is working.                             |
    +-----------------------------------------------------------------------------}

  PROCEDURE RESETPARAM;
    BEGIN
    END;

    {-----------------------------------------------------------------------------+
    | Init the TNC-1/WA8.                                                         |
    +-----------------------------------------------------------------------------}

  PROCEDURE Initdevice;
    VAR daycmdstr : STRING[40]; cha : Char;
    BEGIN
      Async_Send_String(^Q);            {unlock it from possible locks}
      Delay(1000);                      {Wait for return strings}
      Async_Purge_Buffer;               {flush}
      Async_Send_String(^['QRES'^M);
      Delay(1000);
      Async_Send_String(^['L'^M);       {get status of TNC}
    END;

    {-----------------------------------------------------------------------------+
    | Shutdown the TNC-1.                                                         |
    +-----------------------------------------------------------------------------}

  PROCEDURE Shutdowndevice;

    BEGIN
      Async_Send_String(^S);
      Delay(200);
    END;

    {------------------------------------------------------------------------+
    | DEVICE SPECIAL FUNCTIONS                                               |
    +------------------------------------------------------------------------}

  PROCEDURE DEV_SPC_FUN(fn : Integer);
    BEGIN
    END;

  PROCEDURE SWITCH_DEV_MODE;            {ALT/F1...ALT/F10}
    BEGIN                               {dummy, nothing to switch}
    END;

    {$I SSS_MAIN.PAS }
