  {.PL66}
  {.IN+}
  {.PO5}
  {.CC#15}
  {.PW132}
  {.HE Split/Screen Terminalprogram for the TNC-2}
  {.FO Page #}
  {//////////////////////////////////////////////////////////////////////////}
  {/////         Split/Screen Terminalprogram for the PK-232          ///////}
  {//////////////////////////////////////////////////////////////////////////}
  { This program was written by HB9CVV, most of the code (windowing, and     }
  { the asynchronous Com-port server) has been adopted from existing sources }
  {                                                                          }
  { This module contains the TNC device-specific part                        }
  {--------------------------------------------------------------------------}

PROGRAM TNC_TAPR;

    {$C-}
    {$U-}
    {$K-}

  CONST logo = '<<<<<<<<<< PK-232 - Terminal Server *** Sep/86 HB9CVV >>>>>>>>>>';

  CONST parfilnam = 'PK232RIG.PAR';     { filename of rig-parameter file }
  CONST cmdchr = ^C;                    { get command-mode char is ctrl/c}
  CONST Tnc_echo_on = True;             { echoing from PK-232 - THIS IS A MUST }

    { NOTE: Hardware-handshake by CTS (enabled by XFLOW OFF) does not work, so }
    { we use XON/XOFF - consequently XFLOW mus be ON (!).                      }

  CONST Send_ok = True;                 { Send file feature enabled - }

  CONST DefPort = 1;                    { Default Com Port}
  CONST DefBaud = 2400;                 { Default Baudrate}

  CONST PTOOLWIN_Number_of_Windows = 8; { Number of pop-up windows }

  TYPE Devmodenam = (VHF_PR, RF_PR, AMTOR, AMTOR_L, RTTY, MORSE, ASCII, Unknown);
  VAR DevMode : DevModenam;

    {$I SSS_DECL.PAS }
    {$I SSS_ASYN.PAS }                  {I/O Routines for Comm-port}
    {$I SSS_PWIN.PAS }                  {PTOOLWIN functions and parameters }
    {$I SSS_SUBR.PAS }                  {Common subroutines}

    {=============================================================================+
    |                                                                             |
    |  This Module contains device dependant routines                             |
    |                                                                             |
    |-----------------------------------------------------------------------------|
    |                                                                             |
    |  InitHelpwindows     -- define size of the three helpwindows                |
    |  HelpWindow1         -- write the first helpwindow                          |
    |  HelpWindow2         -- write the second helpwindow                         |
    |  HelpWindow3         -- write the third helpwindow                          |
    |  ResetParam          -- send commands to reset the params of the device     |
    |  InitDevice          -- Initialize the device                               |
    |  ShutdownDevice      -- Shut down the device                                |
    |                                                                             |
    +-----------------------------------------------------------------------------}

    {-----------------------------------------------------------------------+
    | Define pop-up help windows                                            |
    +-----------------------------------------------------------------------}

  PROCEDURE InitHelpWindows;

    BEGIN
      PTOOLWIN_Screen_Type := 'X';
      PTWSet(1, 12, 2, 60, 24, 1, 0, 12);
      PTWSet(2, 35, 1, 75, 23, 2, 0, 14);
      PTWSet(3, 25, 3, 60, 23, 2, 0, 10);
      PTWSet(4, 25, 10, 58, 14, -1, 0, 10);
      PTWSet(5, 20, 10, 42, 20, -1, 0, 10);
    END;

    {------------------------------------------------------------------------+
    | Define Help window number ONE                                          |
    +------------------------------------------------------------------------}

  PROCEDURE HelpWindow1;
    BEGIN
      PTWOpen(1);
      ClrScr;
      WriteLn('C call1 v [call2 ... call9] Connect');
      WriteLn('D              Disconnect');
      WriteLn('CTE text       Connect Text');
      WriteLn('CMSG ON|OFF    Enable/disable Ctext');
      WriteLn('BTE text       Beacon text');
      WriteLn('B E n          Beacon every n*10 sec');
      WriteLn('CHeck n        Connect timeout, n*10 sec');
      WriteLn('CONOk ON|OFF   Accept/discard connects');
      WriteLn('DIGI ON|OFF    Digipeater on/off');
      WriteLn('DISPLay        Parameters');
      WriteLn('DWait n        Default wait time, n*10mS');
      WriteLn('MCOM ON|OFF    Monitor control frames');
      WriteLn('MCON ON|OFF    Monitor while connected');
      WriteLn('MAXFrame 1..7  Maximum unacked frames');
      WriteLn('MHeard         Display heard stations');
      WriteLn('MRPT ON|OFF    Monitor repeaters');
      WriteLn('MON ON|OFF     Monitor on/off');
      WriteLn('RESptime n     Delaytime for acks n*100mS');
      WriteLn('TXDelay n      Keying delaytime n*10mS');

      GoToXY(2, 21); Waitreturn(20000.0);
      PTWClose;
      TextColor(15);
      TextBackground(0);
    END;

    {------------------------------------------------------------------------+
    | Define Help window number TWO                                          |
    +------------------------------------------------------------------------}

  PROCEDURE HelpWindow2;

    BEGIN
      Helpwindow3;
    END;

    {------------------------------------------------------------------------+
    | Reset the parameters of the DEVICE. When we do this, we at least       |
    | assume that the communication to the DEVICE is working.                |
    +------------------------------------------------------------------------}

  PROCEDURE RESETTNC(Filename : Maxstring);

    VAR line : Maxstring; SFile : Text;
      IOR, ic, ic0, ic1 : Integer;

    PROCEDURE Comwrite(s : MaxString);  { emit a command }
      VAR chx : Char;
      BEGIN
        Async_Send_String(s);           { send the string }
        Delay(200);                     { wait for the response }
        WHILE Async_Receive(chx) DO BEGIN
          Write(chx); Delay(2);
          IF chx = cr THEN BEGIN Write(lf); Delay(2); END;
        END;
      END;

    BEGIN
      Assign(Sfile, Filename);
      {$I-} Reset(Sfile); IOR := IOResult; {$I+}
      IF IOR <> 0 THEN BEGIN
        WriteLn('*** TNC-Parameter File "'+Filename+'" not found ***');
        Delay(2000);
      END ELSE BEGIN
        Comwrite(^C);
        WriteLn;
        WriteLn('Resetting TNC parameters:');
        WriteLn;
        WHILE (NOT EoF(Sfile)) DO BEGIN
          {$I-} ReadLn(Sfile, line); IOR := IOResult; {$I+}
          IF IOR <> 0 THEN Exit;
          ComWrite(line+cr);
        END;
      END;
      Close(SFile);
    END;

    {------------------------------------------------------------------------+
    | DEVICE SPECIAL FUNCTIONS                                               |
    +------------------------------------------------------------------------}

  PROCEDURE DEV_SPC_FUN(fn : Integer);
    BEGIN
      CASE fn OF
        082   : BEGIN                     { Ins-Key (on Cursor-Pad) }
                  IF DevMode = AMTOR_L THEN BEGIN { AMTOR-L: re-SYNC }
                    Async_Send_String('ALIST'^M);
                    Delay(100);
                  END;
                  IF DevMode = AMTOR THEN BEGIN { AMTOR: Force LETTERS case }
                    Async_Send_String('ALIST'^M);
                    Delay(100);
                  END;
                END;
        083   : BEGIN                     { Del-Key (on Cursor-Pad) }
                  IF DevMode = AMTOR THEN BEGIN {AMTOR: Force CHANGEOVER}
                    Async_Send_String(^C'ACHG'^M'CONV'^M);
                    Delay(300);
                  END;
                END;
      END;
    END;

    {------------------------------------------------------------------------+
    | Routines to switch DEVIVE Modes.                                       |
    +------------------------------------------------------------------------}

  PROCEDURE ModeWindow(Text : MaxString);
    BEGIN
      PTWOpen(4);
      ClrScr;
      GoToXY(2, 2); Write(' Switching device to ');
      Write(Text);
    END;

  PROCEDURE SDM_PR_VHF;
    BEGIN
      IF (DevMode = AMTOR_L) THEN BEGIN
        Async_Send_String(^C^M);
        Delay(200);
        Async_Send_String('AMTOR'^M);
        Delay(300);
      END;
      Modewindow('VHF-PR');
      DevMode := VHF_PR;
      Async_Send_String(^C^M);
      Delay(200);
      Async_Send_String('PACKET'^M);
      Delay(200);
      Async_Send_String('VHF ON'^M);
      Delay(200);
      Async_Send_String('HBAUD 1200'^M);
      Delay(200);
      Async_Send_String('FRAK 3'^M);
      Delay(200);
      Async_Send_String('PACLEN 255'^M);
      Delay(200);
      Async_Send_String('MAXFRAME 4'^M);
      Delay(200);
      Async_Send_String('DWAIT 16'^M);
      Delay(200);
      Async_Send_String('CTEXT Bin z.Zt. OFFLINE, diese Verbindung wird gespeichet. 73 de Peter.'^M);
      PGMCMD_LINEOUT;
      Delay(500);
      Async_Purge_Buffer;
      PTWClose;
      Async_Send_String('DISPLAY L'^M);
    END;

  PROCEDURE SDM_PR_RF;
    BEGIN

      Modewindow('RF-PR');
      IF DevMode = AMTOR_L THEN BEGIN
        Async_Send_String(^C^M);
        Delay(200);
        Async_Send_String('AMTOR'^M);
        Delay(300);
      END;
      DevMode := RF_PR;
      Async_Send_String(^C^M);
      Delay(200);
      Async_Send_String('PACKET'^M);
      Delay(200);
      Async_Send_String('VHF OFF'^M);
      Delay(200);
      Async_Send_String('HBAUD 300'^M);
      Delay(200);
      Async_Send_String('FRAK 5'^M);
      Delay(200);
      Async_Send_String('PACLEN 80'^M);
      Delay(200);
      Async_Send_String('MAXFRAME 1'^M);
      Delay(200);
      Async_Send_String('DWAIT 0'^M);
      Delay(200);
      Async_Send_String('CTEXT Operator is OFFLINE, the message is recorded - 73 de Peter.'^M);
      PGMCMD_LINEOUT;
      Delay(500);
      Async_Purge_Buffer;
      PTWClose;
      Async_Send_String('DISPLAY L'^M);
    END;

  PROCEDURE SDM_AMTOR;
    BEGIN
      Modewindow('AMTOR');
      DevMode := AMTOR;
      Async_Send_String(^C^M);
      Delay(200);
      Async_Send_String('AMTOR'^M);
      PGMCMD_WORDOUT;
      Delay(500);
      Async_Purge_Buffer;
      Async_Send_String('OPMODE'^M);
      PTWClose;
    END;

  PROCEDURE SDM_AMTOR_L;
    BEGIN
      Modewindow('AMTOR-L');
      DevMode := AMTOR_L;
      Async_Send_String(^C^M);
      Delay(200);
      Async_Send_String('AMTOR'^M);
      Delay(200);
      Async_Send_String('ALIST'^M);
      Delay(500);
      Async_Purge_Buffer;
      PTWClose;
      Async_Send_String('OPMODE'^M);
    END;

  PROCEDURE SDM_RTTY;
    BEGIN
      Modewindow('RTTY');
      IF DevMode = AMTOR_L THEN BEGIN
        Async_Send_String(^C^M);
        Delay(200);
        Async_Send_String('AMTOR'^M);
        Delay(300);
      END;
      DevMode := RTTY;
      Async_Send_String(^C^M);
      Delay(200);
      Async_Send_String('AMTOR'^M);
      Delay(200);
      Async_Send_String('BAUDOT'^M);
      PGMCMD_WORDOUT;
      Delay(500);
      Async_Purge_Buffer;
      PTWClose;
      Async_Send_String('OPMODE'^M);
    END;

  PROCEDURE SWITCH_DEV_MODE;            {ALT/F1...ALT/F10}
    VAR chx, echx : Char;
    BEGIN
      PTWOpen(5);
      ClrScr;
      WriteLn;
      WriteLn(' PK-232 MODE SELECT');
      WriteLn;
      WriteLn(' F1 -> VHF-PACKET');
      WriteLn(' F2 -> RF-PACKET');
      WriteLn(' F3 -> AMTOR/FEC');
      WriteLn(' F4 -> AMTOR-L');
      WriteLn(' F5 -> RTTY (Baudot)');
      RDelay(5000.0, chx, echx);
      PTWClose;

      CASE Ord(echx) OF

        59   : SDM_PR_VHF;
        60   : SDM_PR_RF;
        61   : SDM_AMTOR;
        62   : SDM_AMTOR_L;
        63   : SDM_RTTY;

      ELSE
      END;
    END;

    {------------------------------------------------------------------------+
    | Init the DEVICE                                                        |
    +------------------------------------------------------------------------}

  PROCEDURE InitDevice;

    VAR daycmdstr : STRING[40]; cha : Char;
    BEGIN
      IF Async_CTS_On THEN BEGIN
        Async_Send_String(^Q^X);        {unlock it from possible locks}
        {Wait for return strings and flush}
        IF ParamStr(1) <> 'N' THEN BEGIN
        Delay(500);
        IF ParamStr(1) = 'R' THEN
          RESETTNC('PK232.PAR');
        WriteLn;
        WriteLn('...please wait..!');
        Async_Send_string(^C'RESTART'^M);
        Delay(1000);
        daycmdstr := 'DAYTIME '+qdate+qtime+^M; {set TNC's date & time}
        Async_Send_String(daycmdstr);
        Delay(1000);
        Async_Send_String('CHSWITCH $00'^M); {Streamswitch char is ^@}
        Delay(500);
        Async_Send_String('XFLOW ON'^M); {SW flow control for file-send - OFF does NOT work}
        Delay(500);
        Async_Purge_Buffer;
        DevMode := Unknown;
        SDM_PR_VHF;
        END;
      END ELSE BEGIN
        WriteLn('**** Cannot sense RTS from TNC **** Init failed, use ALT/X to exit ***');
        Delay(3000);
      END;
    END;

    {------------------------------------------------------------------------+
    | Shutdown the DEVICE.                                                   |
    +------------------------------------------------------------------------}

  PROCEDURE Shutdowndevice;

    BEGIN
      IF Async_CTS_On THEN BEGIN
        Async_Send_String(^S);
        Delay(500);
        Async_Purge_Buffer;             { and flush it }
      END;
    END;

    {$I SSS_MAIN.PAS }
