{$R-,V-,S-} (*Range, Var-String, Stack checking all off *)
PROGRAM CATY767;
(**)

USES
    CRT, DOS,                          (* Unit files for general functions *)
    Y767GLO, Y767UTIL, Y767DISP,       (* Specific to this pgm *)
    Y767INST, Y767COMM, Y767RTC;

(**)
PROCEDURE DoQuit; (* Shut down communications and exit *)

BEGIN (* DoQuit *)
    WINDOW(2,6,79,23);
    CLRSCR;
    TEXTCOLOR(DFG);
    TEXTBACKGROUND(DBG);                     (* Default screen colors *)
    PrMessage('Restoring the normal timer interrupt.',8);
    RestoreOldTimer;                         (* Restore timer int vector *)
    IF NOT Test THEN BEGIN
        TurnCatOff;
        GOTOXY(30,9);
        Peep(1500);
        WRITE('Port COM',ComPort,': closed OK.');
        DELAY(800);
    END; (* IF NOT *)
    WINDOW(1,1,80,25);
    CLRSCR;                                  (* Clear screen on exit *)
END; (* DoQuit *)

(**)
PROCEDURE SetupFT767; (* Set up basic program functions *)

BEGIN (* SetupFT767 *)
    ComPort            := 1;                 (* Default is COM1: *)
    ComVec             := 12;
    ComBase            := $3F8;
    IRQM               := $10;
    CLRSCR;
    IF PARAMCOUNT > 0 THEN                   (* Command line parameters *)
        IF (PARAMSTR(1) = '/2') THEN BEGIN    (* Values for COM2: *)
            ComPort    := 2;
            ComVec     := 11;
            ComBase    := $2F8;
            IRQM       := $08;
        END; (* IF PARAMSTR(1) *)
        IF (PARAMSTR(2) = '/D') OR (PARAMSTR(2) = '/d') THEN BEGIN
            TimeZone   := TimeZone - 1;      (* For Daylight Saving Time *)
            TZ         := ' EDT ';           (* Set up prompt *)
        END; (* IF PARAMSTR(2) *)
    IF mem[$0040:$0049] = 7 THEN             (* Get video parameters *)
         ScreenSeg     := $B000              (* Monochrome display addressing *)
    ELSE ScreenSeg     := $B800;             (* CGA, EGA display addressing *)
    DirectVideo        := TRUE;              (* Don't use BIOS for video *)
    InitClock;                               (* Initialize clock interrupt *)
    MainFrame;                               (* Build screens framework *)
    IF NOT Test THEN BEGIN                   (* This is for real *)
        SetupSerialPort(ComPort,ComVec,ComBase,IRQM); (* Get COM_ interrupts ready *)
        TurnCatOn;                           (* To get initial UPDATE *)
        CatSend(AClr,26);                    (* Turn off Split, Clar, Offset *)
    END (* IF NOT *)
    ELSE TestFile;                           (* Test, read in simulated Update *)

END; (* SetupFT767 *)

BEGIN (*================= MAINLINE CONTROL ROUTINE ========================*)
    CLRSCR;
    ZeroVariables;                           (* Initialize all globals *)
    FILLCHAR(MemArray,SIZEOF(MemArray),' '); (* Initialize text array *)
    QuitFlag := FALSE;                       (* Set Quit flag *)
    SetupFT767;                              (* Set up housekeeping *)
    REPEAT
        MainMenu;                            (* Loop `til EXIT key (F10) *)
    UNTIL QuitFlag;
    Quit := TRUE;
    DoQuit;                                  (* Do an orderly shutdown *)
END. (* MAINLINE CONTROL ROUTINE *)

