

// 3D FIX MONITOR, GPS MOTOROLA BINARY PROTOCOL v1
// YO4HFU - Pastorcici Robert, 15.03.2023
// Free to use or modify. Please specify my callsign.
// Tested with Jupiter TU60-D125
// Initialization of GPS receiver after startup (@@Ea every 2 secons, mask elevation 10 degree, TRAIM enabled & 1pps control)
// Indication of GPS receiver status by LED connected between port 12 and +5V. Steady indication for 3D Fix, otherwise flashing mode (according status byte detection)

// For timing application is recommended Position Hold mode. Site location is required, can be obtained by Motorola WinOncore software / Survey Window.
// 1st step: Set Position: (@@Ad, @@Ae, @@Af), @@As
// 2nd step: send Position Hold mode @@At01. In this case @Ea receiver status byte will be always 0x08 "Aquisition/Position mode".



#define BUFFER_SIZE 76 // @@Ea status received from GPS has 76 bytes length
#define LED_PIN 12 // LED port 12

void setup() {
  Serial.begin(9600);    // initialize serial communication at 9600 bits per second
  pinMode(LED_PIN, OUTPUT); // set the LED pin as output
  digitalWrite(LED_PIN, HIGH); // clear LED pin to HIGH, LED Connected between pin 12 and +5V (inverted logic)
  
  delay(250); // Wait 250 milliseconds after power on
  
  // Position/Status Enable command
  Serial.write("@@Ea"); // send 40 40 45 61 (hex) over Serial
  Serial.write(0x02); // enable, rate every 2 seconds
  Serial.write(0x26); // XOR Checksum of 45 61 02
  Serial.write(0x0D); //CR
  Serial.write(0x0A); //LF
  delay(50);

  
 // Mask Angle command 
  Serial.write("@@Ag"); // send 40 40 41 67 (hex) over Serial
  Serial.write(0x0A); // 10 degrees elevation mask
  Serial.write(0x2C); // XOR checksum of 41 67 0A
  Serial.write(0x0D); //CR
  Serial.write(0x0A); //LF
  delay(50);


  // TRAIM Setup command sent
  Serial.write("@@En"); // send 40 40 41 6E (hex) over Serial
  Serial.write(0x00); // @@En 000100080300000100000000000000 (1pps active if TRAIM OK, 800nsec)
  Serial.write(0x01); // 
  Serial.write(0x00); // 
  Serial.write(0x08); // 
  Serial.write(0x03); //
  Serial.write(0x00); //
  Serial.write(0x00); //
  Serial.write(0x01); //
  Serial.write(0x00); //
  Serial.write(0x00); //
  Serial.write(0x00); //
  Serial.write(0x00); //
  Serial.write(0x00); //
  Serial.write(0x00); //
  Serial.write(0x00); //
  Serial.write(0x20); // XOR checksum 
  Serial.write(0x0D); //CR
  Serial.write(0x0A); //LF
 
   }


void loop() {
  byte buffer[BUFFER_SIZE];
  int count = 0;
  
  // Wait for hex 40 40 45 61 (header @@Ea) sequence before starting to write the buffer 
  bool started = false;
  while (!started) {
    if (Serial.available()) {    // check if there is data available on Serial
      byte b = Serial.read();
      if (b == 0x40 && count == 0) { // First byte of sequence
        buffer[count] = b;
        count++;
      } else if (b == 0x40 && count == 1) { // Second byte of sequence
        buffer[count] = b;
        count++;
      } else if (b == 0x45 && count == 2) { // Third byte of sequence
        buffer[count] = b;
        count++;
      } else if (b == 0x61 && count == 3) { // Fourth byte of sequence
        buffer[count] = b;
        count++;
        started = true; // Start writing to buffer
      } else { // Other bytes, reset count
        count = 0;
      }
    }
  }
  
  // Read data until buffer is full
  while (count < BUFFER_SIZE) {    
    if (Serial.available()) {    // check if there is data available on Serial
      buffer[count] = Serial.read();   // read one byte from Serial and store it in the buffer
      count++;
    }
  }
  
  // Convert the buffer to Hexadecimal
  char hex_buffer[BUFFER_SIZE*2+1]; // +1 for null terminator
  for (int i = 0; i < BUFFER_SIZE; i++) {
    sprintf(&hex_buffer[i*2], "%02X", buffer[i]);
  }
  hex_buffer[BUFFER_SIZE*2] = '\0'; // add null terminator
  
  
  // Check the content of bytes 72-73 and control LED accordingly
  if (hex_buffer[72*2] == '6' && hex_buffer[72*2+1] == '0') {
    
    // 3D Fix, Poor Geometry
    digitalWrite(LED_PIN, LOW); // turn on LED 
    delay(600); // wait 600ms
    digitalWrite(LED_PIN, HIGH); // turn off LED 
    delay(200); // wait 200ms
    
  } else if (hex_buffer[72*2] == '4' && hex_buffer[72*2+1] == '8') {
    
    // Acquisition, Poor Geometry
    digitalWrite(LED_PIN, LOW); // turn on LED 
    delay(600); // wait 600ms
    digitalWrite(LED_PIN, HIGH); // turn off LED 
    delay(600); // wait 600ms
    
  } else if (hex_buffer[72*2] == '4' && hex_buffer[72*2+1] == '0') {
    
   // Poor Geometry
    digitalWrite(LED_PIN, LOW); // turn on LED 
    delay(600); // wait 600ms
    digitalWrite(LED_PIN, HIGH); // turn off LED 
    delay(600); // wait 600ms

   } else if (hex_buffer[72*2] == '1' && hex_buffer[72*2+1] == '0') {
    
    // 2D Fix
    digitalWrite(LED_PIN, LOW); // turn on LED 
    delay(350); // wait 350ms
    digitalWrite(LED_PIN, HIGH); // turn off LED 
    delay(350); // wait 350ms

   } else if (hex_buffer[72*2] == '0' && hex_buffer[72*2+1] == '8') {
      
   // Acqusition / Position Hold
    digitalWrite(LED_PIN, LOW); // turn on LED 
    delay(600); // wait 600ms
    digitalWrite(LED_PIN, HIGH); // turn off LED 
    delay(600); // wait 600ms
    
  } else if (hex_buffer[72*2] == '2' && hex_buffer[72*2+1] == '0') {
    
    // 3D Fix
    digitalWrite(LED_PIN, LOW); // turn on LED 
    }
    else {
    digitalWrite(LED_PIN, HIGH); // turn off LED 
  }
    }


    
