/*
 
  ADF41513 N DIVIDER MODE UP TO 26GHz
  Source:http://www.g8ajn.tv/dlother3.html
  Modified by YO4HFU / 2019
  ******************************************************
  ARDUINO ATTINY85 pins: 
  SWITCH = port 4, PIN 3
  PLL CLK = port 2, PIN 7
  PLL DATA = port 1, PIN 6  
  PLL LE = port 0, PIN 5
  
  Switch connected between pin 3 and GND. Used to change N divider ratio: 100 or 1000.
  *******************************************************
  CLOCK WIDTH = 0,01 msec (8MHz)
 */
 //MUX 1.8V=300mVpp/50ohms; 3.3V=1.1Vpp/50ohms
 
 //Registers calculated by ADF41513 software. MSB first. Send R13 to R0, 32 bit
 
  const unsigned long R13_A = 0xD; // Divider N = 100, Variable Modulus OFF, Prescaler 4/5, MUXOUT N Div, Out level 1.8V
  const unsigned long R12_A = 0x4000000C; 
  const unsigned long R11_A = 0xB;
  const unsigned long R10_A = 0xA;
  const unsigned long R9_A = 0x9;
  const unsigned long R8_A = 0x8;
  const unsigned long R7_A = 0x200407;
  const unsigned long R6_A = 0x100006;
  const unsigned long R5_A = 0x4E010015;
  const unsigned long R4_A = 0x4;
  const unsigned long R3_A = 0x3;
  const unsigned long R2_A = 0x12;
  const unsigned long R1_A = 0x1;
  const unsigned long R0_A = 0x640;
  
  const unsigned long R13_B = 0xD; // Divider N = 1000, Variable Modulus OFF, Prescaler 8/9, MUXOUT N Div, Out level 1.8V
  const unsigned long R12_B = 0x4000000C; 
  const unsigned long R11_B = 0xB;
  const unsigned long R10_B = 0xA;
  const unsigned long R9_B = 0x9;
  const unsigned long R8_B = 0x8;
  const unsigned long R7_B = 0x200407;
  const unsigned long R6_B = 0x100006;
  const unsigned long R5_B = 0x4E810015; // Here is difference for 8/9
  const unsigned long R4_B = 0x4;
  const unsigned long R3_B = 0x3;
  const unsigned long R2_B = 0x12;
  const unsigned long R1_B = 0x1;
  const unsigned long R0_B = 0x00003E80; //00003E80 for N = 1000 (possible only with 8/9)
  
  int bp;
  int SWstate = 0; //variable for reading the Switch
  unsigned long DTA;
  
  const int LE =  0; // Arduino port
  const int DATA =  1;
  const int CLK =  2;
  const int SWpin = 4;
  


void setup() {       
  pinMode (LE, OUTPUT);  // latch 
  pinMode (CLK, OUTPUT);  // clock
  pinMode (DATA, OUTPUT);  // data
  pinMode (SWpin, INPUT); //switch input
  digitalWrite(SWpin, HIGH); // turn on pullup resistor
  
  digitalWrite(LE,LOW); // clear LE line
  digitalWrite(CLK,LOW); // clear CLK line


//while(true) { // While enable: Start loop and send SPI signals forever. Better to not use due output jitter.
                 // While disable: Power ON, read Switch and send SPI only one time. Need power restart in case of switch changed.
    
 SWstate = digitalRead(SWpin); //Read Switch input
 if (SWstate == HIGH) { 
 
 
 DTA = R13_A;    // Send setup parameters_1
 SendWord();
 DTA = R12_A;
 SendWord();
 DTA = R11_A;
 SendWord();
 DTA = R10_A;
 SendWord();
 DTA = R9_A;
 SendWord();
 DTA = R8_A;
 SendWord();
 DTA = R7_A;
 SendWord();
 DTA = R6_A;
 SendWord();
 DTA = R5_A;
 SendWord();
 DTA = R4_A;
 SendWord();
 DTA = R3_A;
 SendWord();
 DTA = R2_A;
 SendWord();
 DTA = R1_A;
 SendWord();
 DTA = R0_A;
 SendWord();
 }  
 
 else {
 
 
 DTA = R13_B;    // Send setup parameters_2
 SendWord();
 DTA = R12_B;
 SendWord();
 DTA = R11_B;
 SendWord();
 DTA = R10_B;
 SendWord();
 DTA = R9_B;
 SendWord();
 DTA = R8_B;
 SendWord();
 DTA = R7_B;
 SendWord();
 DTA = R6_B;
 SendWord();
 DTA = R5_B;
 SendWord();
 DTA = R4_B;
 SendWord();
 DTA = R3_B;
 SendWord();
 DTA = R2_B;
 SendWord();
 DTA = R1_B;
 SendWord();
 DTA = R0_B;
 SendWord();
} 
delay (500); //jitter reduced due SPI refresh

//}   // uncomment togheter with "while true"

}



void loop() {  } // loop closed
   
   
  int SendWord() {
  bp = 32;
  do{
  bp = bp - 1;   //loop through bit positions 32 to 0
  digitalWrite(CLK,LOW); 
  digitalWrite(DATA, bitRead(DTA,bp) ); 
  digitalWrite(CLK,HIGH); 
  }while(bp>0); 
  
  digitalWrite(CLK,LOW); 
  digitalWrite(DATA,LOW);

  digitalWrite(LE,HIGH);   // Set LE to latch data
  delayMicroseconds(5); // 
  digitalWrite(LE,LOW);
}
