VERSION 2.00
Begin Form Main 
   BackColor       =   &H8000000B&
   Caption         =   "KLI Node Reporter 1.10"
   ClientHeight    =   3270
   ClientLeft      =   5895
   ClientTop       =   5070
   ClientWidth     =   5925
   Height          =   3675
   Icon            =   MAIN.FRX:0000
   Left            =   5835
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   ScaleHeight     =   3270
   ScaleWidth      =   5925
   Top             =   4725
   Width           =   6045
   Begin Socket Mail 
      AutoResolve     =   0   'False
      Backlog         =   5
      Binary          =   -1  'True
      Blocking        =   0   'False
      Broadcast       =   0   'False
      BufferSize      =   0
      ByteOrder       =   1  'Network
      HostAddress     =   "192.168.0.1"
      HostFile        =   ""
      HostName        =   ""
      InLine          =   0   'False
      Interval        =   0
      KeepAlive       =   0   'False
      Left            =   4020
      Linger          =   0
      LocalPort       =   0
      LocalService    =   ""
      Protocol        =   0
      RemotePort      =   0
      RemoteService   =   "smtp"
      ReuseAddress    =   0   'False
      Route           =   -1  'True
      SocketType      =   1
      Timeout         =   0
      Top             =   2100
   End
   Begin Socket Heard 
      AutoResolve     =   0   'False
      Backlog         =   5
      Binary          =   -1  'True
      Blocking        =   0   'False
      Broadcast       =   0   'False
      BufferSize      =   0
      ByteOrder       =   1  'Network
      HostAddress     =   ""
      HostFile        =   ""
      HostName        =   ""
      InLine          =   0   'False
      Interval        =   0
      KeepAlive       =   0   'False
      Left            =   4500
      Linger          =   0
      LocalPort       =   0
      LocalService    =   ""
      Protocol        =   0
      RemotePort      =   0
      RemoteService   =   ""
      ReuseAddress    =   0   'False
      Route           =   -1  'True
      SocketType      =   1
      Timeout         =   0
      Top             =   2100
   End
   Begin Socket Clock 
      AutoResolve     =   0   'False
      Backlog         =   5
      Binary          =   -1  'True
      Blocking        =   0   'False
      Broadcast       =   0   'False
      BufferSize      =   0
      ByteOrder       =   1  'Network
      HostAddress     =   "192.168.0.1"
      HostFile        =   ""
      HostName        =   ""
      InLine          =   0   'False
      Interval        =   0
      KeepAlive       =   0   'False
      Left            =   4980
      Linger          =   0
      LocalPort       =   0
      LocalService    =   ""
      Protocol        =   0
      RemotePort      =   0
      RemoteService   =   ""
      ReuseAddress    =   0   'False
      Route           =   -1  'True
      SocketType      =   1
      Timeout         =   0
      Top             =   2100
   End
   Begin Timer MyTimer 
      Interval        =   1000
      Left            =   5460
      Top             =   1620
   End
   Begin Socket Gateway 
      AutoResolve     =   0   'False
      Backlog         =   5
      Binary          =   -1  'True
      Blocking        =   0   'False
      Broadcast       =   0   'False
      BufferSize      =   0
      ByteOrder       =   1  'Network
      HostAddress     =   "192.168.0.1"
      HostFile        =   ""
      HostName        =   ""
      InLine          =   0   'False
      Interval        =   0
      KeepAlive       =   0   'False
      Left            =   5460
      Linger          =   0
      LocalPort       =   0
      LocalService    =   ""
      Protocol        =   0
      RemotePort      =   0
      RemoteService   =   ""
      ReuseAddress    =   0   'False
      Route           =   -1  'True
      SocketType      =   1
      Timeout         =   0
      Top             =   2100
   End
   Begin Line Line 
      Index           =   1
      X1              =   180
      X2              =   5700
      Y1              =   2460
      Y2              =   2460
   End
   Begin Label MyInfo 
      AutoSize        =   -1  'True
      BackStyle       =   0  'Transparent
      Caption         =   "0 Bps"
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "Verdana"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   195
      Index           =   6
      Left            =   3300
      TabIndex        =   2
      Top             =   2100
      Width           =   480
   End
   Begin Label MyInfo 
      AutoSize        =   -1  'True
      BackStyle       =   0  'Transparent
      Caption         =   "0 Paket"
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "Verdana"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   195
      Index           =   5
      Left            =   3300
      TabIndex        =   14
      Top             =   1860
      Width           =   645
   End
   Begin Label MyInfo 
      AutoSize        =   -1  'True
      BackStyle       =   0  'Transparent
      Caption         =   "0 Byte"
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "Verdana"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   195
      Index           =   4
      Left            =   3300
      TabIndex        =   13
      Top             =   1620
      Width           =   555
   End
   Begin Label MyInfo 
      AutoSize        =   -1  'True
      BackStyle       =   0  'Transparent
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "Verdana"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      ForeColor       =   &H00FFFFFF&
      Height          =   195
      Index           =   3
      Left            =   3300
      TabIndex        =   12
      Top             =   2880
      Width           =   60
   End
   Begin Label MyInfo 
      AutoSize        =   -1  'True
      BackStyle       =   0  'Transparent
      Caption         =   "Belum Tersinkron"
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "Verdana"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      ForeColor       =   &H00FFFFFF&
      Height          =   195
      Index           =   2
      Left            =   3300
      TabIndex        =   11
      Top             =   2640
      Width           =   1515
   End
   Begin Label MyInfo 
      AutoSize        =   -1  'True
      BackStyle       =   0  'Transparent
      Caption         =   "Mencoba hubungan..."
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "Verdana"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   195
      Index           =   1
      Left            =   3300
      TabIndex        =   10
      Top             =   1380
      Width           =   1830
   End
   Begin Label MyInfo 
      AutoSize        =   -1  'True
      BackStyle       =   0  'Transparent
      Caption         =   "KLI Network Gateway"
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "Verdana"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   195
      Index           =   0
      Left            =   3300
      TabIndex        =   9
      Top             =   1140
      Width           =   1860
   End
   Begin Label Info 
      AutoSize        =   -1  'True
      BackStyle       =   0  'Transparent
      Caption         =   "Kecepatan Akses Rata-Rata"
      FontBold        =   -1  'True
      FontItalic      =   0   'False
      FontName        =   "Verdana"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   195
      Index           =   7
      Left            =   180
      TabIndex        =   8
      Top             =   2100
      Width           =   2685
   End
   Begin Label Info 
      AutoSize        =   -1  'True
      BackStyle       =   0  'Transparent
      Caption         =   "Jumlah Transaksi Paket AX.25"
      FontBold        =   -1  'True
      FontItalic      =   0   'False
      FontName        =   "Verdana"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   195
      Index           =   6
      Left            =   180
      TabIndex        =   7
      Top             =   1860
      Width           =   2940
   End
   Begin Label Info 
      AutoSize        =   -1  'True
      BackStyle       =   0  'Transparent
      Caption         =   "Jumlah Transaksi Byte"
      FontBold        =   -1  'True
      FontItalic      =   0   'False
      FontName        =   "Verdana"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   195
      Index           =   5
      Left            =   180
      TabIndex        =   6
      Top             =   1620
      Width           =   2205
   End
   Begin Label Info 
      AutoSize        =   -1  'True
      BackStyle       =   0  'Transparent
      Caption         =   "Waktu Tersinkron"
      FontBold        =   -1  'True
      FontItalic      =   0   'False
      FontName        =   "Verdana"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      ForeColor       =   &H00FFFFFF&
      Height          =   195
      Index           =   4
      Left            =   180
      TabIndex        =   5
      Top             =   2880
      Width           =   1740
   End
   Begin Label Info 
      AutoSize        =   -1  'True
      BackStyle       =   0  'Transparent
      Caption         =   "Akses Jam Atom Internet"
      FontBold        =   -1  'True
      FontItalic      =   0   'False
      FontName        =   "Verdana"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      ForeColor       =   &H00FFFFFF&
      Height          =   195
      Index           =   3
      Left            =   180
      TabIndex        =   4
      Top             =   2640
      Width           =   2475
   End
   Begin Label Info 
      AutoSize        =   -1  'True
      BackStyle       =   0  'Transparent
      Caption         =   "Koneksi ke Gateway"
      FontBold        =   -1  'True
      FontItalic      =   0   'False
      FontName        =   "Verdana"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   195
      Index           =   2
      Left            =   180
      TabIndex        =   3
      Top             =   1380
      Width           =   1965
   End
   Begin Label Info 
      AutoSize        =   -1  'True
      BackStyle       =   0  'Transparent
      Caption         =   "Jenis Gateway"
      FontBold        =   -1  'True
      FontItalic      =   0   'False
      FontName        =   "Verdana"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   195
      Index           =   1
      Left            =   180
      TabIndex        =   1
      Top             =   1140
      Width           =   1395
   End
   Begin Line Line 
      Index           =   0
      X1              =   180
      X2              =   5700
      Y1              =   960
      Y2              =   960
   End
   Begin Label Info 
      BackStyle       =   0  'Transparent
      Caption         =   "Program ini memungkinkan emulasi Node, membentuk laporan aktivitas secara berkala ke email serta melakukan sinkronisasi waktu dengan jam atom Internet"
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "Verdana"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   615
      Index           =   0
      Left            =   780
      TabIndex        =   0
      Top             =   180
      Width           =   4995
   End
   Begin Image MyImage 
      Height          =   480
      Left            =   180
      Top             =   240
      Width           =   480
   End
End
Option Explicit

'Mail process
Dim TMPFile As String
Dim MailFrom As String
Dim RcptTo As String
Dim Body As String
Dim MailStep As Integer

'Time shift
Dim Shift As String

Sub Clock_Disconnect ()

    Clock.Action = 7

End Sub

Sub Clock_LastError (ErrorCode As Integer, ErrorString As String, Response As Integer)

    MyInfo(2).Caption = "Hubungan terputus..."
    Clock_Disconnect

End Sub

Sub Clock_Read (DataLength As Integer, IsUrgent As Integer)

    On Local Error GoTo AnyError:

    Dim Text As String
    Clock.RecvLen = DataLength
    Text = Clock.RecvData

    'Sample data of 'TEXT'
    '....*....1....*....2....*....3....*....4....*...
    '52440 02-06-15 01:02:32 50 0 0 919.9 UTC(NIST) *

    'Link status at byte 30th
    Dim xLink As Integer
    xLink = CInt(Mid(Text, 31, 1))
    If xLink < 2 Then
        
        Dim xYear As String
        Dim xMonth As String
        Dim xDay As String
        Dim xDate As String
        Dim xTime As String
        Dim Result As Currency

        'Get current date and time
        xYear = "20" + Mid(Text, 8, 2)
        xMonth = Mid(Text, 11, 2)
        xDay = Mid(Text, 14, 2)
        xDate = xMonth + "/" + xDay + "/" + xYear
        xTime = Mid(Text, 17, 8)
        Result = DateValue(xDate) + TimeValue(xTime) + TimeValue(Shift)

        'Set date & time
        Date = Format(Result, "mm/dd/yyyy")
        Time = Format(Result, "hh:mm:ss")
        MyInfo(2).Caption = "Sinkronisasi waktu berhasil"
    
    Else
        
        MyInfo(2).Caption = "Waktu kurang presisi"

    End If

EndSub:
    Exit Sub

AnyError:
    MyInfo(2).Caption = "Gagal membaca format"
    Clock.Action = 7
    Resume EndSub

End Sub

Sub Form_Load ()
    
    If App.PrevInstance Then End

    'Access gateway properties
    Gateway.HostAddress = ReadProfile("Gateway", "Address")
    Gateway.RemotePort = CInt(ReadProfile("Gateway", "Port"))
    Select Case UCase(ReadProfile("Gateway", "Type"))
    Case "KLINETGW": gType = 2
    Case "PSKTELNET": gType = 1
    Case Else: gType = 0
    End Select
    Gateway.Action = 2

    'Access application callsign properties
    gSource = ReadProfile("Application", "Source")
    gDestination = ReadProfile("Application", "Destination")
    gDigi = ReadProfile("Application", "Digi")

    'Access atomic-clock server
    Clock.HostAddress = ReadProfile("Clock", "Address")
    Clock.RemotePort = CInt(ReadProfile("Clock", "Port"))
    Shift = ReadProfile("Clock", "Shift")

    'Heard Server settings
    Heard.LocalPort = CInt(ReadProfile("Application", "Port"))
    Heard.Action = 3

    'Mail Server settings
    Mail.HostAddress = ReadProfile("Mail", "SMTPAddress")
    Mail.RemotePort = CInt(ReadProfile("Mail", "SMTPPort"))

    'Window settings
    If CInt(ReadProfile("Application", "Minimized")) Then WindowState = 1
    MyImage.Picture = Icon
    left = Screen.Width - Width - 120
    Top = Screen.Height - Height - 600

    'Type of gateway display
    Select Case gType
    Case 2: MyInfo(0).Caption = "KLI Network Gateway"
    Case 1: MyInfo(0).Caption = "KLI PSKTelnet"
    Case 0: MyInfo(0).Caption = "Generic"
    End Select

    'Redim variable
    ReDim xCall(0)
    ReDim xPacket(0)
    ReDim xByte(0)
    ReDim xHeard(0)
    LoadData
    Gateway_Read 0, 0

    'Test Time Server
    Clock.Action = 2

End Sub

Sub Form_QueryUnload (Cancel As Integer, UnloadMode As Integer)

    Form_Unload False

End Sub

Sub Form_Unload (Cancel As Integer)

    SaveData

End Sub

Sub Gateway_Connect ()

    MyInfo(1).Caption = "Terhubung"

End Sub

Sub Gateway_Disconnect ()
    
    MyInfo(1).Caption = "Tidak Terhubung"
    Gateway.Action = 7

End Sub

Sub Gateway_LastError (ErrorCode As Integer, ErrorString As String, Response As Integer)
    
    Gateway_Disconnect

End Sub

Sub Gateway_Read (DataLength As Integer, IsUrgent As Integer)

    Dim Text As String
    Dim Channel As Integer
    Dim Code As Integer
    Dim Length As Integer
    Dim toPos As Integer
    Dim Counter As Integer
    Static LastCall As String

    If DataLength <> 0 Then

        Gateway.RecvLen = DataLength
        Text = Gateway.RecvData
    
        TFDecode Text, Channel, Code, Length, Text
        Select Case Code
        Case 4, 5:
            
            'Get source callsign portion
            LastCall = Mid(Text, 4)
            toPos = InStr(LastCall, " to ")
            If toPos > 0 Then
                LastCall = Left(LastCall, toPos - 1)
            End If
    
            'Remove SSID portion
            toPos = InStr(LastCall, "-")
            If toPos > 0 Then
                LastCall = Left(LastCall, toPos - 1)
            End If
    
            'Find callsign
            Dim Found As Integer
            Found = 0
            For Counter = 1 To UBound(xCall)
                If LastCall = xCall(Counter) Then
                    xHeard(Counter) = Now
                    xPacket(Counter) = xPacket(Counter) + 1
                    Found = -1
                    Exit For
                End If
            Next
            If Not Found Then
                'Add a callsign
                Counter = UBound(xCall) + 1
                ReDim Preserve xCall(Counter)
                ReDim Preserve xPacket(Counter)
                ReDim Preserve xBytes(Counter)
                ReDim Preserve xHeard(Counter)
                ReDim Preserve xSystem(Counter)
                ReDim Preserve xRole(Counter)
                ReDim Preserve xQTH(Counter)
    
                'Fill basic data
                xCall(Counter) = LastCall
                xHeard(Counter) = Now
                xPacket(Counter) = 1
                xSystem(Counter) = ""
                xRole(Counter) = ""
                xQTH(Counter) = ""
            End If
    
            TotalPacket = TotalPacket + 1
        
        Case 6:
            'Find callsign, it must be founded
            For Counter = 1 To UBound(xCall)
                If LastCall = xCall(Counter) Then
                    xBytes(Counter) = xBytes(Counter) + Length

                    'Extended station information
                    Dim MyBuff As String
                    Dim Pos As Integer
                    MyBuff = Trim(Text)
                    
                    If Left(MyBuff, 7) = "BEACON:" Then
                        Pos = InStr(MyBuff, " ")
                        If Pos > 0 Then
                            
                            'Beacon?
                            xSystem(Counter) = Mid(MyBuff, 8, Pos - 8)
                            MyBuff = Trim(Mid(MyBuff, Pos + 1))

                            'QTH?
                            Pos = InStr(MyBuff, "QTH:")
                            If Pos > 0 Then
                                xQTH(Counter) = Mid(MyBuff, Pos + 4)
                                MyBuff = Trim(Left(MyBuff, Pos - 1))
                                
                                'Check for SPACE
                                Pos = InStr(xQTH(Counter), " ")
                                If Pos > 0 Then xQTH(Counter) = Left(xQTH(Counter), Pos - 1)

                                'Check for ENTER
                                Pos = InStr(xQTH(Counter), Chr(13))
                                If Pos > 0 Then xQTH(Counter) = Left(xQTH(Counter), Pos - 1)

                                'Set station role
                                If Left(MyBuff, 5) = "ROLE:" Then
                                    xRole(Counter) = Mid(MyBuff, 6)
                                End If

                            End If
                        End If
                    End If
                    LastCall = ""

                    Exit For
                End If
            Next
            
            TotalByte = TotalByte + Length
    
        End Select

    End If
    
    MyInfo(4).Caption = Format(TotalByte, "#,##0") + " Byte"
    MyInfo(5).Caption = Format(TotalPacket, "#,##0") + " Paket"

End Sub

Sub Heard_Accept (SocketID As Integer)

    Dim Text As String
    Dim vbCrLf As String

    If Not Heard.Connected Then
        Heard.Action = 4
        
        vbCrLf = Chr(13) + Chr(10)
        Text = "[KLINODE-" + Right(App.Title, 4) + "-HM$]" + vbCrLf + "65535 BYTES AVAILABLE" + vbCrLf
        Heard.SendLen = Len(Text)
        Heard.SendData = Text
        Heard_Read 0, 0
    End If

End Sub

Sub Heard_Disconnect ()

    Heard.Action = 7

    Do While Heard.State <> 0
        DoEvents
    Loop

    Heard.Action = 3

End Sub

Sub Heard_LastError (ErrorCode As Integer, ErrorString As String, Response As Integer)

    Heard_Disconnect

End Sub

Sub Heard_Read (DataLength As Integer, IsUrgent As Integer)

    Dim Text As String
    Dim vbCrLf As String
    Dim Pos As Integer
    Dim Counter As Integer
    Static Buffer As String

    vbCrLf = Chr(13) + Chr(10)

    Heard.RecvLen = DataLength
    Text = Heard.RecvData
    Buffer = Buffer + Text
    Text = ""

    Pos = InStr(Buffer, Chr(13))
    If Pos > 0 Then

        'Get first portion part
        Text = Left(Buffer, Pos - 1)
        Buffer = Mid(Buffer, Pos + 1)
        If Left(Buffer, 1) = Chr(10) Then Buffer = Mid(Buffer, 2)

        Select Case UCase(Left(Text, 1))
        Case "B" 'Bye
            Heard_Disconnect
        
        Case "J" 'JustHeard
            Text = JustHeard()

        Case "T" 'Time
            Text = "Atomic Clock " + Format(Now - TimeValue(Shift), "dd-mmm-yy hh:mm:ss") + vbCrLf
            Text = Text + "Local Time   " + Format(Now, "dd-mmm-yy hh:mm:ss") + vbCrLf
        
        Case "S" 'Status
            Text = Status()
        
        Case "H", "?" 'Help
            Dim hFile As Integer
            hFile = FreeFile
            Open App.Path + "\Help.TXT" For Input As #hFile
            Text = Input(LOF(hFile), hFile)
            Close hFile

        Case Else
            Text = " "

        End Select

    End If

    If Heard.Connected Then
        If Text <> "" Or DataLength = 0 Then
            Text = Text + vbCrLf + "ENTER COMMAND: B,J,T,S or Help >" + vbCrLf
            Heard.SendLen = Len(Text)
            Heard.SendData = Text
        End If
    End If

End Sub

Function JustHeard ()

    Dim Text As String
    Dim Counter As Integer
    Dim vbCrLf As String

    Dim bCall As String
    Dim bByte As String
    Dim bPacket As String
    Dim bSystem As String
    Dim bRole As String
    Dim bQTH As String

    vbCrLf = Chr(13) + Chr(10)

    SortData
    Text = ""
    For Counter = 1 To UBound(xCall)

        bCall = String(6, 32)
        bByte = String(7, 32)
        bPacket = String(5, 32)
        bSystem = String(10, 32)
        bRole = String(15, 32)
        bQTH = String(18, 32)

        LSet bCall = xCall(Counter)
        RSet bByte = Format(xBytes(Counter))
        RSet bPacket = Format(xPacket(Counter))
        LSet bSystem = xSystem(Counter)
        LSet bRole = xRole(Counter)
        LSet bQTH = xQTH(Counter)

        Text = Text + bCall + bPacket + bByte + " " + Format(xHeard(Counter), "dd/mm/yy hh:mm") + " " + Trim(bSystem + " " + bQTH + " " + bRole) + vbCrLf

    Next
    If Text = "" Then
        Text = "No heard callsigns in past minutes..." + vbCrLf
    Else
        Text = "Call-- Pkts Bytes- Heard--------* System---- QTH--------------- Role-----------" + vbCrLf + Text
    End If

    JustHeard = Text

End Function

Sub LoadData ()

    On Local Error GoTo LoadError:

    Dim hFile As Integer
    Dim FileName As String
    Dim Counter As Integer

    hFile = FreeFile
    FileName = App.Path + "\Logs\" + Format(Now, "YYYYMMDD") + ".HRD"
    
    If Dir(FileName) <> "" Then
        Open FileName For Input As hFile
        
        'Read Header
        Input #hFile, TotalByte
        Input #hFile, TotalPacket
        Input #hFile, Speed
        
        'Reset HEARD variable
        Input #hFile, Counter
        ReDim xCall(Counter)
        ReDim xBytes(Counter)
        ReDim xPacket(Counter)
        ReDim xHeard(Counter)
        ReDim xSystem(Counter)
        ReDim xRole(Counter)
        ReDim xQTH(Counter)
    
        'Print Contents
        For Counter = 1 To Counter
            Input #hFile, xCall(Counter), xBytes(Counter), xPacket(Counter), xHeard(Counter), xSystem(Counter), xRole(Counter), xQTH(Counter)
        Next

        Close hFile

    End If

LoadEnd:
    Exit Sub

LoadError:
    Resume LoadEnd

End Sub

Sub Mail_Disconnect ()

    Mail.Action = 7
    MailStep = 0

End Sub

Sub Mail_LastError (ErrorCode As Integer, ErrorString As String, Response As Integer)

    Mail_Disconnect

End Sub

Sub Mail_Read (DataLength As Integer, IsUrgent As Integer)

    Dim vbCrLf As String
    Dim Text As String

    vbCrLf = Chr(13) + Chr(10)
    Mail.RecvLen = DataLength
    Text = Mail.RecvData
    
    Select Case MailStep

    Case 0 'Authenticate link
        Text = "HELO localhost"
        MailStep = 1

    Case 1 'From
        Text = "MAIL FROM: <" + MailFrom + ">"
        MailStep = 2

    Case 2 'To
        Text = "RCPT TO: <" + RcptTo + ">"
        MailStep = 3
        
    Case 3 'Request to transmit body
        Text = "DATA"
        MailStep = 4

    Case 4 'Send
        Text = Body + vbCrLf + "."
        MailStep = 5

    Case 5 'Finishing...
        Text = "QUIT"
        MailStep = 6

    Case 6
        'Reset Mail
        MailFrom = ""
        RcptTo = ""
        Body = ""
        
        'Rename file
        Dim TXTFile As String
        TXTFile = Left(TMPFile, InStr(TMPFile, ".")) + "TXT"
        If Dir(TXTFile) <> "" Then Kill TXTFile
        Name TMPFile As TXTFile

    End Select

    If Text <> "" Then
        Text = Text + vbCrLf
        Mail.SendLen = Len(Text)
        Mail.SendData = Text
    End If

End Sub

Sub MyTimer_Timer ()
 
    Static Tick As Long
    Static LastByte As Single
    Static NotReset As Integer
    Dim Text As String

    Tick = Tick + 1

    'Update Sync-Clock
    MyInfo(3).Caption = Format(Now, "dd mmm yyyy hh:mm:ss")
    
    'Every new date, about 23:59:50
    If Timer > 86390 Then
        If NotReset Then
            
            'Save last data
            SaveData

            'Prepare an email...
            WriteMail
            WriteBirthday

            'Reset counters
            TotalByte = 0
            TotalPacket = 0
            Speed = 0
            ReDim xCall(0)
            ReDim xBytes(0)
            ReDim xPacket(0)
            ReDim xHeard(0)
            ReDim xSystem(0)
            ReDim xRole(0)
            ReDim xQTH(0)
            Gateway_Read 0, 0
            
            'Set flag
            NotReset = False

        End If
    Else
        NotReset = True
    End If

    If (Tick Mod 15) = 0 Then
        'Every 15 second, probe gateway
        If Gateway.State = 0 Then
            Gateway.Action = 2
            MyInfo(1).Caption = "Mencoba hubungan..."
        End If
    End If

    If (Tick Mod 60) = 0 Then
        
        If LastByte <> 0 Then
            
            'Every 1 minute, measure speed
            Speed = Int((TotalByte - LastByte) / 60)
            MyInfo(6).Caption = Format(Speed) + " Bps"
            
            'Send SYNC to all
            Text = "SYNC:" + TimeFormat() + " B:" + Format(TotalByte) + " P:" + Format(TotalPacket) + " S:" + Format(Speed)
            SendToGateway Text
    
        End If

        'Reset Bytes counters
        LastByte = TotalByte
        
    End If

    If (Tick Mod 300) = 0 Then
        'Every 5 minutes, check time server
        If Clock.State = 0 Then Clock.Action = 2

        'Also check for new mail to send
        SendMail
    End If

    If (Tick Mod 600) = 0 Then
        'Every 10 minutes, save data
        SaveData

        'Reset at longest period
        Tick = 0
    End If

End Sub

Sub SaveData ()

    Dim hFile As Integer
    Dim Counter As Integer

    hFile = FreeFile
    Open App.Path + "\Logs\" + Format(Now, "YYYYMMDD") + ".HRD" For Output As hFile
    
    Counter = UBound(xCall)

    'Print Header
    Print #hFile, TotalByte
    Print #hFile, TotalPacket
    Print #hFile, Speed
    Print #hFile, Counter

    SortData

    'Print Contents
    For Counter = 1 To Counter
        Write #hFile, xCall(Counter), xBytes(Counter), xPacket(Counter), xHeard(Counter), xSystem(Counter), xRole(Counter), xQTH(Counter)
    Next

    Close hFile

End Sub

Sub SendMail ()

    Dim hFile As Integer
    Dim Temp As String

    hFile = FreeFile
    TMPFile = Dir(App.Path + "\Mail\*.TMP")

    If TMPFile <> "" Then
        TMPFile = App.Path + "\Mail\" + TMPFile
        Open TMPFile For Input As #hFile
        Line Input #hFile, MailFrom
        Line Input #hFile, RcptTo
        Do While Not EOF(hFile)
            Line Input #hFile, Temp
            Body = Body + Temp + Chr(13) + Chr(10)
        Loop
        Close hFile
        Mail.Action = 2
    End If

End Sub

Sub SendToGateway (Text As String)

    Dim Divider As String
    Dim vbCrLf As String
    
    Divider = Chr(255) + Chr(127)
    vbCrLf = Chr(13) + Chr(10)
    
    'Send only when gateway is connected
    If Gateway.Connected Then
        Select Case gType
        
        Case 2 'KLINetGW
            If Len(Text) > 256 Then Text = Left(Text, 256)
            Text = Divider + gSource + " " + Trim(gDestination + " " + gDigi) + Divider + Text
        
        Case 1 'PSKTelnet
            If Right(Text, 2) <> vbCrLf Then Text = Text + vbCrLf
            Text = Divider + gSource + "@" + gDestination + " " + Text
        
        Case Else 'Plain
        End Select
        
        Gateway.SendLen = Len(Text)
        Gateway.SendData = Text
        DoEvents
    End If

End Sub

Sub SortData ()

    Dim bCall As String
    Dim bBytes As Single
    Dim bPacket As Integer
    Dim bHeard As Double
    Dim bSystem As String
    Dim bRole As String
    Dim bQTH As String

    Dim Counter1 As Integer
    Dim Counter2 As Integer

    For Counter1 = 1 To UBound(xCall)
        For Counter2 = 1 To UBound(xCall)
            If xHeard(Counter1) > xHeard(Counter2) Then
                
                'Save
                bCall = xCall(Counter1)
                bBytes = xBytes(Counter1)
                bPacket = xPacket(Counter1)
                bHeard = xHeard(Counter1)
                bSystem = xSystem(Counter1)
                bRole = xRole(Counter1)
                bQTH = xQTH(Counter1)

                'Replace
                xCall(Counter1) = xCall(Counter2)
                xBytes(Counter1) = xBytes(Counter2)
                xPacket(Counter1) = xPacket(Counter2)
                xHeard(Counter1) = xHeard(Counter2)
                xSystem(Counter1) = xSystem(Counter2)
                xRole(Counter1) = xRole(Counter2)
                xQTH(Counter1) = xQTH(Counter2)

                'Swap
                xCall(Counter2) = bCall
                xBytes(Counter2) = bBytes
                xPacket(Counter2) = bPacket
                xHeard(Counter2) = bHeard
                xSystem(Counter2) = bSystem
                xRole(Counter2) = bRole
                xQTH(Counter2) = bQTH
                
            End If
        Next
    Next

End Sub

Function Status ()

    Dim Text As String
    Dim vbCrLf As String
    vbCrLf = Chr(13) + Chr(10)

    Text = "Operating System   Windows " + Version() + vbCrLf
    Text = Text + "Node Name          " + gSource + vbCrLf
    Text = Text + "Current Speed     " + Str(Speed) + " Bps" + vbCrLf
    Text = Text + "Bytes Transacted   " + Format(TotalByte, "#,##0") + " Bytes" + vbCrLf
    Text = Text + "Packets Transacted " + Format(TotalPacket, "#,##0") + " Packets" + vbCrLf
    Text = Text + "Heard Callsigns   " + Str(UBound(xCall)) + " Callsigns" + vbCrLf

    Status = Text

End Function

Function Version ()

    Select Case getVersion() \ 256
    Case 95
        Select Case getVersion() Mod 256
        Case 1
            Version = "95"
        Case 2
            Version = "95 OSR-2"
        Case 3
            Version = "98SE"
        End Select
    Case 3
        Select Case getVersion() Mod 256
        Case 1
            Version = "3.1"
        Case 11
            Version = "3.11 FWG"
        End Select
    End Select

End Function

Sub WriteBirthday ()

    On Local Error GoTo BirthdayError:

    Dim hFile As Integer
    Dim FileName As String
    Dim hCallbook As Integer
    Dim vbCrLf As String
    Dim Counter As Integer

    vbCrLf = Chr(13) + Chr(10)
    hFile = FreeFile
    FileName = App.Path + "\Mail\MA" + Format(Now, "YYMMDD") + ".TMP"
    
    Open FileName For Output As #hFile

    'Header
    Print #hFile, ReadProfile("Birthday", "From")
    Print #hFile, ReadProfile("Birthday", "To")

    'Opening
    Print #hFile, "Subject: KLIWare: Selamat Ulang Tahun, " + Format(Now + 1, "dd-mmm-yyyy")
    Print #hFile, ""
    Print #hFile, "Bismillahi-r-Rahmani-r-Rahim"
    Print #hFile, ""
    Print #hFile, "Kepada rekan-rekan yang berulangtahun hari ini, kami mengucapkan"
    Print #hFile, "selamat ulang tahun, semoga panjang umur dan selalu mendapat rahmatNya."
    Print #hFile, "Data didapat dari Callbook Amatir Radio Indonesia. Sila kunjungi situs"
    Print #hFile, "web 'CARI' di http://callbook.orari.net"
    Print #hFile, ""
    Print #hFile, "Tidak setiap data memiliki catatan tanggal lahir (*), kami mengasumsikan"
    Print #hFile, "IAR berakhir sama dengan tanggal lahir. Kami mohon maaf bila Anda tidak"
    Print #hFile, "berulangtahun pada tanggal ini, silakan perbaru data Anda dengan"
    Print #hFile, "mengunjungi situs web di atas."
    Print #hFile, ""
    Print #hFile, "Laporan ini dibuat pada KLI Node Reporter di stasiun radio paket otomat"
    Print #hFile, gSource + " pada " + Format(Now, "mmmm dd, yyyy hh:mm:ss") + "."
    Print #hFile, ""
    
    'Global
    Dim Nama As String
    Dim Alamat As String
    Dim Lahir As String
    Dim Email As String
    Dim callsign As String
    Dim ORDA As String
    Dim ORLOK As String
    Dim Kadaluarsa As String
    Dim Kode As Integer
    Dim Cari As Integer
    Dim Password As String
    Dim TglBulan As String

    Dim xCall As String
    Dim xNama As String
    Dim xORLOK As String
    Dim xORDA As String
    Dim Flag As String
    
    TglBulan = Format(Now + 1, "MM-DD")
    hCallbook = FreeFile

    Open App.Path + "\Callbook.CSV" For Input As #hCallbook
    Do While Not EOF(hCallbook)
        Input #hCallbook, Nama, Alamat, Lahir, Email, callsign, ORDA, ORLOK, Kadaluarsa, Kode, Cari, Password
        
        Flag = "*"
        If Lahir = "0000-00-00" Then Lahir = Kadaluarsa Else Flag = ""
        If Lahir <> "0000-00-00" Then
            Lahir = Right(Lahir, 5)
            If Lahir = TglBulan Then
                
                xCall = String(8, 32)
                xNama = String(30, 32)
                xORLOK = String(20, 32)
                xORDA = String(20, 32)
                LSet xCall = callsign + Flag
                LSet xNama = Nama
                LSet xORLOK = ORLOK
                LSet xORDA = ORDA

                Print #hFile, xCall + xNama + xORDA + xORLOK
                DoEvents
            End If
        End If
    Loop

    'Closing
    Print #hFile, ""
    Print #hFile, "Salam,"
    Print #hFile, "Admin " + gSource

    Close #hFile

BirthdayDone:
    Exit Sub

BirthdayError:
    Resume BirthdayDone

End Sub

Sub WriteMail ()
    
    Dim hFile As Integer
    Dim FileName As String
    Dim vbCrLf As String
    Dim Counter As Integer

    vbCrLf = Chr(13) + Chr(10)
    hFile = FreeFile
    FileName = App.Path + "\Mail\" + Format(Now, "YYYYMMDD") + ".TMP"
    
    Open FileName For Output As #hFile

    'Header
    Print #hFile, ReadProfile("Reporter", "From")
    Print #hFile, ReadProfile("Reporter", "To")

    'Opening
    Print #hFile, "Subject: KLIWare: Laporan Penggunaan KLI Network Gateway " + gSource
    Print #hFile, ""
    Print #hFile, "Bismillahi-r-Rahmani-r-Rahim"
    Print #hFile, ""
    Print #hFile, "Berikut kami wartakan laporan penggunaan KLI Network Gateway"
    Print #hFile, "yang terekam secara otomatis pada modul statistik KLI Node Reporter."
    Print #hFile, "KLI Network Gateway terpasang pada stasiun radio paket otomat " + gSource
    Print #hFile, ""
    Print #hFile, "Untuk mendapatkan laporan terkini setiap waktu, sila gunakan"
    Print #hFile, "perangkat lunak Terminal untuk berhubungan dengan callsign " + gSource + "."
    Print #hFile, ""
    Print #hFile, "Laporan ini dibuat pada " + Format(Now, "mmmm dd, yyyy hh:mm:ss") + "."
    Print #hFile, ""
    
    'Global
    Print #hFile, Status()
    Print #hFile, ""

    Print #hFile, JustHeard()

    'Closing
    Print #hFile, "Salam,"
    Print #hFile, "Admin " + gSource

    Close #hFile

End Sub

