' ----------------------------------------------- '
' TF/KLI Developer Kit Version 1.0                '
' For Visual Basic 1.0/3.0 for DOS/Windows        '
' AX.25 Packet Radio Enablement Module            '
' Amateur radio and research purposes only!       '
'                                                 '
' TFPCX - TFX - PC/FlexNet TFEMU Compatible       '
' Portion of software provided by NORD><LINK      '
'                                                 '
' How to contact me?                              '
' Arman Yusuf, S.Kom - YC0KLI                     '
' Email: arman@mik.co.id                          '
' Website: http://www.qsl.net/yc0kli              '
' ----------------------------------------------- '

Option Explicit

Type VBRegs
    AX    As Integer
    BX    As Integer
    CX    As Integer
    DX    As Integer
    BP    As Integer
    SI    As Integer
    DI    As Integer
    Flags As Integer
End Type

'Visual Basic 3.0 for Windows 95
Declare Sub Interrupt Lib "Firmware.DLL" Alias "vbInterrupt" (ByVal IntNum As Integer, InRegs As VBRegs, OutRegs As VBRegs)

'Visual Basic 1.0 for MS-DOS
'DECLARE SUB Interrupt (IntNum AS INTEGER, InRegs AS VBRegs, OutRegs AS VBRegs)

Dim Shared TFIntNum        As Integer
Dim Shared TFCurrentMode   As Integer

Function TFBusy () As Integer

    Dim Reg As VBRegs

    'Only when TF has been initialized
    If TFIntNum <> 0 Then

        'Call buffer state
        Reg.AX = &HFD00
        Call Interrupt(TFIntNum, Reg, Reg)
        TFBusy = Reg.AX = 1

    End If

End Function

Function TFChannel (Code As Integer) As Integer

    Dim Reg As VBRegs

    'Only when TF has been initialized
    If TFIntNum <> 0 Then

        'Call channel state
        Reg.AX = &HFB00
        Call Interrupt(TFIntNum, Reg, Reg)
        
        'Select result
        If Code = 0 Then
            TFChannel = Reg.AX Mod 256
        Else
            TFChannel = Reg.AX \ 256
        End If

    End If

End Function

Sub TFDecode (Packet As String, Channel As Integer, Code As Integer, Length As Integer, Text As String)

    'Prevent error
    If Len(Packet) < 2 Then Exit Sub

    'Fill coded field
    Channel = Asc(Left$(Packet, 1))
    Code = Asc(Mid$(Packet, 2, 1))

    Select Case Code
    
    'Success command
    Case 0
        Length = 0
        Text = ""

    'Connection status
    Case 1 To 5
        Length = Len(Packet) - 3
        Text = Mid$(Packet, 3, Length)
    
    'Data status
    Case 6 To 7
        Length = Len(Packet) - 3
        Text = Mid$(Packet, 4)
    
    'Unknown states
    Case Else
        Length = -1
        Text = ""

    End Select

End Sub

Sub TFInit ()

    'Set Interrupt number
    TFIntNum = &HFD

End Sub

Function TFLed () As Long

    Dim Reg As VBRegs

    'Only when TF has been initialized
    If TFIntNum <> 0 Then

        'Call LED state
        Reg.AX = &HFC00
        Call Interrupt(TFIntNum, Reg, Reg)
        TFLed = Reg.AX

    End If

End Function

Sub TFReadINIFile (FileName As String)

    'Prevent illegal filename
    If Dir$(FileName) <> "" Then
        
        Dim hFile As Integer
        Dim Temp As String

        'File access preparation
        hFile = FreeFile
        Open FileName For Input As #hFile
        Do While Not EOF(1)

            'Read line by line
            Line Input #hFile, Temp
            TFSendCmd 0, Temp
            Temp = TFReceive()

        Loop
        Close #hFile

    End If

End Sub

Function TFReceive () As String

    Dim Buffer As String
    Dim Reg As VBRegs
    
    'Only when TF has been initialized
    If TFIntNum <> 0 Then
        
        'Has a character?
        Reg.AX = &H100
        Call Interrupt(TFIntNum, Reg, Reg)

        Do While Reg.AX = 1
            
            'Get that character
            Reg.AX = &H200
            Call Interrupt(TFIntNum, Reg, Reg)
            Buffer = Buffer + Chr$(Reg.AX)
            
            'Has more characters?
            Reg.AX = &H100
            Call Interrupt(TFIntNum, Reg, Reg)

        Loop
    
    End If
    
    TFReceive = Buffer

End Function

Sub TFSend (Text As String)

    Dim Reg As VBRegs
    Dim Count As Integer

    'Only when TF has been initialized
    If TFIntNum <> 0 Then

        'Send byte sequence data
        For Count = 1 To Len(Text)
            Reg.AX = &H300 + Asc(Mid$(Text, Count, 1))
            Call Interrupt(TFIntNum, Reg, Reg)
        Next

    End If

End Sub

Sub TFSendCmd (Channel As Integer, Cmd As String)

    'Send command
    If TFCurrentMode = 1 Then
        
        'Host Mode
        TFSend Chr$(Channel) + Chr$(1) + Chr$(Len(Cmd) - 1) + Cmd
    
    Else

        'Terminal Mode
        TFSend Chr$(27) + Cmd + Chr$(13)
    
    End If

End Sub

Sub TFSendData (Channel As Integer, Text As String)

    'Send data
    If TFCurrentMode = 1 Then
        
        'Host mode
        TFSend Chr$(Channel) + Chr$(0) + Chr$(Len(Text) - 1) + Text
    
    Else
        
        'Terminal mode
        TFSend Text + Chr$(13)

    End If

End Sub

Sub TFSwitchToHost ()

    'Switch from Terminal to Host mode
    TFSendCmd 0, "JHOST1"
    TFCurrentMode = 1

End Sub

Sub TFSwitchToTerminal ()

    'Switch from Host to Terminal mode
    TFSendCmd 0, "JHOST0"
    TFCurrentMode = 0

End Sub

Sub TFSync ()

    Dim Result As String

    'Force state to Host mode
    TFSwitchToTerminal
    Result = TFReceive()
    TFSwitchToHost
    Result = TFReceive()
    Result = ""

    'Synchronize with #1 sequences
    Do While Result = ""
        TFSend Chr$(1)
        Result = TFReceive()
    Loop

End Sub

Function TFVersion () As Long

    Dim Reg As VBRegs

    'Only when TF has been initialized
    If TFIntNum <> 0 Then

        'Call version state
        Reg.AX = &HFE00
        Call Interrupt(TFIntNum, Reg, Reg)
        TFVersion = Reg.AX

    End If

End Function

