Option Explicit
Global LogDir As String

Declare Function GetPrivateProfileString Lib "Kernel" (ByVal lpSectionName As String, ByVal lpKeyName As Any, ByVal lpDefault As String, ByVal lpReturnedString As String, ByVal nSize As Integer, ByVal lpFileName As String) As Integer
Declare Function ExitWindows Lib "User" (ByVal dwReturnCode As Long, ByVal wReserved As Integer) As Integer

Type MappingType

    'AX.25 configuration
    Callsign    As String
    EndQSO      As Integer
    Timeout     As Integer
    
    'TCP/IP configuration
    Destination As String
    Port        As Integer
    Script      As String
    EscapeWord  As String
    Mode        As Integer

    'Data buffer
    Start       As Integer
    User        As String
    UserTimeout As Double
    UserScript  As String
    TX          As String
    RX          As String

End Type

Type BeaconType

    'Beacon settings
    Delay    As Integer
    Source   As String
    Dest     As String
    Text     As String

    'Runtime settings
    Counter  As Double

End Type

Global Mapping() As MappingType
Global AXBeacon() As BeaconType

Function AppPath () As String

    Dim MyPath As String

    MyPath = App.Path
    If Right(MyPath, 1) <> "\" Then MyPath = MyPath + "\"

    AppPath = MyPath

End Function

Function DecodeMacro (Buffer As String) As String

    Dim Text As String
    Dim MacroPos As Integer
    Const Esc = "\0x"

    'Process the macro
    Text = Buffer
    MacroPos = InStr(Text, Esc)
    Do While MacroPos > 0
        Text = Left(Text, MacroPos - 1) + Chr(Val("&H" + Mid(Text, MacroPos + 3, 2))) + Mid(Text, MacroPos + 5)
        MacroPos = InStr(Text, Esc)
    Loop
    DecodeMacro = Text

End Function

Function DecodeScript (Source As String, Callsign As String) As String

    Dim ScriptPos As Integer
    Dim Buffer As String

    Const Tag = "%call%"

    'Script pre-processor
    Buffer = Source
    ScriptPos = InStr(Buffer, Tag)
    Do While ScriptPos > 0
        Buffer = Left(Buffer, ScriptPos - 1) + Callsign + Mid(Buffer, ScriptPos + Len(Tag))
        ScriptPos = InStr(Buffer, Tag)
    Loop

    DecodeScript = Buffer

End Function

Sub ReadBeaconFile ()

    Dim hFile As Integer
    Dim Label As String
    Dim No    As Integer

    hFile = FreeFile
    Open "Setting\Beacon.INI" For Input As #hFile
    Line Input #hFile, Label
    Do While Not EOF(hFile)
        No = No + 1
        ReDim Preserve AXBeacon(No) As BeaconType
        Input #hFile, Label, AXBeacon(No).delay, AXBeacon(No).Source, AXBeacon(No).Dest, AXBeacon(No).Text
        AXBeacon(No).Text = DecodeMacro(AXBeacon(No).Text)
    Loop
    Close

End Sub

Sub ReadMappingFile ()

    Dim hFile As Integer
    Dim Label As String
    Dim No    As Integer

    hFile = FreeFile
    Open "Setting\Server.INI" For Input As #hFile
    Line Input #hFile, Label
    Do While Not EOF(hFile)
        No = No + 1
        ReDim Preserve Mapping(No) As MappingType
        Input #hFile, Label, Mapping(No).Callsign, Mapping(No).Destination, Mapping(No).Port, Mapping(No).Timeout, Mapping(No).Mode, Mapping(No).Script, Mapping(No).EscapeWord
        Mapping(No).EscapeWord = DecodeMacro(Mapping(No).EscapeWord)
        Mapping(No).Script = DecodeMacro(Mapping(No).Script)
    Loop
    Close

End Sub

Function ReadProfile (Section As String, Key As String) As String

    Dim Dummy As Integer
    Dim Result As String
    Dim Pos As Integer

    Result = String(255, 0)
    Dummy = GetPrivateProfileString(Section, Key, "", Result, Len(Result), AppPath() + "Setting\Setting.INI")
    
    Pos = InStr(Result, Chr(0))
    If Pos > 0 Then ReadProfile = Left(Result, Pos - 1)

End Function

Sub RealizeMapping ()

    Dim Counter As Integer
    Dim Buffer  As String
    Dim SpcLoc  As Integer
    Dim hFile   As Integer

    On Local Error Resume Next
    Main!CurrentList.Clear
    
    For Counter = 1 To UBound(Mapping)
        
        'Initialize list
        Main!CurrentList.AddItem ""
        ResetCallsign

        'Get connected stations
        TFSendCmd Counter, "C"
        Buffer = Mid(TFReceive(), 3)
        If InStr(Buffer, "CHANNEL NOT") = 0 Then
            SpcLoc = InStr(Buffer, " ")
            If SpcLoc > 0 Then Buffer = Left(Buffer, SpcLoc - 1)
            Mapping(Counter).User = Buffer
        End If
        Mapping(Counter).EndQSO = 0
        Mapping(Counter).Start = 0

        'Initialize TCP/IP stack
        Load Main!Socket(Counter)
        If Left(Mapping(Counter).Destination, 1) = "*" Then
            Main!Socket(Counter).AutoResolve = True
            Main!Socket(Counter).HostName = Mid(Mapping(Counter).Destination, 2)
            Mapping(Counter).Destination = Main!Socket(Counter).HostAddress
            Main!Socket(Counter).AutoResolve = False
        Else
            Main!Socket(Counter).HostAddress = Mapping(Counter).Destination
        End If
        Main!Socket(Counter).RemotePort = Mapping(Counter).Port

    Next

    'Expand list
    Main!CurrentList.Height = Counter * 202
    Main!MyLine(8).Y1 = Main!CurrentList.Top + Main!CurrentList.Height + 2 * Screen.TwipsPerPixelY
    Main!MyLine(8).Y2 = Main!MyLine(8).Y1
    Main!MyLine(7).Y2 = Main!CurrentList.Top + Main!CurrentList.Height + 2 * Screen.TwipsPerPixelY
    Main!MyLine(6).Y2 = Main!MyLine(7).Y2
    Main.Height = Main!CurrentList.Top + Main!CurrentList.Height + 38 * Screen.TwipsPerPixelY
    
    RefreshList

End Sub

Sub RefreshList ()

    Dim Counter   As Integer
    Dim RightNo   As String
    Dim LeftCall  As String
    Dim LeftIP    As String
    Dim RightPort As String
    Dim LeftUser  As String
    Dim Buffer    As String

    For Counter = 1 To UBound(Mapping)

        RightNo = String(2, 32)
        LeftCall = String(9, 32)
        LeftIP = String(15, 32)
        RightPort = String(5, 32)
        LeftUser = String(9, 32)

        RSet RightNo = Trim(Str(Counter))
        LSet LeftCall = Mapping(Counter).Callsign
        LSet LeftIP = Mapping(Counter).Destination
        RSet RightPort = Trim(Str(Mapping(Counter).Port))
        LSet LeftUser = Mapping(Counter).User
        Buffer = RightNo + " " + LeftCall + " " + LeftIP + " " + RightPort + " " + LeftUser

        If Main!CurrentList.List(Counter - 1) <> Buffer Then
            Main!CurrentList.List(Counter - 1) = Buffer
        End If

    Next

End Sub

Sub ResetCallsign ()

    Dim Buffer  As String
    Dim Counter As Integer

    'Reset callsign
    For Counter = 1 To UBound(Mapping)
        TFSendCmd Counter, "I " + Mapping(Counter).Callsign
        Buffer = TFReceive()
    Next

End Sub

Sub WriteLog (Text As String)

    On Local Error Resume Next

    Dim hFile As Integer

    If LogDir = "" Then Exit Sub
    hFile = FreeFile
    
    Open LogDir + "\" + Format(Now, "YYYYMMDD") + ".Log" For Append As hFile
    Print #hFile, "KLINetGW:" + Format(Now, "YYYYMMDDHHMMSS") + " " + Text + Chr(255)
    Close hFile

End Sub

