VERSION 2.00
Begin Form Main 
   BackColor       =   &H8000000B&
   ClientHeight    =   3705
   ClientLeft      =   1380
   ClientTop       =   2010
   ClientWidth     =   5070
   ForeColor       =   &H8000000B&
   Height          =   4110
   Icon            =   0
   Left            =   1320
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   ScaleHeight     =   3705
   ScaleWidth      =   5070
   Top             =   1665
   Width           =   5190
   Begin ListBox CurrentList 
      BackColor       =   &H8000000E&
      Enabled         =   0   'False
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "Courier New"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   240
      Left            =   150
      TabIndex        =   7
      Top             =   3285
      Width           =   4755
   End
   Begin Socket Socket 
      AutoResolve     =   0   'False
      Backlog         =   5
      Binary          =   -1  'True
      Blocking        =   0   'False
      Broadcast       =   0   'False
      BufferSize      =   0
      ByteOrder       =   1  'Network
      HostAddress     =   ""
      HostFile        =   ""
      HostName        =   ""
      Index           =   0
      InLine          =   0   'False
      Interval        =   0
      KeepAlive       =   0   'False
      Left            =   4560
      Linger          =   0
      LocalPort       =   0
      LocalService    =   ""
      Protocol        =   0
      RemotePort      =   0
      RemoteService   =   ""
      ReuseAddress    =   0   'False
      Route           =   -1  'True
      SocketType      =   1
      Timeout         =   0
      Top             =   840
   End
   Begin Socket Beacon 
      AutoResolve     =   0   'False
      Backlog         =   5
      Binary          =   -1  'True
      Blocking        =   0   'False
      Broadcast       =   0   'False
      BufferSize      =   0
      ByteOrder       =   1  'Network
      HostAddress     =   ""
      HostFile        =   ""
      HostName        =   ""
      Index           =   0
      InLine          =   0   'False
      Interval        =   0
      KeepAlive       =   0   'False
      Left            =   3600
      Linger          =   0
      LocalPort       =   0
      LocalService    =   ""
      Protocol        =   0
      RemotePort      =   0
      RemoteService   =   ""
      ReuseAddress    =   0   'False
      Route           =   -1  'True
      SocketType      =   1
      Timeout         =   0
      Top             =   840
   End
   Begin Timer MyTimer 
      Interval        =   100
      Left            =   4080
      Top             =   840
   End
   Begin Shape LED 
      FillStyle       =   0  'Solid
      Height          =   135
      Index           =   0
      Left            =   720
      Shape           =   3  'Circle
      Top             =   1020
      Visible         =   0   'False
      Width           =   135
   End
   Begin Label Label 
      BackColor       =   &H80000003&
      Caption         =   "No.   Call Alias        Alamat Tujuan                 Port  Pengguna"
      FontBold        =   -1  'True
      FontItalic      =   0   'False
      FontName        =   "Verdana"
      FontSize        =   6.75
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   225
      Index           =   0
      Left            =   150
      TabIndex        =   8
      Top             =   3045
      Width           =   4755
   End
   Begin Line MyLine 
      BorderColor     =   &H00404040&
      BorderWidth     =   2
      Index           =   9
      X1              =   120
      X2              =   4920
      Y1              =   3015
      Y2              =   3015
   End
   Begin Line MyLine 
      BorderColor     =   &H00C0C0C0&
      BorderWidth     =   2
      Index           =   8
      X1              =   135
      X2              =   4935
      Y1              =   3555
      Y2              =   3555
   End
   Begin Line MyLine 
      BorderColor     =   &H00404040&
      BorderWidth     =   2
      Index           =   7
      X1              =   120
      X2              =   120
      Y1              =   3015
      Y2              =   3540
   End
   Begin Line MyLine 
      BorderColor     =   &H00C0C0C0&
      BorderWidth     =   2
      Index           =   6
      X1              =   4935
      X2              =   4935
      Y1              =   3030
      Y2              =   3540
   End
   Begin Line MyLine 
      BorderColor     =   &H00C0C0C0&
      BorderWidth     =   2
      Index           =   5
      X1              =   4935
      X2              =   4935
      Y1              =   1335
      Y2              =   2520
   End
   Begin Line MyLine 
      BorderColor     =   &H00404040&
      BorderWidth     =   2
      Index           =   2
      X1              =   120
      X2              =   120
      Y1              =   1320
      Y2              =   2505
   End
   Begin Line MyLine 
      BorderColor     =   &H00C0C0C0&
      BorderWidth     =   2
      Index           =   1
      X1              =   135
      X2              =   4935
      Y1              =   2520
      Y2              =   2520
   End
   Begin Line MyLine 
      BorderColor     =   &H00404040&
      BorderWidth     =   2
      Index           =   0
      X1              =   120
      X2              =   4920
      Y1              =   1320
      Y2              =   1320
   End
   Begin Label Content 
      BackStyle       =   0  'Transparent
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "Verdana"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   915
      Left            =   150
      TabIndex        =   5
      Top             =   1590
      Width           =   4755
   End
   Begin Label Header 
      BackColor       =   &H80000003&
      FontBold        =   -1  'True
      FontItalic      =   0   'False
      FontName        =   "Verdana"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   255
      Left            =   150
      TabIndex        =   6
      Top             =   1350
      Width           =   4755
   End
   Begin Label Label 
      Alignment       =   1  'Right Justify
      AutoSize        =   -1  'True
      BackColor       =   &H8000000B&
      FontBold        =   -1  'True
      FontItalic      =   0   'False
      FontName        =   "Verdana"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      ForeColor       =   &H00FFFFFF&
      Height          =   195
      Index           =   5
      Left            =   4860
      TabIndex        =   4
      Top             =   960
      Width           =   60
   End
   Begin Label Label 
      Alignment       =   1  'Right Justify
      AutoSize        =   -1  'True
      BackColor       =   &H8000000B&
      FontBold        =   -1  'True
      FontItalic      =   0   'False
      FontName        =   "Verdana"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      ForeColor       =   &H00FFFFFF&
      Height          =   195
      Index           =   4
      Left            =   4860
      TabIndex        =   3
      Top             =   2640
      Width           =   60
   End
   Begin Label Label 
      AutoSize        =   -1  'True
      BackColor       =   &H8000000B&
      Caption         =   "Status Koneksi"
      FontBold        =   -1  'True
      FontItalic      =   0   'False
      FontName        =   "Verdana"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      ForeColor       =   &H00FFFFFF&
      Height          =   195
      Index           =   3
      Left            =   120
      TabIndex        =   2
      Top             =   2640
      Width           =   1440
   End
   Begin Label Label 
      AutoSize        =   -1  'True
      BackColor       =   &H8000000B&
      Caption         =   "Monitor"
      FontBold        =   -1  'True
      FontItalic      =   0   'False
      FontName        =   "Verdana"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      ForeColor       =   &H00FFFFFF&
      Height          =   195
      Index           =   2
      Left            =   120
      TabIndex        =   1
      Top             =   960
      Width           =   735
   End
   Begin Label Label 
      BackStyle       =   0  'Transparent
      Caption         =   "Program ini berguna untuk menghubungkan LAN berbasis TCP/IP dengan Radio Paket berbasis AX.25 secara transparan."
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "Verdana"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   615
      Index           =   1
      Left            =   960
      TabIndex        =   0
      Top             =   240
      Width           =   3975
   End
   Begin Image FormIcon 
      Height          =   480
      Left            =   240
      Top             =   300
      Width           =   480
   End
   Begin Line MyLine 
      BorderColor     =   &H00C0C0C0&
      Index           =   10
      X1              =   6000
      X2              =   -600
      Y1              =   1080
      Y2              =   1080
   End
   Begin Line MyLine 
      BorderColor     =   &H00404040&
      Index           =   4
      X1              =   6000
      X2              =   -600
      Y1              =   1065
      Y2              =   1065
   End
   Begin Line MyLine 
      BorderColor     =   &H00404040&
      Index           =   11
      X1              =   5820
      X2              =   -780
      Y1              =   2745
      Y2              =   2745
   End
   Begin Line MyLine 
      BorderColor     =   &H00C0C0C0&
      Index           =   3
      X1              =   5820
      X2              =   -780
      Y1              =   2760
      Y2              =   2760
   End
End
Option Explicit
Dim Server As Integer
Dim MaxOutstandingPacket As Integer
Dim Tick As Single

Private Sub Beacon_Accept (Index As Integer, SocketID As Integer)

    Dim Counter As Integer

    'Check for free server
    For Counter = 1 To Server
        If Not Beacon(Counter).Connected Then Exit For
    Next

    'Create server if needed
    If Counter > Server Then
        Server = Counter
        Load Beacon(Server)
        Load LED(Server)
    End If

    'Overhandle the stream
    Beacon(Counter).Accept = SocketID

    LED(Counter).Left = LED(0).Left + Counter * 15 * Screen.TwipsPerPixelY
    LED(Counter).Visible = True
    LED(Counter).ZOrder
    
    WriteLog "MONITOR CONNECT:" + Beacon(Counter).PeerAddress

End Sub

Private Sub Beacon_Disconnect (Index As Integer)

    LED(Index).Visible = False
    WriteLog "MONITOR DISCONNECT:" + Beacon(Index).PeerAddress
    Beacon(Index).Action = 7
    
End Sub

Sub Beacon_LastError (Index As Integer, ErrorCode As Integer, ErrorString As String, Response As Integer)

    Beacon_Disconnect Index

End Sub

Private Sub Beacon_Read (Index As Integer, DataLength As Integer, IsUrgent As Integer)

    Dim Buffer   As String
    Dim Divider  As String
    Dim DivPos   As Integer
    Dim Callsign As String
    Dim Source   As String
    Dim Dest     As String
    Dim Text     As String

    'Set LED
    LED(Index).FillColor = RGB(0, 255, 0)

    Divider = Chr(255) + Chr(127)
    
    'Retrieve TCP/IP packet
    Beacon(Index).RecvLen = DataLength
    Buffer = Beacon(Index).RecvData

    If Left(Buffer, Len(Divider)) = Divider Then
        
        'Check format
        Buffer = Mid(Buffer, 3)
        DivPos = InStr(Buffer, Divider)
        If DivPos > 0 Then

            'Get callsign and text portion
            Callsign = Left(Buffer, DivPos - 1)
            Text = Mid(Buffer, DivPos + Len(Divider))
            If Len(Text) > 256 Then Text = Left(Text, 256)
            DivPos = InStr(Callsign, " ")
            
            'Send beacon, if valid
            If DivPos > 0 Then
                Source = Left(Callsign, DivPos - 1)
                Dest = Mid(Callsign, DivPos + 1)
                SendBeacon Source, Dest, Text
                WriteLog "MONITOR BEACON:" + Beacon(Index).PeerAddress + " SRC:" + Source + " DEST:" + Dest + " TXT:" + Text
            End If
            
        End If
    End If

End Sub

Private Sub Form_Load ()

    Dim Plugins As String
    Dim AppName As String
    Dim sID  As Integer
    Const Appl = "Aplikasi\"

    If App.PrevInstance Then End

    'Many custom - Added on May 11, 2002
    MaxOutstandingPacket = CInt(ReadProfile("Gateway", "MaxOutstandingPacket"))
    If CInt(ReadProfile("Gateway", "StartMinimized")) Then WindowState = 1
    LogDir = ReadProfile("Gateway", "LogDir")

    'Initialize TF driver
    TFInit
    TFSync
    TFReadINIFile "Setting\Mulai.INI"
    ReadMappingFile
    RealizeMapping
    ReadBeaconFile
    WriteLog "STARTUP:Success"

    'Redraw window
    'FormIcon = Icon
    Caption = App.Title
    Left = Screen.Width - Width - 120
    Top = Screen.Height - Height - 600

    'Activate plugins
    If CInt(ReadProfile("Plugins", "Activate")) Then
        
        Dim WinMode As Integer
        If CInt(ReadProfile("Plugins", "StartMinimized")) Then
            WinMode = 6
        Else
            WinMode = 1
        End If

        Plugins = Dir(AppPath() + Appl, 16)
        Do While Plugins <> ""
            If (Plugins <> ".") And (Plugins <> "..") Then
                If (GetAttr(AppPath() + Appl + Plugins) And 16) = 16 Then
                    AppName = AppPath() + Appl + Plugins + "\" + Plugins + ".EXE"
                    WriteLog "PLUGIN STARTING:" + AppName
On Local Error GoTo SkipShell
                    sID = Shell(AppName, WinMode)
                    WriteLog "PLUGIN STARTUP:" + AppName
                    GoTo NextShell
SkipShell:
                    WriteLog "PLUGIN ERROR:" + AppName
                    Resume NextShell
NextShell:
                End If
            End If
            Plugins = Dir
        
        Loop

    End If
    
    'Setting ticker
    Dim UserTimer As Integer
    UserTimer = Val(ReadProfile("Gateway", "Tick"))
    Tick = UserTimer / 1000
    MyTimer.Interval = UserTimer

    'Activate beacon server
    Beacon(0).LocalPort = ReadProfile("Gateway", "UIPort")
    Beacon(0).Action = 3
    Load Beacon(1)
    Load LED(1)
    Server = 1

    'Decorative colorset
    'Upper box
    MyLine(0).BorderColor = &H80000003
    MyLine(1).BorderColor = &H80000005
    MyLine(2).BorderColor = &H80000003
    MyLine(5).BorderColor = &H80000005
    'Lower box
    MyLine(9).BorderColor = &H80000003
    MyLine(6).BorderColor = &H80000005
    MyLine(7).BorderColor = &H80000003
    MyLine(8).BorderColor = &H80000005
    'Upper line
    MyLine(11).BorderColor = &H80000003
    MyLine(3).BorderColor = &H80000005
    'Lower line
    MyLine(4).BorderColor = &H80000003
    MyLine(10).BorderColor = &H80000005

End Sub

Private Sub Form_QueryUnload (Cancel As Integer, UnloadMode As Integer)

    Form_Unload False
    
End Sub

Sub Form_Unload (Cancel As Integer)

    Dim Counter As Integer
    Dim Buffer As String

    For Counter = 1 To UBound(Mapping)
        TFSendCmd Counter, "D"
        Buffer = TFReceive()
    Next

    TFSwitchToTerminal
    TFReadINIFile "Setting\Selesai.INI"
    WriteLog "TERMINATED:Normally"
    End

End Sub

Private Sub MyTimer_Timer ()

    Dim Buffer  As String
    Dim Channel As Integer
    Dim Code    As Integer
    Dim Length  As Integer
    Dim Text    As String
    Dim Counter As Integer
    
    Dim SSIDPos   As Integer
    Dim Callsign  As String

    On Local Error Resume Next

    'Get about 1 second to dim the LED
    Static wait As Single
    wait = wait + Tick
    If wait > 1 Then
        For Counter = 1 To Server
            LED(Counter).FillColor = 0
        Next
        wait = 0
    End If

    'Check beacon enablement
    If UBound(AXBeacon) > 0 Then
        For Counter = 1 To UBound(AXBeacon)
            AXBeacon(Counter).Counter = AXBeacon(Counter).Counter + Tick
            If AXBeacon(Counter).Counter > AXBeacon(Counter).delay Then
                
                'Send beacon
                AXBeacon(Counter).Counter = 0
                SendBeacon AXBeacon(Counter).Source, AXBeacon(Counter).Dest, AXBeacon(Counter).Text
                WriteLog "BEACON SRC:" + AXBeacon(Counter).Source + " DEST:" + AXBeacon(Counter).Dest + " TXT:" + AXBeacon(Counter).Text

            End If
        Next
    End If

    'Check buffer
    TFSendCmd 0, "@B"
    TFDecode TFReceive(), Channel, Code, Length, Text
    Label(4).Caption = Text

    'Show time
    Label(5).Caption = Format(Time, "HH:MM:SS")

    'Create monitor
    TFSendCmd 0, "G"
    Buffer = TFReceive()
    TFDecode Buffer, Channel, Code, Length, Text
    If Buffer <> String(2, 0) Then SendToBeacon Buffer
    Select Case Code
    Case 4: Header = Label(5) + " " + Mid(Text, 4)
            Content = ""
    Case 5: Header = Label(5) + " " + Mid(Text, 4)
            TFSendCmd 0, "G"
            Buffer = TFReceive()
            Content = Mid(Buffer, 4)
            SendToBeacon Buffer
    End Select

    'Scan channels
    For Counter = 1 To UBound(Mapping)
        TFSendCmd Counter, "G"
        TFDecode TFReceive(), Channel, Code, Length, Text
        Select Case Code
        
        Case 3:
                'Check status code
                Dim ConPos As Integer
                ConPos = InStr(Text, " CONNECTED ")
                If ConPos > 0 Then
                    
                    'Get callsign
                    Dim PartnerCall As String
                    PartnerCall = Mid(Text, ConPos + 14)
                    ConPos = InStr(PartnerCall, " ")
                    If ConPos > 0 Then PartnerCall = Left(PartnerCall, ConPos - 1)
                    Mapping(Counter).User = PartnerCall
                    SSIDPos = InStr(PartnerCall, "-")
                    If SSIDPos > 0 Then
                        Callsign = Left(PartnerCall, SSIDPos - 1)
                    Else
                        Callsign = PartnerCall
                    End If

                    'Script pre-processor
                    Mapping(Counter).UserScript = DecodeScript(Mapping(Counter).Script, LCase(Callsign))

                    'Initialize TCP/IP connection
                    Socket(Counter).Action = 2
                    
                    WriteLog "CONNECTED SRC:" + Callsign + " CH:" + Format(Counter)

                Else

                    'Reset resources
                    Mapping(Counter).Start = 0
                    Mapping(Counter).User = ""
                    Mapping(Counter).RX = ""
                    Mapping(Counter).TX = ""

                    'Deinitialize TCP/IP connection
                    Socket_Disconnect Counter

                    WriteLog "DISC SRC:" + Callsign + " CH:" + Format(Counter)
                
                End If
            
        Case 7:

            Select Case Mapping(Counter).Mode
            Case 2 'Packet Guard
                Text = Chr(255) + Chr(127) + Asc(Len(Text)) + Text
            Case 1 'Text Conversion
                If Right(Text, 1) = Chr(13) Then Text = Text + Chr(10)
            Case 0 'Binary Transfer
            End Select
            Mapping(Counter).RX = Mapping(Counter).RX + Text

        End Select
    Next

    'Exchange between stacks
    Transfer
    RefreshList

End Sub

Private Sub SendBeacon (Source As String, Destination As String, Text As String)
    
    Dim Buffer  As String

    'Submit on AX.25 channel
    TFSendCmd 0, "I " + Source
    Buffer = TFReceive()
    TFSendCmd 0, "C " + Destination
    Buffer = TFReceive()
    TFSendData 0, Text
    Buffer = TFReceive()

    ResetCallsign

End Sub

Private Sub SendToBeacon (Buffer As String)

    Dim Counter As Integer
    For Counter = 1 To Server
        If Beacon(Counter).Connected Then
            Beacon(Counter).SendLen = Len(Buffer)
            Beacon(Counter).SendData = Buffer
            DoEvents
            LED(Counter).FillColor = RGB(255, 0, 0)
        End If
    Next

End Sub

Private Sub Socket_Connect (Index As Integer)

    Dim Buffer As String

    Buffer = Mapping(Index).UserScript
    If Buffer <> "" Then
        Socket(Index).SendLen = Len(Buffer)
        Socket(Index).SendData = Buffer
    End If

End Sub

Private Sub Socket_Disconnect (Index As Integer)

    Dim Buffer As String

    'Close TCP/IP socket
    Socket(Index).Action = 7
    Socket(Index).LocalPort = 0
    Mapping(Index).EndQSO = -1

End Sub

Private Sub Socket_LastError (Index As Integer, ErrorCode As Integer, ErrorString As String, Response As Integer)

    Mapping(Index).TX = "Error" + Str(ErrorCode) + ": " + ErrorString
    Socket_Disconnect Index

End Sub

Private Sub Socket_Read (Index As Integer, DataLength As Integer, IsUrgent As Integer)

    Dim Buffer As String
    Dim EscLoc As Integer

    'Retrieve TCP/IP packet
    Socket(Index).RecvLen = DataLength
    Buffer = Socket(Index).RecvData

    Select Case Mapping(Index).Mode
    Case 1 'Text conversion
        Dim Temp As String
        Dim Counter As Integer
        Dim TempChr As String
        For Counter = 1 To Len(Buffer)
            TempChr = Mid(Buffer, Counter, 1)
            If TempChr <> Chr(10) Then Temp = Temp + TempChr
        Next
        Buffer = Temp
        
    Case Else 'Binary & packet guard transfer
    End Select
    
    If Mapping(Index).Start = 0 Then

        'Waiting sync-sequence
        EscLoc = InStr(Buffer, Mapping(Index).EscapeWord)
        If EscLoc > 0 Then
            Mapping(Index).Start = -1
            Mapping(Index).TX = Mid(Buffer, EscLoc)
        End If

    Else

        'Normal traffic handle
        Mapping(Index).TX = Mapping(Index).TX + Buffer
    
    End If

End Sub

Private Sub Transfer ()
    
    Dim Counter As Integer
    Dim Buffer As String
    Dim Chk As Integer
    Dim SpcPos As Integer
    Dim Pending As Integer
    ReDim Status(6) As Integer
    
    For Counter = 1 To UBound(Mapping)

        'Submit AX.25 -> TCP/IP
        If (Mapping(Counter).RX <> "") And Socket(Counter).Connected Then
            Socket(Counter).SendLen = Len(Mapping(Counter).RX)
            Socket(Counter).SendData = Mapping(Counter).RX
            Mapping(Counter).RX = ""
        End If
    
        'Buffer control on AX.25 stack
        TFSendCmd Counter, "L"
        Buffer = Mid(TFReceive(), 3) + " "
        For Chk = 1 To 5
            SpcPos = InStr(Buffer, " ")
            Status(Chk) = Val(Left(Buffer, SpcPos))
            Buffer = Mid(Buffer, SpcPos + 1)
        Next
        Pending = Status(3) + Status(4)

        'Submit TCP/IP -> AX.25
        If Pending < MaxOutstandingPacket Then
        
            Select Case Mapping(Counter).Mode
            Case 2
                'Packet Guard transfer
                SpcPos = InStr(Mapping(Counter).TX, Chr(255) + Chr(127))
                If SpcPos > 0 Then
                    Chk = Asc(Mid(Mapping(Counter).TX, SpcPos + 2, 1)) + 1
                    Buffer = Mid(Mapping(Counter).TX, SpcPos + 3, Chk)
                    Mapping(Counter).TX = Mid(Mapping(Counter).TX, Chk + SpcPos + 3)
                Else
                    Mapping(Counter).TX = ""
                End If
            
            Case Else
                'Binary & text transfer
                Buffer = Left(Mapping(Counter).TX, 256)
                Mapping(Counter).TX = Mid(Mapping(Counter).TX, 257)
                
            End Select
            
            'Send buffer
            If Buffer <> "" Then
                TFSendData Counter, Buffer
                Buffer = TFReceive()
            End If
        
        End If

        'Check timeout settings
        If (Pending = 0) And (Mapping(Counter).RX = "") And Socket(Counter).Connected Then
            Mapping(Counter).UserTimeout = Mapping(Counter).UserTimeout + Tick
            If Mapping(Counter).UserTimeout > Mapping(Counter).Timeout Then
                Socket_Disconnect Counter
            End If
        Else
            Mapping(Counter).UserTimeout = 0
        End If

        'Check DISC-Request from TCP/IP
        If Mapping(Counter).EndQSO And Mapping(Counter).TX = "" Then
            
            'Close AX.25 socket
            TFSendCmd Counter, "D"
            Buffer = TFReceive()
            Mapping(Counter).EndQSO = 0
            ResetCallsign
                    
        End If
    
    Next

End Sub

