# calmi.py = Compressed Air Launcher Modeler Interactive by AKBiocca 7/2002
print
print "CALMi.py"
print
print "Interactive Compressed Air Launcher Modeler v1.0"
print "(C) 2002,2003 by Alan Biocca http://www.qsl.net/wb6zqz/"
print
from math import *
import sys

g = 32.2            # gravity ft / sec / sec

def diatoarea(dia):
    "circle diameter to area"
    return pi/4.*dia*dia

def cylvol(dia,len):
    "volume of cylinder"
    return diatoarea(dia)*len

# pvc pipe
pvc4id    = 4.03
pvc4od    = 4.50
pvc3id    = 3.07
pvc3od    = 3.50
pvc2p5id  = 2.45
pvc2p5od  = 2.88
pvc2id    = 2.07
pvc2od    = 2.38
pvc1p5id  = 1.61
pvc1p5od  = 1.90
pvc1p25id = 1.38
pvc1p25od = 1.66
pvc1id    = 1.05
pvc1od    = 1.32
pvcp75id  = 0.82
pvcp75od  = 1.05

interval = 0.00001          # modelling time interval in seconds

temp = 70.                                  # temp deg f
scfmtocuinps = 12.*12.*12./60.              # scfm to cu in/s
    
def init():
    global supplypressure, supplypv, initialpv, borepv, boreposition, \
           velocity, time, iteration, borepressure, cvcf, chargevolume, \
           initialvolume, finalvolume, borearea, ballmass
    borearea = diatoarea(boredia)               # bore area in sq inches
    ballmass = ballweight /16. / g              # ballweight in oz
    borevolume = borelen * borearea
    initialvolume = deadvolume + chargevolume
    finalvolume = initialvolume + borevolume
    expansionratio = chargevolume / (deadvolume + borevolume+chargevolume)
    supplypressure = chargepressure + 14.7      # supply chamber pressure in psi

    supplypv = supplypressure * chargevolume
    initialpv = 14.7 * initialvolume + supplypv
    borepv = 14.7 * deadvolume                  # initial
    borepressure = 14.7                         # psia
    
    boreposition = boredia/2.                   # bore position inches (ball)
    velocity = 0.                               # velocity in fps
    time = 0.                                   # time in sec
    iteration = 0                               # iteration counter

def nextposition():
    global boreposition, velocity, time, iteration, borepressure, \
        supplypressure, borepv, supplypv
    
    borevolume = boreposition * borearea - boredia/2.       # cu in
    currentvolume = initialvolume + borevolume              # cu in
    equilibpressure = initialpv / currentvolume             # psi

    p1 = supplypressure
    p2 = borepressure
    if p1 < p2: p1 = p2

    t = temp + 460.                                         # rankin
    
    if p2 < (0.53 * p1):                                    # supersonic
        p2 = 0.53 * p1                                      # limits eff deltaP
        
    flowrate = 16.05 * cv * sqrt((p1*p1-p2*p2)/t)           # in SCFM

    flowvol = flowrate * scfmtocuinps * interval            # cu in @ stp

    flowpv = flowvol * 14.7                                 # convert to pv

    borepv += flowpv                                        # implement flow
    supplypv -= flowpv

    borepressure = borepv / (borevolume + deadvolume)
    supplypressure = supplypv / chargevolume
    
    airforce = (borepressure-14.7) * borearea               # pounds
    
    if velocity > 0.:
        netforce = airforce - boredrag                      # pounds
    else:
        netforce = max(airforce-boredrag,0.)                # bore friction
    
    acceleration = netforce / ballmass                      # ft / sec / sec
    velocity += acceleration * interval                     # ft / sec
    boreposition += velocity*12 * interval                  # inches
    time += interval                                        # sec
    iteration += 1

def prnt():
    print "%4d %4.1f %5.1f %6.4f %4.1f %4.1f"%\
          (iteration,boreposition, velocity, time, \
           borepressure-14.7, supplypressure-14.7)

def prnt2():
    print "%3d %5d %4.1f %5.1f %6.4f %4.1f %4.1f"%\
          (chargepressure, iteration, boreposition, velocity, time, \
           borepressure-14.7, supplypressure-14.7)

def compute():
    "through the bore by time step"
    global velocity,recoile
    init()
    while boreposition < borelen and time < 0.1:
        if (iteration % 250) == 0:                  # print redux
            #prnt2()
            pass
        nextposition()
    #prnt2()
    if boreposition < borelen:                      # no escape
        velocity = 0.
    
    launchermass = launcherwt / g
    recoilv = ballmass * velocity / launchermass
    recoile = 0.5 * launchermass * recoilv * recoilv
    trajectory()

def findcv(p,v):
    "fit cv for given pressure and velocity"
    global cv,chargepressure
    cv = 0.
    chargepressure = p
    delcv = 10.
    stopdel = .01
    #print "chp vel    cv"
    while delcv >= stopdel:
        cv += delcv
        if cv > 99:
            cv -= delcv
            print "%3d %4.0f %5.2f out of cv range"%(p,velocity,cv)
            return
        compute()
        if velocity > v:
            cv -= delcv
            delcv *= 0.1
    compute()
    #print "%3d %3d %5.2f"%(p,velocity+0.5,cv)
    print "%3d %4.0f %5.2f %5.3f %4.1f %4.1f %3d %4.1f"%\
          (chargepressure, velocity, cv, time,\
           borepressure-14.7, supplypressure-14.7,peak,ttime)

def trajectory():
    global peak,ttime
    iter = 0
    tinterval = interval * 100.
    vposition = 0.                  # vertical position
    vvelocity = velocity            # vertical velocity
    terminalv = 70./60./60.*5280.   # 70 mph terminal from www.phys.washington.edu/~young208A/ball-air.html
##    print "terminal velocity %d fps"%terminalv
    ttime = 0.                      # trajectory time
    ballarea = diatoarea(2.56)
    peak = 0.

    # use the relationship dragforce = D * v * v, and
    # the terminal velocity to make a simple calculation of D & drag
    D = 2./16./(terminalv*terminalv)        # for tennis ball
##    print "D",D
##    print
##    print " iv time  pos  vel"

    while vposition >= 0. :
        iter += 1
        ttime += tinterval
        vposition += vvelocity * tinterval
        if peak < vposition:
            peak = vposition
        vacceleration = 0.

        drag = D * vvelocity * vvelocity
        if vvelocity > 0. :
            drag = -drag
        drag *= 1.0  # adjust for altitude 0.7 for 8k?
        vacceleration = drag/ballmass
        vvelocity += (vacceleration - g) * tinterval
        
#        if (iter % 500) == 0 :
#            print "%5.3f %4d %4d"%(ttime,vposition,vvelocity)
            
#    print "%3d %6.3f %4d %4d %4d"%(velocity,ttime,vposition,vvelocity,peak)

def trajectories():
    global velocity
    print
    print " iv   time  pos  vel peak"
    for velocity in range(100,451,50):
        trajectory()

#trajectories()

def calc():
    
    global chargepressure,chargevolume

    chargevolume = cylvol(chargedia,chargelen)

    print
    print model
    print
    
    print "Chamber %s x %s, Bore %s x %s in"%(chargedia,chargelen,boredia,borelen)
    print "Cv %s gpm/psi, iv %d cu in, Ball %s oz, drag %s lb"%(cv,deadvolume,ballweight,boredrag)
        
    print
    print "chp  fps   sec  xbp  xcp  ht tofl"
    for chargepressure in range(10,maxp+1,5):
                compute()
                if velocity > 50.:
                    print "%3d %4.0f %5.3f %4.1f %4.1f %3d %4.1f"%\
                          (chargepressure, velocity, time,\
                           borepressure-14.7, supplypressure-14.7,peak,ttime)
    print
    print

def key():
    print
    print "Variables Key"
    print
    print "Chamber diameter and length in inches inside"
    print "Bore diameter in inches inside"
    print "Ball bore acceleration distance under pressure in inches"
    print "Cv system airflow gallons per minute for one psi pressure drop"
    print "iv initial valve to ball volume"
    print "Ball weight in ounces, bore drag in pounds"
    print
    print "Columns Key"
    print
    #print "bwt  ball weight in oz"
    print "chp  storage chamber pressure in pounds per square inch"
    #print "cv   valve flow 2-20 gpm per psi"
    #print "oal  overall length inches"
    #print "chl  storage chamber length inches"
    #print "bbl  barrel length inches"
    #print "dl   dead (unused bore) length"
    print "fps  launch velocity feet per second"
    print "sec  exit time from start"
    print "xbp  exit bore pressure in psi"
    print "xcp  exit storage chamber pressure in psi"
    print "ht   peak height in feet if launched straight up"
    print "tofl time of flight sec (start to return to earth)"
    print

def u(prompt, default, min, max):
    "user input & check"
    while 1:
        print "enter %s (%.1f)"%(prompt,default)
        s = sys.stdin.readline()
        if s == "\n":
            s = default
        else:
            s = float(s)
        if s >= min and s <= max:
            return s
        print "out of range (%s .. %s)"%(min,max)

def userin():
    " interactive input and evaluate "

    global ballweight,boredrag,cv,chargedia,chargelen,deadvolume,boredia, \
           borelen,launcherwt,chargevolume,model,maxp

    # defaults
    ballweight = 2.
    boredrag = 10.5
    boredia = pvc2p5id
    launcherwt = 10.
    maxp = 80.

    # "TBL-U37A"
    cv = 4.
    chargedia = pvc3id
    chargelen = 24.
    deadvolume = cylvol(pvc2id,7)
    borelen = 20.

    p = 40
    v = 110

    xit = 0

    while 1:
        xit = u("-1=exit 0=Vel 1=Cv 2=key 3=U37 4=DV54 5=QE20 6=egCv",xit,-1,6)
        if xit == -1: break

        if xit == 1:
            print "Calculate Cv from Velocity & Dimensions"
            ballweight = u("ball weight ounces",ballweight,.1,100)
            boredrag = u("bore drag pounds",boredrag,0.,100)
            chargedia = u("charge chamber inside diameter inches",chargedia,1,10)
            chargelen = u("charge chamber length inches",chargelen,1,100)
            deadvolume = u("initial volume cubic inches", deadvolume,.1,100)
            boredia = u("bore inside diameter inches",boredia,.1,10)
            borelen = u("bore travel length inches",borelen,1,100)
            p = u("pressure",p,10,150)
            v = u("velocity",v,10,600)
            print "working..."
            print
            print "Chamber %s x %s, Bore %s x %s in"%(chargedia,chargelen,boredia,borelen)
            print "iv %d cu in, Ball %s oz, drag %s lb"%(deadvolume,ballweight,boredrag)
            print
            print "psi  fps    Cv   sec  xbp  xcp  ht tofl"
            print
            chargevolume = cylvol(chargedia,chargelen)
            findcv(p,v)
            print

        elif xit == 6:
            print
            print "Example Cv Solving (using Eric's DV-54 measurements)"
            print "note these Cv values are for dual valves"
            print "for a single valve use about half these values"
            print "be patient, this may take awhile.."

            ballweight = 2.
            cv = 6. * 2
            chargedia = pvc3id
            chargelen = 35.75 * 2
            borelen = 47.
            deadvolume = 30.
            print
            print "Chamber %s x %s, Bore %s x %s in"%(chargedia,chargelen,boredia,borelen)
            print "iv %d cu in, Ball %s oz, drag %s lb"%(deadvolume,ballweight,boredrag)
            print
            print "psi  fps    Cv   sec  xbp  xcp  ht tofl"
            print
            chargevolume = cylvol(chargedia,chargelen)
            #findcv(p,v)
            #findcv(10,200)  #err test
            findcv(20,78)
            findcv(30,173)
            findcv(40,237)
            findcv(50,284)
            findcv(60,323)
            findcv(70,362)
            print
            
        elif xit == 2:
            key()
            
        elif xit == 0:
            print "Calculate velocity et al from Cv & dimensions"
            ballweight = u("ball weight ounces",ballweight,.1,100)
            boredrag = u("bore drag pounds",boredrag,0.,100)
            cv = u("system (valve) Cv (gpm/psi)",cv,.01,100)
            chargedia = u("charge chamber inside diameter inches",chargedia,1,10)
            chargelen = u("charge chamber length inches",chargelen,1,100)
            maxp = u("maximum pressure psi",maxp,1,150)
            deadvolume = u("initial volume cubic inches", deadvolume,.1,100)
            boredia = u("bore inside diameter inches",boredia,.1,10)
            borelen = u("bore travel length inches",borelen,1,100)
            #launcherwt = u("launcher weight pounds",launcherwt,.1,50)
            model = "Compressed Air Launcher Modeler"
            calc()

        elif xit == 3:
            model = "TBL-U37A Example"
            cv = 4.
            chargedia = pvc3id
            chargelen = 24.
            deadvolume = cylvol(pvc2id,7)
            borelen = 20.
            calc()

        elif xit == 4:
            model = "Erics M2 TBL-DV54A Example"
            cv = 6. * 2
            chargedia = pvc3id
            chargelen = 35.75 * 2
            borelen = 47.
            deadvolume = 30.
            calc()
            
        elif xit == 5:
            model = "TBL-QE20A Example"
            cv = 7.
            chargedia = 2.
            chargelen = 20.
            borelen = 12.
            deadvolume = 4.
            calc()

userin()

#eof

