    ' Program Name:  TRANSLIN.BAS
    '
    ' Version 1.0 Started:  September 28, 2003
    ' Version 1.0 Completed:  April 15, 2004
    '
    ' Used in program TRANSLIN.EXE
    '
    ' Language:  Microsoft Visual Basic 3.0, Professional Edition
    '            (Professional Edition features not used)
    '
    ' Programmer:  Stephen R. Bird, WS7R, SRB Enterprises, Wickenburg, AZ

    Option Explicit                         ' force declaration of all variables

        ' ----------------
        ' global variables
        ' ----------------
    Global N As String                      ' newline character
    Global S As String                      ' space string

    Global I As Integer                     ' loop counter
    Global J As Integer                     ' loop counter
    Global TWIPS As Integer                 ' scale mode of all forms

    Global Angle As Single                  ' variable angle for L/XL/C/XC
    Global C As Single                      ' capacitance (picoFarads)
    Global DieCon As Single                 ' input design diel. constant
    Global ElQWaveLenFt As Single           ' elec quarterwavelength (feet)
    Global ElQWaveLenM As Single            ' elec quarterwavelength (meters)
    Global ElWaveLenFt As Single            ' electrical wavelength (feet)
    Global ElWaveLenM As Single             ' electrical wavelength (meters)
    Global Freq As Single                   ' input design frequency
    Global Imped As Single                  ' input design impedance
    Global K As Single                      ' variable ratio
    Global L As Single                      ' inductance (microHenries)
    Global LenFt As Single                  ' length (feet)
    Global LenMt As Single                  ' length (meters)
    Global WaveLen As Single                ' free space wavelength
    Global XC As Single                     ' capacitive reactance (ohms)
    Global XL As Single                     ' inductive reactance (ohms)

        ' ---------------
        ' global constant
        ' ---------------
    Global Const PI = 3.141592654

        ' -------------------
        ' command button tops
        ' -------------------

        ' -------------------------------------------------------------------
        ' all forms are 9000 pixels high except frmAboutCoax, frmAvailPgm,
        '  frmProgHelp, frmRevHist, and frmTLineMenu
        '
        ' if form has no menu bar, scale height = 8595 (405 difference)
        ' if form has a menu bar, scale height = 8310 (690 difference)
        ' on most forms, the command button height is 495
        ' 285 was chosen as an arbitrary space between the bottom of the form
        '  and the bottom of the command buttons
        '
        ' cmdTop1 = 8595 - (495 + 285) = 7815
        ' -------------------------------------------------------------------

    Global Const cmdTop1 = 7815
                    ' used on form:  frmCoaxStub

    Global Const cmdTop2 = 7635
                    ' used on forms:  frmCoaxChar, frmCoaxDiel, frmCoaxPrimer,
                    '  frmOpenWire,  frmSqrCoax, frmSqrLine, and frmTLineMenu

    Global Const cmdTop3 = 7920
                    ' used on forms:  frmCoaxStub, frmProgDir, frmSqrCoax, and
                    '  frmTLinePerf

    Global Const cmdTop4 = 7695
                    ' used on form:  frmTLinePerf

        ' -------------
        ' global arrays
        ' -------------
    Global Form(4) As Integer                           ' form dimensions
        ' --------------------------
        ' individual quantity arrays
        ' --------------------------
            'Form(1) = frmCoaxData.ScaleTop
            'Form(2) = frmCoaxData.ScaleLeft
            'Form(3) = frmCoaxData.ScaleWidth
            'Form(4) = frmCoaxData.ScaleHeight

            'Form(1) = frmCoaxPrimer.ScaleTop
            'Form(2) = frmCoaxPrimer.ScaleLeft
            'Form(3) = frmCoaxPrimer.ScaleWidth
            'Form(4) = frmCoaxPrimer.ScaleHeight

    Global ShellPic(9) As Integer                       ' data shell dimensions
        ' --------------------------------------------------------
        ' individual quantity arrays - frmCoaxData & frmCoaxPrimer
        ' --------------------------------------------------------
            'ShellPic(1) = shell top offset
            'ShellPic(2) = shell bottom offset
            'ShellPic(3) = shell left offset
            'ShellPic(4) = shell right offset
            'ShellPic(5) = top of shell
            'ShellPic(6) = left side of shell
            'ShellPic(7) = width of shell
            'ShellPic(8) = height of shell
            'ShellPic(9) = bottom of shell

    ' --------------------------------------------------------------------------
    ' program project file:
    ' TRANSLIN.MAK
    '
    ' executable file:
    ' TRANSLIN.EXE
    ' --------------------------------------------------------------------------
    ' program includes the following BASIC program:
    ' TRANSLIN.BAS
    '   Function:
    '       Function ValCheck (frm As Form, T As String, Box As Integer,
    '                         Units As String) As Integer
    '
    '   Subprograms:
    '       Sub CenterForm (frm As Form)
    '       Sub ClearForm (frm As Form)
    '       Sub ErrorMessage (frm As Form, ErrorType As Integer, Box As Integer)
    '       Sub Main ()
    '       Sub ProgramTitle (frm As Form, Sp As Integer)
    ' --------------------------------------------------------------------------

    ' --------------------------------------------------------------------------
    ' program requires the following data files (text format):
    '   LINEDATA.FIL
    '   TLINDATA.FIL
    '
    ' program requires the following icon file:
    '   HAMCALC.ICO
    ' --------------------------------------------------------------------------

    ' --------------------------------------------------------------------------
    ' program includes the following forms:
    ' CABLEDAT.FRM      frmCoaxData
    ' CABLELEG.FRM      frmSymbolLegend
    ' COAXABT.FRM       frmAboutCoax
    ' COAXAVAL.FRM      frmAvailPgm
    ' COAXCHAR.FRM      frmCoaxChar
    ' COAXDIEL.FRM      frmCoaxDiel
    ' COAXPRIM.FRM      frmCoaxPrimer
    ' COAXSTUB.FRM      frmCoaxStub
    ' OPENWIRE.FRM      frmOpenWire
    ' PROGDIR.FRM       frmProgDir
    ' SQRCOAX.FRM       frmSqrCoax
    ' SQRLINE.FRM       frmSqrLine
    ' TLINHELP.FRM      frmProgHelp
    ' TLINMENU.FRM      frmTLineMenu
    ' TLINPERF.FRM      frmTLinePerf
    ' TLINREVS.FRM      frmRevHist
    '
    ' CABLEDAT.FRM
    '   Subprograms:
    '       Sub CAPACITANCE ()
    '       Sub CaptionLabels ()
    '       Sub CENTER ()
    '       Sub cmdExit_Click ()
    '       Sub cmdOpenMenu_Click ()
    '       Sub DataLabels ()
    '       Sub DIELECTRIC ()
    '       Sub Form_Load ()
    '       Sub hsbShell_Change ()
    '       Sub IMPEDANCE ()
    '       Sub JACKET ()
    '       Sub LOSS1 ()
    '       Sub LOSS10 ()
    '       Sub LOSS100 ()
    '       Sub LOSS1000 ()
    '       Sub mnuExit_Click ()
    '       Sub mnuLegend_Click ()
    '       Sub mnuSymbol_Click ()
    '       Sub OUTDIAM ()
    '       Sub PARTNUM ()
    '       Sub RGTYPE ()
    '       Sub RMS ()
    '       Sub SHIELD ()
    '       Sub VELOCITY ()
    '       Sub vsbShell_Change ()
    '
    ' CABLELEG.FRM
    '   Subprograms:
    '       Sub cmdClose_Click ()
    '       Sub Form_Load ()
    '
    ' COAXABT.FRM
    '   Subprograms:
    '       Sub cmdOK_Click ()
    '       Sub Form_Load ()
    '
    ' COAXAVAL.FRM
    '   Subprograms:
    '       Sub cmdOK_Click ()
    '       Sub Form_Load ()
    '
    ' COAXCHAR.FRM
    '   Function:
    '       Function VelError () As Integer
    '
    '   Subprograms:
    '       Sub AttenOut (CableData() As String)
    '       Sub AttenText ()
    '       Sub CheckNumUnkInputs ()
    '       Sub ClearPhysDimTable ()
    '       Sub cmdAnother_Click ()
    '       Sub CmdAnotherAttenPos ()
    '       Sub CmdAnotherLenPos ()
    '       Sub CmdAnotherUnkPos ()
    '       Sub cmdAtten_Click ()
    '       Sub CmdAttenPos ()
    '       Sub cmdClose_Click ()
    '       Sub cmdCloseNote_Click ()
    '       Sub CmdDimPos ()
    '       Sub CmdEquatPos ()
    '       Sub cmdExit_Click ()
    '       Sub cmdLen_Click ()
    '       Sub CmdLenPos ()
    '       Sub cmdOK_Click ()
    '       Sub cmdOpenMenu_Click ()
    '       Sub CmdOpenPos ()
    '       Sub cmdUnknown_Click ()
    '       Sub CmdUnknownPos ()
    '       Sub ComputeAtten ()
    '       Sub ComputeLengths ()
    '       Sub ComputeUnknown ()
    '       Sub EquationText ()
    '       Sub Form_Load ()
    '       Sub GetAttenInput ()
    '       Sub mnuExit_Click ()
    '       Sub mnuNote_Click ()
    '       Sub mnuProgDir_Click ()
    '       Sub mnuRanges_Click ()
    '       Sub optAtten_Click ()
    '       Sub optDielConst_Click ()
    '       Sub optDimen_Click ()
    '       Sub optEquations_Click ()
    '       Sub optInches_Click ()
    '       Sub optLineLen_Click ()
    '       Sub optMeters_Click ()
    '       Sub optMillimeters_Click ()
    '       Sub optSqCoax_Click ()
    '       Sub optTable_Click ()
    '       Sub optUnknown_Click ()
    '       Sub optUS_Click ()
    '       Sub OutputCB (CapIn As Single, BIn As Single)
    '       Sub OutputCE (CapIn As Single, DielIn As Single)
    '       Sub OutputCL (CapIn As Single, IndIn As Single)
    '       Sub OutputCV (CapIn As Single, VelIn As Single)
    '       Sub OutputEB (DielIn As Single, BIn As Single)
    '       Sub OutputEV ()
    '       Sub OutputLB ()
    '       Sub OutputLE (IndIn As Single, DielIn As Single)
    '       Sub OutputLV (IndIn As Single, VelIn As Single)
    '       Sub OutputVB (VelIn As Single, BIn As Single)
    '       Sub OutputZB (ZIn As Single, BIn As Single)
    '       Sub OutputZC (ZIn As Single, CapIn As Single, DielIn As Single)
    '       Sub OutputZE (ZIn As Single, DielIn As Single)
    '       Sub OutputZL (ZIn As Single, IndIn As Single)
    '       Sub OutputZV (ZIn As Single, VelIn As Single)
    '       Sub PhysDimTable ()
    '       Sub ReadCoaxData ()
    '
    ' COAXDIEL.FRM
    '   Subprograms:
    '       Sub cmdAnother_Click ()
    '       Sub cmdClose_Click ()
    '       Sub cmdCompute_Click ()
    '       Sub cmdContinue_Click ()
    '       Sub cmdExit_Click ()
    '       Sub cmdOK_Click ()
    '       Sub cmdOpenMenu_Click ()
    '       Sub Form_Load ()
    '       Sub mnuExit_Click ()
    '       Sub mnuProgDir_Click ()
    '       Sub mnuRanges_Click ()
    '       Sub ShowDielTable ()
    '
    ' COAXPRIM.FRM
    '   Subprograms:
    '       Sub CheckInputs ()
    '       Sub CheckNumInputs ()
    '       Sub cmdAnother_Click ()
    '       Sub CmdAnotherPos ()
    '       Sub cmdClose_Click ()
    '       Sub cmdCompute_Click ()
    '       Sub cmdContinue_Click ()
    '       Sub CmdContinuePos ()
    '       Sub cmdExit_Click ()
    '       Sub cmdExitHelp_Click ()
    '       Sub cmdOK_Click ()
    '       Sub cmdOpenMenu_Click ()
    '       Sub CmdOpenPos ()
    '       Sub ComputeOutput ()
    '       Sub Form_Load ()
    '       Sub Help ()
    '       Sub mnuExit_Click ()
    '       Sub mnuHelp_Click ()
    '       Sub mnuProgDir_Click ()
    '       Sub mnuRanges_Click ()
    '       Sub ShowPrimer ()
    '       Sub vsbShell_Change ()
    '
    ' COAXSTUB.FRM
    '   Function:
    '       Function CheckInput () As Integer
    '
    '   Subprograms:
    '       Sub cmdAnother_Click ()
    '       Sub CmdAnotherPos ()
    '       Sub CmdAnotherSpPos ()
    '       Sub cmdClose_Click ()
    '       Sub cmdCompute_Click ()
    '       Sub cmdExit_Click ()
    '       Sub cmdLineData_Click ()
    '       Sub cmdOK_Click ()
    '       Sub cmdOpenMenu_Click ()
    '       Sub CmdOpenPos ()
    '       Sub cmdPrintDesign_Click ()
    '       Sub cmdSpecific_Click ()
    '       Sub CmdSpecificPos ()
    '       Sub ComputeOutput (Freq, Imped, DieCon)
    '       Sub Form_Load ()
    '       Sub lstCoaxData_Click ()
    '       Sub mnuExit_Click ()
    '       Sub mnuHelp_Click ()
    '       Sub mnuProgDir_Click ()
    '       Sub mnuRanges_Click ()
    '       Sub optCapacitance_Click ()
    '       Sub optCapReact_Click ()
    '       Sub optFrequency_Click ()
    '       Sub optInductance_Click ()
    '       Sub optInductReact_Click ()
    '       Sub optLength_Click ()
    '       Sub optMetric_Click ()
    '       Sub optNo_Click ()
    '       Sub optUS_Click ()
    '       Sub optYes_Click ()
    '       Sub ReadLineData ()
    '       Sub ResetFrames ()
    '       Sub ShowInputPicture ()
    '       Sub ShowOutputPicture ()
    '       Sub ShowSpecificOutput ()
    '       Sub SpCapacitance (Freq, Imped, DieCon)
    '       Sub SpCapReact (Freq, Imped, DieCon)
    '       Sub SpFrequency (DieCon)
    '       Sub SpInductance (Freq, Imped, DieCon)
    '       Sub SpInductReact (Freq, Imped, DieCon)
    '       Sub SpLength (Freq, Imped, DieCon)
    '       Sub StubInfo ()
    '
    ' OPENWIRE.FRM
    '   Subprograms:
    '       Sub cmdAnother_Click ()
    '       Sub CmdAnotherPos ()
    '       Sub CmdCalcDoublePos ()
    '       Sub cmdCalcDubLoss_Click ()
    '       Sub CmdCalcDubLossPos ()
    '       Sub cmdCalcDubWire_Click ()
    '       Sub CmdCalcQuadPos ()
    '       Sub cmdCalcQuadWire_Click ()
    '       Sub CmdCalcSinglePos ()
    '       Sub cmdCalcSinWire_Click ()
    '       Sub cmdClose_Click ()
    '       Sub cmdCloseDim_Click ()
    '       Sub cmdCloseType_Click ()
    '       Sub cmdExit_Click ()
    '       Sub cmdOK_Click ()
    '       Sub cmdOpenMenu_Click ()
    '       Sub CmdOpenPos ()
    '       Sub DoubleZOut ()
    '       Sub Form_Load ()
    '       Sub GetWireInput ()
    '       Sub mnuExit_Click ()
    '       Sub mnuProgDir_Click ()
    '       Sub mnuRanges_Click ()
    '       Sub opt100_Click ()
    '       Sub opt150_Click ()
    '       Sub optAWG_Click ()
    '       Sub optDoubleLoss_Click ()
    '       Sub optDoubleZ_Click ()
    '       Sub optHTFt_Click ()
    '       Sub optHTMet_Click ()
    '       Sub optIN_Click ()
    '       Sub optInch_Click ()
    '       Sub optLLFt_Click ()
    '       Sub optLLMet_Click ()
    '       Sub optMil_Click ()
    '       Sub optMM_Click ()
    '       Sub optQuadZ_Click ()
    '       Sub optSingleZ_Click ()
    '       Sub optSqrPar_Click ()
    '       Sub optTypOpen_Click ()
    '       Sub optUSOpen_Click ()
    '       Sub QuadOut ()
    '
    ' PROGDIR.FRM
    '   Subprograms:
    '       Sub cmdExit_Click ()
    '       Sub CoaxChar ()
    '       Sub Form_Load ()
    '       Sub MainMenu ()
    '       Sub OpenWire ()
    '       Sub optAtten_Click ()
    '       Sub optChar_Click ()
    '       Sub optData_Click ()
    '       Sub optDiel_Click ()
    '       Sub optEquat_Click ()
    '       Sub optLen_Click ()
    '       Sub optOpen_Click ()
    '       Sub optPerf_Click ()
    '       Sub optPhys_Click ()
    '       Sub optPrimer_Click ()
    '       Sub optQuad_Click ()
    '       Sub optSingle_Click ()
    '       Sub optSpLoss2_Click ()
    '       Sub optSqrCoax_Click ()
    '       Sub optSqrPar_Click ()
    '       Sub optStubs_Click ()
    '       Sub optTypOpen_Click ()
    '       Sub optUnkCoax_Click ()
    '       Sub optUSOpen_Click ()
    '       Sub optZLoss2_Click ()
    '
    ' SQRCOAX.FRM
    '   Subprograms:
    '       Sub AccuracyNote ()
    '       Sub cmdAnother_Click ()
    '       Sub CmdAnotherPos ()
    '       Sub CmdCalcPos ()
    '       Sub cmdCalculate_Click ()
    '       Sub cmdClose_Click ()
    '       Sub cmdContinue_Click ()
    '       Sub cmdExit_Click ()
    '       Sub cmdOK_Click ()
    '       Sub cmdOpenMenu_Click ()
    '       Sub CmdOpenPos ()
    '       Sub cmdRetry_Click ()
    '       Sub ComputeSqRnd (CCD As Single, SH As Single, Z As Single)
    '       Sub ComputeSqSq (CCF As Single, SH As Single, Z As Single)
    '       Sub ErrorGap ()
    '       Sub Form_Load ()
    '       Sub InputScrn ()
    '       Sub mnuExit_Click ()
    '       Sub mnuProgDir_Click ()
    '       Sub mnuRanges_Click ()
    '       Sub optCentMtrs_Click ()
    '       Sub optCtrCond_Click ()
    '       Sub optImped_Click ()
    '       Sub optInches_Click ()
    '       Sub optShield_Click ()
    '       Sub optSqRnd_Click ()
    '       Sub optSqSq_Click ()
    '       Sub OutputDesign ()
    '       Sub SetupInputScrn ()
    '
    ' SQRLINE.FRM
    '   Function:
    '       Function CheckInput () As Integer
    '
    '   Subprograms:
    '       Sub cmdAnother_Click ()
    '       Sub CmdAnotherPos ()
    '       Sub cmdCompute_Click ()
    '       Sub cmdExit_Click ()
    '       Sub cmdExitLimits_Click ()
    '       Sub cmdOK_Click ()
    '       Sub cmdOpenMenu_Click ()
    '       Sub CmdOpenPos ()
    '       Sub cmdRetry_Click ()
    '       Sub ErrorGap ()
    '       Sub Form_Load ()
    '       Sub mnuExit_Click ()
    '       Sub mnuProgDir_Click ()
    '       Sub mnuRanges_Click ()
    '       Sub optImped_Click ()
    '       Sub optInches_Click ()
    '       Sub optMillimeters_Click ()
    '       Sub optSpacing_Click ()
    '       Sub ShowOutputPicture ()
    '       Sub Warning (Z As Single)
    '
    ' TLINHELP.FRM
    '   Subprograms:
    '       Sub cmdOK_Click ()
    '       Sub Form_Load ()
    '
    ' TLINMENU.FRM
    '   Subprograms:
    '       Sub cmdExit_Click ()
    '       Sub Form_Load ()
    '       Sub mnuAbout_Click ()
    '       Sub mnuExit_Click ()
    '       Sub mnuHelp_Click ()
    '       Sub mnuProgAvail_Click ()
    '       Sub mnuProgDir_Click ()
    '       Sub mnuRevHist_Click ()
    '       Sub optCoaxChar_Click ()
    '       Sub optCoaxPrimer_Click ()
    '       Sub optCoaxStubs_Click ()
    '       Sub optOpenWire_Click ()
    '       Sub optTLinePerf_Click ()
    '
    ' TLINPERF.FRM
    '   Function:
    '       Function CheckInput () As Integer
    '
    '   Subprograms:
    '       Sub cmdAnother_Click ()
    '       Sub CmdAnotherPos ()
    '       Sub cmdClose_Click ()
    '       Sub cmdCompute_Click ()
    '       Sub cmdContinue_Click ()
    '       Sub CmdContinuePos ()
    '       Sub cmdExit_Click ()
    '       Sub cmdOK_Click ()
    '       Sub cmdOpenMenu_Click ()
    '       Sub CmdOpenPos ()
    '       Sub ComputeEI ()
    '       Sub ComputePower ()
    '       Sub Form_Load ()
    '       Sub mnuExit_Click ()
    '       Sub mnuProgDir_Click ()
    '       Sub mnuRanges_Click ()
    '       Sub InputScreen ()
    '       Sub optDegrees_Click ()
    '       Sub optEI_Click ()
    '       Sub optFeet_Click ()
    '       Sub optMeters_Click ()
    '       Sub optNo_Click ()
    '       Sub optPower_Click ()
    '       Sub optYes_Click ()
    '       Sub OutputScreen ()
    '       Sub OutputTable ()
    '       Sub vsbShell_Change ()
    '
    ' TLINREVS.FRM
    '   Subprograms:
    '       Sub cmdOK_Click ()
    '       Sub Form_Load ()
    ' --------------------------------------------------------------------------

    Sub CenterForm (frm As Form)

        ' ========================================
        ' Subprogram to center forms on the screen
        ' ========================================
        ' parent:  TRANSLIN.BAS
        ' ========================================

            ' -------------------------
            ' dimension local variables
            ' -------------------------
        Dim LeftSide As Integer
        Dim TopOfForm As Integer

            ' ---------------------------------------
            ' determine location of left side of form
            ' ---------------------------------------
        LeftSide = (Screen.Width - frm.Width) / 2

            ' ---------------------------------
            ' determine location of top of form
            ' ---------------------------------
        TopOfForm = (Screen.Height - frm.Height) / 2

            ' -----------------------
            ' position form on screen
            ' -----------------------
        frm.Move LeftSide, TopOfForm

    End Sub                                         ' CenterForm (frm As Form)

    Sub ClearForm (frm As Form)

        ' =============================================
        ' CLEAR ALL TEXT BOXES AND LABELS ON GIVEN FORM
        ' =============================================
        ' parent:  TRANSLIN.BAS
        ' =============================================

            ' -----------
            ' frmCoaxDiel
            ' -----------
        If frmCoaxDiel.Visible = True Then
            frm.lblCalcDielOut.Caption = ""
            frm.lblCalcVFOut.Caption = ""
            frm.txtPubCapac.Text = ""
            frm.txtPubZo.Text = ""

            ' -----------
            ' frmCoaxChar
            ' -----------
        ElseIf frmCoaxChar.Visible = True Then
            frm.lbl8LineFt.Caption = ""
            frm.lbl8LineMt.Caption = ""
            frm.lblFreeFt.Caption = ""
            frm.lblFreeMt.Caption = ""
            frm.lblHfLineFt.Caption = ""
            frm.lblHfLineMt.Caption = ""
            frm.lblLineFt.Caption = ""
            frm.lblLineMt.Caption = ""
            frm.lblQLineFt.Caption = ""
            frm.lblQLineMt.Caption = ""
            frm.lblVFOut.Caption = ""

            frm.txtFreq.Text = ""
            frm.txtLineLen.Text = ""
            frm.txtOpFreq.Text = ""
            frm.txtUnkCap.Text = ""
            frm.txtUnkDiel.Text = ""
            frm.txtUnkImped.Text = ""
            frm.txtUnkInduct.Text = ""
            frm.txtUnkRatio.Text = ""
            frm.txtUnkVel.Text = ""

            ' -------------
            ' frmCoaxPrimer
            ' -------------
        ElseIf frmCoaxPrimer.Visible = True Then
            frm.lblAttenOut.Caption = ""
            frm.lblCapOut.Caption = ""
            frm.lblImpedOut.Caption = ""
            frm.lblTDOut.Caption = ""
            frm.lblVBDOut.Caption = ""
            frm.lblVelOut.Caption = ""

            frm.txtAlt.Text = ""
            frm.txtDiel.Text = ""
            frm.txtFreq.Text = ""
            frm.txtID.Text = ""
            frm.txtK1.Text = ""
            frm.txtOD.Text = ""
            frm.txtPF.Text = ""
            frm.txtRMS.Text = ""

            ' -----------
            ' frmCoaxStub
            ' -----------
        ElseIf frmCoaxStub.Visible = True Then
            frm.txtDielConst.Text = ""
            frm.txtFreq.Text = ""
            frm.txtImped.Text = ""
            frm.txtSpInput.Text = ""

            ' -----------
            ' frmOpenWire
            ' -----------
        ElseIf frmOpenWire.Visible = True Then
            frm.txtACBD.Text = ""
            frm.txtADBC.Text = ""
            frm.txtCCIn.Text = ""
            frm.txtFreq.Text = ""
            frm.txtHT.Text = ""
            frm.txtLinLen.Text = ""
            frm.txtWire.Text = ""
            frm.txtZIn.Text = ""

        End If

    End Sub                                         ' ClearForm (frm As Form)

    Sub ErrorMessage (frm As Form, ErrorType As Integer, Box As Integer)

        ' =================================================================
        ' Output error messages if input is out of valid range or if input
        '  contains an invalid character - clears invalid input and re-sets
        '  focus to the appropriate input text box
        ' =================================================================
        '
        ' frm is the form being checked.
        '
        ' Error types:
        '  10 = invalid character
        '  20 = invalid range
        '
        ' Box indicates the text box being checked.
        '   1 = txtPubZo (frmCoaxDiel)
        '   2 = txtPubCapac (frmCoaxDiel)
        '   3 = txtLineLen (frmCoaxChar)
        '   4 = txtFreq (frmCoaxChar)
        '   5 = txtUnkImped (frmCoaxChar)
        '   6 = txtUnkCap (frmCoaxChar)
        '   7 = txtUnkInduct (frmCoaxChar)
        '   8 = txtUnkDiel (frmCoaxChar)
        '   9 = txtUnkVel (frmCoaxChar)
        '  10 = txtUnkRatio (frmCoaxChar)
        '  11 = txtID (frmCoaxPrimer)
        '  12 = txtOD (frmCoaxPrimer)
        '  13 = txtDiel (frmCoaxPrimer)
        '  14 = txtK1 (frmCoaxPrimer)
        '  15 = txtK2 (frmCoaxPrimer)
        '  16 = txtFreq (frmCoaxPrimer)
        '  17 = txtPF (frmCoaxPrimer)
        '  18 = txtAlt (frmCoaxPrimer)
        '  19 = txtRMS (frmCoaxPrimer)
        '  20 = txtOpFreq (frmCoaxChar)
        '  21 = txtFreq (frmCoaxStub)
        '  22 = txtImped (frmCoaxStub)
        '  23 = txtDielConst (frmCoaxStub)
        '  24 = txtSpInput (frmCoaxStub)
        '  25 = txtInput (frmSqrLine)
        '  26 = txtWidth (frmSqrLine)
        '  27 = txtParam1 (frmSqrCoax)
        '  28 = txtParam2 (frmSqrCoax)
        '  29 = txtAntR (frmTLinePerf)
        '  30 = txtAntX (frmTLinePerf)
        '  31 = txtLoadPwr (frmTLinePerf)
        '  32 = txtAntLoadI (frmTLinePerf)
        '  33 = txtLoadIPhase (frmTLinePerf)
        '  34 = txtAntLoadV (frmTLinePerf)
        '  35 = txtLoadVPhase (frmTLinePerf)
        '  36 = txtLLDeg (frmTLinePerf)
        '  37 = txtLLFt (frmTLinePerf)
        '  38 = txtLLMt (frmTLinePerf)
        '  39 = txtFreqIn (frmTLinePerf)
        '  40 = txtCharZ (frmTLinePerf)
        '  41 = txtLineVFDec (frmTLinePerf)
        '  42 = txtWire (frmOpenWire)
        '  43 = txtHT (frmOpenWire)
        '  44 = txtCCIn (frmOpenWire)
        '  45 = txtLinLen (frmOpenWire)
        '  46 = txtFreq (frmOpenWire)
        '  47 = txtZIn (frmOpenWire)
        '  48 = txtACBD (frmOpenWire)
        '  49 = txtADBC (frmOpenWire)
        '
        ' Message box values:
        '   0 = first button (Retry) is default
        '   5 = display Retry and Cancel buttons
        '  16 = stop sign icon
        ' =================================================================
        ' parent:  TRANSLIN.BAS
        ' =================================================================

            ' -----------------------
            ' declare local variables
            ' -----------------------
        Dim Msg1 As String                      ' error messages - range limits
        Dim Msg2 As String
        Dim Msg3 As String
        Dim Msg4 As String
        Dim Msg5 As String
        Dim Msg6 As String
        Dim Msg7 As String
        Dim Msg8 As String
        Dim Msg9 As String
        Dim Msg10 As String
        Dim Msg11 As String
        Dim Msg12 As String
        Dim Msg13 As String
        Dim Msg14 As String
        Dim Msg15 As String
        Dim Msg16 As String
        Dim Msg17 As String
        Dim Msg18 As String
        Dim Msg19 As String
        Dim Msg20 As String
        Dim Msg21 As String
        Dim Msg22 As String
        Dim Msg23 As String
        Dim Msg24 As String
        Dim Msg25 As String
        Dim Msg26 As String
        Dim Msg27 As String
        Dim Msg28 As String
        Dim Msg29 As String
        Dim Msg30 As String
        Dim Msg31 As String
        Dim Msg32 As String
        Dim Msg33 As String
        Dim Msg34 As String
        Dim Msg35 As String
        Dim Msg36 As String
        Dim Msg37 As String
        Dim Msg38 As String
        Dim Msg39 As String
        Dim Msg40 As String
        Dim Msg41 As String
        Dim Msg42 As String
        Dim Msg43 As String
        Dim Msg44 As String
        Dim Msg45 As String
        Dim Msg46 As String
        Dim Msg47 As String
        Dim Msg48 As String
        Dim Msg49 As String
        Dim Msg50 As String
        Dim Msg51 As String
        Dim Msg52 As String
        Dim Msg53 As String
        Dim Msg54 As String

        Dim Title As String
        Dim Response As Integer
'==                                                                            |
            ' ------------------------
            ' message box text strings
            ' ------------------------
        Title = " Input Error"                  ' leading space for readability
        Msg1 = "Illegal Input Character - Must be a digit."
        Msg2 = "Illegal Input Value - Out of Valid Range."
        Msg3 = Chr(10) + "Range:  > 0 and <= 125 ohms)"         ' boxes 1 & 5
        Msg4 = Chr(10) + "Range:  >= 6 and <= 35 pF/ft."        ' boxes 2 & 6
        Msg5 = Chr(10) + "Range:  >= 0.03 and <= 2000 ft."      ' boxes 3 & 24
        Msg6 = Chr(10) + "Range:  >= 0.009 and <= 610 mt."      ' boxes 3 & 24
        Msg7 = Chr(10) + "Range:  >= 0.1 and <= 999.999 MHz"    ' boxes 4, 16,
                                                                '  20, 21, 24,
                                                                '  & 39
        Msg8 = Chr(10) + "Range:  > 0 and <= 0.2 microH/ft."    ' box 7
        Msg9 = Chr(10) + "Range:  > 1.0 and <= 3.0"             ' boxes 8, 13,
                                                                '  & 23
        Msg10 = Chr(10) + "Range:  >= 50 and < 100 %"           ' box 9
        Msg11 = Chr(10) + "Range:  > 2.5 and < 13"              ' box 10
        Msg12 = Chr(10) + "Range:  > 0 and <= 1.2 inches"       ' box 11
        Msg13 = Chr(10) + "Range:  >= 0.01 and <= 0.33 inches"  ' box 12
        Msg14 = Chr(10) + "Range:  >= 0.939 and <= 1.0"         ' boxes 14 & 15
        Msg15 = Chr(10) + "Range:  >= 0.00000001 and <= 0.0001" ' box 17
        Msg16 = Chr(10) + "Range:  > - 300 and <= 21000 feet"       ' box 18
        Msg17 = Chr(10) + "Range:  >= 300 and <= 11000 volts"       ' box 19
        Msg18 = Chr(10) + "Range:  >= 1 and <= 100,000 picoFarads"  ' box 24
        Msg19 = Chr(10) + "Range:  >= 1 and <= 250 ohms"            ' box 24 (XC)
        Msg20 = Chr(10) + "Range:  >= .01 and <= 3000 microHenries" ' box 24
        Msg21 = Chr(10) + "Range:  >= 150 and <= 2000 ohms"         ' box 24 (XL)
        Msg22 = Chr(10) + "Range:  >= 0 and <= 600 ohms"            ' box 22, 40
        Msg23 = Chr(10) + "Range:  >= 10 and <= 800 ohms"           ' box 25
        Msg24 = Chr(10) + "Range:  >= 0.0012 and <= 46.36 inches"   ' box 25
        Msg25 = Chr(10) + "Range:  >= 0.030 and <= 1178 mm"         ' box 25
        Msg26 = Chr(10) + "Range:  >= 0.001 and <= 0.100 inches"    ' box 26
        Msg27 = Chr(10) + "Range:  >= 0.0254 and <= 2.54 mm"        ' box 26
        Msg28 = Chr(10) + "Range:  >= 0.1 and <= 30 inches"         ' box 27
        Msg29 = Chr(10) + "Range:  >= 0.254 and <= 76.2 centimeters"' box 27
        Msg30 = Chr(10) + "Range:  >= 0.2 and <= 30 inches"         ' boxes 27
                                                                    '  and 28
        Msg31 = Chr(10) + "Range:  >= 0.508 and <= 76.2 centimeters"' boxes 27
                                                                    '  and 28
        Msg32 = Chr(10) + "Range:  >= 10 and <= 150 ohms"           ' box 28
        Msg33 = Chr(10) + "Range:  >= 0.1 and <= 1"                 ' box 41
        Msg34 = Chr(10) + "Range:  >= 0 and <= 1000 ohms"           ' boxes 29
                                                                    '  and 30
        Msg35 = Chr(10) + "Range:  > 0 and <= 2500 watts"           ' box 31
        Msg36 = Chr(10) + "Range:  >= 10 and <= 600 ohms"           ' box 40
        Msg37 = Chr(10) + "Range:  > 0 and <= 16 amps"              ' box 32
        Msg38 = Chr(10) + "Range:  > 0 and <= 16000 volts"          ' box 34
        Msg39 = Chr(10) + "Range:  > 0 and <= 5000 feet"            ' box 37
        Msg40 = Chr(10) + "Range:  > 0 and <= 1500 meters"          ' box 38
        Msg41 = Chr(10) + "Range:  >= 0 and <= 360 degrees"         ' box 36
        Msg42 = Chr(10) + "range:  >= -360 and <= 360 degrees"      ' boxes 33
                                                                    '  and 35
        Msg43 = Chr(10) + "range:  >= 0.0031 and <= 0.2893 in"      ' box 42
        Msg44 = Chr(10) + "range:  >= 0.0787 and <= 7.2325 mm"      ' box 42
        Msg45 = Chr(10) + "range:  >= #1 and <= #40 AWG"            ' box 42
        Msg46 = Chr(10) + "range:  > 0 <= 300 feet"                 ' box 43
        Msg47 = Chr(10) + "range:  > 0 and <= 100 meters"           ' box 43
        Msg48 = Chr(10) + "range:  > 0 and <= 12 inches"            ' box 44
        Msg49 = Chr(10) + "range:  > 0 and <= 300 millimeters"      ' box 44
        Msg50 = Chr(10) + "range:  > 0 and <= 500 feet"             ' box 45
        Msg51 = Chr(10) + "range:  > 0 and <= 150 meters"           ' box 45
        Msg52 = Chr(10) + "range:  >= 85 and <= 800 ohms"           ' box 47
        Msg53 = Chr(10) + "range:  > 0 and <= 12 inches"            ' boxes 48
                                                                    '  and 49
        Msg54 = Chr(10) + "range:  > 0 and <= 300 millimeters"      ' boxes 48
                                                                    '  and 49
            ' --------------------------------------
            ' nominal impedance (ohms) - frmCoaxDiel
            ' --------------------------------------
        If Box = 1 And ErrorType = 10 Then              ' character error
            Response = MsgBox(Msg1, 5 + 16 + 0, Title)
            If Response = 4 Then                        ' retry
                frm.txtPubZo.Text = ""                  ' clear input
                frm.txtPubZo.SetFocus                   ' set focus
                Exit Sub                                ' exit on error
            ElseIf Response = 2 Then                    ' cancel
                frm.txtPubZo.SetFocus                   ' set focus
                ClearForm frm                           ' clear the form
                Exit Sub                                ' exit on error
            End If                                      ' end character error
        ElseIf Box = 1 And ErrorType = 20 Then          ' range error
            Response = MsgBox(Msg2 + Msg3, 5 + 16 + 0, Title)
            If Response = 4 Then                        ' retry
                frm.txtPubZo.Text = ""
                frm.txtPubZo.SetFocus
                Exit Sub
            ElseIf Response = 2 Then                    ' cancel
                frm.txtPubZo.SetFocus
                ClearForm frm
                Exit Sub
            End If                                      ' end range error
        End If

            ' --------------------------------------------
            ' published capacitance (pF/ft.) - frmCoaxDiel
            ' --------------------------------------------
        If Box = 2 And ErrorType = 10 Then              ' character error
            Response = MsgBox(Msg1, 5 + 16 + 0, Title)
            If Response = 4 Then                        ' retry
                frm.txtPubCapac.Text = ""
                frm.txtPubCapac.SetFocus
                Exit Sub
            ElseIf Response = 2 Then                    ' cancel
                frm.txtPubZo.SetFocus
                ClearForm frm
                Exit Sub
            End If                                      ' end character error
        ElseIf Box = 2 And ErrorType = 20 Then          ' range error
            Response = MsgBox(Msg2 + Msg4, 5 + 16 + 0, Title)
            If Response = 4 Then                        ' retry
                frm.txtPubCapac.Text = ""
                frm.txtPubCapac.SetFocus
                Exit Sub
            ElseIf Response = 2 Then                    ' cancel
                frm.txtPubZo.SetFocus
                ClearForm frm
                Exit Sub
            End If                                      ' end range error
        End If

            ' --------------------------------
            ' line length (feet) - frmCoaxChar
            ' --------------------------------
        If Box = 3 And ErrorType = 10 Then              ' character error
            Response = MsgBox(Msg1, 5 + 16 + 0, Title)
            If Response = 4 Then                        ' retry
                frm.txtLineLen.Text = ""
                frm.txtLineLen.SetFocus
                Exit Sub
            ElseIf Response = 2 Then                    ' cancel
                frm.txtLineLen.SetFocus
                ClearForm frm
                Exit Sub
            End If                                      ' end character error
        ElseIf Box = 3 And ErrorType = 20 Then          ' range error
            Response = MsgBox(Msg2 + Msg5 + Msg6, 5 + 16 + 0, Title)
            If Response = 4 Then                        ' retry
                frm.txtLineLen.Text = ""
                frm.txtLineLen.SetFocus
                Exit Sub
            ElseIf Response = 2 Then                    ' cancel
                frm.txtLineLen.SetFocus
                ClearForm frm
                Exit Sub
            End If                                      ' end range error
        End If

            ' -----------------------------
            ' frequency (MHz) - frmCoaxChar
            ' -----------------------------
        If Box = 4 And ErrorType = 10 Then              ' character error
            Response = MsgBox(Msg1, 5 + 16 + 0, Title)
            If Response = 4 Then                        ' retry
                frm.txtFreq.Text = ""
                frm.txtFreq.SetFocus
                Exit Sub
            ElseIf Response = 2 Then                    ' cancel
                frm.txtLineLen.SetFocus
                ClearForm frm
                Exit Sub
            End If                                      ' end character error
        ElseIf Box = 4 And ErrorType = 20 Then          ' range error
            Response = MsgBox(Msg2 + Msg7, 5 + 16 + 0, Title)
            If Response = 4 Then                        ' retry
                frm.txtFreq.Text = ""
                frm.txtFreq.SetFocus
                Exit Sub
            ElseIf Response = 2 Then                    ' cancel
                frm.txtLineLen.SetFocus
                ClearForm frm
                Exit Sub
            End If                                      ' end range error
        End If

            ' --------------------------------------
            ' unknown impedance (ohms) - frmCoaxChar
            ' --------------------------------------
        If Box = 5 And ErrorType = 10 Then              ' character error
            Response = MsgBox(Msg1, 5 + 16 + 0, Title)
            If Response = 4 Then                        ' retry
                frm.txtUnkImped.Text = ""
                frm.txtUnkImped.SetFocus
                Exit Sub
            ElseIf Response = 2 Then                    ' cancel
                frm.txtUnkImped.SetFocus
                ClearForm frm
                Exit Sub
            End If                                      ' end character error
        ElseIf Box = 5 And ErrorType = 20 Then          ' range error
            Response = MsgBox(Msg2 + Msg3, 5 + 16 + 0, Title)
            If Response = 4 Then                        ' retry
                frm.txtUnkImped.Text = ""
                frm.txtUnkImped.SetFocus
                Exit Sub
            ElseIf Response = 2 Then                    ' cancel
                frm.txtUnkImped.SetFocus
                ClearForm frm
                Exit Sub
            End If                                      ' end range error
        End If

            ' ------------------------------------------
            ' unknown capacitance (pF/ft.) - frmCoaxChar
            ' ------------------------------------------
        If Box = 6 And ErrorType = 10 Then              ' character error
            Response = MsgBox(Msg1, 5 + 16 + 0, Title)
            If Response = 4 Then                        ' retry
                frm.txtUnkCap.Text = ""
                frm.txtUnkCap.SetFocus
                Exit Sub
            ElseIf Response = 2 Then                    ' cancel
                frm.txtUnkImped.SetFocus
                ClearForm frm
                Exit Sub
            End If                                      ' end character error
        ElseIf Box = 6 And ErrorType = 20 Then          ' range error
            Response = MsgBox(Msg2 + Msg4, 5 + 16 + 0, Title)
            If Response = 4 Then                        ' retry
                frm.txtUnkCap.Text = ""
                frm.txtUnkCap.SetFocus
                Exit Sub
            ElseIf Response = 2 Then                    ' cancel
                frm.txtUnkImped.SetFocus
                ClearForm frm
                Exit Sub
            End If                                      ' end range error
        End If

            ' ---------------------------------------------
            ' unknown inductance (microH/ft.) - frmCoaxChar
            ' ---------------------------------------------
        If Box = 7 And ErrorType = 10 Then              ' character error
            Response = MsgBox(Msg1, 5 + 16 + 0, Title)
            If Response = 4 Then                        ' retry
                frm.txtUnkInduct.Text = ""
                frm.txtUnkInduct.SetFocus
                Exit Sub
            ElseIf Response = 2 Then                    ' cancel
                frm.txtUnkImped.SetFocus
                ClearForm frm
                Exit Sub
            End If                                      ' end character error
        ElseIf Box = 7 And ErrorType = 20 Then          ' range error
            Response = MsgBox(Msg2 + Msg8, 5 + 16 + 0, Title)
            If Response = 4 Then                        ' retry
                frm.txtUnkInduct.Text = ""
                frm.txtUnkInduct.SetFocus
                Exit Sub
            ElseIf Response = 2 Then                    ' cancel
                frm.txtUnkImped.SetFocus
                ClearForm frm
                Exit Sub
            End If                                      ' end range error
        End If

            ' -----------------------------------------
            ' unknown dielectric constant - frmCoaxChar
            ' -----------------------------------------
        If Box = 8 And ErrorType = 10 Then              ' character error
            Response = MsgBox(Msg1, 5 + 16 + 0, Title)
            If Response = 4 Then                        ' retry
                frm.txtUnkDiel.Text = ""
                frm.txtUnkDiel.SetFocus
                Exit Sub
            ElseIf Response = 2 Then                    ' cancel
                frm.txtUnkImped.SetFocus
                ClearForm frm
                Exit Sub
            End If                                      ' end character error
        ElseIf Box = 8 And ErrorType = 20 Then          ' range error
            Response = MsgBox(Msg2 + Msg9, 5 + 16 + 0, Title)
            If Response = 4 Then                        ' retry
                frm.txtUnkDiel.Text = ""
                frm.txtUnkDiel.SetFocus
                Exit Sub
            ElseIf Response = 2 Then                    ' cancel
                frm.txtUnkImped.SetFocus
                ClearForm frm
                Exit Sub
            End If                                      ' end range error
        End If

            ' -----------------------------------------
            ' unknown velocity factor (%) - frmCoaxChar
            ' -----------------------------------------
        If Box = 9 And ErrorType = 10 Then              ' character error
            Response = MsgBox(Msg1, 5 + 16 + 0, Title)
            If Response = 4 Then                        ' retry
                frm.txtUnkVel.Text = ""
                frm.txtUnkVel.SetFocus
                Exit Sub
            ElseIf Response = 2 Then                    ' cancel
                frm.txtUnkImped.SetFocus
                ClearForm frm
                Exit Sub
            End If                                      ' end character error
        ElseIf Box = 9 And ErrorType = 20 Then          ' range error
            Response = MsgBox(Msg2 + Msg10, 5 + 16 + 0, Title)
            If Response = 4 Then                        ' retry
                frm.txtUnkVel.Text = ""
                frm.txtUnkVel.SetFocus
                Exit Sub
            ElseIf Response = 2 Then                    ' cancel
                frm.txtUnkImped.SetFocus
                ClearForm frm
                Exit Sub
            End If                                      ' end range error
        End If

            ' ------------------------------------
            ' unknown diameter ratio - frmCoaxChar
            ' ------------------------------------
        If Box = 10 And ErrorType = 10 Then             ' character error
            Response = MsgBox(Msg1, 5 + 16 + 0, Title)
            If Response = 4 Then                        ' retry
                frm.txtUnkRatio.Text = ""
                frm.txtUnkRatio.SetFocus
                Exit Sub
            ElseIf Response = 2 Then                    ' cancel
                frm.txtUnkImped.SetFocus
                ClearForm frm
                Exit Sub
            End If                                      ' end character error
        ElseIf Box = 10 And ErrorType = 20 Then         ' range error
            Response = MsgBox(Msg2 + Msg11, 5 + 16 + 0, Title)
            If Response = 4 Then                        ' retry
                frm.txtUnkRatio.Text = ""
                frm.txtUnkRatio.SetFocus
                Exit Sub
            ElseIf Response = 2 Then                    ' cancel
                frm.txtUnkImped.SetFocus
                ClearForm frm
                Exit Sub
            End If                                      ' end range error
        End If

            ' -------------------------------------------------
            ' inner diameter of outer conductor - frmCoaxPrimer
            ' -------------------------------------------------
        If Box = 11 And ErrorType = 10 Then             ' character error
            Response = MsgBox(Msg1, 5 + 16 + 0, Title)
            If Response = 4 Then                        ' retry
                frm.txtID.Text = ""
                frm.txtID.SetFocus
                Exit Sub
            ElseIf Response = 2 Then                    ' cancel
                frm.txtID.SetFocus
                ClearForm frm
                Exit Sub
            End If                                      ' end character error
        ElseIf Box = 11 And ErrorType = 20 Then         ' range error
            Response = MsgBox(Msg2 + Msg12, 5 + 16 + 0, Title)
            If Response = 4 Then                        ' retry
                frm.txtID.Text = ""
                frm.txtID.SetFocus
                Exit Sub
            ElseIf Response = 2 Then                    ' cancel
                frm.txtID.SetFocus
                ClearForm frm
                Exit Sub
            End If                                      ' end range error
        End If

            ' -------------------------------------------------
            ' outer diameter of inner conductor - frmCoaxPrimer
            ' -------------------------------------------------
        If Box = 12 And ErrorType = 10 Then             ' character error
            Response = MsgBox(Msg1, 5 + 16 + 0, Title)
            If Response = 4 Then                        ' retry
                frm.txtOD.Text = ""
                frm.txtOD.SetFocus
                Exit Sub
            ElseIf Response = 2 Then                    ' cancel
                frm.txtID.SetFocus
                ClearForm frm
                Exit Sub
            End If                                      ' end character error
        ElseIf Box = 12 And ErrorType = 20 Then         ' range error
            Response = MsgBox(Msg2 + Msg13, 5 + 16 + 0, Title)
            If Response = 4 Then                        ' retry
                frm.txtOD.Text = ""
                frm.txtOD.SetFocus
                Exit Sub
            ElseIf Response = 2 Then                    ' cancel
                frm.txtID.SetFocus
                ClearForm frm
                Exit Sub
            End If                                      ' end range error
        End If

            ' -----------------------------------
            ' dielectric constant - frmCoaxPrimer
            ' -----------------------------------
        If Box = 13 And ErrorType = 10 Then             ' character error
            Response = MsgBox(Msg1, 5 + 16 + 0, Title)
            If Response = 4 Then                        ' retry
                frm.txtDiel.Text = ""
                frm.txtDiel.SetFocus
                Exit Sub
            ElseIf Response = 2 Then                    ' cancel
                frm.txtID.SetFocus
                ClearForm frm
                Exit Sub
            End If                                      ' end character error
        ElseIf Box = 13 And ErrorType = 20 Then         ' range error
            Response = MsgBox(Msg2 + Msg9, 5 + 16 + 0, Title)
            If Response = 4 Then                        ' retry
                frm.txtDiel.Text = ""
                frm.txtDiel.SetFocus
                Exit Sub
            ElseIf Response = 2 Then                    ' cancel
                frm.txtID.SetFocus
                ClearForm frm
                Exit Sub
            End If                                      ' end range error
        End If

            ' -----------------------------------------------
            ' conductor stranding factor (K1) - frmCoaxPrimer
            ' -----------------------------------------------
        If Box = 14 And ErrorType = 10 Then             ' character error
            Response = MsgBox(Msg1, 5 + 16 + 0, Title)
            If Response = 4 Then                        ' retry
                frm.txtK1.Text = ""
                frm.txtK1.SetFocus
                Exit Sub
            ElseIf Response = 2 Then                    ' cancel
                frm.txtID.SetFocus
                ClearForm frm
                Exit Sub
            End If                                      ' end character error
        ElseIf Box = 14 And ErrorType = 20 Then         ' range error
            Response = MsgBox(Msg2 + Msg14, 5 + 16 + 0, Title)
            If Response = 4 Then                        ' retry
                frm.txtK1.Text = ""
                frm.txtK1.SetFocus
                Exit Sub
            ElseIf Response = 2 Then                    ' cancel
                frm.txtID.SetFocus
                ClearForm frm
                Exit Sub
            End If                                      ' end range error
        End If

            ' -------------------------------------------
            ' braid stranding factor (K2) - frmCoaxPrimer
            ' -------------------------------------------
        If Box = 15 And ErrorType = 10 Then             ' character error
            Response = MsgBox(Msg1, 5 + 16 + 0, Title)
            If Response = 4 Then                        ' retry
                frm.txtK2Out.Text = ""
                frm.txtK2Out.SetFocus
                Exit Sub
            ElseIf Response = 2 Then                    ' cancel
                frm.txtID.SetFocus
                ClearForm frm
                Exit Sub
            End If                                      ' end character error
        ElseIf Box = 15 And ErrorType = 20 Then         ' range error
            Response = MsgBox(Msg2 + Msg14, 5 + 16 + 0, Title)
            If Response = 4 Then                        ' retry
                frm.txtK2Out.Text = ""
                frm.txtK2Out.SetFocus
                Exit Sub
            ElseIf Response = 2 Then                    ' cancel
                frm.txtID.SetFocus
                ClearForm frm
                Exit Sub
            End If                                      ' end range error
        End If

            ' -------------------------------
            ' frequency (MHz) - frmCoaxPrimer
            ' -------------------------------
        If Box = 11 And ErrorType = 10 Then             ' character error
            Response = MsgBox(Msg1, 5 + 16 + 0, Title)
            If Response = 4 Then                        ' retry
                frm.txtFreq.Text = ""
                frm.txtFreq.SetFocus
                Exit Sub
            ElseIf Response = 2 Then                    ' cancel
                frm.txtID.SetFocus
                ClearForm frm
                Exit Sub
            End If                                      ' end character error
        ElseIf Box = 11 And ErrorType = 20 Then         ' range error
            Response = MsgBox(Msg2 + Msg7, 5 + 16 + 0, Title)
            If Response = 4 Then                        ' retry
                frm.txtFreq.Text = ""
                frm.txtFreq.SetFocus
                Exit Sub
            ElseIf Response = 2 Then                    ' cancel
                frm.txtID.SetFocus
                ClearForm frm
                Exit Sub
            End If                                      ' end range error
        End If

            ' ---------------------------------------
            ' dielectric power factor - frmCoaxPrimer
            ' ---------------------------------------
        If Box = 17 And ErrorType = 10 Then             ' character error
            Response = MsgBox(Msg1, 5 + 16 + 0, Title)
            If Response = 4 Then                        ' retry
                frm.txtPF.Text = ""
                frm.txtPF.SetFocus
                Exit Sub
            ElseIf Response = 2 Then                    ' cancel
                frm.txtID.SetFocus
                ClearForm frm
                Exit Sub
            End If                                      ' end character error
        ElseIf Box = 17 And ErrorType = 20 Then         ' range error
            Response = MsgBox(Msg2 + Msg15, 5 + 16 + 0, Title)
            If Response = 4 Then                        ' retry
                frm.txtPF.Text = ""
                frm.txtPF.SetFocus
                Exit Sub
            ElseIf Response = 2 Then                    ' cancel
                frm.txtID.SetFocus
                ClearForm frm
                Exit Sub
            End If                                      ' end range error
        End If

            ' ----------------------------------
            ' operating altitude - frmCoaxPrimer
            ' ----------------------------------
        If Box = 18 And ErrorType = 10 Then             ' character error
            Response = MsgBox(Msg1, 5 + 16 + 0, Title)
            If Response = 4 Then                        ' retry
                frm.txtAlt.Text = ""
                frm.txtAlt.SetFocus
                Exit Sub
            ElseIf Response = 2 Then                    ' cancel
                frm.txtID.SetFocus
                ClearForm frm
                Exit Sub
            End If                                      ' end character error
        ElseIf Box = 18 And ErrorType = 20 Then         ' range error
            Response = MsgBox(Msg2 + Msg16, 5 + 16 + 0, Title)
            If Response = 4 Then                        ' retry
                frm.txtAlt.Text = ""
                frm.txtAlt.SetFocus
                Exit Sub
            ElseIf Response = 2 Then                    ' cancel
                frm.txtID.SetFocus
                ClearForm frm
                Exit Sub
            End If                                      ' end range error
        End If

            ' ------------------------------------------
            ' de-rated breakdown voltage - frmCoaxPrimer
            ' ------------------------------------------
        If Box = 19 And ErrorType = 10 Then             ' character error
            Response = MsgBox(Msg1, 5 + 16 + 0, Title)
            If Response = 4 Then                        ' retry
                frm.txtRMS.Text = ""
                frm.txtRMS.SetFocus
                Exit Sub
            ElseIf Response = 2 Then                    ' cancel
                frm.txtID.SetFocus
                ClearForm frm
                Exit Sub
            End If                                      ' end character error
        ElseIf Box = 19 And ErrorType = 20 Then         ' range error
            Response = MsgBox(Msg2 + Msg17, 5 + 16 + 0, Title)
            If Response = 4 Then                        ' retry
                frm.txtRMS.Text = ""
                frm.txtRMS.SetFocus
                Exit Sub
            ElseIf Response = 2 Then                    ' cancel
                frm.txtID.SetFocus
                ClearForm frm
                Exit Sub
            End If                                      ' end range error
        End If

            ' -------------------------------
            ' frequency (MHz) - frmCoaxPrimer
            ' -------------------------------
        If Box = 20 And ErrorType = 10 Then             ' character error
            Response = MsgBox(Msg1, 5 + 16 + 0, Title)
            If Response = 4 Then                        ' retry
                frm.txtOpFreq.Text = ""
                frm.txtOpFreq.SetFocus
                Exit Sub
            ElseIf Response = 2 Then                    ' cancel
                frm.txtOpFreq.SetFocus
                ClearForm frm
                Exit Sub
            End If                                      ' end character error
        ElseIf Box = 20 And ErrorType = 20 Then         ' range error
            Response = MsgBox(Msg2 + Msg7, 5 + 16 + 0, Title)
            If Response = 4 Then                        ' retry
                frm.txtOpFreq.Text = ""
                frm.txtOpFreq.SetFocus
                Exit Sub
            ElseIf Response = 2 Then                    ' cancel
                frm.txtOpFreq.SetFocus
                ClearForm frm
                Exit Sub
            End If                                      ' end range error
        End If

            ' -----------------------------
            ' frequency (MHz) - frmCoaxStub
            ' -----------------------------
        If Box = 21 And ErrorType = 10 Then             ' character error
            Response = MsgBox(Msg1, 5 + 16 + 0, Title)
            If Response = 4 Then                        ' retry
                frm.txtFreq.Text = ""
                frm.txtFreq.SetFocus
                Exit Sub
            ElseIf Response = 2 Then                    ' cancel
                frm.txtFreq.SetFocus
                ClearForm frm
                Exit Sub
            End If                                      ' end character error
        ElseIf Box = 21 And ErrorType = 20 Then         ' range error
            Response = MsgBox(Msg2 + Msg7, 5 + 16 + 0, Title)
            If Response = 4 Then                        ' retry
                frm.txtFreq.Text = ""
                frm.txtFreq.SetFocus
                Exit Sub
            ElseIf Response = 2 Then                    ' cancel
                frm.txtFreq.SetFocus
                ClearForm frm
                Exit Sub
            End If                                      ' end range error
        End If

            ' ------------------------------
            ' impedance (ohms) - frmCoaxStub
            ' ------------------------------
        If Box = 22 And ErrorType = 10 Then             ' character error
            Response = MsgBox(Msg1, 5 + 16 + 0, Title)
            If Response = 4 Then                        ' retry
                frm.txtImped.Text = ""
                frm.txtImped.SetFocus
                Exit Sub
            ElseIf Response = 2 Then                    ' cancel
                frm.txtFreq.SetFocus
                ClearForm frm
                Exit Sub
            End If                                      ' end character error
        ElseIf Box = 22 And ErrorType = 20 Then         ' range error
            Response = MsgBox(Msg2 + Msg22, 5 + 16 + 0, Title)
            If Response = 4 Then                        ' retry
                frm.txtImped.Text = ""
                frm.txtImped.SetFocus
                Exit Sub
            ElseIf Response = 2 Then                    ' cancel
                frm.txtFreq.SetFocus
                ClearForm frm
                Exit Sub
            End If                                      ' end range error
        End If

            ' ---------------------------------
            ' dielectric constant - frmCoaxStub
            ' ---------------------------------
        If Box = 23 And ErrorType = 10 Then             ' character error
            Response = MsgBox(Msg1, 5 + 16 + 0, Title)
            If Response = 4 Then                        ' retry
                frm.txtDielConst.Text = ""
                frm.txtDielConst.SetFocus
                Exit Sub
            ElseIf Response = 2 Then                    ' cancel
                frm.txtFreq.SetFocus
                ClearForm frm
                Exit Sub
            End If                                      ' end character error
        ElseIf Box = 23 And ErrorType = 20 Then         ' range error
            Response = MsgBox(Msg2 + Msg9, 5 + 16 + 0, Title)
            If Response = 4 Then                        ' retry
                frm.txtDielConst.Text = ""
                frm.txtDielConst.SetFocus
                Exit Sub
            ElseIf Response = 2 Then                    ' cancel
                frm.txtFreq.SetFocus
                ClearForm frm
                Exit Sub
            End If                                      ' end range error
        End If

            ' ----------------------------
            ' specific input - frmCoaxStub
            ' ----------------------------
        If Box = 24 And ErrorType = 10 Then             ' character error
            Response = MsgBox(Msg1, 5 + 16 + 0, Title)
                If Response = 4 Then                    ' retry
                    frm.txtSpInput.Text = ""
                    frm.txtSpInput.SetFocus
                    Exit Sub
                ElseIf Response = 2 Then                ' cancel
                    Unload frm                          ' start over
                    Load frm
                    frm.Show
                    Exit Sub
                End If
        ElseIf Box = 24 And ErrorType = 20 Then         ' range error
            If frm.optCapacitance.Value = True Then
                Response = MsgBox(Msg2 + Msg18, 5 + 16 + 0, Title)
                If Response = 4 Then                    ' retry
                    frm.txtSpInput.Text = ""
                    frm.txtSpInput.SetFocus
                    Exit Sub
                ElseIf Response = 2 Then                ' cancel
                    Unload frm
                    Load frm
                    frm.Show
                    Exit Sub
                End If
            ElseIf frm.optCapReact.Value = True Then    ' range error
            Response = MsgBox(Msg2 + Msg19, 5 + 16 + 0, Title)
                If Response = 4 Then                    ' retry
                    frm.txtSpInput.Text = ""
                    frm.txtSpInput.SetFocus
                    Exit Sub
                ElseIf Response = 2 Then                ' cancel
                    Unload frm
                    Load frm
                    frm.Show
                    Exit Sub
                End If
            ElseIf frm.optFrequency.Value = True Then   ' range error
                Response = MsgBox(Msg2 + Msg7, 5 + 16 + 0, Title)
                If Response = 4 Then                    ' retry
                    frm.txtSpInput.Text = ""
                    frm.txtSpInput.SetFocus
                    Exit Sub
                ElseIf Response = 2 Then                ' cancel
                    Unload frm
                    Load frm
                    frm.Show
                    Exit Sub
                End If
            ElseIf frm.optInductance.Value = True Then  ' range error
                Response = MsgBox(Msg2 + Msg20, 5 + 16 + 0, Title)
                If Response = 4 Then                    ' retry
                    frm.txtSpInput.Text = ""
                    frm.txtSpInput.SetFocus
                    Exit Sub
                ElseIf Response = 2 Then                ' cancel
                    Unload frm
                    Load frm
                    frm.Show
                    Exit Sub
                End If
            ElseIf frm.optInductReact.Value = True Then ' range error
                Response = MsgBox(Msg2 + Msg21, 5 + 16 + 0, Title)
                If Response = 4 Then                    ' retry
                    frm.txtSpInput.Text = ""
                    frm.txtSpInput.SetFocus
                    Exit Sub
                ElseIf Response = 2 Then                ' cancel
                    Unload frm
                    Load frm
                    frm.Show
                    Exit Sub
                End If
            ElseIf frm.optMetric.Value = True Then      ' range error
                Response = MsgBox(Msg2 + Msg6, 5 + 16 + 0, Title)
                If Response = 4 Then                    ' retry
                    frm.txtSpInput.Text = ""
                    frm.txtSpInput.SetFocus
                    Exit Sub
                ElseIf Response = 2 Then                ' cancel
                    Unload frm
                    Load frm
                    frm.Show
                    Exit Sub
                End If
            ElseIf frm.optUS.Value = True Then          ' range error
                Response = MsgBox(Msg2 + Msg5, 5 + 16 + 0, Title)
                If Response = 4 Then                    ' retry
                    frm.txtSpInput.Text = ""
                    frm.txtSpInput.SetFocus
                    Exit Sub
                ElseIf Response = 2 Then                ' cancel
                    Unload frm
                    Load frm
                    frm.Show
                    Exit Sub
                End If
            End If
        End If

            ' -------------------------------------------
            ' conductor impedance or spacing - frmSqrLine
            ' -------------------------------------------
        If Box = 25 And ErrorType = 10 Then             ' character error
            Response = MsgBox(Msg1, 5 + 16 + 0, Title)
                If Response = 4 Then                    ' retry
                    frm.txtInput.Text = ""
                    frm.txtInput.SetFocus
                    Exit Sub
                ElseIf Response = 2 Then                ' cancel
                    Unload frm                          ' start over
                    Load frm
                    frm.Show
                    Exit Sub
                End If
        ElseIf Box = 25 And ErrorType = 20 Then         ' range error
            If frm.optImped.Value = True And frm.optInches.Value = True Then
                Response = MsgBox(Msg2 + Msg24, 5 + 16 + 0, Title)
                    If Response = 4 Then                ' retry
                        frm.txtInput.Text = ""
                        frm.txtInput.SetFocus
                        Exit Sub
                    ElseIf Response = 2 Then            ' cancel
                        Unload frm                      ' start over
                        Load frm
                        frm.Show
                        Exit Sub
                    End If
            ElseIf frm.optImped.Value <> 0 And frm.optMillimeters.Value <> 0 Then
                Response = MsgBox(Msg2 + Msg25, 5 + 16 + 0, Title)
                    If Response = 4 Then                ' retry
                        frm.txtInput.Text = ""
                        frm.txtInput.SetFocus
                        Exit Sub
                    ElseIf Response = 2 Then            ' cancel
                        Unload frm                      ' start over
                        Load frm
                        frm.Show
                        Exit Sub
                    End If
            ElseIf frm.optSpacing.Value = True Then
                Response = MsgBox(Msg2 + Msg23, 5 + 16 + 0, Title)
                    If Response = 4 Then                ' retry
                        frm.txtInput.Text = ""
                        frm.txtInput.SetFocus
                        Exit Sub
                    ElseIf Response = 2 Then            ' cancel
                        Unload frm                      ' start over
                        Load frm
                        frm.Show
                        Exit Sub
                    End If

            End If
        End If

            ' ----------------------------
            ' conductor width - frmSqrLine
            ' ----------------------------
        If Box = 26 And ErrorType = 10 Then             ' character error
            Response = MsgBox(Msg1, 5 + 16 + 0, Title)
                If Response = 4 Then                    ' retry
                    frm.txtWidth.Text = ""
                    frm.txtWidth.SetFocus
                    Exit Sub
                ElseIf Response = 2 Then                ' cancel
                    Unload frm                          ' start over
                    Load frm
                    frm.Show
                    Exit Sub
                End If
        ElseIf Box = 26 And ErrorType = 20 Then         ' range error
            If frm.optInches.Value = True Then
                Response = MsgBox(Msg2 + Msg26, 5 + 16 + 0, Title)
                    If Response = 4 Then                ' retry
                        frm.txtWidth.Text = ""
                        frm.txtWidth.SetFocus
                        Exit Sub
                    ElseIf Response = 2 Then            ' cancel
                        Unload frm                      ' start over
                        Load frm
                        frm.Show
                        Exit Sub
                    End If
            ElseIf frm.optMillimeters.Value = True Then
                Response = MsgBox(Msg2 + Msg27, 5 + 16 + 0, Title)
                    If Response = 4 Then                ' retry
                        frm.txtWidth.Text = ""
                        frm.txtWidth.SetFocus
                        Exit Sub
                    ElseIf Response = 2 Then            ' cancel
                        Unload frm                      ' start over
                        Load frm
                        frm.Show
                        Exit Sub
                    End If
            End If
        End If

            ' ------------------------------------------------
            ' frmSqrCoax
            '   center conductor size (optImped and optShield)
            '   shield inner face (optCtrCond)
            ' ------------------------------------------------
        If Box = 27 And ErrorType = 10 Then             ' character error
            Response = MsgBox(Msg1, 5 + 16 + 0, Title)
                If Response = 4 Then                    ' retry
                    frm.txtParam1.Text = ""
                    frm.txtParam1.SetFocus
                    Exit Sub
                ElseIf Response = 2 Then                ' cancel
                    Unload frm                          ' start over
                    Load frm
                    frm.Show
                    Exit Sub
                End If
        ElseIf Box = 27 And ErrorType = 20 Then         ' range error
            If frm.optImped.Value = True Then           ' compute impedance
                    ' ---------------------------
                    ' center conductor outer face
                    ' ---------------------------
                If frm.optInches.Value = True Then
                    Response = MsgBox(Msg2 + Msg28, 5 + 16 + 0, Title)
                    If Response = 4 Then                ' retry
                        frm.txtParam1.Text = ""
                        frm.txtParam1.SetFocus
                        Exit Sub
                    ElseIf Response = 2 Then            ' cancel
                        Unload frm                      ' start over
                        Load frm
                        frm.Show
                        Exit Sub
                    End If
                ElseIf frm.optCentMtrs.Value = True Then
                    Response = MsgBox(Msg2 + Msg29, 5 + 16 + 0, Title)
                    If Response = 4 Then                ' retry
                        frm.txtParam1.Text = ""
                        frm.txtParam1.SetFocus
                        Exit Sub
                    ElseIf Response = 2 Then            ' cancel
                        Unload frm                      ' start over
                        Load frm
                        frm.Show
                        Exit Sub
                    End If
                End If

                    ' ---------------------------
                    ' center conductor outer face
                    ' ---------------------------
            ElseIf frm.optShield.Value = True Then      ' compute shield
                If frm.optInches.Value = True Then
                    Response = MsgBox(Msg2 + Msg28, 5 + 16 + 0, Title)
                    If Response = 4 Then                ' retry
                        frm.txtParam1.Text = ""
                        frm.txtParam1.SetFocus
                        Exit Sub
                    ElseIf Response = 2 Then            ' cancel
                        Unload frm                      ' start over
                        Load frm
                        frm.Show
                        Exit Sub
                    End If
                ElseIf frm.optCentMtrs.Value = True Then
                    Response = MsgBox(Msg2 + Msg29, 5 + 16 + 0, Title)
                    If Response = 4 Then                ' retry
                        frm.txtParam1.Text = ""
                        frm.txtParam1.SetFocus
                        Exit Sub
                    ElseIf Response = 2 Then            ' cancel
                        Unload frm                      ' start over
                        Load frm
                        frm.Show
                        Exit Sub
                    End If
                End If

                    ' -----------------
                    ' shield inner face
                    ' -----------------
            ElseIf frm.optCtrCond.Value = True Then     ' compute center cond
                If frm.optInches.Value = True Then
                    Response = MsgBox(Msg2 + Msg30, 5 + 16 + 0, Title)
                    If Response = 4 Then                ' retry
                        frm.txtParam1.Text = ""
                        frm.txtParam1.SetFocus
                        Exit Sub
                    ElseIf Response = 2 Then            ' cancel
                        Unload frm                      ' start over
                        Load frm
                        frm.Show
                        Exit Sub
                    End If
                ElseIf frm.optCentMtrs.Value = True Then
                    Response = MsgBox(Msg2 + Msg31, 5 + 16 + 0, Title)
                    If Response = 4 Then                ' retry
                        frm.txtParam1.Text = ""
                        frm.txtParam1.SetFocus
                        Exit Sub
                    ElseIf Response = 2 Then            ' cancel
                        Unload frm                      ' start over
                        Load frm
                        frm.Show
                        Exit Sub
                    End If
                End If
            End If
        End If

            ' --------------------------------------
            ' frmSqrCoax
            '   shield inner face (optImped)
            '   impedance (optShield and optCtrCond)
            ' --------------------------------------
        If Box = 28 And ErrorType = 10 Then             ' character error
            Response = MsgBox(Msg1, 5 + 16 + 0, Title)
                If Response = 4 Then                    ' retry
                    frm.txtParam2.Text = ""
                    frm.txtParam2.SetFocus
                    Exit Sub
                ElseIf Response = 2 Then                ' cancel
                    Unload frm                          ' start over
                    Load frm
                    frm.Show
                    Exit Sub
                End If
        ElseIf Box = 28 And ErrorType = 20 Then         ' range error
                    ' -----------------
                    ' shield inner face
                    ' -----------------
            If frm.optImped.Value = True Then           ' compute impedance
                If frm.optInches.Value = True Then
                    Response = MsgBox(Msg2 + Msg30, 5 + 16 + 0, Title)
                    If Response = 4 Then                ' retry
                        frm.txtParam2.Text = ""
                        frm.txtParam2.SetFocus
                        Exit Sub
                    ElseIf Response = 2 Then            ' cancel
                        Unload frm                      ' start over
                        Load frm
                        frm.Show
                        Exit Sub
                    End If
                ElseIf frm.optCentMtrs.Value = True Then
                    Response = MsgBox(Msg2 + Msg31, 5 + 16 + 0, Title)
                    If Response = 4 Then                ' retry
                        frm.txtParam2.Text = ""
                        frm.txtParam2.SetFocus
                        Exit Sub
                    ElseIf Response = 2 Then            ' cancel
                        Unload frm                      ' start over
                        Load frm
                        frm.Show
                        Exit Sub
                    End If
                End If

                    ' ----------------
                    ' design impedance
                    ' ----------------
            ElseIf frm.optShield.Value = True Then          ' compute shield
                Response = MsgBox(Msg2 + Msg32, 5 + 16 + 0, Title)
                If Response = 4 Then                    ' retry
                    frm.txtParam2.Text = ""
                    frm.txtParam2.SetFocus
                    Exit Sub
                ElseIf Response = 2 Then                ' cancel
                    Unload frm                          ' start over
                    Load frm
                    frm.Show
                    Exit Sub
                End If

                    ' ----------------
                    ' design impedance
                    ' ----------------
            ElseIf frm.optCtrCond.Value = True Then     ' compute center cond
                Response = MsgBox(Msg2 + Msg32, 5 + 16 + 0, Title)
                If Response = 4 Then                    ' retry
                    frm.txtParam2.Text = ""
                    frm.txtParam2.SetFocus
                    Exit Sub
                ElseIf Response = 2 Then                ' cancel
                    Unload frm                          ' start over
                    Load frm
                    frm.Show
                    Exit Sub
                End If
            End If
        End If

            ' ---------------------------------
            ' antenna resistance - frmTLinePerf
            ' ---------------------------------
        If Box = 29 And ErrorType = 10 Then             ' character error
            Response = MsgBox(Msg1, 5 + 16 + 0, Title)
                If Response = 4 Then                    ' retry
                    frm.txtAntR.Text = ""
                    frm.txtAntR.SetFocus
                    Exit Sub
                ElseIf Response = 2 Then                ' cancel
                    Unload frm                          ' start over
                    Load frm
                    frm.Show
                    Exit Sub
                End If
        ElseIf Box = 29 And ErrorType = 20 Then         ' range error
            Response = MsgBox(Msg2 + Msg34, 5 + 16 + 0, Title)
                If Response = 4 Then                    ' retry
                    frm.txtAntR.Text = ""
                    frm.txtAntR.SetFocus
                    Exit Sub
                ElseIf Response = 2 Then                ' cancel
                    Unload frm                          ' start over
                    Load frm
                    frm.Show
                    Exit Sub
                End If
        End If

            ' --------------------------------
            ' antenna reactance - frmTLinePerf
            ' --------------------------------
        If Box = 30 And ErrorType = 10 Then             ' character error
            Response = MsgBox(Msg1, 5 + 16 + 0, Title)
                If Response = 4 Then                    ' retry
                    frm.txtAntX.Text = ""
                    frm.txtAntX.SetFocus
                    Exit Sub
                ElseIf Response = 2 Then                ' cancel
                    Unload frm                          ' start over
                    Load frm
                    frm.Show
                    Exit Sub
                End If
        ElseIf Box = 30 And ErrorType = 20 Then         ' range error
            Response = MsgBox(Msg2 + Msg34, 5 + 16 + 0, Title)
                If Response = 4 Then                    ' retry
                    frm.txtAntX.Text = ""
                    frm.txtAntX.SetFocus
                    Exit Sub
                ElseIf Response = 2 Then                ' cancel
                    Unload frm                          ' start over
                    Load frm
                    frm.Show
                    Exit Sub
                End If
        End If

            ' -------------------------
            ' load power - frmTLinePerf
            ' -------------------------
        If Box = 31 And ErrorType = 10 Then             ' character error
            Response = MsgBox(Msg1, 5 + 16 + 0, Title)
                If Response = 4 Then                    ' retry
                    frm.txtLoadPwr.Text = ""
                    frm.txtLoadPwr.SetFocus
                    Exit Sub
                ElseIf Response = 2 Then                ' cancel
                    Unload frm                          ' start over
                    Load frm
                    frm.Show
                    Exit Sub
                End If
        ElseIf Box = 31 And ErrorType = 20 Then         ' range error
            Response = MsgBox(Msg2 + Msg35, 5 + 16 + 0, Title)
                If Response = 4 Then                    ' retry
                    frm.txtLoadPwr.Text = ""
                    frm.txtLoadPwr.SetFocus
                    Exit Sub
                ElseIf Response = 2 Then                ' cancel
                    Unload frm                          ' start over
                    Load frm
                    frm.Show
                    Exit Sub
                End If
        End If

            ' -----------------------------------
            ' antenna load current - frmTLinePerf
            ' -----------------------------------
        If Box = 32 And ErrorType = 10 Then             ' character error
            Response = MsgBox(Msg1, 5 + 16 + 0, Title)
                If Response = 4 Then                    ' retry
                    frm.txtAntLoadI.Text = ""
                    frm.txtAntLoadI.SetFocus
                    Exit Sub
                ElseIf Response = 2 Then                ' cancel
                    Unload frm                          ' start over
                    Load frm
                    frm.Show
                    Exit Sub
                End If
        ElseIf Box = 32 And ErrorType = 20 Then         ' range error
            Response = MsgBox(Msg2 + Msg37, 5 + 16 + 0, Title)
                If Response = 4 Then                    ' retry
                    frm.txtAntLoadI.Text = ""
                    frm.txtAntLoadI.SetFocus
                    Exit Sub
                ElseIf Response = 2 Then                ' cancel
                    Unload frm                          ' start over
                    Load frm
                    frm.Show
                    Exit Sub
                End If
        End If

            ' ---------------------------------
            ' load current phase - frmTLinePerf
            ' ---------------------------------
        If Box = 33 And ErrorType = 10 Then             ' character error
            Response = MsgBox(Msg1, 5 + 16 + 0, Title)
                If Response = 4 Then                    ' retry
                    frm.txtLoadIPhase.Text = ""
                    frm.txtLoadIPhase.SetFocus
                    Exit Sub
                ElseIf Response = 2 Then                ' cancel
                    Unload frm                          ' start over
                    Load frm
                    frm.Show
                    Exit Sub
                End If
        ElseIf Box = 33 And ErrorType = 20 Then         ' range error
            Response = MsgBox(Msg2 + Msg42, 5 + 16 + 0, Title)
                If Response = 4 Then                    ' retry
                    frm.txtLoadIPhase.Text = ""
                    frm.txtLoadIPhase.SetFocus
                    Exit Sub
                ElseIf Response = 2 Then                ' cancel
                    Unload frm                          ' start over
                    Load frm
                    frm.Show
                    Exit Sub
                End If
        End If

            ' -----------------------------------
            ' antenna load voltage - frmTLinePerf
            ' -----------------------------------
        If Box = 34 And ErrorType = 10 Then             ' character error
            Response = MsgBox(Msg1, 5 + 16 + 0, Title)
                If Response = 4 Then                    ' retry
                    frm.txtAntLoadV.Text = ""
                    frm.txtAntLoadV.SetFocus
                    Exit Sub
                ElseIf Response = 2 Then                ' cancel
                    Unload frm                          ' start over
                    Load frm
                    frm.Show
                    Exit Sub
                End If
        ElseIf Box = 34 And ErrorType = 20 Then         ' range error
            Response = MsgBox(Msg2 + Msg38, 5 + 16 + 0, Title)
                If Response = 4 Then                    ' retry
                    frm.txtAntLoadV.Text = ""
                    frm.txtAntLoadV.SetFocus
                    Exit Sub
                ElseIf Response = 2 Then                ' cancel
                    Unload frm                          ' start over
                    Load frm
                    frm.Show
                    Exit Sub
                End If
        End If

            ' ---------------------------------
            ' load voltage phase - frmTLinePerf
            ' ---------------------------------
        If Box = 35 And ErrorType = 10 Then             ' character error
            Response = MsgBox(Msg1, 5 + 16 + 0, Title)
                If Response = 4 Then                    ' retry
                    frm.txtLoadVPhase.Text = ""
                    frm.txtLoadVPhase.SetFocus
                    Exit Sub
                ElseIf Response = 2 Then                ' cancel
                    Unload frm                          ' start over
                    Load frm
                    frm.Show
                    Exit Sub
                End If
        ElseIf Box = 35 And ErrorType = 20 Then         ' range error
            Response = MsgBox(Msg2 + Msg42, 5 + 16 + 0, Title)
                If Response = 4 Then                    ' retry
                    frm.txtLoadVPhase.Text = ""
                    frm.txtLoadVPhase.SetFocus
                    Exit Sub
                ElseIf Response = 2 Then                ' cancel
                    Unload frm                          ' start over
                    Load frm
                    frm.Show
                    Exit Sub
                End If
        End If

            ' -------------------------------------
            ' line length in degrees - frmTLinePerf
            ' -------------------------------------
        If Box = 36 And ErrorType = 10 Then             ' character error
            Response = MsgBox(Msg1, 5 + 16 + 0, Title)
                If Response = 4 Then                    ' retry
                    frm.txtLLDeg.Text = ""
                    frm.txtLLDeg.SetFocus
                    Exit Sub
                ElseIf Response = 2 Then                ' cancel
                    Unload frm                          ' start over
                    Load frm
                    frm.Show
                    Exit Sub
                End If
        ElseIf Box = 36 And ErrorType = 20 Then         ' range error
            Response = MsgBox(Msg2 + Msg41, 5 + 16 + 0, Title)
                If Response = 4 Then                    ' retry
                    frm.txtLLDeg.Text = ""
                    frm.txtLLDeg.SetFocus
                    Exit Sub
                ElseIf Response = 2 Then                ' cancel
                    Unload frm                          ' start over
                    Load frm
                    frm.Show
                    Exit Sub
                End If
        End If

            ' ----------------------------------
            ' line length in feet - frmTLinePerf
            ' ----------------------------------
        If Box = 37 And ErrorType = 10 Then             ' character error
            Response = MsgBox(Msg1, 5 + 16 + 0, Title)
                If Response = 4 Then                    ' retry
                    frm.txtLLFt.Text = ""
                    frm.txtLLFt.SetFocus
                    Exit Sub
                ElseIf Response = 2 Then                ' cancel
                    Unload frm                          ' start over
                    Load frm
                    frm.Show
                    Exit Sub
                End If
        ElseIf Box = 37 And ErrorType = 20 Then         ' range error
            Response = MsgBox(Msg2 + Msg39, 5 + 16 + 0, Title)
                If Response = 4 Then                    ' retry
                    frm.txtLLFt.Text = ""
                    frm.txtLLFt.SetFocus
                    Exit Sub
                ElseIf Response = 2 Then                ' cancel
                    Unload frm                          ' start over
                    Load frm
                    frm.Show
                    Exit Sub
                End If
        End If

            ' ------------------------------------
            ' line length in meters - frmTLinePerf
            ' ------------------------------------
        If Box = 38 And ErrorType = 10 Then             ' character error
            Response = MsgBox(Msg1, 5 + 16 + 0, Title)
                If Response = 4 Then                    ' retry
                    frm.txtLLMt.Text = ""
                    frm.txtLLMt.SetFocus
                    Exit Sub
                ElseIf Response = 2 Then                ' cancel
                    Unload frm                          ' start over
                    Load frm
                    frm.Show
                    Exit Sub
                End If
        ElseIf Box = 38 And ErrorType = 20 Then         ' range error
            Response = MsgBox(Msg2 + Msg40, 5 + 16 + 0, Title)
                If Response = 4 Then                    ' retry
                    frm.txtLLMt.Text = ""
                    frm.txtLLMt.SetFocus
                    Exit Sub
                ElseIf Response = 2 Then                ' cancel
                    Unload frm                          ' start over
                    Load frm
                    frm.Show
                    Exit Sub
                End If
        End If

            ' ----------------------------------
            ' operating frequency - frmTLinePerf
            ' ----------------------------------
        If Box = 39 And ErrorType = 10 Then             ' character error
            Response = MsgBox(Msg1, 5 + 16 + 0, Title)
                If Response = 4 Then                    ' retry
                    frm.txtFreqIn.Text = ""
                    frm.txtFreqIn.SetFocus
                    Exit Sub
                ElseIf Response = 2 Then                ' cancel
                    Unload frm                          ' start over
                    Load frm
                    frm.Show
                    Exit Sub
                End If
        ElseIf Box = 39 And ErrorType = 20 Then         ' range error
            Response = MsgBox(Msg2 + Msg7, 5 + 16 + 0, Title)
                If Response = 4 Then                    ' retry
                    frm.txtFreqIn.Text = ""
                    frm.txtFreqIn.SetFocus
                    Exit Sub
                ElseIf Response = 2 Then                ' cancel
                    Unload frm                          ' start over
                    Load frm
                    frm.Show
                    Exit Sub
                End If
        End If

            ' --------------------------------------------
            ' line characteristic impedance - frmTLinePerf
            ' --------------------------------------------
        If Box = 40 And ErrorType = 10 Then             ' character error
            Response = MsgBox(Msg1, 5 + 16 + 0, Title)
                If Response = 4 Then                    ' retry
                    frm.txtCharZ.Text = ""
                    frm.txtCharZ.SetFocus
                    Exit Sub
                ElseIf Response = 2 Then                ' cancel
                    Unload frm                          ' start over
                    Load frm
                    frm.Show
                    Exit Sub
                End If
        ElseIf Box = 40 And ErrorType = 20 Then         ' range error
            Response = MsgBox(Msg2 + Msg36, 5 + 16 + 0, Title)
                If Response = 4 Then                    ' retry
                    frm.txtCharZ.Text = ""
                    frm.txtCharZ.SetFocus
                    Exit Sub
                ElseIf Response = 2 Then                ' cancel
                    Unload frm                          ' start over
                    Load frm
                    frm.Show
                    Exit Sub
                End If
        End If

            ' -----------------------------------
            ' line velocity factor - frmTLinePerf
            ' -----------------------------------
        If Box = 41 And ErrorType = 10 Then             ' character error
            Response = MsgBox(Msg1, 5 + 16 + 0, Title)
                If Response = 4 Then                    ' retry
                    frm.txtLineVFDec.Text = ""
                    frm.txtLineVFDec.SetFocus
                    Exit Sub
                ElseIf Response = 2 Then                ' cancel
                    Unload frm                          ' start over
                    Load frm
                    frm.Show
                    Exit Sub
                End If
        ElseIf Box = 41 And ErrorType = 20 Then         ' range error
            Response = MsgBox(Msg2 + Msg33, 5 + 16 + 0, Title)
                If Response = 4 Then                    ' retry
                    frm.txtLineVFDec.Text = ""
                    frm.txtLineVFDec.SetFocus
                    Exit Sub
                ElseIf Response = 2 Then                ' cancel
                    Unload frm                          ' start over
                    Load frm
                    frm.Show
                    Exit Sub
                End If
        End If

            ' ---------------------------
            ' wire diameter - frmOpenWire
            ' ---------------------------
        If Box = 42 And ErrorType = 10 Then             ' character error
            Response = MsgBox(Msg1, 5 + 16 + 0, Title)
                If Response = 4 Then                    ' retry
                    frm.txtWire.Text = ""
                    frm.txtWire.SetFocus
                    Exit Sub
                ElseIf Response = 2 Then                ' cancel
                    Unload frm                          ' start over
                    Load frm
                    frm.Show
                    Exit Sub
                End If
        ElseIf Box = 42 And ErrorType = 20 Then         ' range error
                    ' ------
                    ' inches
                    ' ------
                If frm.optIN.Value = True Then
                    Response = MsgBox(Msg2 + Msg43, 5 + 16 + 0, Title)
                    If Response = 4 Then                ' retry
                        frm.txtWire.Text = ""
                        frm.txtWire.SetFocus
                        Exit Sub
                    ElseIf Response = 2 Then            ' cancel
                        Unload frm                      ' start over
                        Load frm
                        frm.Show
                        Exit Sub
                    End If

                    ' -----------
                    ' millimeters
                    ' -----------
                ElseIf frm.optMM.Value = True Then
                    Response = MsgBox(Msg2 + Msg44, 5 + 16 + 0, Title)
                    If Response = 4 Then                ' retry
                        frm.txtWire.Text = ""
                        frm.txtWire.SetFocus
                        Exit Sub
                    ElseIf Response = 2 Then            ' cancel
                        Unload frm                      ' start over
                        Load frm
                        frm.Show
                        Exit Sub
                    End If

                    ' ---
                    ' AWG
                    ' ---
                ElseIf frm.optAWG.Value = True Then
                    Response = MsgBox(Msg2 + Msg45, 5 + 16 + 0, Title)
                    If Response = 4 Then                ' retry
                        frm.txtWire.Text = ""
                        frm.txtWire.SetFocus
                        Exit Sub
                    ElseIf Response = 2 Then            ' cancel
                        Unload frm                      ' start over
                        Load frm
                        frm.Show
                        Exit Sub
                    End If
                End If
        End If

            ' --------------------------------------
            ' wire height above ground - frmOpenWire
            ' --------------------------------------
        If Box = 43 And ErrorType = 10 Then             ' character error
            Response = MsgBox(Msg1, 5 + 16 + 0, Title)
                If Response = 4 Then                    ' retry
                    frm.txtHT.Text = ""
                    frm.txtHT.SetFocus
                    Exit Sub
                ElseIf Response = 2 Then                ' cancel
                    Unload frm                          ' start over
                    Load frm
                    frm.Show
                    Exit Sub
                End If
        ElseIf Box = 43 And ErrorType = 20 Then         ' range error
                    ' ----
                    ' feet
                    ' ----
                If frm.optHTFt.Value = True Then
                    Response = MsgBox(Msg2 + Msg46, 5 + 16 + 0, Title)
                    If Response = 4 Then                ' retry
                        frm.txtHT.Text = ""
                        frm.txtHT.SetFocus
                        Exit Sub
                    ElseIf Response = 2 Then            ' cancel
                        Unload frm                      ' start over
                        Load frm
                        frm.Show
                        Exit Sub
                    End If

                    ' ------
                    ' meters
                    ' ------
                ElseIf frm.optHTMet.Value = True Then
                    Response = MsgBox(Msg2 + Msg47, 5 + 16 + 0, Title)
                    If Response = 4 Then                ' retry
                        frm.txtHT.Text = ""
                        frm.txtHT.SetFocus
                        Exit Sub
                    ElseIf Response = 2 Then            ' cancel
                        Unload frm                      ' start over
                        Load frm
                        frm.Show
                        Exit Sub
                    End If
                End If
        End If

            ' --------------------------------------
            ' center-to-center spacing - frmOpenWire
            ' --------------------------------------
        If Box = 44 And ErrorType = 10 Then             ' character error
            Response = MsgBox(Msg1, 5 + 16 + 0, Title)
                If Response = 4 Then                    ' retry
                    frm.txtCCIn.Text = ""
                    frm.txtCCIn.SetFocus
                    Exit Sub
                ElseIf Response = 2 Then                ' cancel
                    Unload frm                          ' start over
                    Load frm
                    frm.Show
                    Exit Sub
                End If
        ElseIf Box = 44 And ErrorType = 20 Then         ' range error
                    ' ------
                    ' inches
                    ' ------
                If frm.optLLFt.Value = True Then
                    Response = MsgBox(Msg2 + Msg48, 5 + 16 + 0, Title)
                    If Response = 4 Then                ' retry
                        frm.txtCCIn.Text = ""
                        frm.txtCCIn.SetFocus
                        Exit Sub
                    ElseIf Response = 2 Then            ' cancel
                        Unload frm                      ' start over
                        Load frm
                        frm.Show
                        Exit Sub
                    End If

                    ' -----------
                    ' millimeters
                    ' -----------
                ElseIf frm.optLLMet.Value = True Then
                    Response = MsgBox(Msg2 + Msg49, 5 + 16 + 0, Title)
                    If Response = 4 Then                ' retry
                        frm.txtCCIn.Text = ""
                        frm.txtCCIn.SetFocus
                        Exit Sub
                    ElseIf Response = 2 Then            ' cancel
                        Unload frm                      ' start over
                        Load frm
                        frm.Show
                        Exit Sub
                    End If
                End If
        End If

            ' --------------------------------------
            ' line length - frmOpenWire
            ' --------------------------------------
        If Box = 45 And ErrorType = 10 Then             ' character error
            Response = MsgBox(Msg1, 5 + 16 + 0, Title)
                If Response = 4 Then                    ' retry
                    frm.txtLinLen.Text = ""
                    frm.txtLinLen.SetFocus
                    Exit Sub
                ElseIf Response = 2 Then                ' cancel
                    Unload frm                          ' start over
                    Load frm
                    frm.Show
                    Exit Sub
                End If
        ElseIf Box = 45 And ErrorType = 20 Then         ' range error
                    ' ----
                    ' feet
                    ' ----
                If frm.optLLFt.Value = True Then
                    Response = MsgBox(Msg2 + Msg50, 5 + 16 + 0, Title)
                    If Response = 4 Then                ' retry
                        frm.txtLinLen.Text = ""
                        frm.txtLinLen.SetFocus
                        Exit Sub
                    ElseIf Response = 2 Then            ' cancel
                        Unload frm                      ' start over
                        Load frm
                        frm.Show
                        Exit Sub
                    End If

                    ' ------
                    ' meters
                    ' ------
                ElseIf frm.optLLMet.Value = True Then
                    Response = MsgBox(Msg2 + Msg51, 5 + 16 + 0, Title)
                    If Response = 4 Then                ' retry
                        frm.txtLinLen.Text = ""
                        frm.txtLinLen.SetFocus
                        Exit Sub
                    ElseIf Response = 2 Then            ' cancel
                        Unload frm                      ' start over
                        Load frm
                        frm.Show
                        Exit Sub
                    End If
                End If
        End If

            ' -----------------------------
            ' frequency (MHz) - frmOpenWire
            ' -----------------------------
        If Box = 46 And ErrorType = 10 Then             ' character error
            Response = MsgBox(Msg1, 5 + 16 + 0, Title)
            If Response = 4 Then                        ' retry
                frm.txtFreq.Text = ""
                frm.txtFreq.SetFocus
                Exit Sub
            ElseIf Response = 2 Then                    ' cancel
                Unload frm                              ' start over
                Load frm
                frm.Show
                Exit Sub
            End If                                      ' end character error
        ElseIf Box = 46 And ErrorType = 20 Then         ' range error
            Response = MsgBox(Msg2 + Msg7, 5 + 16 + 0, Title)
            If Response = 4 Then                        ' retry
                frm.txtFreq.Text = ""
                frm.txtFreq.SetFocus
                Exit Sub
            ElseIf Response = 2 Then                    ' cancel
                Unload frm                              ' start over
                Load frm
                frm.Show
                Exit Sub
            End If                                      ' end range error
        End If

            ' ------------------------------
            ' design impedance - frmOpenWire
            ' ------------------------------
        If Box = 47 And ErrorType = 10 Then             ' character error
            Response = MsgBox(Msg1, 5 + 16 + 0, Title)
            If Response = 4 Then                        ' retry
                frm.txtZIn.Text = ""
                frm.txtZIn.SetFocus
                Exit Sub
            ElseIf Response = 2 Then                    ' cancel
                Unload frm                              ' start over
                Load frm
                frm.Show
                Exit Sub
            End If                                      ' end character error
        ElseIf Box = 47 And ErrorType = 20 Then         ' range error
            Response = MsgBox(Msg2 + Msg52, 5 + 16 + 0, Title)
            If Response = 4 Then                        ' retry
                frm.txtZIn.Text = ""
                frm.txtZIn.SetFocus
                Exit Sub
            ElseIf Response = 2 Then                    ' cancel
                Unload frm                              ' start over
                Load frm
                frm.Show
                Exit Sub
            End If                                      ' end range error
        End If

            ' ---------------------------------------------
            ' conductor spacing (4 wire line) - frmOpenWire
            ' ---------------------------------------------
        If Box = 48 And ErrorType = 10 Then             ' character error
            Response = MsgBox(Msg1, 5 + 16 + 0, Title)
                If Response = 4 Then                    ' retry
                    frm.txtACBD.Text = ""
                    frm.txtACBD.SetFocus
                    Exit Sub
                ElseIf Response = 2 Then                ' cancel
                    Unload frm                          ' start over
                    Load frm
                    frm.Show
                    Exit Sub
                End If
        ElseIf Box = 48 And ErrorType = 20 Then         ' range error
                    ' ------
                    ' inches
                    ' ------
                If frm.optLLFt.Value = True Then
                    Response = MsgBox(Msg2 + Msg53, 5 + 16 + 0, Title)
                    If Response = 4 Then                ' retry
                        frm.txtACBD.Text = ""
                        frm.txtACBD.SetFocus
                        Exit Sub
                    ElseIf Response = 2 Then            ' cancel
                        Unload frm                      ' start over
                        Load frm
                        frm.Show
                        Exit Sub
                    End If

                    ' -----------
                    ' millimeters
                    ' -----------
                ElseIf frm.optLLMet.Value = True Then
                    Response = MsgBox(Msg2 + Msg54, 5 + 16 + 0, Title)
                    If Response = 4 Then                ' retry
                        frm.txtACBD.Text = ""
                        frm.txtACBD.SetFocus
                        Exit Sub
                    ElseIf Response = 2 Then            ' cancel
                        Unload frm                      ' start over
                        Load frm
                        frm.Show
                        Exit Sub
                    End If
                End If
        End If

            ' ---------------------------------------------
            ' conductor spacing (4 wire line) - frmOpenWire
            ' ---------------------------------------------
        If Box = 49 And ErrorType = 10 Then             ' character error
            Response = MsgBox(Msg1, 5 + 16 + 0, Title)
                If Response = 4 Then                    ' retry
                    frm.txtADBC.Text = ""
                    frm.txtADBC.SetFocus
                    Exit Sub
                ElseIf Response = 2 Then                ' cancel
                    Unload frm                          ' start over
                    Load frm
                    frm.Show
                    Exit Sub
                End If
        ElseIf Box = 49 And ErrorType = 20 Then         ' range error
                    ' ------
                    ' inches
                    ' ------
                If frm.optLLFt.Value = True Then
                    Response = MsgBox(Msg2 + Msg53, 5 + 16 + 0, Title)
                    If Response = 4 Then                ' retry
                        frm.txtADBC.Text = ""
                        frm.txtADBC.SetFocus
                        Exit Sub
                    ElseIf Response = 2 Then            ' cancel
                        Unload frm                      ' start over
                        Load frm
                        frm.Show
                        Exit Sub
                    End If

                    ' -----------
                    ' millimeters
                    ' -----------
                ElseIf frm.optLLMet.Value = True Then
                    Response = MsgBox(Msg2 + Msg54, 5 + 16 + 0, Title)
                    If Response = 4 Then                ' retry
                        frm.txtADBC.Text = ""
                        frm.txtADBC.SetFocus
                        Exit Sub
                    ElseIf Response = 2 Then            ' cancel
                        Unload frm                      ' start over
                        Load frm
                        frm.Show
                        Exit Sub
                    End If
                End If
        End If

    End Sub   ' ErrorMessage (frm As Form, ErrorType As Integer, Box As Integer)

    Sub Main ()

        ' =====================
        ' parent:  TRANSLIN.BAS
        ' =====================

        Load frmCoaxStub            ' load here for faster display when called
        frmTLineMenu.Show                                   ' program main menu

    End Sub                                                         ' Main ()

    Sub ProgramTitle (frm As Form, Sp As Integer)

        ' ============================================
        ' caption property for all forms - placed here
        '  to make it easy to change all forms at once
        ' ============================================
        ' parent:  TRANSLIN.BAS
        ' ============================================

            ' -------------------------
            ' dimension local variables
            ' -------------------------
        Dim Credit As String
        Dim S As String
        Dim Title As String

            ' --------------------------------------------
            ' leading space in title added for readability
            ' --------------------------------------------
        Title = " Transmission Line Data and Calculations - Version 1.0"
        Credit = "WS7R, 2004"
        S = Space$(Sp)

        frm.Caption = Title + S + Credit

    End Sub                         ' ProgramTitle (frm As Form, Sp As Integer)

    Function ValCheck (frm As Form, T As String, Box As Integer, Units As String) As Integer

        ' ====================================================================
        ' Checks the string input for valid characters (0 thru 9 and decimal
        '  point only).  If the input characters are valid, converts string to
        '  a type Single variable and checks for valid range.  Valid range is
        '  dependent upon the input quantity and the form.  Outputs an integer
        '  indicating the type of error detected, if any.
        '
        ' frm is the form to test.
        '
        ' T is the string to test.
        '
        ' Box indicates the text box to be checked.
        '   1 = txtPubZo (frmCoaxDiel)
        '   2 = txtPubCapac (frmCoaxDiel)
        '   3 = txtLineLen (frmCoaxChar)
        '   4 = txtFreq (frmCoaxChar)
        '   5 = txtUnkImped (frmCoaxChar)
        '   6 = txtUnkCap (frmCoaxChar)
        '   7 = txtUnkInduct (frmCoaxChar)
        '   8 = txtUnkDiel (frmCoaxChar)
        '   9 = txtUnkVel (frmCoaxChar)
        '  10 = txtUnkRatio (frmCoaxChar)
        '  11 = txtID (frmCoaxPrimer)
        '  12 = txtOD (frmCoaxPrimer)
        '  13 = txtDiel (frmCoaxPrimer)
        '  14 = txtK1 (frmCoaxPrimer)
        '  15 = txtK2 (frmCoaxPrimer)
        '  16 = txtFreq (frmCoaxPrimer)
        '  17 = txtPF (frmCoaxPrimer)
        '  18 = txtAlt (frmCoaxPrimer)
        '  19 = txtRMS (frmCoaxPrimer)
        '  20 = txtOpFreq (frmCoaxChar)
        '  21 = txtFreq (frmCoaxStub)
        '  22 = txtImped (frmCoaxStub)
        '  23 = txtDielConst (frmCoaxStub)
        '  24 = txtSpInput (frmCoaxStub)
        '  25 = txtInput (frmSqrLine)
        '  26 = txtWidth (frmSqrLine)
        '  27 = txtParam1 (frmSqrCoax)
        '  28 = txtParam2 (frmSqrCoax)
        '  29 = txtAntR (frmTLinePerf)
        '  30 = txtAntX (frmTLinePerf)
        '  31 = txtLoadPwr (frmTLinePerf)
        '  32 = txtAntLoadI (frmTLinePerf)
        '  33 = txtLoadIPhase (frmTLinePerf)
        '  34 = txtAntLoadV (frmTLinePerf)
        '  35 = txtLoadVPhase (frmTLinePerf)
        '  36 = txtLLDeg (frmTLinePerf)
        '  37 = txtLLFt (frmTLinePerf)
        '  38 = txtLLMt (frmTLinePerf)
        '  39 = txtFreqIn (frmTLinePerf)
        '  40 = txtCharZ (frmTLinePerf)
        '  41 = txtLineVFDec (frmTLinePerf)
        '  42 = txtWire (frmOpenWire)
        '  43 = txtHT (frmOpenWire)
        '  44 = txtCCIn (frmOpenWire)
        '  45 = txtLinLen (frmOpenWire)
        '  46 = txtFreq (frmOpenWire)
        '  47 = txtZIn (frmOpenWire)
        '  48 = txtACBD (frmOpenWire)
        '  49 = txtADBC (frmOpenWire)
        '
        ' Units values:
        '  AWG = AWG
        '  Cm = centimeters
        '  In = inches
        '  Ft = feet
        '  Mm = millimeters
        '  Mt = meters
        '  NA = not applicable
        '
        ' Error outputs:
        '   0 = no error detected
        '  10 = invalid character
        '  20 = invalid range
        ' ====================================================================
        ' parent:  TRANSLIN.BAS
        ' ====================================================================

            ' -----------------------
            ' declare local variables
            ' -----------------------
        Dim TestChar As String              ' individual character to test
        Dim Test As Integer                 ' ASCII value of TestChar
        Dim V As Single                     ' value of input string

            ' --------------------------------------------------
            ' parse input string and test for illegal characters
            '   45 = minus sign
            '   46 = decimal point
            '   48 = 0
            '   57 = 9
            ' --------------------------------------------------
            ' strip leading & trailing spaces from input string
            ' --------------------------------------------------
        T = LTrim$(RTrim$(T))

        If Box = 33 Or Box = 35 Then            ' allow minus sign
            For I = 1 To Len(T)                 ' read left to right
                TestChar = Mid$(T, I, 1)
                Test = Asc(TestChar)
                If Test = 45 Or Test = 46 Or (Test >= 48 And Test <= 57) Then
                    ValCheck = 0                ' no error
                    V = Val(T)                  ' convert input to type Single
                Else
                    ValCheck = 10               ' character error
                    Exit Function               ' exit on error
                End If
            Next I
        Else                                    ' no minus sign
            For I = 1 To Len(T)                 ' read left to right
                TestChar = Mid$(T, I, 1)
                Test = Asc(TestChar)
                If Test = 46 Or (Test >= 48 And Test <= 57) Then
                    ValCheck = 0                ' no error
                    V = Val(T)                  ' convert input to type Single
                Else
                    ValCheck = 10               ' character error
                    Exit Function               ' exit on error
                End If
            Next I
        End If

            ' ---------------------------
            ' test inputs for valid range
            ' ---------------------------

            ' --------------------------------------
            ' nominal impedance (ohms) - frmCoaxDiel
            '  range: > 0 and <= 125
            ' --------------------------------------
        If Box = 1 And (V > 0 And V <= 125) Then
            ValCheck = 0
        ElseIf Box = 1 And (V > 125 Or V < 0) Then
            ValCheck = 20

            ' --------------------------------------------
            ' published capacitance (pF/ft.) - frmCoaxDiel
            '  range: >= 6 and <= 35
            ' --------------------------------------------
        ElseIf Box = 2 And (V >= 6 And V <= 35) Then
            ValCheck = 0
        ElseIf Box = 2 And (V > 35 Or V < 6) Then
            ValCheck = 20

            ' ----------------------------------
            ' line length - frmCoaxChar
            '  range: >= 0.03 and <= 2000 feet
            '  range: >= 0.009 and <= 610 meters
            ' ----------------------------------
        ElseIf (Box = 3 And Units = "Ft") And (V >= .03 And V <= 2000) Then
            ValCheck = 0
        ElseIf (Box = 3 And Units = "Ft") And (V > 2000 Or V < .03) Then
            ValCheck = 20
        ElseIf (Box = 3 And Units = "Mt") And (V >= .009 And V <= 610) Then
            ValCheck = 0
        ElseIf (Box = 3 And Units = "Mt") And (V > 610 Or V < .009) Then
            ValCheck = 20

            ' -----------------------------
            ' frequency (MHz) - frmCoaxChar
            '  range: >= 0.1 and <= 999.999
            ' -----------------------------
        ElseIf Box = 4 And (V >= .1 And V <= 999.999) Then
            ValCheck = 0
        ElseIf Box = 4 And (V > 999.999 Or V < .1) Then
            ValCheck = 20

            ' --------------------------------------
            ' unknown impedance (ohms) - frmCoaxChar
            '  range: > 0 and <= 125
            ' --------------------------------------
        ElseIf Box = 5 And (V > 0 And V <= 125) Then
            ValCheck = 0
        ElseIf Box = 5 And (V > 125 Or V < 0) Then
            ValCheck = 20

            ' --------------------------------------------------
            ' unknown capacitance (picoFarads/ft.) - frmCoaxChar
            '  range: >= 6 and <= 35
            ' --------------------------------------------------
        ElseIf Box = 6 And (V >= 6 And V <= 35) Then
            ValCheck = 0
        ElseIf Box = 6 And (V > 35 Or V < 6) Then
            ValCheck = 20

            ' ---------------------------------------------------
            ' unknown inductance (microHenries/ft.) - frmCoaxChar
            '  range: > 0 and <= .2
            ' ---------------------------------------------------
        ElseIf Box = 7 And (V > 0 And V <= .2) Then
            ValCheck = 0
        ElseIf Box = 7 And (V > .2 Or V < 0) Then
            ValCheck = 20

            ' -----------------------------------------
            ' unknown dielectric constant - frmCoaxChar
            '  range: >= 1.0 and <= 3.0
            ' -----------------------------------------
        ElseIf Box = 8 And (V >= 1# And V <= 3#) Then
            ValCheck = 0
        ElseIf Box = 8 And (V > 3# Or V < 1) Then
            ValCheck = 20

            ' -----------------------------------------
            ' unknown velocity factor (%) - frmCoaxChar
            '  range: >= 60 and < 100
            ' -----------------------------------------
        ElseIf Box = 9 And (V >= 60 And V < 100) Then
            ValCheck = 0
        ElseIf Box = 9 And (V >= 100 Or V < 60) Then
            ValCheck = 20

            ' ---------------------------------------------------
            ' unknown outer cond. ID/inner cond. OD - frmCoaxChar
            '  range: > 2.5 and < 13
            ' ---------------------------------------------------
        ElseIf Box = 10 And (V > 2.5 And V < 13) Then
            ValCheck = 0
        ElseIf Box = 10 And (V >= 13 Or V <= 2.5) Then
            ValCheck = 20

            ' -------------------------------------------------------------
            ' inner diameter of outer conductor (jacket OD) - frmCoaxPrimer
            '  range:  > 0 and <= 1.20 inches
            ' -------------------------------------------------------------
        ElseIf Box = 11 And (V > 0 And V <= 1.2) Then
            ValCheck = 0
        ElseIf Box = 11 And (V >= 1.2 Or V <= 0) Then
            ValCheck = 20

            ' -------------------------------------------------
            ' outer diameter of inner conductor - frmCoaxPrimer
            '  range:  >= 0.01 and <= 0.33 inches
            ' -------------------------------------------------
        ElseIf Box = 12 And (V >= .01 And V <= .33) Then
            ValCheck = 0
        ElseIf Box = 12 And (V > .33 Or V < .01) Then
            ValCheck = 20

            ' -----------------------------------
            ' dielectric constant - frmCoaxPrimer
            '  range:  >= 1.0 and <= 3.0
            ' -----------------------------------
        ElseIf Box = 13 And (V >= 1# And V <= 3#) Then
            ValCheck = 0
        ElseIf Box = 13 And (V > 3# Or V < 1) Then
            ValCheck = 20

            ' -----------------------------------------------------
            ' inner conductor stranding factor (K1) - frmCoaxPrimer
            '  range:  >= 0.939 and <= 1.0
            ' -----------------------------------------------------
        ElseIf Box = 14 And (V >= .939 And V <= 1#) Then
            ValCheck = 0
        ElseIf Box = 14 And (V > 1# Or V < .939) Then
            ValCheck = 20

            ' -------------------------------------------
            ' braid stranding factor (K2) - frmCoaxPrimer
            '  range:  >= 0.939 and <= 1.0
            ' -------------------------------------------
        ElseIf Box = 15 And (V >= .939 And V <= 1#) Then
            ValCheck = 0
        ElseIf Box = 15 And (V > 1# Or V < .939) Then
            ValCheck = 20

            ' -------------------------------
            ' frequency (MHz) - frmCoaxPrimer
            '  range: >= 0.1 and <= 999.999
            ' -------------------------------
        ElseIf Box = 16 And (V >= .1 And V <= 999.999) Then
            ValCheck = 0
        ElseIf Box = 16 And (V > 999.999 Or V < .1) Then
            ValCheck = 20

            ' ---------------------------------------
            ' dielectric power factor - frmCoaxPrimer
            '  range:  >= 0.00000001 and <= 0.0003
            ' ---------------------------------------
        ElseIf Box = 17 And (V >= .00000001 And V <= .0003) Then
            ValCheck = 0
        ElseIf Box = 17 And (V > .0003 Or V < .00000001) Then
            ValCheck = 20

            ' ---------------------------------------------
            ' altitude above sea level - frmCoaxPrimer
            '  range:  >= 0 and <= 29000 feet
            '  Death Valley -282 and Mt. McKinley 20320 ft.
            '  Mt. Everest 29,028 ft.
            ' ---------------------------------------------
        ElseIf Box = 18 And (V >= 0 And V <= 29000) Then
            ValCheck = 0
        ElseIf Box = 18 And (V > 29000 Or V < 0) Then
            ValCheck = 20

            ' ---------------------------------------------
            ' maximum RMS operating voltage - frmCoaxPrimer
            '  range:  >= 300 and <= 11000 volts
            ' ---------------------------------------------
        ElseIf Box = 19 And (V >= 300 And V <= 11000) Then
            ValCheck = 0
        ElseIf Box = 19 And (V > 11000 Or V < 300) Then
            ValCheck = 20

            ' -----------------------------
            ' frequency (MHz) - frmCoaxChar
            '  range: >= 0.1 and <= 999.999
            ' -----------------------------
        ElseIf Box = 20 And (V >= .1 And V <= 999.999) Then
            ValCheck = 0
        ElseIf Box = 20 And (V > 999.999 Or V < .1) Then
            ValCheck = 20

            ' -----------------------------
            ' frequency (MHz) - frmCoaxStub
            '  range: >= 0.1 and <= 999.999
            ' -----------------------------
        ElseIf Box = 21 And (V >= .1 And V <= 999.999) Then
            ValCheck = 0
        ElseIf Box = 21 And (V > 999.999 Or V < .1) Then
            ValCheck = 20

            ' ------------------------------
            ' impedance (ohms) - frmCoaxStub
            '  range: > 0 and <= 600
            ' ------------------------------
        ElseIf Box = 22 And (V > 0 And V <= 600) Then
            ValCheck = 0
        ElseIf Box = 22 And (V > 600 Or V < 0) Then
            ValCheck = 20

            ' ---------------------------------
            ' dielectric constant - frmCoaxStub
            '  range: >= 1.0 and <= 3.0
            ' ---------------------------------
        ElseIf Box = 23 And (V >= 1# And V <= 3#) Then
            ValCheck = 0
        ElseIf Box = 23 And (V > 3# Or V < 1) Then
            ValCheck = 20

            ' -------------------------------------------------------
            ' specific input text box - frmCoaxStub
            '  ranges:
            '   Capacitance (C)             1 to 100,000 picoFarads
            '   Capacitive Reactance (XC)   1 to 250 ohms
            '   Frequency                   0.100 to 999.999 MHz
            '   Inductance (L)              0.01 to 3000 microHenries
            '   Inductive Reactance (XL)    150 to 2000 ohms
            '   Length                      0.03 to 2000 feet
            '   Length                      0.009 to 610 meters
            ' -------------------------------------------------------
        ElseIf Box = 24 Then
            If frm.optCapacitance.Value = True Then
                If V >= 1 And V <= 100000 Then
                    ValCheck = 0
                ElseIf V < 1 Or V > 100000 Then
                    ValCheck = 20
                End If
            ElseIf frm.optCapReact.Value = True Then
                If V >= 1 And V <= 250 Then
                    ValCheck = 0
                ElseIf V < 1 Or V > 250 Then
                    ValCheck = 20
                End If
            ElseIf frm.optFrequency.Value = True Then
                If V >= .1 And V <= 999.999 Then
                    ValCheck = 0
                ElseIf V < .1 Or V > 999.999 Then
                    ValCheck = 20
                End If
            ElseIf frm.optInductance.Value = True Then
                If V >= .01 And V <= 3000 Then
                    ValCheck = 0
                ElseIf V < .01 Or V > 3000 Then
                    ValCheck = 20
                End If
            ElseIf frm.optInductReact.Value = True Then
                If V >= 150 And V <= 2000 Then
                    ValCheck = 0
                ElseIf V < 150 Or V > 2000 Then
                    ValCheck = 20
                End If
            ElseIf frm.optLength.Value = True Then
                If frm.optUS.Value = True Then
                    If V >= .03 And V <= 2000 Then
                        ValCheck = 0
                    ElseIf V < .03 Or V > 2000 Then
                        ValCheck = 20
                    End If
                ElseIf frm.optMetric.Value = True Then
                    If V >= .009 And V <= 610 Then
                        ValCheck = 0
                    ElseIf V < .009 Or V > 610 Then
                        ValCheck = 20
                    End If
                End If
            End If

            ' -----------------------------------------------------
            ' general input box (impedance or spacing) - frmSqrLine
            '  ranges:
            '   Impedance (ohms)            10 to 800
            '   Spacing (inches)            0.0012 to 46.36
            '   Spacing (millimeters)       0.030 to 1178
            ' -----------------------------------------------------
        ElseIf Box = 25 Then
            If frm.optSpacing.Value = True Then
                If V >= 10 And V <= 800 Then
                    ValCheck = 0
                ElseIf V < 10 Or V > 800 Then
                    ValCheck = 20
                End If
            ElseIf frm.optImped.Value = True Then
                If frm.optInches.Value = True Then
                    If V >= .0012 And V <= 46.36 Then
                        ValCheck = 0
                    ElseIf V < .0012 Or V > 46.36 Then
                        ValCheck = 20
                    End If
                ElseIf frm.optMillimeters.Value = True Then
                    If V >= .03 And V <= 1178 Then
                        ValCheck = 0
                    ElseIf V < .03 Or V > 1178 Then
                        ValCheck = 20
                    End If
                End If
            End If

            ' --------------------------------------
            ' width of square conductor - frmSqrLine
            '  ranges:
            '   Inches          0.001 to 0.100
            '   Millimeters     0.0254 to 2.54
            ' --------------------------------------
        ElseIf Box = 26 Then
            If frm.optInches.Value = True Then
                If V >= .001 And V <= .1 Then
                    ValCheck = 0
                ElseIf V < .001 Or V > .1 Then
                    ValCheck = 20
                End If
            ElseIf frm.optMillimeters.Value = True Then
                If V >= .0254 And V <= 2.54 Then
                    ValCheck = 0
                ElseIf V < .0254 Or V > 2.54 Then
                    ValCheck = 20
                End If
            End If

            ' ----------------------------------------------------------------
            ' param1 (center conductor size or shield inner face) - frmSqrCoax
            '  Center conductor side (optSqSq and optImped or optShield) or
            '  center conductor diameter (optSqRnd and optImped or optShield)
            '   ranges:
            '    Inches         0.1 to 30
            '    Centimeters    0.254 to 76.2
            '  Shield inner face (optCtrCond)
            '   ranges:
            '    Inches         0.2 to 30
            '    Centimeters    0.508 to 76.2
            ' ----------------------------------------------------------------
        ElseIf Box = 27 Then
            If frm.optImped.Value = True Or frm.optShield.Value = True Then
                If frm.optInches.Value = True Then
                    If V >= .1 And V <= 30 Then
                        ValCheck = 0
                    ElseIf V < .1 Or V > 30 Then
                        ValCheck = 20
                    End If
                ElseIf frm.optCentMtrs.Value = True Then
                    If V >= .254 And V <= 76.2 Then
                        ValCheck = 0
                    ElseIf V < .254 Or V > 76.2 Then
                        ValCheck = 20
                    End If
                End If
            ElseIf frm.optCtrCond.Value = True Then
                If frm.optInches.Value = True Then
                    If V >= .2 And V <= 30 Then
                        ValCheck = 0
                    ElseIf V < .2 Or V > 30 Then
                        ValCheck = 20
                    End If
                ElseIf frm.optCentMtrs.Value = True Then
                    If V >= .508 And V <= 76.2 Then
                        ValCheck = 0
                    ElseIf V < .508 Or V > 76.2 Then
                        ValCheck = 20
                    End If
                End If
            End If
            ' ----------------------------------------------------
            ' param2 (shield inner face or impedance) - frmSqrCoax
            '  Shield inner face (optImped)
            '   ranges:
            '    Inches         0.2 to 30
            '    Centimeters    0.508 to 76.2
            '  Impedance (optShield and optCtrCond)
            '   range:
            '    Ohms           10 to 150
            ' ----------------------------------------------------
        ElseIf Box = 28 Then
            If frm.optImped.Value = True Then
                If frm.optInches.Value = True Then
                    If V >= .2 And V <= 30 Then
                        ValCheck = 0
                    ElseIf V < .2 Or V > 30 Then
                        ValCheck = 20
                    End If
                ElseIf frm.optCentMtrs.Value = True Then
                    If V >= .508 And V <= 76.2 Then
                        ValCheck = 0
                    ElseIf V < .508 Or V > 76.2 Then
                        ValCheck = 20
                    End If
                End If
            ElseIf frm.optShield.Value = True Or frm.optCtrCond.Value = True Then
                If V >= 10 And V <= 150 Then
                    ValCheck = 0
                ElseIf V < 10 Or V > 150 Then
                    ValCheck = 20
                End If
            End If

            ' ----------------------------------------
            ' antenna resistance (ohms) - frmTLinePerf
            '  range: >= 0 and <= 1000
            ' ----------------------------------------
        ElseIf Box = 29 Then
            If V >= 0 And V <= 1000 Then
                ValCheck = 0
            ElseIf V < 0 Or V > 1000 Then
                ValCheck = 20
            End If

            ' ---------------------------------------
            ' antenna reactance (ohms) - frmTLinePerf
            '  range: >= 0 and <= 1000
            ' ---------------------------------------
        ElseIf Box = 30 Then
            If V >= 0 And V <= 1000 Then
                ValCheck = 0
            ElseIf V < 0 Or V > 1000 Then
                ValCheck = 20
            End If

            ' ---------------------------------
            ' load power (watts) - frmTLinePerf
            '  range: > 0 and <= 2500
            ' ---------------------------------
        ElseIf Box = 31 Then
            If V > 0 And V <= 2500 Then
                ValCheck = 0
            ElseIf V = 0 Or V > 2500 Then
                ValCheck = 20
            End If

            ' ------------------------------------------
            ' antenna load current (amps) - frmTLinePerf
            '  range: > 0 and <= 16
            ' ------------------------------------------
        ElseIf Box = 32 Then
            If V > 0 And V <= 16 Then
                ValCheck = 0
            ElseIf V <= 0 Or V > 16 Then
                ValCheck = 20
            End If

            ' -------------------------------------------
            ' load current phase (degrees) - frmTLinePerf
            '  range: >= -360 and <= 360
            ' -------------------------------------------
        ElseIf Box = 33 Then
            If V >= -360 And V <= 360 Then
                ValCheck = 0
            ElseIf V < -360 Or V > 360 Then
                ValCheck = 20
            End If

            ' -------------------------------------------
            ' antenna load voltage (volts) - frmTLinePerf
            '  range: > 0 and <= 16000
            ' -------------------------------------------
        ElseIf Box = 34 Then
            If V > 0 And V <= 16000 Then
                ValCheck = 0
            ElseIf V <= 0 Or V > 16000 Then
                ValCheck = 20
            End If

            ' -------------------------------------------
            ' load voltage phase (degrees) - frmTLinePerf
            '  range: >= -360 and <= 360
            ' -------------------------------------------
        ElseIf Box = 35 Then
            If V >= -360 And V <= 360 Then
                ValCheck = 0
            ElseIf V < -360 Or V > 360 Then
                ValCheck = 20
            End If

            ' -------------------------------------
            ' line length in degrees - frmTLinePerf
            '  range: >= 0 and <= 360
            ' -------------------------------------
        ElseIf Box = 36 Then
            If V >= 0 And V <= 360 Then
                ValCheck = 0
            ElseIf V < 0 Or V > 360 Then
                ValCheck = 20
            End If

            ' ----------------------------------
            ' line length in feet - frmTLinePerf
            '  range: > 0 and <= 5000
            ' ----------------------------------
        ElseIf Box = 37 Then
            If V > 0 And V <= 5000 Then
                ValCheck = 0
            ElseIf V <= 0 Or V > 5000 Then
                ValCheck = 20
            End If

            ' ------------------------------------
            ' line length in meters - frmTLinePerf
            '  range: > 0 and <= 1500
            ' ------------------------------------
        ElseIf Box = 38 Then
            If V > 0 And V <= 1500 Then
                ValCheck = 0
            ElseIf V <= 0 Or V > 1500 Then
                ValCheck = 20
            End If

            ' ----------------------------------------
            ' operating frequency (MHz) - frmTLinePerf
            '  range: >= 0.1 and <= 999.999
            ' ----------------------------------------
        ElseIf Box = 39 Then
            If V >= .1 And V <= 999.999 Then
                ValCheck = 0
            ElseIf V < .1 Or V > 999.999 Then
                ValCheck = 20
            End If

            ' ---------------------------------------------------
            ' line characteristic impedance (ohms) - frmTLinePerf
            '  range: >= 10 and <= 600
            ' ---------------------------------------------------
        ElseIf Box = 40 Then
            If V >= 10 And V <= 600 Then
                ValCheck = 0
            ElseIf V < 10 Or V > 600 Then
                ValCheck = 20
            End If

            ' ------------------------------------------------
            ' line velocity factor as a decimal - frmTLinePerf
            '  range: >= 0.1 and <= 1
            ' ------------------------------------------------
        ElseIf Box = 41 Then
            If V >= .1 And V <= 1 Then
                ValCheck = 0
            ElseIf V < .1 Or V > 1 Then
                ValCheck = 20
            End If

            ' -----------------------------------------
            ' wire size - frmOpenWire
            '  decimal inches (optIN)
            '   range:          >= 0.0031 and <= 0.2893
            '  millimeters (optMM)
            '   range:          >= 0.0787 and <= 7.2325
            '  AWG size (optAWG)
            '   range:          >= 1 and <= 40
            ' -----------------------------------------
        ElseIf Box = 42 Then
            If frm.optMM.Value = True Then
                If V >= .0787 And V <= 7.2325 Then
                    ValCheck = 0
                ElseIf V < .0787 Or V > 7.2325 Then
                    ValCheck = 20
                End If
            ElseIf frm.optIN.Value = True Then
                If V >= .0031 And V <= .2893 Then
                    ValCheck = 0
                ElseIf V < .0031 Or V > .2893 Then
                    ValCheck = 20
                End If
            ElseIf frm.optAWG.Value = True Then
                If V >= 1 And V <= 40 Then
                    ValCheck = 0
                ElseIf V < 1 Or V > 40 Then
                    ValCheck = 20
                End If
            End If

            ' ---------------------------------
            ' height above ground - frmOpenWire
            '  meters (optHTMet)
            '   range:          > 0 and <= 100
            '  feet (optHTFt)
            '   range:          > 0 and <= 300
            ' ---------------------------------
        ElseIf Box = 43 Then
            If frm.optHTMet.Value = True Then
                If V > 0 And V <= 100 Then
                    ValCheck = 0
                ElseIf V < 0 Or V > 100 Then
                    ValCheck = 20
                End If
            ElseIf frm.optHTFt.Value = True Then
                If V > 0 And V <= 300 Then
                    ValCheck = 0
                ElseIf V < 0 Or V > 300 Then
                    ValCheck = 20
                End If
            End If

            ' --------------------------------------
            ' center-to-center spacing - frmOpenWire
            '  millimeters (optLLMet)
            '   range:          > 0 and <= 300
            '  inches (optLLFt)
            '   range:          > 0 and <= 12
            ' --------------------------------------
        ElseIf Box = 44 Then
            If frm.optLLMet.Value = True Then
                If V > 0 And V <= 300 Then
                    ValCheck = 0
                ElseIf V < 0 Or V > 300 Then
                    ValCheck = 20
                End If
            ElseIf frm.optLLFt.Value = True Then
                If V > 0 And V <= 12 Then
                    ValCheck = 0
                ElseIf V < 0 Or V > 12 Then
                    ValCheck = 20
                End If
            End If

            ' --------------------------------
            ' 2-wire line length - frmOpenWire
            '  meters (optLLMet)
            '   range:          > 0 and <= 150
            '  feet (optLLFt)
            '   range:          > 0 and <= 500
            ' --------------------------------
        ElseIf Box = 45 Then
            If frm.optLLMet.Value = True Then
                If V > 0 And V <= 150 Then
                    ValCheck = 0
                ElseIf V < 0 Or V > 150 Then
                    ValCheck = 20
                End If
            ElseIf frm.optLLFt.Value = True Then
                If V > 0 And V <= 500 Then
                    ValCheck = 0
                ElseIf V < 0 Or V > 500 Then
                    ValCheck = 20
                End If
            End If

            ' ------------------------------------
            ' design frequency (MHz) - frmOpenWire
            '  range: >= 0.1 and <= 999.999
            ' ------------------------------------
        ElseIf Box = 46 And (V >= .1 And V <= 999.999) Then
            ValCheck = 0
        ElseIf Box = 46 And (V > 999.999 Or V < .1) Then
            ValCheck = 20

            ' -------------------------------------
            ' design impedance (ohms) - frmOpenWire
            '  range: >= 85 and <= 800
            ' -------------------------------------
        ElseIf Box = 47 Then
            If V >= 85 And V <= 800 Then
                ValCheck = 0
            ElseIf V < 85 Or V > 800 Then
                ValCheck = 20
            End If

            ' ---------------------------------------------
            ' conductor spacing (4 wire line) - frmOpenWire
            '  (dimensions AC or BD)
            '  inches (optLLFt)
            '   range:          > 0 and <= 12
            '  millimeters (optMet)
            '   range:          > 0 and <= 300
            ' ---------------------------------------------
        ElseIf Box = 48 Then
            If frm.optLLMet.Value = True Then
                If V > 0 And V <= 300 Then
                    ValCheck = 0
                ElseIf V < 0 Or V > 300 Then
                    ValCheck = 20
                End If
            ElseIf frm.optLLFt.Value = True Then
                If V > 0 And V <= 12 Then
                    ValCheck = 0
                ElseIf V < 0 Or V > 12 Then
                    ValCheck = 20
                End If
            End If

            ' ---------------------------------------------
            ' conductor spacing (4 wire line) - frmOpenWire
            '  (dimensions AD or BC)
            '  inches (optLLFt)
            '   range:          > 0 and <= 12
            '  millimeters (optLLMet)
            '   range:          > 0 and <= 300
            ' ---------------------------------------------
        ElseIf Box = 49 Then
            If frm.optLLMet.Value = True Then
                If V > 0 And V <= 300 Then
                    ValCheck = 0
                ElseIf V < 0 Or V > 300 Then
                    ValCheck = 20
                End If
            ElseIf frm.optLLFt.Value = True Then
                If V > 0 And V <= 12 Then
                    ValCheck = 0
                ElseIf V < 0 Or V > 12 Then
                    ValCheck = 20
                End If
            End If
        End If
                        ' ValCheck (frm as Form, T As String, Box As Integer,
    End Function        '  Units As String) As Integer

