VERSION 5.00
Begin VB.Form frmSqrLine 
   Appearance      =   0  'Flat
   BackColor       =   &H00FFEBC8&
   ClientHeight    =   6615
   ClientLeft      =   6060
   ClientTop       =   2205
   ClientWidth     =   6135
   BeginProperty Font 
      Name            =   "MS Sans Serif"
      Size            =   8.25
      Charset         =   0
      Weight          =   700
      Underline       =   0   'False
      Italic          =   0   'False
      Strikethrough   =   0   'False
   EndProperty
   ForeColor       =   &H80000008&
   Icon            =   "SQRLINE.frx":0000
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   PaletteMode     =   1  'UseZOrder
   ScaleHeight     =   6615
   ScaleWidth      =   6135
   Begin VB.PictureBox picGapError 
      Appearance      =   0  'Flat
      BackColor       =   &H00C0FFC0&
      ForeColor       =   &H80000008&
      Height          =   1215
      Left            =   120
      ScaleHeight     =   1185
      ScaleWidth      =   2385
      TabIndex        =   40
      Top             =   5400
      Width           =   2415
      Begin VB.CommandButton cmdRetry 
         Appearance      =   0  'Flat
         Caption         =   "&Re-Enter"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   9.75
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   495
         Left            =   0
         TabIndex        =   41
         Top             =   600
         Width           =   1605
      End
      Begin VB.Label lblGapError 
         Appearance      =   0  'Flat
         BackColor       =   &H80000005&
         BackStyle       =   0  'Transparent
         BorderStyle     =   1  'Fixed Single
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   9.75
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         ForeColor       =   &H80000008&
         Height          =   495
         Left            =   0
         TabIndex        =   39
         Top             =   0
         Width           =   1215
      End
   End
   Begin VB.CommandButton cmdOK 
      Appearance      =   0  'Flat
      Caption         =   "&OK"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   495
      Left            =   4320
      TabIndex        =   38
      Top             =   4800
      Width           =   1605
   End
   Begin VB.CommandButton cmdAnother 
      Appearance      =   0  'Flat
      Caption         =   "&Compute Another"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   495
      Left            =   120
      TabIndex        =   37
      Top             =   4800
      Width           =   2430
   End
   Begin VB.PictureBox picRanges 
      Appearance      =   0  'Flat
      BackColor       =   &H00C0FFC0&
      ForeColor       =   &H80000008&
      Height          =   615
      Left            =   3000
      ScaleHeight     =   585
      ScaleWidth      =   2985
      TabIndex        =   33
      Top             =   2760
      Width           =   3015
      Begin VB.CommandButton cmdClose 
         Appearance      =   0  'Flat
         Caption         =   "&Close"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   9.75
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   495
         Left            =   0
         TabIndex        =   34
         Top             =   0
         Width           =   1605
      End
      Begin VB.Label lblLimits2 
         Appearance      =   0  'Flat
         BackColor       =   &H80000005&
         BackStyle       =   0  'Transparent
         BorderStyle     =   1  'Fixed Single
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   9.75
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         ForeColor       =   &H80000008&
         Height          =   255
         Left            =   2295
         TabIndex        =   29
         Top             =   300
         Width           =   495
      End
      Begin VB.Label lblLimTitle 
         Alignment       =   2  'Center
         Appearance      =   0  'Flat
         BackColor       =   &H80000005&
         BackStyle       =   0  'Transparent
         BorderStyle     =   1  'Fixed Single
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   12
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         ForeColor       =   &H80000008&
         Height          =   255
         Left            =   1695
         TabIndex        =   36
         Top             =   0
         Width           =   1215
      End
      Begin VB.Label lblLimits1 
         Appearance      =   0  'Flat
         BackColor       =   &H80000005&
         BackStyle       =   0  'Transparent
         BorderStyle     =   1  'Fixed Single
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   9.75
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         ForeColor       =   &H80000008&
         Height          =   255
         Left            =   1695
         TabIndex        =   35
         Top             =   300
         Width           =   495
      End
   End
   Begin VB.PictureBox picOutput 
      Appearance      =   0  'Flat
      BackColor       =   &H00D0FFFF&
      ForeColor       =   &H80000008&
      Height          =   1695
      Left            =   120
      ScaleHeight     =   1665
      ScaleWidth      =   2745
      TabIndex        =   23
      Top             =   2400
      Width           =   2775
      Begin VB.Label lblGapMm 
         Alignment       =   1  'Right Justify
         Appearance      =   0  'Flat
         BackColor       =   &H80000005&
         BackStyle       =   0  'Transparent
         BorderStyle     =   1  'Fixed Single
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   9.75
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         ForeColor       =   &H80000008&
         Height          =   300
         Left            =   1800
         TabIndex        =   32
         Top             =   900
         Width           =   600
      End
      Begin VB.Label lblCCDistMm 
         Alignment       =   1  'Right Justify
         Appearance      =   0  'Flat
         BackColor       =   &H80000005&
         BackStyle       =   0  'Transparent
         BorderStyle     =   1  'Fixed Single
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   9.75
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         ForeColor       =   &H80000008&
         Height          =   300
         Left            =   1800
         TabIndex        =   31
         Top             =   450
         Width           =   600
      End
      Begin VB.Label lblCondWidMm 
         Alignment       =   1  'Right Justify
         Appearance      =   0  'Flat
         BackColor       =   &H80000005&
         BackStyle       =   0  'Transparent
         BorderStyle     =   1  'Fixed Single
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   9.75
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         ForeColor       =   &H80000008&
         Height          =   300
         Left            =   1800
         TabIndex        =   30
         Top             =   0
         Width           =   600
      End
      Begin VB.Label lblImpedOut 
         Alignment       =   1  'Right Justify
         Appearance      =   0  'Flat
         BackColor       =   &H80000005&
         BackStyle       =   0  'Transparent
         BorderStyle     =   1  'Fixed Single
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   9.75
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         ForeColor       =   &H80000008&
         Height          =   300
         Left            =   900
         TabIndex        =   28
         Top             =   1320
         Width           =   600
      End
      Begin VB.Label lblGapIn 
         Alignment       =   1  'Right Justify
         Appearance      =   0  'Flat
         BackColor       =   &H80000005&
         BackStyle       =   0  'Transparent
         BorderStyle     =   1  'Fixed Single
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   9.75
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         ForeColor       =   &H80000008&
         Height          =   300
         Left            =   900
         TabIndex        =   27
         Top             =   900
         Width           =   600
      End
      Begin VB.Label lblImped 
         Appearance      =   0  'Flat
         BackColor       =   &H80000005&
         BackStyle       =   0  'Transparent
         BorderStyle     =   1  'Fixed Single
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   9.75
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         ForeColor       =   &H80000008&
         Height          =   300
         Left            =   0
         TabIndex        =   26
         Top             =   1320
         Width           =   600
      End
      Begin VB.Label lblGap 
         Appearance      =   0  'Flat
         BackColor       =   &H80000005&
         BackStyle       =   0  'Transparent
         BorderStyle     =   1  'Fixed Single
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   9.75
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         ForeColor       =   &H80000008&
         Height          =   300
         Left            =   0
         TabIndex        =   25
         Top             =   900
         Width           =   600
      End
      Begin VB.Label lblCondWidIn 
         Alignment       =   1  'Right Justify
         Appearance      =   0  'Flat
         BackColor       =   &H80000005&
         BackStyle       =   0  'Transparent
         BorderStyle     =   1  'Fixed Single
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   9.75
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         ForeColor       =   &H80000008&
         Height          =   300
         Left            =   900
         TabIndex        =   17
         Top             =   0
         Width           =   600
      End
      Begin VB.Label lblCCDistIn 
         Alignment       =   1  'Right Justify
         Appearance      =   0  'Flat
         BackColor       =   &H80000005&
         BackStyle       =   0  'Transparent
         BorderStyle     =   1  'Fixed Single
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   9.75
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         ForeColor       =   &H80000008&
         Height          =   300
         Left            =   900
         TabIndex        =   24
         Top             =   450
         Width           =   600
      End
      Begin VB.Label lblCCDist 
         Appearance      =   0  'Flat
         BackColor       =   &H80000005&
         BackStyle       =   0  'Transparent
         BorderStyle     =   1  'Fixed Single
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   9.75
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         ForeColor       =   &H80000008&
         Height          =   300
         Left            =   0
         TabIndex        =   15
         Top             =   450
         Width           =   600
      End
      Begin VB.Label lblCondWid 
         Appearance      =   0  'Flat
         BackColor       =   &H80000005&
         BackStyle       =   0  'Transparent
         BorderStyle     =   1  'Fixed Single
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   9.75
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         ForeColor       =   &H80000008&
         Height          =   300
         Left            =   0
         TabIndex        =   20
         Top             =   0
         Width           =   600
      End
   End
   Begin VB.PictureBox picWarning 
      Appearance      =   0  'Flat
      BackColor       =   &H0080FF80&
      ForeColor       =   &H80000008&
      Height          =   615
      Left            =   3000
      ScaleHeight     =   585
      ScaleWidth      =   2985
      TabIndex        =   21
      Top             =   3480
      Width           =   3015
      Begin VB.Label lblWarning 
         Appearance      =   0  'Flat
         BackColor       =   &H000000FF&
         BorderStyle     =   1  'Fixed Single
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   12
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         ForeColor       =   &H00FFFFFF&
         Height          =   495
         Left            =   0
         TabIndex        =   22
         Top             =   0
         Width           =   1215
      End
   End
   Begin VB.TextBox txtInput 
      Alignment       =   2  'Center
      Appearance      =   0  'Flat
      BackColor       =   &H00D0FFFF&
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   495
      Left            =   1680
      MaxLength       =   6
      TabIndex        =   16
      Top             =   1800
      Width           =   1215
   End
   Begin VB.Frame fraFunction 
      Appearance      =   0  'Flat
      BackColor       =   &H00FFEBC8&
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H80000008&
      Height          =   600
      Left            =   3000
      TabIndex        =   11
      Top             =   1200
      Width           =   3060
      Begin VB.OptionButton optSpacing 
         Appearance      =   0  'Flat
         BackColor       =   &H00FFEBC8&
         Caption         =   "&Spacing"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   9.75
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         ForeColor       =   &H80000008&
         Height          =   240
         Left            =   120
         TabIndex        =   13
         Top             =   270
         Width           =   1395
      End
      Begin VB.OptionButton optImped 
         Appearance      =   0  'Flat
         BackColor       =   &H00FFEBC8&
         Caption         =   "Im&pedance"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   9.75
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         ForeColor       =   &H80000008&
         Height          =   240
         Left            =   1575
         TabIndex        =   12
         Top             =   270
         Width           =   1395
      End
   End
   Begin VB.TextBox txtWidth 
      Alignment       =   2  'Center
      Appearance      =   0  'Flat
      BackColor       =   &H00D0FFFF&
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   495
      Left            =   1680
      MaxLength       =   6
      TabIndex        =   10
      Top             =   1200
      Width           =   1215
   End
   Begin VB.Frame fraUnits 
      Appearance      =   0  'Flat
      BackColor       =   &H00FFEBC8&
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H80000008&
      Height          =   600
      Left            =   3000
      TabIndex        =   6
      Top             =   1995
      Width           =   3060
      Begin VB.OptionButton optMillimeters 
         Appearance      =   0  'Flat
         BackColor       =   &H00FFEBC8&
         Caption         =   "Mi&llimeters"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   9.75
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         ForeColor       =   &H80000008&
         Height          =   240
         Left            =   1575
         TabIndex        =   8
         Top             =   270
         Width           =   1395
      End
      Begin VB.OptionButton optInches 
         Appearance      =   0  'Flat
         BackColor       =   &H00FFEBC8&
         Caption         =   "I&nches"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   9.75
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         ForeColor       =   &H80000008&
         Height          =   240
         Left            =   120
         TabIndex        =   7
         Top             =   270
         Width           =   1395
      End
   End
   Begin VB.CommandButton cmdExit 
      Appearance      =   0  'Flat
      Caption         =   "&Exit Program"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   495
      Left            =   2640
      TabIndex        =   2
      Top             =   4800
      Width           =   1605
   End
   Begin VB.CommandButton cmdCompute 
      Appearance      =   0  'Flat
      Caption         =   "&Compute Values"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   495
      Left            =   2640
      TabIndex        =   1
      Top             =   4200
      Width           =   2430
   End
   Begin VB.CommandButton cmdOpenMenu 
      Appearance      =   0  'Flat
      Caption         =   "Opening &Menu"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   495
      Left            =   120
      TabIndex        =   0
      Top             =   4200
      Width           =   2430
   End
   Begin VB.Label lblUnits 
      Appearance      =   0  'Flat
      BackColor       =   &H80000005&
      BackStyle       =   0  'Transparent
      BorderStyle     =   1  'Fixed Single
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H80000008&
      Height          =   495
      Left            =   4440
      TabIndex        =   19
      Top             =   600
      Width           =   1215
   End
   Begin VB.Label lblFunction 
      Appearance      =   0  'Flat
      BackColor       =   &H80000005&
      BackStyle       =   0  'Transparent
      BorderStyle     =   1  'Fixed Single
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H80000008&
      Height          =   495
      Left            =   3000
      TabIndex        =   18
      Top             =   600
      Width           =   1215
   End
   Begin VB.Label lblInput 
      Appearance      =   0  'Flat
      BackColor       =   &H80000005&
      BackStyle       =   0  'Transparent
      BorderStyle     =   1  'Fixed Single
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H80000008&
      Height          =   495
      Left            =   120
      TabIndex        =   14
      Top             =   1800
      Width           =   1215
   End
   Begin VB.Label lblWidth 
      Appearance      =   0  'Flat
      BackColor       =   &H80000005&
      BackStyle       =   0  'Transparent
      BorderStyle     =   1  'Fixed Single
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H80000008&
      Height          =   495
      Left            =   120
      TabIndex        =   9
      Top             =   1200
      Width           =   1215
   End
   Begin VB.Label lblNote2 
      Appearance      =   0  'Flat
      BackColor       =   &H80000005&
      BackStyle       =   0  'Transparent
      BorderStyle     =   1  'Fixed Single
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H80000008&
      Height          =   495
      Left            =   1680
      TabIndex        =   5
      Top             =   600
      Width           =   1215
   End
   Begin VB.Label lblNote1 
      Appearance      =   0  'Flat
      BackColor       =   &H80000005&
      BackStyle       =   0  'Transparent
      BorderStyle     =   1  'Fixed Single
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H80000008&
      Height          =   495
      Left            =   120
      TabIndex        =   4
      Top             =   600
      Width           =   1215
   End
   Begin VB.Label lblTitle 
      Alignment       =   2  'Center
      Appearance      =   0  'Flat
      BackColor       =   &H80000005&
      BackStyle       =   0  'Transparent
      BorderStyle     =   1  'Fixed Single
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H80000008&
      Height          =   300
      Left            =   120
      TabIndex        =   3
      Top             =   120
      Width           =   6015
   End
   Begin VB.Menu mnuInfo 
      Caption         =   "&Information"
      Begin VB.Menu mnuRanges 
         Caption         =   "&Ranges"
      End
      Begin VB.Menu mnuProgDir 
         Caption         =   "&Program Directory"
      End
      Begin VB.Menu NULL 
         Caption         =   "-"
      End
      Begin VB.Menu mnuExit 
         Caption         =   "&Exit"
      End
   End
End
Attribute VB_Name = "frmSqrLine"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
    ' SQRLINE.FRM
    '
    ' Version 1.0 Started:  January 26, 2004
    ' Version 1.0 Completed:  April 15, 2004
    '
    ' Used in program TRANSLIN.EXE
    '
    ' Language:  Microsoft Visual Basic 3.0, Professional Edition
    '            (Professional Edition features not used)
    '
    ' Programmer:  Stephen R. Bird, WS7R, SRB Enterprises, Wickenburg, AZ
    '
    ' This form is based upon the GW-BASIC program SQLINE.BAS in HamCalc.
    '
    ' Function and Subprograms in TRANSLIN.BAS used:
    '
    '   Function ValCheck (frm As Form, T As String, Box As Integer,
    '                     Units As String) As Integer
    '
    '   Sub CenterForm (frm As Form)
    '   Sub ClearForm (frm As Form)
    '   Sub ErrorMessage (frm As Form, ErrorType As Integer, Box As Integer)
    '   Sub ProgramTitle (frm As Form, Sp As Integer)

    Option Explicit                         ' force declaration of all variables

        ' --------------------------------
        ' label vertical spacing constants
        ' --------------------------------
    Const VertSp1 = 150
    Const VertSp2 = 30

    ' ----------------------------------------------------------
    ' This form contains the following Function and Subprograms:
    '
    '   Function:
    '       Function CheckInput () As Integer
    '
    '   Subprograms:
    '       Sub cmdAnother_Click ()
    '       Sub CmdAnotherPos ()
    '       Sub cmdClose_Click ()
    '       Sub cmdCompute_Click ()
    '       Sub cmdExit_Click ()
    '       Sub cmdOK_Click ()
    '       Sub cmdOpenMenu_Click ()
    '       Sub CmdOpenPos ()
    '       Sub cmdRetry_Click ()
    '       Sub ErrorGap ()
    '       Sub Form_Load ()
    '       Sub mnuExit_Click ()
    '       Sub mnuProgDir_Click ()
    '       Sub mnuRanges_Click ()
    '       Sub optImped_Click ()
    '       Sub optInches_Click ()
    '       Sub optMillimeters_Click ()
    '       Sub optSpacing_Click ()
    '       Sub ShowOutputPicture ()
    '       Sub Warning (Z As Single)
    ' ----------------------------------------------------------

    Private Function CheckInput() As Integer

        ' =====================================================================
        ' CHECK FOR REQUIRED INPUT AND VALIDATE ITS VALUES
        ' =====================================================================
        ' parent:  frmSqrLine
        ' =====================================================================
        ' called from Sub cmdCompute_Click ()
        '
        ' calls Function ValCheck (frm As Form, T As String, Box As Integer,
        '  Units As String) As Integer and
        '  Sub ErrorMessage (frm As Form, ErrorType As Integer, Box As Integer)
        '
        ' outputs 0 if all inputs valid, otherwise outputs 1
        ' =====================================================================

            ' -----------------------
            ' declare local variables
            ' -----------------------
        Dim InpText As String               ' c-to-c spacing or imped input
        Dim Units As String                 ' units of length
        Dim WidText As String               ' conductor width input

        Dim ErrorSp As Integer              ' c-to-c spacing error flag
        Dim ErrorWid As Integer             ' conductor width error flag
        Dim ErrorZ As Integer               ' impedance error flag

            ' -----------------------------------------
            ' check for required number of inputs (2) -
            '  if both given, then check for validity
            ' -----------------------------------------
        If txtInput.Text = "" And txtWidth.Text = "" Then
            txtInput.SetFocus
            CheckInput = 1
            Exit Function
        ElseIf txtInput.Text = "" And txtWidth.Text <> "" Then
            txtInput.SetFocus
            CheckInput = 1
            Exit Function
        ElseIf txtInput.Text <> "" And txtWidth.Text = "" Then
            txtWidth.SetFocus
            CheckInput = 1
            Exit Function
        ElseIf txtInput.Text <> "" And txtWidth.Text <> "" Then

            ' -----------------
            ' are inputs valid?
            ' -----------------
                ' ------------------
                ' input text strings
                ' ------------------
            InpText = txtInput.Text         ' impedance or c-to-c spacing
            WidText = txtWidth.Text         ' conductor width

                ' ------------------------------------------
                ' determine function and units to test input
                ' ------------------------------------------
            If optSpacing.Value = True Then
                    ' ---------------
                    ' impedance check
                    ' ---------------
                ErrorZ = ValCheck(frmSqrLine, InpText, 25, "")
                    If ErrorZ = 10 Then
                        ErrorMessage frmSqrLine, 10, 25
                        CheckInput = 1
                        Exit Function
                    ElseIf ErrorZ = 20 Then
                        ErrorMessage frmSqrLine, 20, 25
                        CheckInput = 1
                        Exit Function
                    End If
            End If

                    ' --------------------------------
                    ' conductor center-to-center check
                    ' --------------------------------
            If optImped.Value = True Then
                If optInches.Value = True Then
                    Units = "In"
                    ErrorSp = ValCheck(frmSqrLine, InpText, 25, Units)
                    If ErrorSp = 10 Then
                        ErrorMessage frmSqrLine, 10, 25
                        CheckInput = 1
                        Exit Function
                    ElseIf ErrorSp = 20 Then
                        ErrorMessage frmSqrLine, 20, 25
                        CheckInput = 1
                        Exit Function
                    End If
                ElseIf optMillimeters.Value = True Then
                    Units = "Mm"
                    ErrorSp = ValCheck(frmSqrLine, InpText, 25, Units)
                    If ErrorSp = 10 Then
                        ErrorMessage frmSqrLine, 10, 25
                        CheckInput = 1
                        Exit Function
                    ElseIf ErrorSp = 20 Then
                        ErrorMessage frmSqrLine, 20, 25
                        CheckInput = 1
                        Exit Function
                    End If
                End If
            End If

                    ' ---------------------
                    ' conductor width check
                    ' ---------------------
            If optInches.Value = True Then
                Units = "In"
                ErrorWid = ValCheck(frmSqrLine, WidText, 26, Units)
                If ErrorWid = 10 Then
                    ErrorMessage frmSqrLine, 10, 26
                    CheckInput = 1
                    Exit Function
                ElseIf ErrorWid = 20 Then
                    ErrorMessage frmSqrLine, 20, 26
                    CheckInput = 1
                    Exit Function
                End If
            ElseIf optMillimeters.Value = True Then
                Units = "Mm"
                ErrorWid = ValCheck(frmSqrLine, WidText, 26, Units)
                If ErrorWid = 10 Then
                    ErrorMessage frmSqrLine, 10, 26
                    CheckInput = 1
                    Exit Function
                ElseIf ErrorWid = 20 Then
                    ErrorMessage frmSqrLine, 20, 26
                    CheckInput = 1
                    Exit Function
                End If
            End If
        End If

            ' ----------------------------
            ' output all inputs valid flag
            ' ----------------------------
        CheckInput = 0

    End Function                                                ' CheckInput ()

    Private Sub cmdAnother_Click()

        ' ============================================
        ' SET UP SCREEN TO PERFORM ANOTHER CALCULATION
        ' ============================================
        ' parent:  frmSqrLine
        ' ============================================
        ' called from Sub cmdCompute_Click ()
        ' ============================================

        Form_Load

    End Sub                                             ' cmdAnother_Click ()

    Private Sub CmdAnotherPos()

        ' ===========================================
        ' POSITION COMMAND BUTTONS TO PERFORM ANOTHER
        '  CALCULATION AND HIDE UNUSED COMMAND BUTTON
        ' ===========================================
        ' parent:  frmSqrLine
        ' ===========================================
        ' called from Sub cmdCompute_Click ()
        ' ===========================================

            ' -----------------------
            ' declare local variables
            ' -----------------------
        Dim cmdW1 As Integer                            ' width of cmdOK
        Dim cmdW2 As Integer                            ' width of cmdOpenMenu
        Dim cmdW3 As Integer                            ' width of cmdAnother
        Dim cmdW4 As Integer                            ' width of cmdExit
        Dim SpAvail As Integer                          ' command button spacing

            ' ---------------------------------
            ' show and position command buttons
            '  cmdTop2 = 7635
            ' ---------------------------------
        cmdAnother.Visible = True
        cmdExit.Visible = True
        cmdOK.Visible = True
        cmdOpenMenu.Visible = True

        cmdW1 = cmdOK.Width
        cmdW2 = cmdOpenMenu.Width
        cmdW3 = cmdAnother.Width
        cmdW4 = cmdExit.Width

        SpAvail = (frmSqrLine.ScaleWidth - (cmdW1 + cmdW2 + cmdW3 + cmdW4)) \ 5

        cmdOK.Top = cmdTop2
        cmdOK.Left = SpAvail

        cmdOpenMenu.Top = cmdTop2
        cmdOpenMenu.Left = cmdW1 + (2 * SpAvail)

        cmdAnother.Top = cmdTop2
        cmdAnother.Left = cmdW1 + cmdW2 + (3 * SpAvail)

        cmdExit.Top = cmdTop2
        cmdExit.Left = cmdW1 + cmdW2 + cmdW3 + (4 * SpAvail)

        cmdAnother.SetFocus

            ' --------------------------
            ' hide unused command button
            ' --------------------------
        cmdCompute.Visible = False

    End Sub                                                 ' CmdAnotherPos ()

    Private Sub cmdClose_Click()

        ' ==================================
        ' CLOSE PROGRAM RANGES SCREEN
        ' ==================================
        ' parent:  frmSqrLine
        ' ==================================
        ' called from Sub mnuRanges_Click ()
        ' ==================================

            ' --------------
            ' hide picRanges
            ' --------------
        picRanges.Visible = False

            ' ------------------------------------
            ' enable command buttons and tab stops
            ' ------------------------------------

                ' ------------------
                ' data output screen
                ' ------------------
        If picOutput.Visible = True Then
            cmdOpenMenu.Enabled = True
            cmdAnother.Enabled = True
            cmdAnother.SetFocus

                ' -----------------------------
                ' select dimension units screen
                ' -----------------------------
        ElseIf txtInput.Text <> "" And txtWidth.Text <> "" Then
            fraFunction.Enabled = True
            txtInput.TabStop = False
            txtWidth.TabStop = False
            cmdOK.Enabled = True
            cmdOpenMenu.Enabled = True
            cmdCompute.Enabled = True
            cmdCompute.SetFocus
        ElseIf fraUnits.Enabled = True And txtInput.Text = "" Then
            optSpacing.Enabled = True
            optImped.Enabled = True
            txtInput.TabStop = True
            txtWidth.TabStop = True
            cmdOK.Enabled = True
            cmdCompute.Enabled = True
            cmdOpenMenu.Enabled = True
            If txtInput.Visible = True Then
                txtInput.SetFocus
            End If
        ElseIf fraUnits.Enabled = True And txtWidth.Text = "" Then
            optSpacing.Enabled = True
            optImped.Enabled = True
            txtInput.TabStop = False
            txtWidth.TabStop = True
            cmdOK.Enabled = True
            cmdCompute.Enabled = True
            cmdOpenMenu.Enabled = True
            txtWidth.SetFocus

                ' --------------
                ' opening screen
                ' --------------
        ElseIf fraUnits.Enabled = False Then
            optSpacing.Enabled = True
            optImped.Enabled = True
            optSpacing.TabStop = False
            optImped.TabStop = False
            cmdOK.Enabled = True
            cmdOpenMenu.Enabled = True
            cmdOK.SetFocus
        End If

    End Sub                                                 ' cmdClose_Click ()

    Private Sub cmdCompute_Click()

        ' ==================================================================
        ' COMPUTE OUTPUT BASED UPON DESIRED PARAMETERS
        ' ==================================================================
        ' parent:  frmSqrLine
        ' ==================================================================
        ' called from Sub optInches_Click () and Sub optMillimeters_Click ()
        '
        ' calls Function CheckInput () As Integer, Sub ErrorGap (),
        '  Sub Warning (Z As Single), Sub ShowOutputPicture (), and
        '  Sub CmdAnotherPos ()
        ' ==================================================================

            ' -----------------------
            ' declare local variables
            ' -----------------------
        Dim Check As Integer                ' input validity check
        Dim A As Single                     ' temporary variable
        Dim B As Single                     ' temporary variable
        Dim C As Single                     ' temporary variable
        Dim D As Single                     ' minimum center-to-center spacing
        Dim K As Single                     ' increment constant
        Dim S As Single                     ' center-to-center spacing
        Dim W As Single                     ' conductor width
        Dim Z As Single                     ' impedance

            ' -------------------------
            ' check inputs for validity
            ' -------------------------
        Check = CheckInput()

            ' -----------------
            ' if valid, proceed
            ' -----------------
        If Check = 0 Then

                ' --------------------------------------
                ' determine conductor spacing
                '  (impedance and conductor width given)
                ' --------------------------------------
            If optSpacing.Value = True Then
                Z = Val(txtInput.Text)
                A = 1
                B = Exp(Z / 120)
                K = 0.1
                If optInches.Value = True Then
                    W = Val(txtWidth.Text)
                ElseIf optMillimeters.Value = True Then
                    W = Val(txtWidth.Text) / 25.4
                End If
                Do
                    A = A + K
                    C = A + Sqr(A ^ 2 - 1)
                    If C > B Then
                        A = A - K
                        K = K / 10
                    End If
                Loop Until Abs(C - B) < 0.0001
                D = (1.18 * W)
                S = A * D

                    ' -------
                    ' outputs
                    ' -------
                lblCondWidIn.Caption = Format$(W, "0.0000") + " in)"
                lblCondWidMm.Caption = Format$(W * 25.4, "0.0000") + " mm"
                lblCCDistIn.Caption = Format$(S, "0.0000") + " in"
                lblCCDistMm.Caption = Format$(S * 25.4, "0.0000") + " mm"
                lblGapIn.Caption = Format$(S - W, "0.0000") + " in"
                lblGapMm.Caption = Format$((S - W) * 25.4, "0.0000") + " mm"
                lblImpedOut.Caption = Format$(Z, "#.0")

                ' ------------------------------------
                ' determine impedance
                '  (conductor spacing and width given)
                ' ------------------------------------
            ElseIf optImped.Value = True Then
                If optInches.Value = True Then
                    W = Val(txtWidth.Text)
                    S = Val(txtInput.Text)
                ElseIf optMillimeters.Value = True Then
                    W = Val(txtWidth.Text) / 25.4
                    S = Val(txtInput.Text) / 25.4
                End If
                    D = (1.18 * W)
                    A = S / D
                    If (A ^ 2) < 1 Then
                        ErrorGap
                        Exit Sub
                    Else
                        Z = 120 * Log(A + Sqr(A ^ 2 - 1))
                    End If

                        ' -------
                        ' outputs
                        ' -------
                    lblCondWidIn.Caption = Format$(W, "0.0000") + " in)"
                    lblCondWidMm.Caption = Format$(W * 25.4, "0.0000") + " mm"
                    lblCCDistIn.Caption = Format$(S, "0.0000") + " in"
                    lblCCDistMm.Caption = Format$(S * 25.4, "0.0000") + " mm"
                    lblGapIn.Caption = Format$(S - W, "0.0000") + " in"
                    lblGapMm.Caption = Format$((S - W) * 25.4, "0.0000") + " mm"
                    lblImpedOut.Caption = Format$(Z, "#.0")
            End If

            ' ------------------------------------
            ' display warning if Z < 70 or Z > 120
            ' ------------------------------------
        Warning Z

            ' --------------
            ' display output
            ' --------------
        ShowOutputPicture

            ' -----------------------
            ' disable input tab stops
            ' -----------------------
        txtInput.TabStop = False
        txtWidth.TabStop = False

            ' ----------------------------------------------
            ' set up command buttons for another calculation
            ' ----------------------------------------------
        CmdAnotherPos

            ' ------------------------------
            ' if any input invalid, exit sub
            ' ------------------------------
        Else
            Exit Sub
        End If

    End Sub                                             ' cmdCompute_Click ()

    Private Sub cmdExit_Click()

        ' ==================
        ' EXIT PROGRAM
        ' ==================
        ' parent: frmSqrLine
        ' ==================

        End                                                 ' exit program

    End Sub                                                 ' cmdExit_Click ()

    Private Sub cmdOK_Click()

        ' ====================================================
        ' RETURN TO MAIN MENU FOR OPEN WIRE TRANSMISSION LINES
        ' ====================================================
        ' parent:  frmSqrLine
        ' ====================================================
        ' called from Sub Form_Load ()
        ' ====================================================

        Unload frmSqrLine
        frmOpenWire.Show

    End Sub                                                     ' cmdOK_Click ()

    Private Sub cmdOpenMenu_Click()

        ' ==========================================
        ' SHOW PROGRAM OPENING SCREEN - TLINMENU.FRM
        ' ==========================================
        ' parent:  frmSqrLine
        ' ==========================================
        ' called from Sub Form_Load ()
        ' ==========================================

            ' ---------------------------------------------------
            ' show program opening menu screen and reset function
            ' ---------------------------------------------------
        Unload frmSqrLine
        frmTLineMenu.Show
        frmTLineMenu.optOpenWire.Value = False
        frmTLineMenu.cmdExit.SetFocus

    End Sub                                             ' cmdOpenMenu_Click ()

    Private Sub CmdOpenPos()

        ' ================================================
        ' POSITION COMMAND BUTTONS FOR FORM OPENING SCREEN
        '  AND HIDE UNUSED COMMAND BUTTONS
        ' ================================================
        ' parent:  frmSqrLine
        ' ================================================
        ' called from Sub Form_Load ()
        ' ================================================

            ' -----------------------
            ' declare local variables
            ' -----------------------
        Dim cmdW1 As Integer                            ' width of cmdOK
        Dim cmdW2 As Integer                            ' width of cmdOpenMenu
        Dim cmdW3 As Integer                            ' width of cmdCompute
        Dim cmdW4 As Integer                            ' width of cmdExit
        Dim SpAvail As Integer                          ' command button spacing

            ' ---------------------------------
            ' show and position command buttons
            '   cmdTop2 = 7635
            ' ---------------------------------
        cmdCompute.Visible = True
        cmdExit.Visible = True
        cmdOK.Visible = True
        cmdOpenMenu.Visible = True

        cmdW1 = cmdOK.Width
        cmdW2 = cmdOpenMenu.Width
        cmdW3 = cmdCompute.Width
        cmdW4 = cmdExit.Width
        SpAvail = (frmSqrLine.ScaleWidth - (cmdW1 + cmdW2 + cmdW3 + cmdW4)) \ 5

        cmdOK.Top = cmdTop2
        cmdOK.Left = SpAvail

        cmdOpenMenu.Top = cmdTop2
        cmdOpenMenu.Left = cmdW1 + (2 * SpAvail)

        cmdCompute.Top = cmdTop2
        cmdCompute.Left = cmdW1 + cmdW2 + (3 * SpAvail)

        cmdExit.Top = cmdTop2
        cmdExit.Left = cmdW1 + cmdW2 + cmdW3 + (4 * SpAvail)

    End Sub                                                     ' CmdOpenPos ()

    Private Sub cmdRetry_Click()
'==                                                                            |
        ' ====================================================
        ' CLEAR GAP ERROR MESSAGE AND SET UP FOR DATA RE-ENTRY
        ' ====================================================
        ' parent:  frmSqrLine
        ' ====================================================
        ' called from Sub ErrorGap ()
        ' ====================================================

            ' ----------------
            ' hide picGapError
            ' ----------------
        picGapError.Visible = False

            ' ------------
            ' clear inputs
            ' ------------
        txtInput.Text = ""
        txtWidth.Text = ""

            ' -----------------------
            ' enable information menu
            ' -----------------------
        mnuRanges.Enabled = True

            ' ------------------------------------
            ' enable command buttons and tab stops
            ' ------------------------------------
        cmdCompute.Enabled = True
        cmdOK.Enabled = True
        cmdOpenMenu.Enabled = True

        txtInput.TabStop = True
        txtWidth.TabStop = True

        txtInput.SetFocus

    End Sub                                                 ' cmdRetry_Click ()

    Private Sub ErrorGap()

        ' ==========================
        ' DISPLAY GAP ERROR MESSAGE
        ' ==========================
        ' parent:  frmSqrLine
        ' ==========================
        ' called from Sub Compute ()
        ' ==========================

            ' ------------------------
            ' disable information menu
            ' ------------------------
        mnuRanges.Enabled = False

            ' -----------------------
            ' declare local variables
            ' -----------------------
        Dim E1 As String                ' error message text
        Dim E2 As String
        Dim E3 As String

        Dim TxtBot As Integer           ' bottom of text box txtWidth
        Dim VSp As Integer              ' vertical space to locate picGapError

            ' -------------------------------------
            ' position picGapError and output label
            ' -------------------------------------
        TxtBot = txtWidth.Top + txtWidth.Height
        picGapError.Visible = True
        picGapError.Height = 1410
        VSp = (TxtBot + (cmdTop2 - picGapError.Height)) \ 2
        picGapError.Top = VSp
        picGapError.Width = 7380
        picGapError.Left = (frmSqrLine.ScaleWidth - picGapError.Width) \ 2

        lblGapError.BorderStyle = 0
        lblGapError.Top = 120
        lblGapError.Height = 555
        lblGapError.Width = picGapError.Width - 120
        lblGapError.Left = 60

        E1 = "The ratio of center-to-center spacing to conductor width must be "
        E2 = "equal to or greater than 1.18.  Please re-enter the values or "
        E3 = "exit the program."

        lblGapError.Caption = E1 + E2 + E3

            ' -----------------------
            ' position command button
            ' -----------------------
        cmdRetry.Top = lblGapError.Top + lblGapError.Height + 120
        cmdRetry.Left = (picGapError.Width - cmdRetry.Width) \ 2

            ' -------------------------------------------------
            ' disable tab stops and command buttons - set focus
            ' -------------------------------------------------
        cmdCompute.Enabled = False
        cmdOK.Enabled = False
        cmdOpenMenu.Enabled = False

        txtInput.TabStop = False
        txtWidth.TabStop = False

        cmdRetry.SetFocus

    End Sub                                                     ' ErrorGap ()

    Private Sub Form_Load()

        ' =================================================
        ' LOAD frmSqrLine AND SET OPENING SCREEN PARAMETERS
        ' =================================================
        ' calls Sub CenterForm (frm As Form),
        '  Sub ProgramTitle (frm As Form, Sp As Integer),
        '  and Sub CmdOpenPos ()
        ' =================================================

            ' -----------------------
            ' declare local variables
            ' -----------------------
        Dim Cap1 As String                              ' caption text
        Dim Cap2 As String

        Dim L1 As String                                ' text strings
        Dim L2 As String
        Dim L3 As String
        Dim L4 As String
        Dim L5 As String
        Dim L6 As String
        Dim L7 As String
        Dim L8 As String
        Dim L9 As String
        Dim L10 As String
        Dim L11 As String
        Dim L12 As String

        Dim FraHt As Integer                            ' height of frames
        Dim LblHt As Integer                            ' height of labels
        Dim LblLeft As Integer                          ' left side of labels
        Dim LblRight As Integer                         ' right side of labels
        Dim LblWid As Integer                           ' width of labels
        Dim TxtHt As Integer

            ' -------------------
            ' set form scale mode
            ' -------------------
        frmSqrLine.ScaleMode = TWIPS

            ' ----------------------------------------------
            ' set form to maximum size for 800 x 600 display
            ' ----------------------------------------------
        frmSqrLine.Height = 9000                        ' 600 x 15 twips/pixel
        frmSqrLine.Width = 12000                        ' 800 x 15 twips/pixel
            ' ScaleHeight = 8310 w/menu bar
            ' ScaleHeight = 8595 wo/menu bar

            ' -------------------
            ' define newline code
            ' -------------------
        N = Chr(13) + Chr(10)                           ' Chr(13) is enter
                                                        ' Chr(10) is line feed

            ' -----------------------
            ' space string (3 spaces)
            ' -----------------------
        S = Space(3)

            ' ---------------------
            ' center form on screen
            ' ---------------------
        CenterForm frmSqrLine

            ' --------------------------------
            ' display program title and credit
            ' --------------------------------
        ProgramTitle frmSqrLine, 83

            ' ---------------------------------------------------------
            ' disable command and option buttons until appropriate time
            ' ---------------------------------------------------------
        cmdCompute.Enabled = False
        fraUnits.Enabled = False
        optInches.Enabled = False
        optMillimeters.Enabled = False

            ' -----------------------------------------------
            ' disable picture box and option button tab stops
            ' -----------------------------------------------
        optImped.TabStop = False
        optInches.TabStop = False
        optMillimeters.TabStop = False
        optSpacing.TabStop = False

        picGapError.TabStop = False
        picOutput.TabStop = False
        picRanges.TabStop = False
        picWarning.TabStop = False

            ' --------------------
            ' reset option buttons
            ' --------------------
        optImped.Value = False
        optInches.Value = False
        optMillimeters.Value = False
        optSpacing.Value = False

            ' --------------------------
            ' hide controls until needed
            ' --------------------------
        cmdAnother.Visible = False
        
        lblInput.Visible = False
        lblWidth.Visible = False

        picGapError.Visible = False
        picOutput.Visible = False
        picRanges.Visible = False
        picWarning.Visible = False

        txtInput.Visible = False
        txtWidth.Visible = False

            ' ----------------------
            ' clear input text boxes
            ' ----------------------
        txtInput.Text = ""
        txtWidth.Text = ""

            ' -------------------------------------------------------------
            ' constants for frames, labels, text boxes, and output pictures
            ' -------------------------------------------------------------
            ' from form general declarations:
            '   VertSp1 = 150
            '   VertSp2 = 30
            ' -------------------------------------------------------------

        FraHt = 600

        LblHt = 270
        LblWid = 9450
        LblLeft = (frmSqrLine.ScaleWidth - LblWid) \ 2
        LblRight = LblLeft + LblWid

        TxtHt = 360

            ' ------------
            ' screen title
            ' ------------
        lblTitle.BorderStyle = 0
        lblTitle.Top = VertSp1
        lblTitle.AutoSize = True
        L1 = "IMPEDANCE and SPACING of PARALLEL TRANSMISSION "
        L2 = "LINE with SQUARE CONDUCTORS"
        lblTitle.Caption = L1 + L2
        lblTitle.Left = (frmSqrLine.ScaleWidth - lblTitle.Width) \ 2

            ' ------------
            ' opening note
            ' ------------
        lblNote1.BorderStyle = 0
        lblNote1.Top = lblTitle.Top + lblTitle.Height + VertSp1
        lblNote1.Height = 1005
        lblNote1.Width = LblWid
        lblNote1.Left = (frmSqrLine.ScaleWidth - LblWid) \ 2

        L3 = S + "Open-wire lines of less than 83.1 ohms impedance are not "
        L4 = "physically possible with round conductors because the space "
        L5 = "between the conductors would theoretically be zero or less. "
        L6 = "Impedances of less than 83.1 ohms or any other value are possible"
        L7 = " if the line is constructed using square conductors."
        lblNote1.Caption = L3 + L4 + L5 + L6 + L7

            ' ------------
            ' HAMCALC note
            ' ------------
        lblNote2.BorderStyle = 0
        lblNote2.Top = lblNote1.Top + lblNote1.Height + VertSp1
        lblNote2.Height = 750
        lblNote2.Width = LblWid
        lblNote2.Left = (frmSqrLine.ScaleWidth - LblWid) \ 2

        L8 = "This program is an excerpt from ""HAMCALC - Painless Math for "
        L9 = "Radio Amateurs"", free soft-" + N + "ware with over 250 programs"
        L10 = " on CD-ROM, available from VE3ERP for a modest charge to" + N
        L11 = "cover costs of materials and shipping.  For details, e-mail "
        L12 = "Murph at ve3erp@encode.com."
        lblNote2.Caption = L8 + L9 + L10 + L11 + L12

            ' -------------------------------
            ' function - spacing or impedance
            ' -------------------------------
        fraFunction.Top = lblNote2.Top + lblNote2.Height + VertSp2
        fraFunction.Height = FraHt
        fraFunction.Left = LblRight - fraFunction.Width

        lblFunction.BorderStyle = 0
        lblFunction.Height = LblHt
        lblFunction.Width = 6000
        lblFunction.Top = fraFunction.Top + 90 + (((FraHt - 90) - LblHt) \ 2)
        lblFunction.Left = LblLeft
        Cap1 = "Do you want to find conductor spacing or line impedance?"
        lblFunction.Caption = Cap1

            ' -----------------------------
            ' units - inches or millimeters
            ' -----------------------------
        fraUnits.Top = lblFunction.Top + lblFunction.Height + VertSp1
        fraUnits.Height = FraHt
        fraUnits.Left = LblRight - fraUnits.Width

        lblUnits.BorderStyle = 0
        lblUnits.Height = LblHt
        lblUnits.Width = 2880
        lblUnits.Top = fraUnits.Top + ((fraUnits.Height - lblUnits.Height) \ 2)
        lblUnits.Left = LblLeft
        lblUnits.Caption = "Select desired output units: "

            ' ---------------------------
            ' position inputs and outputs
            ' ---------------------------
        txtInput.Height = TxtHt
        txtInput.Top = fraUnits.Top + FraHt + VertSp1
        txtInput.Width = 900
        txtInput.Left = LblRight - txtInput.Width

        lblInput.BorderStyle = 0
        lblInput.Height = LblHt
        lblInput.Width = 5850
        lblInput.Top = txtInput.Top + ((TxtHt - LblHt) \ 2)
        lblInput.Left = LblLeft

        txtWidth.Height = TxtHt
        txtWidth.Top = txtInput.Top + TxtHt + VertSp1
        txtWidth.Width = 900
        txtWidth.Left = LblRight - txtWidth.Width

        lblWidth.BorderStyle = 0
        lblWidth.Height = LblHt
        lblWidth.Top = txtWidth.Top + ((TxtHt - LblHt) \ 2)
        lblWidth.Width = 6330
        lblWidth.Left = LblLeft

        picOutput.Top = txtWidth.Top + TxtHt + VertSp1
        picOutput.Height = (4 * LblHt + 3 * VertSp1) + 90
        picWarning.Top = picOutput.Top + picOutput.Height + VertSp1

            ' ---------------------------------------------------------
            ' show and position command buttons for form opening screen
            ' ---------------------------------------------------------
        CmdOpenPos

            ' -----------------
            ' set the tab order
            ' -----------------
        cmdOK.TabIndex = 0
        cmdOpenMenu.TabIndex = 1
        cmdExit.TabIndex = 2

    End Sub                                                     ' Form_Load ()

    Private Sub mnuExit_Click()

        ' ================================
        ' parent:  frmSqrLine
        ' ================================
        ' called from Sub mnuInfo_Click ()
        ' ================================

        End                                                 ' exit program

    End Sub                                                 ' mnuExit_Click ()

    Private Sub mnuProgDir_Click()

        ' ================================
        ' DISPLAY PROGRAM DIRECTORY
        ' ================================
        ' parent:  frmSqrLine
        ' ================================
        ' called from Sub mnuInfo_Click ()
        ' ================================

        frmProgDir.Show

    End Sub                                             ' mnuProgDir_Click ()

    Private Sub mnuRanges_Click()

        ' ================================
        ' DISPLAY PROGRAM LIMITS
        ' ================================
        ' parent:  frmSqrLine
        ' ================================
        ' called from Sub mnuInfo_Click ()
        ' ================================

            ' -----------------------
            ' declare local variables
            ' -----------------------
        Dim L1 As String                                ' message text strings
        Dim L2 As String
        Dim L3 As String
        Dim L4 As String
        Dim L5 As String
        Dim L6 As String
        Dim L7 As String
        Dim L8 As String
        Dim L9 As String
        Dim L10 As String
        Dim L11 As String
        Dim L12 As String
        Dim L13 As String
        Dim L14 As String
        Dim L15 As String
        Dim L16 As String
        Dim L17 As String
        Dim L18 As String
        Dim L19 As String
        Dim L20 As String
        Dim L21 As String
        Dim L22 As String
        Dim L23 As String
        Dim L24 As String
        Dim L25 As String

        Dim Cap1 As String                              ' caption text strings
        Dim Cap2 As String
        Dim Cap3 As String

        Dim Sp1 As String                               ' space string
        Dim Sp2 As String
        Dim Sp3 As String

            ' ------------------------------------------------
            ' display, size, and position picRanges and labels
            ' ------------------------------------------------
        picRanges.Visible = True
        picRanges.Top = lblNote2.Top + lblNote2.Height
        picRanges.Height = 5175
        picRanges.Width = 11770
        picRanges.Left = (frmSqrLine.ScaleWidth - picRanges.Width) \ 2

        lblLimTitle.BorderStyle = 0
        lblLimTitle.Top = 45
        lblLimTitle.AutoSize = True
        lblLimTitle.Left = (picRanges.Width - lblLimTitle.Width) \ 2
        lblLimTitle.Caption = "PRACTICAL PROGRAM LIMITS"

        lblLimits1.BorderStyle = 0
        lblLimits1.Height = 2220
        lblLimits1.Width = picRanges.Width - 600
        
        lblLimits1.Top = lblLimTitle.Top + lblLimTitle.Height + VertSp2 + 30
        lblLimits1.Left = (picRanges.Width - lblLimits1.Width) \ 2

        lblLimits2.BorderStyle = 0
        lblLimits2.Height = 1710 + 225 + 15
        lblLimits2.Width = picRanges.Width - 600
        lblLimits2.Top = lblLimits1.Top + lblLimits1.Height - 60
        lblLimits2.Left = (picRanges.Width - lblLimits1.Width) \ 2

            ' --------------------
            ' define space strings
            ' --------------------
        Sp1 = Space$(5)
        Sp2 = Space$(12)
        Sp3 = Space$(17)

            ' -------------------------
            ' message text - lblLimits1
            ' -------------------------
        L1 = "The design of custom, ""home-brew"" transmission lines is "
        L2 = "limited by several factors.  Probably the most important one is "
        L3 = """is it practical to build""?  Physical considerations such as "
        L4 = "weight and appearance enter into any design but the electrical "
        L5 = "and safety ones must not be forgotten.  Normally, voltage on a "
        L6 = "transmission line is not a major consideration unless operating "
        L7 = "high power or the standing wave ratio is high.  The inner "
        L8 = "conductor of coaxial cable is protected from accidental contact "
        L9 = "by the outer jacket but no such protection exists for an open "
        L10 = "line.  Contact with humans or other animals, as well as "
        L11 = "structures, must be protected "
        L12 = "against.  Also, the space between conductors becomes limiting "
        L13 = "when the breakdown voltage of air is considered, particularly "
        L14 = "in humid and/or snow and ice conditions.  The breakdown voltage "
        L15 = "decreases markedly under these conditions and the weight "
        L16 = "increases substantially under heavy ice or snow.  Finally,"

        Cap1 = L1 + L2 + L3 + L4 + L5 + L6 + L7 + L8 + L9 + L10 + L11 + L12
        Cap2 = L13 + L14 + L15 + L16
        lblLimits1.Caption = Cap1 + Cap2

            ' -------------------------
            ' message text - lblLimits2
            ' -------------------------

        L17 = "it must be understood that the impedance of open line "
        L18 = "can be influenced by the weather as the dielectric of air "
        L19 = "changes with humidity." + N + N + "With this said, I have built "
        L20 = "in the following limitations:" + N + Sp1 + "Impedance Range:"
        L21 = Sp2 + "10 to 800 ohms" + N + Sp1 + "Conductor width:" + Sp3
        L22 = "0.001 to 0.100 inches  (0.0254 to 2.54 millimeters)" + N + Sp1
        L23 = "Center-to-center spacing:  0.0012 to 46.36 inches  (0.030 to "
        L24 = "1178 millimeters)" + N + Sp2 + "(spacing increases in direct "
        L25 = "proportion to impedance and conductor width)"

        Cap3 = L17 + L18 + L19 + L20 + L21 + L22 + L23 + L24 + L25
        lblLimits2.Caption = Cap3

            ' -------------------------
            ' disable program functions
            ' -------------------------
        cmdCompute.Enabled = False
        cmdOK.Enabled = False
        cmdOpenMenu.Enabled = False

        optImped.TabStop = False
        optSpacing.TabStop = False
        
        txtInput.TabStop = False
        txtWidth.TabStop = False

            ' ----------------------------
            ' position exit command button
            ' ----------------------------
        cmdClose.Top = picRanges.Height - (cmdClose.Height + 105)
        cmdClose.Left = (picRanges.Width - cmdClose.Width) \ 2

            ' -------------
            ' set the focus
            ' -------------
        cmdClose.SetFocus

    End Sub                                                 ' mnuRanges_Click ()

    Private Sub optImped_Click()

        ' ================================================================
        ' SET UP SCREEN TO COMPUTE IMPEDANCE OF PARALLEL SQUARE CONDUCTORS
        ' ================================================================
        ' parent:  frmSqrLine
        ' ================================================================
        ' called from fraFunction
        ' displays cmdCompute caption
        ' ================================================================

            ' --------------------------
            ' enable unit option buttons
            ' --------------------------
        fraUnits.Enabled = True
        optInches.Enabled = True
        optMillimeters.Enabled = True

            ' -----------------
            ' disable tab stops
            ' -----------------
        optImped.TabStop = False
        optSpacing.TabStop = False

            ' -------------------------
            ' clear input and set focus
            ' -------------------------
        If txtInput.Visible = True And txtInput.Text = "" Then
            txtInput.SetFocus
        ElseIf txtInput.Visible = True And txtInput.Text <> "" Then
            txtInput.Text = ""
            txtInput.SetFocus
        Else
            cmdOK.SetFocus
        End If

            ' --------------------
            ' display input prompt
            ' --------------------
        lblInput.Caption = "ENTER:  Center-to-Center Spacing Between Conductors:"

            ' ------------------------------
            ' display command button caption
            ' ------------------------------
        cmdCompute.Caption = "&Compute Impedance"

    End Sub                                                 ' optImped_Click ()

    Private Sub optInches_Click()

        ' ===============================================
        ' ENABLE OPTION BUTTONS FOR FUNCTION CALCULATIONS
        ' ===============================================
        ' parent:  frmSqrLine
        ' ===============================================
        ' called from fraUnits
        ' ===============================================

            ' -----------------------
            ' declare local variables
            ' -----------------------
        Dim Cap1 As String                              ' label caption strings
        Dim Cap2 As String

            ' ---------------------
            ' display input prompts
            ' ---------------------
        lblInput.Visible = True
        txtInput.Visible = True

        lblWidth.Visible = True
        Cap1 = "ENTER:  Width of one side of square conductor "
        Cap2 = "(inches): "
        lblWidth.Caption = Cap1 + Cap2

        txtWidth.Visible = True

            ' ------------------------------------------
            ' disable/enable tab stops and set tab index
            ' ------------------------------------------
        optInches.TabStop = False
        txtInput.TabStop = True
        txtWidth.TabStop = True

        txtInput.TabIndex = 0
        txtWidth.TabIndex = 1
        cmdCompute.TabIndex = 2
        cmdOK.TabIndex = 3
        cmdOpenMenu.TabIndex = 4
        cmdExit.TabIndex = 5

            ' -------------------------
            ' clear input and set focus
            ' -------------------------
        If txtInput.Text = "" Then
            txtInput.SetFocus
        ElseIf txtInput.Text <> "" Then
            txtWidth.Text = ""
            txtWidth.SetFocus
        End If

            ' -----------------
            ' enable cmdCompute
            ' -----------------
        cmdCompute.Enabled = True

    End Sub                                                 ' optInches_Click ()

    Private Sub optMillimeters_Click()

        ' ===============================================
        ' ENABLE OPTION BUTTONS FOR FUNCTION CALCULATIONS
        ' ===============================================
        ' parent:  frmSqrLine
        ' ===============================================
        ' called from fraUnits
        ' ===============================================

            ' -------------------------
            ' dimension local variables
            ' -------------------------
        Dim Cap1 As String                              ' label caption strings
        Dim Cap2 As String

            ' --------------------
            ' display input prompt
            ' --------------------
        lblInput.Visible = True
        txtInput.Visible = True

        lblWidth.Visible = True
        Cap1 = "ENTER:  Width of one side of square conductor "
        Cap2 = "(millimeters): "
        lblWidth.Caption = Cap1 + Cap2

        txtWidth.Visible = True

            ' ------------------------------------------
            ' disable/enable tab stops and set tab index
            ' ------------------------------------------
        optMillimeters.TabStop = False
        txtInput.TabStop = True
        txtWidth.TabStop = True

        txtInput.TabIndex = 0
        txtWidth.TabIndex = 1
        cmdCompute.TabIndex = 2
        cmdOK.TabIndex = 3
        cmdOpenMenu.TabIndex = 4
        cmdExit.TabIndex = 5

            ' -------------------------
            ' clear input and set focus
            ' -------------------------
        If txtInput.Text = "" Then
            txtInput.SetFocus
        ElseIf txtInput.Text <> "" Then
            txtWidth.Text = ""
            txtWidth.SetFocus
        End If

            ' -----------------
            ' enable cmdCompute
            ' -----------------
        cmdCompute.Enabled = True

    End Sub                                         ' optMillimeters_Click ()

    Private Sub optSpacing_Click()

        ' ==============================================================
        ' SET UP SCREEN TO COMPUTE SPACING OF PARALLEL SQUARE CONDUCTORS
        ' ==============================================================
        ' parent:  frmSqrLine
        ' ==============================================================
        ' called from fraFunction
        ' displays cmdCompute caption
        ' ==============================================================

            ' --------------------------
            ' enable unit option buttons
            ' --------------------------
        fraUnits.Enabled = True
        optInches.Enabled = True
        optMillimeters.Enabled = True

            ' -----------------
            ' disable tab stops
            ' -----------------
        optImped.TabStop = False
        optSpacing.TabStop = False

            ' -------------------------
            ' clear input and set focus
            ' -------------------------
        If txtInput.Visible = True And txtInput.Text = "" Then
            txtInput.SetFocus
        ElseIf txtInput.Visible = True And txtInput.Text <> "" Then
            txtInput.Text = ""
            txtInput.SetFocus
        Else
            cmdOK.SetFocus
        End If

            ' --------------------
            ' display input prompt
            ' --------------------
        lblInput.Caption = "ENTER:  Impedance of line (ohms):"

            ' ------------------------------
            ' display command button caption
            ' ------------------------------
        cmdCompute.Caption = "&Compute Spacing"

    End Sub                                             ' optSpacing_Click ()

    Private Sub ShowOutputPicture()

        ' =========================================
        ' DISPLAY AND POSITION picOUTPUT AND LABELS
        ' =========================================
        ' parent:  frmSqrLine
        ' =========================================
        ' called from Sub cmdCompute_Click ()
        ' =========================================

            ' -----------------------
            ' declare local variables
            ' -----------------------
        Dim HorizOff As Integer
        Dim HorizSp As Integer

            ' -----------------------------------
            ' size and position picOutput
            '  top and height in Sub Form_Load ()
            ' -----------------------------------
        picOutput.Visible = True
        picOutput.Width = 9000
        picOutput.Left = (frmSqrLine.ScaleWidth - picOutput.Width) \ 2

            ' -------------------------------
            ' size and position output labels
            ' -------------------------------
        HorizOff = 90           ' horizontal offset of right output labels
        HorizSp = 300           ' horizontal spacing between labels

            ' -------------------------
            ' width of square conductor
            ' -------------------------
        lblCondWid.BorderStyle = 0
        lblCondWid.Height = 270
        lblCondWid.Width = 4095
        lblCondWid.Top = 30
        lblCondWid.Left = 0
        lblCondWid.Caption = " Width of one side of square conductor:"

        lblCondWidMm.BorderStyle = 0
        lblCondWidMm.Height = 270
        lblCondWidMm.Width = 1395
        lblCondWidMm.Top = lblCondWid.Top
        lblCondWidMm.Left = picOutput.Width - (lblCondWidMm.Width + HorizOff)
            'lblCondWidMm.Caption in Sub cmdCompute_Click ()

        lblCondWidIn.BorderStyle = 0
        lblCondWidIn.Height = 270
        lblCondWidIn.Width = 1395
        lblCondWidIn.Top = lblCondWid.Top
        lblCondWidIn.Left = lblCondWidMm.Left - (lblCondWidIn.Width + HorizSp)
            'lblCondWidIn.Caption in Sub cmdCompute_Click ()

            ' ----------------------
            ' gap between conductors
            ' ----------------------
        lblGap.BorderStyle = 0
        lblGap.Height = 270
        lblGap.Width = 2730
        lblGap.Top = lblCondWid.Top + lblCondWid.Height + VertSp1
        lblGap.Left = 0
        lblGap.Caption = " Gap between conductors:"

        lblGapMm.BorderStyle = 0
        lblGapMm.Height = 270
        lblGapMm.Width = 1395
        lblGapMm.Top = lblGap.Top
        lblGapMm.Left = picOutput.Width - (lblGapMm.Width + HorizOff)
            'lblGapMm.Caption in Sub cmdCompute_Click ()

        lblGapIn.BorderStyle = 0
        lblGapIn.Height = 270
        lblGapIn.Width = 1395
        lblGapIn.Top = lblGap.Top
        lblGapIn.Left = lblGapMm.Left - (lblGapMm.Width + HorizSp)
            'lblGapIn.Caption in Sub cmdCompute_Click ()

            ' ----------------------------------
            ' conductor center-to-center spacing
            ' ----------------------------------
        lblCCDist.BorderStyle = 0
        lblCCDist.Height = 270
        lblCCDist.Width = 3810
        lblCCDist.Top = lblGap.Top + lblGap.Height + VertSp1
        lblCCDist.Left = 0
        lblCCDist.Caption = " Conductor center-to-center spacing:"

        lblCCDistMm.BorderStyle = 0
        lblCCDistMm.Height = 270
        lblCCDistMm.Width = 1395
        lblCCDistMm.Top = lblCCDist.Top
        lblCCDistMm.Left = picOutput.Width - (lblCCDistMm.Width + HorizOff)
            'lblCCDistMm.Caption in Sub cmdCompute_Click ()

        lblCCDistIn.BorderStyle = 0
        lblCCDistIn.Height = 270
        lblCCDistIn.Width = 1395
        lblCCDistIn.Top = lblCCDist.Top
        lblCCDistIn.Left = lblCCDistMm.Left - (lblCCDistIn.Width + HorizSp)
            'lblCCDistIn.Caption in Sub cmdCompute_Click ()

            ' --------------
            ' line impedance
            ' --------------
        lblImped.BorderStyle = 0
        lblImped.Height = 270
        lblImped.Width = 4260
        lblImped.Top = lblCCDist.Top + lblCCDist.Height + VertSp1
        lblImped.Left = 0
        lblImped.Caption = " Characteristic impedance of line (ohms):"

        lblImpedOut.BorderStyle = 0
        lblImpedOut.Height = 270
        lblImpedOut.Width = 1395
        lblImpedOut.Top = lblImped.Top
        lblImpedOut.Left = picOutput.Width - (lblImpedOut.Width + HorizOff)
            'lblImpedOut.Caption in Sub cmdCompute_Click ()

    End Sub                                             ' ShowOutputPicture ()

    Private Sub Warning(Z As Single)

        ' ===================================
        ' IMPEDANCE WARNING MESSAGE
        ' ===================================
        ' parent:  frmSqrLine
        ' ===================================
        ' called from Sub cmdCompute_Click ()
        ' ===================================

            ' -----------------------
            ' declare local variables
            ' -----------------------
        Dim Msg1 As String                              ' message text strings
        Dim Msg2 As String
        Dim Msg3 As String

            ' -------------------------------------------------
            ' display and position picWarning and warning label
            ' -------------------------------------------------
            ' from Form_Load:
            '   LblLeft = 1215
            '   LblRight = 10665
            '   fraFunction.Top = 4665
            '   fraFunction.Height = 600
            '   VertSp = 300
            ' --------------------------
        If Z >= 70 And Z <= 120 Then
            picWarning.Visible = False
        Else
            picWarning.Visible = True
            picWarning.Height = 705

                ' -------------
                ' warning label
                ' -------------
            lblWarning.BorderStyle = 0
            lblWarning.Top = 15
            lblWarning.Left = 15
            lblWarning.Height = picWarning.Height - 60

            Msg1 = S + "Calculations of impedances "
            If Z < 70 Then
                picWarning.Width = 6615
                Msg2 = "less than 70 ohms may" + N
            ElseIf Z > 120 Then
                picWarning.Width = 6615 + 300
                Msg2 = "more than 120 ohms may" + N
            End If
            Msg3 = S + "be unreliable and should be empirically tested."

            lblWarning.Caption = Msg1 + Msg2 + Msg3

            lblWarning.Width = picWarning.Width - 60
            picWarning.Left = (frmSqrLine.ScaleWidth - picWarning.Width) \ 2
        End If

    End Sub                                             ' Warning (Z As Integer)

