VERSION 5.00
Begin VB.Form frmCoaxDiel 
   Appearance      =   0  'Flat
   BackColor       =   &H00FFEBC8&
   ClientHeight    =   7185
   ClientLeft      =   4875
   ClientTop       =   2220
   ClientWidth     =   7365
   BeginProperty Font 
      Name            =   "MS Sans Serif"
      Size            =   8.25
      Charset         =   0
      Weight          =   700
      Underline       =   0   'False
      Italic          =   0   'False
      Strikethrough   =   0   'False
   EndProperty
   ForeColor       =   &H80000008&
   Icon            =   "COAXDIEL.frx":0000
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   PaletteMode     =   1  'UseZOrder
   ScaleHeight     =   7185
   ScaleWidth      =   7365
   Begin VB.PictureBox picRanges 
      Appearance      =   0  'Flat
      BackColor       =   &H00C0FFC0&
      ForeColor       =   &H80000008&
      Height          =   1215
      Left            =   3840
      ScaleHeight     =   1185
      ScaleWidth      =   2625
      TabIndex        =   24
      Top             =   1920
      Width           =   2655
      Begin VB.CommandButton cmdClose 
         Appearance      =   0  'Flat
         Caption         =   "&Close"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   9.75
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   495
         Left            =   0
         TabIndex        =   25
         Top             =   600
         Width           =   1215
      End
      Begin VB.Label lblRanges2 
         Appearance      =   0  'Flat
         BackColor       =   &H80000005&
         BackStyle       =   0  'Transparent
         BorderStyle     =   1  'Fixed Single
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   9.75
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         ForeColor       =   &H80000008&
         Height          =   495
         Left            =   1320
         TabIndex        =   27
         Top             =   600
         Width           =   1215
      End
      Begin VB.Label lblRanges1 
         Appearance      =   0  'Flat
         BackColor       =   &H80000005&
         BackStyle       =   0  'Transparent
         BorderStyle     =   1  'Fixed Single
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   9.75
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         ForeColor       =   &H80000008&
         Height          =   495
         Left            =   1320
         TabIndex        =   28
         Top             =   0
         Width           =   1215
      End
      Begin VB.Label lblRangeTitle 
         Alignment       =   2  'Center
         Appearance      =   0  'Flat
         BackColor       =   &H80000005&
         BackStyle       =   0  'Transparent
         BorderStyle     =   1  'Fixed Single
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   9.75
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         ForeColor       =   &H80000008&
         Height          =   495
         Left            =   0
         TabIndex        =   26
         Top             =   0
         Width           =   1215
      End
   End
   Begin VB.CommandButton cmdOpenMenu 
      Appearance      =   0  'Flat
      Caption         =   "Opening &Menu"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   495
      Left            =   4680
      TabIndex        =   23
      Top             =   6600
      Width           =   2430
   End
   Begin VB.CommandButton cmdAnother 
      Appearance      =   0  'Flat
      Caption         =   "&Compute Another"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   495
      Left            =   2160
      TabIndex        =   22
      Top             =   6600
      Width           =   2430
   End
   Begin VB.CommandButton cmdContinue 
      Appearance      =   0  'Flat
      Caption         =   "&Continue"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   495
      Left            =   480
      TabIndex        =   21
      Top             =   6600
      Width           =   1605
   End
   Begin VB.TextBox txtPubCapac 
      Alignment       =   2  'Center
      Appearance      =   0  'Flat
      BackColor       =   &H00D0FFFF&
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   495
      Left            =   2400
      TabIndex        =   18
      Top             =   2520
      Width           =   1215
   End
   Begin VB.TextBox txtPubZo 
      Alignment       =   2  'Center
      Appearance      =   0  'Flat
      BackColor       =   &H00D0FFFF&
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   495
      Left            =   2400
      TabIndex        =   17
      Top             =   1920
      Width           =   1215
   End
   Begin VB.CommandButton cmdCompute 
      Appearance      =   0  'Flat
      Caption         =   "&Compute"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   495
      Left            =   2880
      TabIndex        =   12
      Top             =   5880
      Width           =   1605
   End
   Begin VB.CommandButton cmdExit 
      Appearance      =   0  'Flat
      Caption         =   "&Exit Program"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   495
      Left            =   4680
      TabIndex        =   10
      Top             =   5880
      Width           =   1605
   End
   Begin VB.CommandButton cmdOK 
      Appearance      =   0  'Flat
      Caption         =   "&OK"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   495
      Left            =   1080
      TabIndex        =   9
      Top             =   5880
      Width           =   1605
   End
   Begin VB.PictureBox picDielectric 
      Appearance      =   0  'Flat
      BackColor       =   &H00D0FFFF&
      ForeColor       =   &H80000008&
      Height          =   855
      Left            =   960
      ScaleHeight     =   825
      ScaleWidth      =   5505
      TabIndex        =   1
      Top             =   840
      Width           =   5535
      Begin VB.Label lblDiscussion 
         Appearance      =   0  'Flat
         BackColor       =   &H80000005&
         BackStyle       =   0  'Transparent
         BorderStyle     =   1  'Fixed Single
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   9.75
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         ForeColor       =   &H80000008&
         Height          =   270
         Left            =   0
         TabIndex        =   11
         Top             =   510
         Width           =   1215
      End
      Begin VB.Line linDivider 
         BorderWidth     =   4
         X1              =   0
         X2              =   1200
         Y1              =   420
         Y2              =   420
      End
      Begin VB.Label lblVelFact 
         Alignment       =   2  'Center
         Appearance      =   0  'Flat
         BackColor       =   &H80000005&
         BackStyle       =   0  'Transparent
         BorderStyle     =   1  'Fixed Single
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   9.75
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         ForeColor       =   &H80000008&
         Height          =   270
         Left            =   3960
         TabIndex        =   2
         Top             =   300
         Width           =   1215
      End
      Begin VB.Label lblVFCol 
         Alignment       =   2  'Center
         Appearance      =   0  'Flat
         BackColor       =   &H80000005&
         BackStyle       =   0  'Transparent
         BorderStyle     =   1  'Fixed Single
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   9.75
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         ForeColor       =   &H80000008&
         Height          =   270
         Left            =   3960
         TabIndex        =   4
         Top             =   0
         Width           =   1215
      End
      Begin VB.Label lblDielCons 
         Alignment       =   2  'Center
         Appearance      =   0  'Flat
         BackColor       =   &H80000005&
         BackStyle       =   0  'Transparent
         BorderStyle     =   1  'Fixed Single
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   9.75
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         ForeColor       =   &H80000008&
         Height          =   270
         Left            =   2640
         TabIndex        =   6
         Top             =   300
         Width           =   1215
      End
      Begin VB.Label lblDielCol 
         Alignment       =   2  'Center
         Appearance      =   0  'Flat
         BackColor       =   &H80000005&
         BackStyle       =   0  'Transparent
         BorderStyle     =   1  'Fixed Single
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   9.75
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         ForeColor       =   &H80000008&
         Height          =   270
         Left            =   2640
         TabIndex        =   8
         Top             =   0
         Width           =   1215
      End
      Begin VB.Label lblMatCol 
         Alignment       =   2  'Center
         Appearance      =   0  'Flat
         BackColor       =   &H80000005&
         BackStyle       =   0  'Transparent
         BorderStyle     =   1  'Fixed Single
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   9.75
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         ForeColor       =   &H80000008&
         Height          =   270
         Left            =   1320
         TabIndex        =   7
         Top             =   0
         Width           =   1215
      End
      Begin VB.Label lblMaterial 
         Appearance      =   0  'Flat
         BackColor       =   &H80000005&
         BackStyle       =   0  'Transparent
         BorderStyle     =   1  'Fixed Single
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   9.75
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         ForeColor       =   &H80000008&
         Height          =   270
         Left            =   1320
         TabIndex        =   5
         Top             =   300
         Width           =   1215
      End
      Begin VB.Label lblExplanation 
         Appearance      =   0  'Flat
         BackColor       =   &H80000005&
         BackStyle       =   0  'Transparent
         BorderStyle     =   1  'Fixed Single
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   9.75
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         ForeColor       =   &H80000008&
         Height          =   270
         Left            =   0
         TabIndex        =   3
         Top             =   0
         Width           =   1215
      End
   End
   Begin VB.Label lblCalcVFOut 
      Alignment       =   2  'Center
      Appearance      =   0  'Flat
      BackColor       =   &H00D0FFFF&
      BorderStyle     =   1  'Fixed Single
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H80000008&
      Height          =   495
      Left            =   2400
      TabIndex        =   20
      Top             =   3720
      Width           =   1215
   End
   Begin VB.Label lblCalcDielOut 
      Alignment       =   2  'Center
      Appearance      =   0  'Flat
      BackColor       =   &H00D0FFFF&
      BorderStyle     =   1  'Fixed Single
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H80000008&
      Height          =   495
      Left            =   2400
      TabIndex        =   19
      Top             =   3120
      Width           =   1215
   End
   Begin VB.Label lblCalcVF 
      Appearance      =   0  'Flat
      BackColor       =   &H80000005&
      BackStyle       =   0  'Transparent
      BorderStyle     =   1  'Fixed Single
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H80000008&
      Height          =   495
      Left            =   960
      TabIndex        =   16
      Top             =   3720
      Width           =   1215
   End
   Begin VB.Label lblCalcDiel 
      Appearance      =   0  'Flat
      BackColor       =   &H80000005&
      BackStyle       =   0  'Transparent
      BorderStyle     =   1  'Fixed Single
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H80000008&
      Height          =   495
      Left            =   960
      TabIndex        =   15
      Top             =   3120
      Width           =   1215
   End
   Begin VB.Label lblPubCapac 
      Appearance      =   0  'Flat
      BackColor       =   &H80000005&
      BackStyle       =   0  'Transparent
      BorderStyle     =   1  'Fixed Single
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H80000008&
      Height          =   495
      Left            =   960
      TabIndex        =   14
      Top             =   2520
      Width           =   1215
   End
   Begin VB.Label lblPubZo 
      Appearance      =   0  'Flat
      BackColor       =   &H80000005&
      BackStyle       =   0  'Transparent
      BorderStyle     =   1  'Fixed Single
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H80000008&
      Height          =   495
      Left            =   960
      TabIndex        =   13
      Top             =   1920
      Width           =   1215
   End
   Begin VB.Label lblTitle 
      Alignment       =   2  'Center
      Appearance      =   0  'Flat
      BackColor       =   &H80000005&
      BackStyle       =   0  'Transparent
      BorderStyle     =   1  'Fixed Single
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   12
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H80000008&
      Height          =   300
      Left            =   960
      TabIndex        =   0
      Top             =   120
      Width           =   5535
   End
   Begin VB.Menu mnuInfo 
      Caption         =   "&Information"
      Begin VB.Menu mnuRanges 
         Caption         =   "&Ranges"
      End
      Begin VB.Menu mnuProgDir 
         Caption         =   "&Program Directory"
      End
      Begin VB.Menu NULL 
         Caption         =   "-"
      End
      Begin VB.Menu mnuExit 
         Caption         =   "&Exit"
      End
   End
End
Attribute VB_Name = "frmCoaxDiel"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
    ' COAXDIEL.FRM
    '
    ' Version 1.0 Started:  December 1, 2003
    ' Version 1.0 Completed:  April 15, 2004
    '
    ' Used in program TRANSLIN.EXE
    '
    ' Language:  Microsoft Visual Basic 3.0, Professional Edition
    '            (Professional Edition features not used)
    '
    ' Programmer:  Stephen R. Bird, WS7R, SRB Enterprises, Wickenburg, AZ
    '
    ' Function and Subprograms in TRANSLIN.BAS used:
    '
    '   Function ValCheck (frm As Form, T As String, Box As Integer,
    '                     Units As String) As Integer
    '
    '   Sub CenterForm (frm As Form)
    '   Sub ErrorMessage (frm As Form, ErrorType As Integer, Box As Integer)
    '   Sub ProgramTitle (frm As Form, Sp As Integer)

    Option Explicit                         ' force declaration of all variables

    ' ---------------------------------------------
    ' this form includes the following Subprograms:
    '
    '   Sub cmdAnother_Click ()
    '   Sub cmdClose_Click ()
    '   Sub cmdCompute_Click ()
    '   Sub cmdContinue_Click ()
    '   Sub cmdExit_Click ()
    '   Sub cmdOK_Click ()
    '   Sub cmdOpenMenu_Click ()
    '   Sub Form_Load ()
    '   Sub mnuExit_Click ()
    '   Sub mnuProgDir_Click ()
    '   Sub mnuRanges_Click ()
    '   Sub ShowDielTable ()
    ' ---------------------------------------------

    Private Sub cmdAnother_Click()

        ' =======================================================
        ' COMPUTE ANOTHER DIELECTRIC CONSTANT AND VELOCITY FACTOR
        ' =======================================================
        ' parent:  frmCoaxDiel
        ' =======================================================
        ' called from Sub cmdCompute_Click ()
        '
        ' calls Sub Form_Load ()
        ' =======================================================

            ' ----------------
            ' re-load the form
            ' ----------------
        Form_Load

            ' -------------
            ' show controls
            ' -------------
        lblPubZo.Visible = True
        lblPubCapac.Visible = True
        txtPubZo.Visible = True
        txtPubCapac.Visible = True

            ' ----------------------------------------
            ' clear input text boxes and output labels
            ' ----------------------------------------
        txtPubZo.Text = ""
        txtPubCapac.Text = ""
        lblCalcDielOut.Caption = ""
        lblCalcVFOut.Caption = ""

            ' --------------------------------
            ' enable tab stops and ranges menu
            ' --------------------------------
        cmdCompute.TabStop = True
        mnuRanges.Enabled = True
        txtPubZo.TabStop = True
        txtPubCapac.TabStop = True

            ' ------------------------
            ' position command buttons
            ' ------------------------
        CmdAnotherPos

            ' ---------------
            ' reset the focus
            ' ---------------
        txtPubZo.SetFocus

    End Sub                                             ' cmdAnother_Click ()

    Private Sub CmdAnotherPos()

        ' =======================================================
        ' POSITION COMMAND BUTTONS TO PERFORM ANOTHER CALCULATION
        ' =======================================================
        ' parent:  frmCoaxDiel
        ' =======================================================
        ' called from Sub cmdAnother_Click ()
        ' =======================================================

            ' -----------------------
            ' declare local variables
            ' -----------------------
        Dim cmdW1 As Integer                            ' width of cmdOK
        Dim cmdW2 As Integer                            ' width of cmdCompute
        Dim cmdW3 As Integer                            ' width of cmdExit
        Dim SpAvail As Integer                          ' command button spacing

            ' ---------------------------
            ' hide unused command buttons
            ' ---------------------------
        cmdAnother.Visible = False
        cmdContinue.Visible = False
        cmdOpenMenu.Visible = False

            ' ---------------------------------
            ' show and position command buttons
            '  cmdTop2 = 7635
            ' ---------------------------------
        cmdOK.Visible = True
        cmdCompute.Visible = True

        cmdW1 = cmdOK.Width
        cmdW2 = cmdCompute.Width
        cmdW3 = cmdExit.Width
        SpAvail = (frmCoaxChar.ScaleWidth - (cmdW1 + cmdW2 + cmdW3)) \ 4

        cmdOK.Top = cmdTop2
        cmdOK.Left = SpAvail

        cmdCompute.Top = cmdTop2
        cmdCompute.Left = cmdW1 + (2 * SpAvail)

        cmdExit.Top = cmdTop2
        cmdExit.Left = cmdW1 + cmdW2 + (3 * SpAvail)

    End Sub                                                 ' CmdAnotherPos ()

    Private Sub cmdClose_Click()

        ' ==================================
        ' CLOSE THE VALUE RANGE TABLE
        ' ==================================
        ' parent:  frmCoaxDiel
        ' ==================================
        ' called from Sub mnuRanges_Click ()
        ' ==================================

            ' --------------
            ' hide picRanges
            ' --------------
        picRanges.Visible = False

            ' ------------------------------------
            ' enable command buttons and info menu
            ' ------------------------------------
        cmdAnother.Enabled = True
        cmdCompute.Enabled = True
        cmdOK.Enabled = True
        mnuInfo.Enabled = True

            ' -------------
            ' set the focus
            ' -------------
        If cmdAnother.Visible = True Then
            cmdAnother.SetFocus
        ElseIf cmdAnother.Visible = False Then
            txtPubZo.SetFocus
        End If

    End Sub                                                 ' cmdClose_Click ()

    Private Sub cmdCompute_Click()

        ' =====================================================================
        ' COMPUTE THE DIELECTRIC CONSTANT AND VELOCITY FACTOR GIVEN IMPEDANCE
        '  (Zo) AND CAPACITANCE (pF/ft.)
        ' =====================================================================
        ' parent:  frmCoaxDiel
        ' =====================================================================
        ' called from Sub cmdContinue_Click ()
        '
        ' calls Function ValCheck (frm As Form, T As String, Box As Integer,
        '  Units As String) As Integer, and
        '  Sub ErrorMessage (frm As Form, ErrorType As Integer, Box As Integer)
        ' =====================================================================

            ' -----------------------
            ' declare local variables
            ' -----------------------
        Dim Msg1 As String                  ' message box text strings
        Dim Msg2 As String
        Dim Msg3 As String
        Dim EMsg As String
        Dim Title As String
        Dim NA As String                    ' value units N/A

        Dim cmdW1 As Integer                ' width of cmdAnother
        Dim cmdW2 As Integer                ' width of cmdExit
        Dim cmdSp As Integer                ' command button spacing
        Dim ErrorCapac As Integer           ' error flags
        Dim ErrorImped As Integer
        Dim Response As Integer             ' message box response

        Dim CapIn As Single                 ' input capacitance, Pf/ft.
        Dim E As Single                     ' calculated dielectric constant
        Dim VF As Single                    ' calculated velocity factor
        Dim ZoIn As Single                  ' input impedance, ohms
        Dim Temp1 As Single                 ' temporary variable - HamCalc EC
        Dim Temp2 As Single                 ' temporary variable - HamCalc N
        Dim Temp3 As Single                 ' temporary variable - HamCalc EZ

            ' ----------------------------------------------------------
            ' check if all required input given and calculate quantities
            ' ----------------------------------------------------------
        If txtPubZo.Text = "" And txtPubCapac.Text = "" Then
            txtPubZo.SetFocus                           ' set to missing data
            Exit Sub
        ElseIf txtPubZo.Text = "" And txtPubCapac.Text <> "" Then
            txtPubZo.SetFocus
            Exit Sub
        ElseIf txtPubZo.Text <> "" And txtPubCapac.Text = "" Then
            txtPubCapac.SetFocus
            Exit Sub
        ElseIf txtPubZo.Text <> "" And txtPubCapac.Text <> "" Then

                ' ---------------------------
                ' test impedance input
                '  range: > 0 and <= 125 ohms
                ' ---------------------------
            ErrorImped = ValCheck(frmCoaxDiel, (txtPubZo.Text), 1, NA)
            If ErrorImped = 10 Then
                ErrorMessage frmCoaxDiel, 10, 1
                Exit Sub
            ElseIf ErrorImped = 20 Then
                ErrorMessage frmCoaxDiel, 20, 1
                Exit Sub
            ElseIf ErrorImped = 0 Then
                ZoIn = Val(txtPubZo.Text)
            End If                                  ' end test impedance input

                ' -----------------------------
                ' test capacitance input
                '  range: >= 6 and <= 35 pF/ft.
                ' -----------------------------
            ErrorCapac = ValCheck(frmCoaxDiel, (txtPubCapac.Text), 2, NA)
            If ErrorCapac = 10 Then
                ErrorMessage frmCoaxDiel, 10, 2
                Exit Sub
            ElseIf ErrorCapac = 20 Then
                ErrorMessage frmCoaxDiel, 20, 2
                Exit Sub
            ElseIf ErrorCapac = 0 Then
                CapIn = Val(txtPubCapac.Text)
            End If                                  ' end test capacitance input

                ' ------------------------------------
                ' iteration loop to calculate e and VF
                ' ------------------------------------
            Temp1 = 0.1                                         ' initial values
            Temp2 = 0.1
            Do While Abs(Temp1 - Temp3) >= 0.0001
                Temp1 = Temp1 + Temp2
                Temp3 = ((7.26 * Temp1 * 138) / (ZoIn * CapIn)) ^ 2
                If Temp3 > Temp1 Then
                    Temp1 = Temp1 - Temp2
                    Temp2 = Temp2 / 10
                End If
            Loop

            E = Temp1
            lblCalcDielOut.Caption = Format$(E, "#.000")
            VF = 100 / Sqr(Temp1)
            lblCalcVFOut.Caption = Format$(VF, "##.0")

                ' -------------------------------------------------
                ' check for valid velocity factor (>= 60 and < 100)
                ' -------------------------------------------------
                ' error condition:  Zo = 55 and cap = 31
                ' -------------------------------------------------

                ' ------------------------
                ' message box text strings
                ' ------------------------
            Title = " Input Quantity Error"     ' leading space for readability
            Msg1 = "ERROR - Input values yield a Velocity Factor" + Chr(10)
            Msg2 = "exceeding 100%!  Select ""OK"" to input new" + Chr(10)
            Msg3 = "values or ""Cancel"" to exit the program."
            EMsg = Msg1 + Msg2 + Msg3

                ' ------------------------------------
                ' display message box and get response
                ' ------------------------------------
            If VF >= 100 Or VF < 60 Then                        ' invalid value
                Response = MsgBox(EMsg, 1 + 16, Title)
                    If Response = 1 Then                        ' OK - retry
                        txtPubZo.Text = ""
                        txtPubCapac.Text = ""
                        txtPubZo.SetFocus
                        Exit Sub
                    ElseIf Response = 2 Then                    ' Cancel - exit
                        ClearForm frmCoaxDiel
                        picDielectric.Visible = True
                        picDielectric.ZOrder 0
                        CmdOpenPos
                        txtPubZo.TabStop = False
                        txtPubCapac.TabStop = False
                        cmdContinue.SetFocus
                        Exit Sub
                    End If                          ' end velocity factor test
            End If

                ' -----------------------------------------
                ' show output labels if VF is a valid value
                ' -----------------------------------------
            lblCalcDiel.Visible = True
            lblCalcDielOut.Visible = True
            lblCalcVF.Visible = True
            lblCalcVFOut.Visible = True

                ' -----------------------------
                ' show and hide command buttons
                ' -----------------------------
            cmdOK.Visible = False
            cmdCompute.Visible = False
            cmdAnother.Visible = True

                ' ------------------------
                ' position command buttons
                '  cmdTop2 = 7635
                ' ------------------------
            cmdW1 = cmdAnother.Width
            cmdW2 = cmdExit.Width
            cmdSp = (frmCoaxDiel.ScaleWidth - (cmdW1 + cmdW2)) \ 3

            cmdAnother.Top = cmdTop2
            cmdAnother.Left = cmdSp
            cmdExit.Left = cmdW1 + (2 * cmdSp)

                ' -----------------------------------
                ' disable tab stops and set tab order
                ' -----------------------------------
            cmdAnother.TabIndex = 0
            cmdExit.TabIndex = 1
            txtPubZo.TabStop = False
            txtPubCapac.TabStop = False

                ' ---------------
                ' reset the focus
                ' ---------------
            cmdAnother.TabStop = True
            cmdAnother.SetFocus
        End If                                              ' no input errors

    End Sub                                             ' cmdCompute_Click ()

    Private Sub cmdContinue_Click()

        ' ===========================================
        ' DIMENSION AND POSITION LABELS AND TEXTBOXES
        ' ===========================================
        ' parent:  frmCoaxDiel
        ' ===========================================
        ' called from Sub Form_Load ()
        ' ===========================================

            ' -----------------------
            ' declare local variables
            ' -----------------------
        Dim cmdW1 As Integer                    ' width of cmdOK
        Dim cmdW2 As Integer                    ' width of cmdCompute
        Dim cmdW3 As Integer                    ' width of cmdExit
        Dim cmdSp As Integer                    ' command button spacing
        Dim CtrlSpace As Integer                ' width of text string to center
        Dim FormWid As Integer                  ' form scale width
        Dim LblLeft As Integer                  ' left side of labels

            ' ---------------------------------------------
            ' hide picDielectric and unused command buttons
            ' ---------------------------------------------
        picDielectric.Visible = False
        cmdContinue.Visible = False
        cmdOpenMenu.Visible = False

            ' ------------------------------------
            ' display and position command buttons
            '  cmdTop2 = 7635
            ' ------------------------------------
        cmdCompute.Visible = True
        cmdCompute.TabStop = True

        cmdW1 = cmdOK.Width
        cmdW2 = cmdCompute.Width
        cmdW3 = cmdExit.Width
        cmdSp = (frmCoaxDiel.ScaleWidth - (cmdW1 + cmdW2 + cmdW3)) \ 4

        cmdOK.Top = cmdTop2
        cmdOK.Left = cmdSp

        cmdCompute.Top = cmdTop2
        cmdCompute.Left = cmdW1 + (2 * cmdSp)

        cmdExit.Top = cmdTop2
        cmdExit.Left = cmdW1 + cmdW2 + (3 * cmdSp)

            ' --------------------------------------------------
            ' enable tab stops and ranges menu and set tab order
            ' --------------------------------------------------
        txtPubZo.TabStop = True
        txtPubCapac.TabStop = True

        txtPubZo.TabIndex = 0
        txtPubCapac.TabIndex = 1
        cmdCompute.TabIndex = 2
        cmdOK.TabIndex = 3
        cmdExit.TabIndex = 4

        mnuRanges.Enabled = True

            ' -------------------------------------
            ' locate and size labels and text boxes
            ' -------------------------------------
        lblPubZo.Visible = True
        lblPubZo.BorderStyle = 0
        lblPubZo.AutoSize = True                                ' height = 270
        lblPubZo.Caption = "Enter nominal characteristic impedance (ohms):"

        CtrlSpace = 1005
        FormWid = frmCoaxDiel.ScaleWidth
        LblLeft = (FormWid - (lblPubZo.Width + txtPubZo.Width + CtrlSpace)) \ 2

        lblPubZo.Top = 645
        lblPubZo.Left = LblLeft

        txtPubZo.Visible = True
        txtPubZo.Top = 600
        txtPubZo.Height = 360
        txtPubZo.Left = lblPubZo.Left + lblPubZo.Width + CtrlSpace
        txtPubZo.SetFocus

        lblPubCapac.Visible = True
        lblPubCapac.BorderStyle = 0
        lblPubCapac.AutoSize = True
        lblPubCapac.Top = 1305
        lblPubCapac.Left = lblPubZo.Left
        lblPubCapac.Caption = "Enter published capacitance (Pf/ft.):"

        txtPubCapac.Visible = True
        txtPubCapac.Top = lblPubCapac.Top - 45
        txtPubCapac.Height = 360
        txtPubCapac.Left = txtPubZo.Left

        lblCalcDiel.BorderStyle = 0
        lblCalcDiel.AutoSize = True
        lblCalcDiel.Top = 2010
        lblCalcDiel.Left = LblLeft
        lblCalcDiel.Caption = "Calculated Dielectric Constant:"

        lblCalcDielOut.Height = 360
        lblCalcDielOut.Width = 1215
        lblCalcDielOut.Top = 2010
        lblCalcDielOut.Left = txtPubZo.Left

        lblCalcVF.BorderStyle = 0
        lblCalcVF.AutoSize = True
        lblCalcVF.Top = 2715
        lblCalcVF.Left = LblLeft
        lblCalcVF.Caption = "Calculated Velocity Factor:"

        lblCalcVFOut.Height = 360
        lblCalcVFOut.Width = 1215
        lblCalcVFOut.Top = 2715
        lblCalcVFOut.Left = txtPubZo.Left

    End Sub                                             ' cmdContinue_Click ()

    Private Sub cmdExit_Click()

        ' ====================
        ' EXIT PROGRAM
        ' ====================
        ' parent:  frmCoaxDiel
        ' ====================

        End                                                 ' exit program

    End Sub                                                 ' cmdExit_Click ()

    Private Sub cmdOK_Click()

        ' ===============================================
        ' RETURN TO COAXIAL CABLE CHARACTERISTICS OPENING
        '  SCREEN FROM CABLE DIELECTRIC SCREEN
        ' ===============================================
        ' parent:  frmCoaxDiel
        ' ===========================================
        ' called from Sub Form_Load ()
        ' ===========================================

            ' -------------------------------------
            ' return to coax characteristics screen
            ' -------------------------------------
        Unload frmCoaxDiel                  ' remove form from memory
        frmCoaxChar.Show                    ' return to coax char opening screen

            ' --------------------------------------
            ' reset function option button and focus
            ' --------------------------------------
        frmCoaxChar.optDielConst.Value = False
        frmCoaxChar.cmdOpenMenu.SetFocus

    End Sub                                                     ' cmdOK_Click ()

    Private Sub cmdOpenMenu_Click()

        ' ==========================================
        ' SHOW PROGRAM OPENING SCREEN - TLINMENU.FRM
        ' ==========================================
        ' parent:  frmCoaxDiel
        ' ==========================================
        ' called from Sub Form_Load ()
        ' ==========================================

            ' -----------------------------------------------------------
            ' show program opening menu screen and reset default function
            ' -----------------------------------------------------------
        Unload frmCoaxChar
        Unload frmCoaxDiel
        frmTLineMenu.Show
        frmTLineMenu.optCoaxChar.Value = False
        frmTLineMenu.cmdExit.SetFocus

    End Sub                                             ' cmdOpenMenu_Click ()

    Private Sub CmdOpenPos()

        ' ================================================
        ' POSITION COMMAND BUTTONS FOR FORM OPENING SCREEN
        '  AND HIDE UNUSED COMMAND BUTTONS
        ' ================================================
        ' parent:  frmCoaxDiel
        ' ================================================
        ' called from Sub Form_Load ()
        ' ================================================

            ' -----------------------
            ' declare local variables
            ' -----------------------
        Dim cmdW1 As Integer                            ' width of cmdOK
        Dim cmdW2 As Integer                            ' width of cmdOpenMenu
        Dim cmdW3 As Integer                            ' width of cmdContinue
        Dim cmdW4 As Integer                            ' width of cmdExit
        Dim SpAvail As Integer                          ' command button spacing

            ' ---------------------------------
            ' show and position command buttons
            '  cmdTop2 = 7635
            ' ---------------------------------
        cmdContinue.Visible = True
        cmdOK.Visible = True
        cmdOpenMenu.Visible = True
        cmdExit.Visible = True

        cmdW1 = cmdOK.Width
        cmdW2 = cmdOpenMenu.Width
        cmdW3 = cmdContinue.Width
        cmdW4 = cmdExit.Width
        SpAvail = (frmCoaxDiel.ScaleWidth - (cmdW1 + cmdW2 + cmdW3 + cmdW4)) \ 5

        cmdOK.Top = cmdTop2
        cmdOK.Left = SpAvail

        cmdOpenMenu.Top = cmdTop2
        cmdOpenMenu.Left = cmdW1 + (2 * SpAvail)

        cmdContinue.Top = cmdTop2
        cmdContinue.Left = cmdW1 + cmdW2 + (3 * SpAvail)

        cmdExit.Top = cmdTop2
        cmdExit.Left = cmdW1 + cmdW2 + cmdW3 + (4 * SpAvail)

            ' ---------------------------
            ' hide unused command buttons
            ' ---------------------------
        cmdAnother.Visible = False
        cmdCompute.Visible = False
        cmdAnother.TabStop = False
        cmdCompute.TabStop = False

    End Sub                                                     ' CmdOpenPos ()

    Private Sub Form_Load()

        ' ==================================================
        ' LOAD frmCoaxDiel AND SET OPENING SCREEN PARAMETERS
        ' ==================================================
        ' calls Sub CenterForm (frm As Form),
        '  Sub ProgramTitle (frm As Form, Sp As Integer),
        '  Sub CmdOpenPos (), and Sub ShowDielTable ()
        ' ==================================================

            ' -------------------
            ' set form scale mode
            ' -------------------
        frmCoaxDiel.ScaleMode = TWIPS

            ' --------------------------------------------
            ' set form to maximum size for 800x600 display
            ' --------------------------------------------
        frmCoaxDiel.Height = 9000                       ' 600 x 15 twips/pixel
        frmCoaxDiel.Width = 12000                       ' 800 x 15 twips/pixel
            ' ScaleHeight = 8310 w/menu bar
            ' ScaleHeight = 8595 wo/menu bar

            ' -------------------
            ' define newline code
            ' -------------------
        N = Chr(13) + Chr(10)                           ' Chr(13) is enter
                                                        ' Chr(10) is line feed

            ' -----------------------
            ' space string (3 spaces)
            ' -----------------------
        S = Space(3)

            ' ---------------------
            ' center form on screen
            ' ---------------------
        CenterForm frmCoaxDiel

            ' --------------------------------
            ' display program title and credit
            ' --------------------------------
        ProgramTitle frmCoaxDiel, 83

            ' ----------
            ' form title
            ' ----------
        lblTitle.BorderStyle = 0
        lblTitle.Top = 120
        lblTitle.AutoSize = True
        lblTitle.Caption = "TYPICAL DIELECTRIC CONSTANTS"
        lblTitle.Left = (frmCoaxDiel.ScaleWidth - lblTitle.Width) \ 2

            ' ------------------------------------------
            ' hide unused controls and disable mnuRanges
            ' ------------------------------------------
        lblPubZo.Visible = False
        lblPubCapac.Visible = False
        lblCalcDiel.Visible = False
        lblCalcDielOut.Visible = False
        lblCalcVF.Visible = False
        lblCalcVFOut.Visible = False
        picRanges.Visible = False
        txtPubZo.Visible = False
        txtPubCapac.Visible = False

        mnuRanges.Enabled = False

            ' ------------------------
            ' position command buttons
            ' ------------------------
        CmdOpenPos

            ' --------------------------------------------------
            ' set command button tab order and disable tab stops
            ' --------------------------------------------------
        cmdContinue.TabIndex = 0
        cmdOK.TabIndex = 1
        cmdOpenMenu.TabIndex = 2
        cmdExit.TabIndex = 3

        picDielectric.TabStop = False
        txtPubZo.TabStop = False
        txtPubCapac.TabStop = False

            ' -------------------------------------
            ' display the dielectric constant table
            ' -------------------------------------
        ShowDielTable

    End Sub                                                     ' Form_Load ()

    Private Sub mnuExit_Click()

        ' ====================
        ' parent:  frmCoaxDiel
        ' ====================

        End                                                 ' exit program

    End Sub                                                 ' mnuExit_Click ()

    Private Sub mnuProgDir_Click()

        ' ================================
        ' DISPLAY PROGRAM DIRECTORY
        ' ================================
        ' parent:  frmCoaxDiel
        ' ================================
        ' called from Sub mnuInfo_Click ()
        ' ================================

        frmProgDir.Show

    End Sub                                             ' mnuProgDir_Click ()

    Private Sub mnuRanges_Click()

        ' ==================================================================
        ' DISPLAY TABLE OF VALUE RANGES FOR DIELECTRIC CONSTANT CALCULATIONS
        ' ==================================================================
        ' parent:  frmCoaxDiel
        ' ==================================================================
        ' called from Sub Form_Load ()
        '
        ' all range limits in TRANSLIN.BAS
        ' ==================================================================

            ' -----------------------
            ' declare local variables
            ' -----------------------
        Dim R1 As String                            ' text strings
        Dim R2 As String
        Dim R3 As String
        Dim R4 As String

        Dim VertSp As Integer                       ' vertical spacing constant

            ' -------------------------------------
            ' disable command buttons and info menu
            ' -------------------------------------
        cmdAnother.Enabled = False
        cmdCompute.Enabled = False
        cmdOK.Enabled = False
        mnuInfo.Enabled = False

            ' ---------------------------
            ' size and position picRanges
            ' ---------------------------
        VertSp = 120

        picRanges.Height = 1890
        picRanges.Width = 6900
        picRanges.Top = 3420
        picRanges.Left = (frmCoaxDiel.ScaleWidth - picRanges.Width) \ 2

            ' -----
            ' title
            ' -----
        lblRangeTitle.BorderStyle = 0
        lblRangeTitle.Top = VertSp
        lblRangeTitle.Height = 300
        lblRangeTitle.Width = 4995
        lblRangeTitle.Left = (picRanges.Width - lblRangeTitle.Width) \ 2
        lblRangeTitle.Caption = "Dielectric Constant Calculation Value Ranges"

            ' ----------
            ' range text
            ' ----------
        lblRanges1.BorderStyle = 0
        lblRanges1.Top = lblRangeTitle.Top + lblRangeTitle.Height + VertSp
        lblRanges1.Height = 555
        lblRanges1.Width = 3000
        lblRanges1.Left = 495

        lblRanges2.BorderStyle = 0
        lblRanges2.Top = lblRangeTitle.Top + lblRangeTitle.Height + VertSp
        lblRanges2.Height = 555
        lblRanges2.Width = picRanges.Width - (lblRanges1.Width + (2 * 495))
        lblRanges2.Left = lblRanges1.Left + lblRanges1.Width

        R1 = " Nominal impedance:" + N
        R2 = " Published capacitance:"

        lblRanges1.Caption = R1 + R2

        R3 = " > 0 to <= 125 ohms" + N
        R4 = " >= 6 to <= 35 picoFarads/ft."

        lblRanges2.Caption = R3 + R4

            ' --------------------------
            ' size and position cmdClose
            ' --------------------------
        cmdClose.Height = 495
        cmdClose.Width = 1215
        cmdClose.Top = picRanges.Height - (cmdClose.Height + VertSp)
        cmdClose.Left = (picRanges.Width - cmdClose.Width) \ 2

            ' -----------------
            ' display picRanges
            ' -----------------
        picRanges.Visible = True

            ' -------------
            ' set the focus
            ' -------------
        cmdClose.SetFocus

    End Sub                                                 ' mnuRanges_Click ()

    Private Sub ShowDielTable()

        ' =====================================
        ' DISPLAY THE DIELECTRIC CONSTANT TABLE
        ' =====================================
        ' parent:  frmCoaxDiel
        ' =====================================
        ' called from Sub Form_Load ()
        ' =====================================

            ' -----------------------
            ' declare local variables
            ' -----------------------
        Dim L1 As String                                ' text strings
        Dim L2 As String
        Dim L3 As String

        Dim M1 As String                                ' material types
        Dim M2 As String
        Dim M3 As String
        Dim M4 As String
        Dim M5 As String
        Dim M6 As String
        Dim M7 As String
        Dim M8 As String
        Dim M9 As String
        Dim M10 As String
        Dim M11 As String
        Dim M12 As String
        Dim M13 As String
        Dim M14 As String
        Dim M15 As String
        Dim M16 As String
        Dim M17 As String

        Dim O1 As String                                ' dielectric constants
        Dim O2 As String
        Dim O3 As String
        Dim O4 As String
        Dim O5 As String
        Dim O6 As String
        Dim O7 As String
        Dim O8 As String
        Dim O9 As String
        Dim O10 As String
        Dim O11 As String
        Dim O12 As String
        Dim O13 As String
        Dim O14 As String
        Dim O15 As String
        Dim O16 As String
        Dim O17 As String

        Dim Q1 As String                                ' velocity factors
        Dim Q2 As String
        Dim Q3 As String
        Dim Q4 As String
        Dim Q5 As String
        Dim Q6 As String
        Dim Q7 As String
        Dim Q8 As String
        Dim Q9 As String
        Dim Q10 As String
        Dim Q11 As String
        Dim Q12 As String
        Dim Q13 As String
        Dim Q14 As String
        Dim Q15 As String
        Dim Q16 As String
        Dim Q17 As String

        Dim R1 As String                                ' discussion text
        Dim R2 As String
        Dim R3 As String
        Dim R4 As String
        Dim R5 As String
        Dim R6 As String
        Dim R7 As String
        Dim R8 As String

        Dim P1 As String                                ' caption text strings
        Dim P2 As String
        Dim P3 As String
        Dim P4 As String
        Dim P5 As String
        Dim P6 As String
        Dim P7 As String

        Dim LblSp As Integer                            ' space between labels

            ' -----------------------------
            ' size and locate picDielectric
            ' -----------------------------
        picDielectric.Top = 510
        picDielectric.Width = 10005
        picDielectric.Height = 6945
        picDielectric.Left = (frmCoaxDiel.ScaleWidth - picDielectric.Width) \ 2

            ' ---------------------------------
            ' size and locate explanation label
            ' ---------------------------------
        lblExplanation.BorderStyle = 0
        lblExplanation.Top = 120
        lblExplanation.Width = 8910
        lblExplanation.Height = 555
        lblExplanation.Left = (picDielectric.Width - lblExplanation.Width) \ 2

        L1 = "Some values of dielectric constants (e) of the more common "
        L2 = "dielectric cores are listed" + N + "below.  The reference "
        L3 = "material is air (e = 1)."
        lblExplanation.Caption = L1 + L2 + L3

            ' ----------------------------------------
            ' size and locate horizontal dividing line
            ' ----------------------------------------
        linDivider.X1 = lblExplanation.Left
        linDivider.X2 = lblExplanation.Left + lblExplanation.Width
        linDivider.Y1 = 1155
        linDivider.Y2 = 1155

            ' -----------------------------
            ' size and locate column labels
            ' -----------------------------

            ' --------
            ' material
            ' --------
        lblMatCol.BorderStyle = 0
        lblMatCol.Top = 810
        lblMatCol.Width = 4200
        lblMatCol.Left = lblExplanation.Left
        lblMatCol.Caption = "Material"

        lblMaterial.BorderStyle = 0
        lblMaterial.Top = 1215
        lblMaterial.Width = 4200
        lblMaterial.Height = 4155
        lblMaterial.Left = lblExplanation.Left

        M1 = "Foamed Polyethylene" + N
        M2 = "Foamed FEP" + N
        M3 = "Cellular Polyethylene" + N
        M4 = "Polytetrafluoethylene (PTFE)" + N
        M5 = "Flourinated Ethylene Propylene (FEP)" + N
        M6 = "Polyethylene - High Pressure" + N
        M7 = "Polyethylene - Nominal" + N
        M8 = "Polyethylene - Low Pressure" + N
        M9 = "Butyl Rubber" + N
        M10 = "Polystyrene" + N
        M11 = "Nylon" + N
        M12 = "Silicon Rubber" + N
        M13 = "Polysulfone" + N
        M14 = "Magnesium Oxide" + N
        M15 = "Polyimide G-30" + N
        M16 = "Epoxy\glass FR-4 Generic" + N
        M17 = "Epoxy\glass G-10 Generic"

        P1 = M1 + M2 + M3 + M4 + M5 + M6 + M7 + M8 + M9
        P2 = M10 + M11 + M12 + M13 + M14 + M15 + M16 + M17

        lblMaterial.Caption = P1 + P2

            ' -------------------
            ' dielectric constant
            ' -------------------
        LblSp = 225                                     ' space between labels

        lblDielCol.BorderStyle = 0
        lblDielCol.Top = 810
        lblDielCol.Width = 2130
        lblDielCol.Left = lblExplanation.Left + lblMaterial.Width + LblSp
        lblDielCol.Caption = "Dielectric Constant"

        lblDielCons.BorderStyle = 0
        lblDielCons.Top = 1215
        lblDielCons.Width = 2130
        lblDielCons.Height = 4155
        lblDielCons.Left = lblExplanation.Left + lblMaterial.Width + LblSp

        O1 = "1.55" + N
        O2 = "1.6" + N
        O3 = "1.75" + N
        O4 = "2.4 nom" + N
        O5 = "2.15" + N
        O6 = "2.26" + N
        O7 = "2.3" + N
        O8 = "2.34" + N
        O9 = "2.37" + N
        O10 = "2.5" + N
        O11 = "3.0" + N
        O12 = "3.1" + N
        O13 = "3.5 - 3.9" + N
        O14 = "3.6" + N
        O15 = "4.2" + N
        O16 = "4.3" + N
        O17 = "4.3 " + Chr$(177) + " 0.05"

        P3 = O1 + O2 + O3 + O4 + O5 + O6 + O7 + O8 + O9
        P4 = O10 + O11 + O12 + O13 + O14 + O15 + O16 + O17

        lblDielCons.Caption = P3 + P4

            ' ---------------
            ' velocity factor
            ' ---------------
        lblVFCol.BorderStyle = 0
        lblVFCol.Top = 810
        lblVFCol.Width = 2130
        lblVFCol.Left = lblDielCons.Left + lblDielCons.Width + LblSp
        lblVFCol.Caption = "Velocity Factor"

        lblVelFact.BorderStyle = 0
        lblVelFact.Top = 1215
        lblVelFact.Width = 2130
        lblVelFact.Height = 4155
        lblVelFact.Left = lblDielCons.Left + lblDielCons.Width + LblSp

        Q1 = "80" + N
        Q2 = "79" + N
        Q3 = "76" + N
        Q4 = "64.5" + N
        Q5 = "68" + N
        Q6 = "66.5" + N
        Q7 = "65.9" + N
        Q8 = "65.4" + N
        Q9 = "65" + N
        Q10 = "63.2" + N
        Q11 = "57.7" + N
        Q12 = "56.8" + N
        Q13 = "53.5 - 50.6" + N
        Q14 = "52.7" + N
        Q15 = "48.8" + N
        Q16 = "48.2" + N
        Q17 = "48.5 - 47.9"

        P5 = Q1 + Q2 + Q3 + Q4 + Q5 + Q6 + Q7 + Q8 + Q9
        P6 = Q10 + Q11 + Q12 + Q13 + Q14 + Q15 + Q16 + Q17

        lblVelFact.Caption = P5 + P6

            ' ----------
            ' discussion
            ' ----------
        lblDiscussion.BorderStyle = 0
        lblDiscussion.Top = 5490 + 30
        lblDiscussion.Width = 8910
        lblDiscussion.Height = 1260
        lblDiscussion.Left = lblExplanation.Left

        R1 = "Many coaxial cable equations stem from the dielectric "
        R2 = "constant e.  Most published coaxial cable tables do "
        R3 = "not show this constant.  Most published coaxial cable "
        R4 = "tabular data appear to be rounded off.  The least "
        R5 = "rounding-off appears to be in the listed Zo and pF/ft. "
        R6 = "values.  This program calculates e based on published "
        R7 = "Zo and Pf/ft. values." + N + "Using e it re-calculates "
        R8 = "the characteristic impedance and velocity factor."

        P7 = R1 + R2 + R3 + R4 + R5 + R6 + R7 + R8

        lblDiscussion.Caption = P7

    End Sub                                                 ' ShowDielTable ()

