unit MainLog;
{************************************************************************}

{      KIA LogBook Project}
{       Version 0.90}

{ The initial developer of the Delphi code is < Steve Gradijan, WB5KIA>}
{ (wb5kia@arrl.net).}
{The idea for the use of grids and file mainfile input/output is based }
{on Delphi 3 public domain code written in 1998 }
{by Jrme FORESTIER, jforestier@altern.org}
{
{ Code created by < Steve Gradijan> are}
{ Copyright  2003  Steve Gradijan, WB5KIA>.}


{       Obtained through:}
{       WB5KIA}



{ The contents of this file are used with permission. You may}
{ not use this file except in non-commercial programs}

{ Software distributed on an "AS IS" basis, WITHOUT WARRANTY OF ANY}
{ KIND, either express or implied. }

{ If you modify this file or correct mistakes, I would appreciate}
{ you dropping me an e-mail to let me know what you think of it and}
{ let me know about your bug fixes and any additions you have made.}
{ Reach me at wb5kia@arrl.net}

{Steve Gradijan 03/24/03}

{************************************************************************}

{************************************************************************}
{  revision history}
{   date        comment                                       who}

{  01/27/03     began development                             sjg}

{************************************************************************}


interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Grids, ExtCtrls, StdCtrls, Menus, Printers;

const
  VERSION = '0.9';
  DATEVERSION = '20 March 2003';

  LogEntry : array[0..9] of string = ('QSO#', 'Date', 'UTC','STATION', 'RSTs','RSTr', 'Freq','Mode', 'QTH','Comments');
  //number of fields in logging database   string is the grid header information
  COLQSO = 0;
  COLDATE = 1;
  COLTIME = 2;
  COLSTN = 3;
  COLRST = 4;
  COLRSTr = 5;
  COLFRQ = 6;
  COLMODE = 7;
  COLQTH = 8;
  COLCOM =9 ;
  //constants to provide entry box labels
  NORMAL = 'QSO #               UTC                                     STATION                RSTs  RSTr    FREQ     MODE                 QTH                                COMMENTS';
  ARRLSS = 'QSO #               UTC                                     STATION                RSTs  RSTr    FREQ     MODE                 SECTION                            EXCHANGE';
  TXQSOP = 'QSO #               UTC                                     STATION                RSTs  RSTr    FREQ     MODE                 COUNTY                             EXCHANGE';

type
  TForm1 = class(TForm)
    eSTN: TEdit;
    eRST: TEdit;
    lTime: TLabel;
    Timer1: TTimer;
    bOK: TButton;
    qso: TStringGrid;
    eFRQ: TEdit;
    eMode: TEdit;
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Setup1: TMenuItem;
    New1: TMenuItem;
    Load1: TMenuItem;
    Save1: TMenuItem;
    Quit1: TMenuItem;
    Font1: TMenuItem;
    fdQSO: TFontDialog;
    sdQSO: TSaveDialog;
    odQSO: TOpenDialog;
    Help1: TMenuItem;
    About1: TMenuItem;
    N1: TMenuItem;
    N2: TMenuItem;
    eQTH: TEdit;
    eCOM: TEdit;
    lDate: TLabel;
    Edit1: TEdit;
    Button1: TButton;
    Edit2: TEdit;
    ListBox2: TListBox;
    Label1: TLabel;
    Edit3: TEdit;
    Edit5: TEdit;
    ListBox1: TListBox;
    RadioGroup1: TRadioGroup;
    RadioGroup2: TRadioGroup;
    lqso: TLabel;
    Button2: TButton;
    Help2: TMenuItem;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Print1: TMenuItem;
    PrinttoFile1: TMenuItem;
    PrintGridLogBook1: TMenuItem;
    Label5: TLabel;
    Contest1: TMenuItem;
    ARRLSweepstakes1: TMenuItem;
    TexasQSOParty1: TMenuItem;
    ContestList: TListBox;
    Edit4: TEdit;
    NONE1: TMenuItem;
    ListBox4: TListBox;
    EditLog1: TMenuItem;
    EditCurrentLog1: TMenuItem;
    Edit6: TEdit;
    procedure Timer1Timer(Sender: TObject);
    procedure bOKClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure eSTNKeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure FormResize(Sender: TObject);
    procedure Quit1Click(Sender: TObject);
    procedure Font1Click(Sender: TObject);
    procedure Save1Click(Sender: TObject);
    procedure Load1Click(Sender: TObject);
    procedure New1Click(Sender: TObject);
    procedure About1Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure eSTNChange(Sender: TObject);
    procedure RadioGroup2Click(Sender: TObject);
    procedure RadioGroup1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Help2Click(Sender: TObject);
    procedure PrintGridLogBook1Click(Sender: TObject);
    procedure eSTNKeyPress(Sender: TObject; var Key: Char);
    procedure ARRLSweepstakes1Click(Sender: TObject);
    procedure TexasQSOParty1Click(Sender: TObject);
    procedure NONE1Click(Sender: TObject);
    procedure eQTHChange(Sender: TObject);
    procedure ListBox4DblClick(Sender: TObject);
    procedure EditCurrentLog1Click(Sender: TObject);
    procedure eCOMKeyPress(Sender: TObject; var Key: Char);
    procedure eQTHKeyPress(Sender: TObject; var Key: Char);

  private
    { Private Declarations }
  public
    { Public Declarations }
    procedure SaveInfo(fileName:string);
    procedure LoadInfo(fileName:string);
  end;

var
  Form1: TForm1;
  SAVED : boolean;
  DateNum, TimeNow : string;
  SS : string;

     qQSO:string;
     qDate:string;
     qUTC:string;
     qSTATION:string;
     qRST:string;
     qRSTr:string;
     qFreq:string;
     qMode:string;
     qQTH:string;
     qComments:string;
     T :String;
     n : integer;

     // for contests
     ARRLs : boolean;
     TXQSO:boolean;
     nomultipliers:integer;

     Currentlog : String;  //****
     F:TextFile;
     
implementation

uses EditLog;        //refers to form2



{$R *.DFM}

//function to access the KIADX DLL
Function DDXCheck(source: Pchar; SL : TStringList):Pchar; far external 'KIADX.dll';


function MakeItAString(I: Longint): string;
{ Convert any integer type to a string }
var
  S: string[11];
begin
  Str(I, S);
  Result:= S;
end;

function getString(s : string) : string;
begin
  if s<>'' then
    getString := s
  else
    getString := '---';      //if a field is empty, put something in it
end;

procedure ParseIt(var contact: String);   //use with string list
var
InWord:Boolean;
Index, FirstChar:Integer;
begin
  InWord := False;
  Index := 1;
  FirstChar :=1;
  while Index <=Length(Ss) do     //ss is the string to parse
  begin
    T:=Copy(Ss,Index,1);
    If((T>='0')and (T<='9')) or     //these are the recognized characters
    ((T>='A') and (T<='Z')) or
    ((T>='a') and (T<='z')) or
    (T ='_') or
    (T ='/') or
    (T ='?') or
    (T ='.') or
    (T ='-') or
    (T =' ') or
    //(T=',') or    //can not use a comma.  It is the database delimiter
    (T =':')  then
  begin
    If not InWord then FirstChar := Index;
      InWord := true;
      end
      else begin
        If InWord then begin
           T := Copy(Ss, FirstChar, Index-FirstChar);
           Form1.ListBox2.items.add(T);
        end;
        InWord := False;
       end;
       Inc(Index);
 end;
end;


procedure TForm1.SaveInfo(filename:string);
var
  n : integer;
 // F  : TextFile;
  Datestr, Timestr :string;

begin
    AssignFile(F,FileName);
   // if FileExists(FileName) then
    // Append(F)
    // else
    // begin
     
     Rewrite(F);
     //end;

     writeln(f, qso.rowcount);
    for n := 0 to qso.RowCount-2 do
    begin
       begin
          datestr:=(qso.cells[COLDATE,n]) ;
          timestr := (qso.cells[COLTIME,n]) ;
          writeln(F, qso.cells[COLQSO,n]+',',datestr+',',timestr+',',QSO.Cells[COLSTN,n]+',',QSO.Cells[COLRST,n]+','+ QSO.Cells[COLRSTr,n]+',',QSO.Cells[COLFRQ,n]+',',QSO.Cells[COLMODE,n]+',', qso.cells[COLQTH,n]+',', qso.cells[COLCOM,n]+',','-----');
          //above writes new contact to log database
        end
    end;

    CloseFile(F);

end;

//-----------------------------------
// procedure to use vertical text file  instead of the comma delimited file
 { procedure TForm1.LoadInfo(fileName:string);
var
  n : integer;
  F  : TextFile;
  dummy : string;
begin
  AssignFile(F,FileName);
  reset(f);
  readln(f, n);
  qso.RowCount := n;
  for n := 0 to qso.RowCount do
  begin
    ReadLn(f, dummy); qso.cells[COLQSO,n] := dummy;
    ReadLn(f, dummy); qso.cells[COLDATE,n] := dummy;
    ReadLn(f, dummy); qso.Cells[COLTIME,n] := dummy;
    Readln(f, dummy); qso.Cells[COLSTN,n] := dummy;
    Readln(f, dummy); qso.Cells[COLRST,n] := dummy;
    Readln(f, dummy); qso.Cells[COLRSTr,n] := dummy;
    Readln(f, dummy); qso.Cells[COLFRQ,n] := dummy;
    Readln(f, dummy); qso.Cells[COLMODE,n] := dummy;
    Readln(f, dummy); qso.Cells[COLQTH,n] := dummy;
    Readln(f, dummy); qso.Cells[COLCOM,n] := dummy;
    Readln(f, dummy);
  end;
  closefile(f);
  eProg.Text := intToStr(strToInt(qso.cells[COLQSO,qso.rowcount-2]) + 1);
end;
}
 //---------------------------------

procedure TForm1.LoadInfo(fileName:string);
//procedure to load the logbook
var

  dummy : string;

begin

  AssignFile(F,FileName); //create and open a file called F

  CurrentLog := odQSO.Filename;

  reset(f);
  readln(f, n);
  qso.RowCount := n;    //read the first line of the file, it has the row count

 for n:=0 to (qso.RowCount -2) do
 //while not Eof(F) do
  begin
     Readln(f, dummy);
     edit2.text := dummy;  //hidden edit box behind contest
                        //list box that has the unparsed log data
                        //kept in the program to monitor for problems
     Ss:= dummy +' ';
     ParseIt(Ss);     //parse the logbook record string
     //put the records in the array / grid
        Form1.qso.cells[COLQSO,n] := ListBox2.Items[0];
        Form1.qso.cells[COLDATE,n] := ListBox2.Items[1];
        Form1.qso.cells[COLTIME,n] := ListBox2.Items[2];
        Form1.qso.cells[COLSTN,n]  := ListBox2.Items[3];
        Form1.qso.Cells[COLRST,n] := ListBox2.Items[4];
        Form1.qso.Cells[COLRSTr,n] := ListBox2.Items[5];
        Form1.qso.Cells[COLFRQ,n] :=  ListBox2.Items[6];
        Form1.qso.cells[COLMODE,n] :=  ListBox2.Items[7];
        Form1.qso.Cells[COLQTH,n] :=  ListBox2.Items[8];
        Form1.qso.Cells[COLCOM,n] :=  ListBox2.Items[9];

        ListBox2.Clear;   //empty the list box

    end;
    closefile(f);
    lQSO.Caption := intToStr(strToInt(qso.cells[COLQSO,qso.rowcount-2]) + 1);
 end;


procedure TForm1.Timer1Timer(Sender: TObject);

var
     DateTime : TDateTime;
     Timestr,Timestr2 : string;
begin
    DateTime := Time;  // store the current date and time
    Timestr2 := TimeToStr(DateTime); // convert the time into a string
    Caption := Timestr2;  // display the time on the form's caption
    {Note This could have been done with the following line of code:
    Caption := TimeToStr(Time); }
    Timestr := formatDateTime('hh:mm', StrToDateTime(Timestr2));//format the time }
     //  Label2.caption := TimeToStr(Time);   //alternative method
     //I think the alternative method needs to be used with Delphi 1
    lTime.Caption := Timestr;
    lDate.Caption :=  DateToStr(Date);
 end;


procedure TForm1.bOKClick(Sender: TObject);
var
 myRect: TGridRect;

 NewRecord:string;
// F:TextFile;  // n : integer;
 // F  : TextFile;
  Datestr, Timestr :string;


begin
   //QSO.Options[goFixedVertLine,goFixedHorzLine,goVertLine,goHorzLine,goRowSizing,goColSizing,goEditing]
    //QSO.Options[goFixedVertLine,goFixedHorzLine,goVertLine,goHorzLine,goRowSizing,goColSizing];      //remove goEditing to disallow grid modifications
   estn.SetFocus;  //return the cursor to the station box
   //SAVED := false;

If estn.text ='' then
   begin
        (Application.MessageBox('You must enter a call sign.', '', MB_OK));// of
   end
else
  begin
    //populate the qso array/grid
    qso.cells[COLQSO,qso.RowCount-1] := getString(lQSO.Caption);
    qso.cells[COLDATE,qso.RowCount-1] := getString(lDate.Caption);
    qso.cells[COLTIME,qso.RowCount-1] := getString(lTime.Caption);
    qso.cells[COLSTN,qso.RowCount-1]  := getString(eSTN.Text);
    qso.Cells[COLRST,qso.RowCount-1] := getString(eRST.Text);
    qso.Cells[COLRSTr,qso.RowCount-1] := getString(Edit5.Text);
    qso.Cells[COLFRQ,qso.RowCount-1] := getString(eFRQ.Text);
    qso.cells[COLMODE,qso.RowCount-1] := getString(eMODE.Text);
    qso.Cells[COLQTH,qso.RowCount-1] := getString(eQTH.Text);
    qso.Cells[COLCOM,qso.RowCount-1] := getString(eCOM.Text);

    qso.RowCount := qso.rowcount + 1;
    //eQSO.Text := intToStr(strToInt(eQSO.Text) + 1);   //***needed for version 1

    lQSO.Caption:=   intToStr(strToInt(lQSO.Caption) + 1);
    qso.row:=qso.rowcount-1;   //scrolls to end
   //------------------------

   //----------------------
   //   eQSO.Text := InttoStr(qso.RowCount);
    eSTN.Text := '';       //clear the edit boxes
    //  eRST.Text := '';    //better to keep a value
    //  Edit5.Text :='';    //better to keep a value
    //  eFRQ.Text := '';    //better to keep a value
    //  eMODE.Text := '';   //better to keep a value
    eQTH.Text := '';
    eCOM.Text := '';
    listbox1.visible := false;
    edit3.visible := false;
    //QSO.Options.goEditing := False;

//routine to select  row in stringgrid  --keep the selector on the most recent entry
  myRect.Left := 1;   //highlights column
  myRect.Top := qso.rowcount; //row control this is the last one
  myRect.Right :=0;  //highlights column
  myRect.Bottom := qso.rowcount;//row control
  qso.Selection := myRect;

end;
  //====================================================
   //routine to append new log entry to the logbook
   //(actually rewrites the entire log...I could not get append to
   //work correctly in this version)
  // NewRecord:=  qso.cells[COLQSO,qso.RowCount-1]+','+ qso.cells[COLDATE,qso.RowCount-1]+','+ qso.cells[COLTIME,qso.RowCount-1] +','+ qso.cells[COLSTN,qso.RowCount-1]+','+qso.Cells[COLRST,qso.RowCount-1]+','+ qso.Cells[COLRSTr,qso.RowCount-1]+','+ qso.Cells[COLFRQ,qso.RowCount-1]+','+ qso.cells[COLMODE,qso.RowCount-1]+','+ qso.Cells[COLQTH,qso.RowCount-1]+','+ qso.Cells[COLCOM,qso.RowCount-1];
   NewRecord:=  qso.cells[COLQSO,qso.RowCount-1]+','+ qso.cells[COLDATE,qso.RowCount-2]+','+ qso.cells[COLTIME,qso.RowCount-2] +','+ qso.cells[COLSTN,qso.RowCount-2]+','+qso.Cells[COLRST,qso.RowCount-2]+','+ qso.Cells[COLRSTr,qso.RowCount-2]+','+ qso.Cells[COLFRQ,qso.RowCount-2]+','+ qso.cells[COLMODE,qso.RowCount-2]+','+ qso.Cells[COLQTH,qso.RowCount-2]+','+ qso.Cells[COLCOM,qso.RowCount-2]+','+'-----';

begin
//'kiatxtlog.kia';
  //  AssignFile(F,'kiatxtlog.kia');

    AssignFile(F,currentlog); //****

    if FileExists(currentlog) then
    
   // Append(F)
   // else
    begin
    Reset(F);
    Rewrite(F);
    end;

     writeln(f, qso.rowcount);
    for n := 0 to qso.RowCount-2 do
    begin
       begin
          datestr:=(qso.cells[COLDATE,n]) ;
          timestr := (qso.cells[COLTIME,n]) ;
          writeln(F, qso.cells[COLQSO,n]+',',datestr+',',timestr+',',QSO.Cells[COLSTN,n]+',',QSO.Cells[COLRST,n]+','+ QSO.Cells[COLRSTr,n]+',',QSO.Cells[COLFRQ,n]+',',QSO.Cells[COLMODE,n]+',', qso.cells[COLQTH,n]+',', qso.cells[COLCOM,n]+',','-----');
          //above writes new contact to log database
        end
    end;

    CloseFile(F);

end;
end;

procedure TForm1.FormCreate(Sender: TObject);
var i : byte;
begin
  Timer1Timer(nil);
  for i := 0 to 9 do   //number of fields in logging database (10 in this set)
  begin                //constantly saving the log
    qso.Cells[i,0] := LogEntry[i];
  end;
  SAVED := true;


  // initialize parameters
  Label1.caption := NORMAL;   //normal/contest label
  ARRLs:=False;
  TXQSO:=False;
  case RadioGroup2.ItemIndex of
  // default settings ... put your default frequency or band info here
  // by replacing the right side frequency values with band or frequency
   0: eFRQ.text := '1.9';
   1: eFRQ.text := '3.850';
   2: eFRQ.text:= '7.230';
   3: eFRQ.text:= '10.125';
   4: eFRQ.text:= '14.25';
   5: eFRQ.text:= '18.110';
   6: eFRQ.text:='21.320';
   7: eFRQ.text:='24.950';
   8: eFRQ.text:='28.400';
   9: eFRQ.text:='10.125';
   10: eFRQ.text:='50.125';
   end;
   case RadioGroup1.ItemIndex of
   // handle the mode stuff like the frequency stuff above
   0: begin
   eMode.text := 'SSB';
   eRST.text :='59';
   edit5.text :='59';
   end;
   1: begin
   eMode.text := 'CW';
   eRST.text :='599';
   edit5.text :='599';
   end;
   2:
   begin
   eMode.text:='PSK';
   eRST.text :='599';
   edit5.text :='599';
   end;

   end;
end;

procedure TForm1.eSTNKeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
 // if key = 13 then bOKclick(nil);        //same as OK button
 
end;

procedure TForm1.FormResize(Sender: TObject);
begin
  // if you want to standardize the form, put the code here
 // qso.Width := form1.Width - 24;
 // qso.Height := form1.Height - 120;
 // bOK.Top := form1.Height - (bOK.Height*3)-6;
 // eProg.Top := Form1.Height - (bOK.Height*3) - 38;
 // lTime.Top := Form1.Height - (bOK.Height*3) - 38;
 // eQRZ.Top := Form1.Height - (bOK.Height*3) - 38;
 // eSR.Top := Form1.Height - (bOK.Height*3) - 38;
 // eFrq.Top := Form1.Height - (bOK.Height*3) - 38;
 // eCoord.Top := Form1.Height - (bOK.Height*3) - 38;
end;

procedure TForm1.Quit1Click(Sender: TObject);
begin
  if (SAVED = true ) then Close
  else
  begin
    case (Application.MessageBox('Do you want to save the log before quitting?', '', MB_YESNOCANCEL)) of
      IDNO:Close;
      IDYES:begin Save1Click(nil);Close; end;
    end;
  end;
end;

procedure TForm1.Font1Click(Sender: TObject);
begin
  fdqso.font := qso.font;
  if (fdQSO.Execute = true) then
  begin
    qso.font := fdqso.font;
    qso.DefaultRowHeight := fdQSO.Font.size * 2 + 2;
  end;
end;

procedure TForm1.Save1Click(Sender: TObject);
begin
  if (sdQSO.Execute= true) then
  begin
    saveInfo(sdQSO.Filename);
    Label4.caption := 'LogBook is '+odQSO.Filename;
    SAVED := true;
  end;
  loadInfo(odQSO.Filename);

end;

procedure TForm1.Load1Click(Sender: TObject);
var
rnumb : integer;
begin
   For rnumb := 1 to qso.RowCount do
   qso.Rows[rnumb];   //clears the string grid but does not free memory


  if (odQSO.Execute= true) then
  begin
     loadInfo(odQSO.Filename);
     Label4.caption := 'LogBook is '+ odQSO.Filename;
  end;

end;

procedure TForm1.New1Click(Sender: TObject);
var
rnumb : integer;
begin
   For rnumb := 1 to qso.RowCount do
   qso.Rows[rnumb];   //this clears the existing stringgrid values but does not release memory

  if (SAVED = false ) then
  begin
    case (Application.MessageBox('Do you want to save the log?', '', MB_YESNOCANCEL)) of
      IDNO:begin SAVED := true; new1click(nil); end;
      IDYES:begin Save1Click(nil);if (SAVED = true) then new1click(nil); end;
    end;

  end
  else
  begin
   // saved := false; //sjg
    qso.rowcount := 2;
    qso.Cells[COLQSO,1] := '';      //clear the array
    qso.Cells[COLDATE,1] := '';
    qso.Cells[COLTIME,1] := '';
    qso.Cells[COLSTN,1] := '';
    qso.Cells[COLRST,1] := '';
    qso.Cells[COLRSTr,1] := '';
    qso.Cells[COLFRQ,1] := '';
    qso.Cells[COLMODE,1] := '';
    qso.Cells[COLQTH,1] := '';
    qso.Cells[COLCOM,1] := '';
    qso.Cells[COLQSO,2] := '';
    qso.Cells[COLDATE,2] := '';
    qso.Cells[COLTIME,2] := '';
    qso.Cells[COLSTN,2] := '';
    qso.Cells[COLRST,2] := '';
    qso.Cells[COLRSTr,2] := '';
    qso.Cells[COLFRQ,2] := '';
    qso.Cells[COLMODE,2] := '';
    qso.Cells[COLQTH,2] := '';
    qso.Cells[COLCOm,2] := '';
    // clear the appropriate edit boxes of information
    // eQSO.Text := '1';
    lQSO.Caption := '1';
    eSTN.Text := '';    //clear the edit boxes but not the ones you want
                        //to have default values
    // eRST.Text := '';
    // Edit5.Text :='';
    // eFRQ.Text := '';
    // eMODE.Text := '';
    eQTH.Text := '';
    eCOM.Text := '';
    end;
 // Label4.caption := 'LogBook is not yet named.  Name and save the LogBook before you exit.';
   Label4.caption := 'LogBook is '+ odQSO.Filename;
end;

procedure TForm1.About1Click(Sender: TObject);
begin
   //about message
  Application.MessageBox('Delphi KIA LogBook Project by WB5KIA'+#10#13+'                 Version 0.90'+#10#13+#10#13+'Copyright  2003  Steve Gradijan, WB5KIA'+#10#13+#10#13,'About...',0);
end;

procedure TForm1.Button1Click(Sender: TObject);
 begin
    Ss:= form1.edit2.text +' ';  //call the parse routine to check it
    ParseIt(Ss);      //call ParseIt routine
end;

procedure TForm1.eSTNChange(Sender: TObject);
var
  dupCounter:integer;
  //used with KIADX DLL
  SL:TstringList;
  Source :PChar;
  MyStr:string;

begin
  Listbox1.clear;
  Listbox1.Visible := false;
  edit3.visible := false;
        //dupe checking routine.  This is a simple sequential search.
        //If the database were huge, you could do a binary search but then
        //you would need to sort the dataset first to achieve greater
        //execution speed.

  For dupCounter := 0 to (strToInt(lQSO.Caption) + 1) do
        begin
 //-----------
                begin //call the KIADX DLL
                //Allocate space for null terminated string
                Source :=StrAlloc(200);
                //get the text from the edit box
                MyStr := eSTN.text;
                //convert to a null terminated string
                StrPcopy(Source,MyStr);
                //post the result of the DX check
                Label5.caption := DDXCheck(Source,SL);
                freeLibrary(loadlibrary('KIADX.dll'));    //probably not needed
                end;

 //-------------
           //simple filter goes here  (NOT YET IMPLIMENTED)
           // check the entire data set or restrict by MODE and/or BAND
           if (trim(Form1.qso.Cells[COLSTN,dupCounter])= trim(eSTN.text)) and (lQSO.caption <>'')then
             // if (trim(Form1.qso.Cells[COLSTN,dupCounter])= trim(eSTN.text) )and (trim(Form1.qso.Cells[COLMODE,dupCounter])= 'SSB' )  //would limit the dupe check to only SSB mode  contacts
             // other 'filters' could be used for different bands and modes
           begin
            // edit4.text := trim(Form1.qso.Cells[COLSTN,dupCounter]+'  '+trim(Form1.qso.Cells[COLDATE,dupCounter]+'  ' + trim(Form1.qso.Cells[COLTIME,dupCounter])));
            //could also include COLFRQ, COLMODE, COLQSO etc.
            //if you want to use a memo, this should work:   memo1.lines.add (trim(Form1.qso.Cells[COLSTN,dupCounter]+'  '+trim(Form1.qso.Cells[COLDATE,dupCounter]+'  ' + trim(Form1.qso.Cells[COLTIME,dupCounter]))) ) ;
            if eSTN.text <>'' then
            begin
            listbox1.visible := true;
            edit3.visible := true;
            listbox1.Items.add  (trim(Form1.qso.Cells[COLSTN,dupCounter]+'  '+trim(Form1.qso.Cells[COLDATE,dupCounter]+'  ' + trim(Form1.qso.Cells[COLTIME,dupCounter]+'  '+trim(Form1.qso.Cells[COLFRQ,dupCounter]+'  ' + trim(Form1.qso.Cells[COLMODE,dupCounter])))))) ;
            end;

            end
         else
     //
     end;
end;

procedure TForm1.RadioGroup2Click(Sender: TObject);
begin
   case RadioGroup2.ItemIndex of
     //set the default freq or band as you desire, currently set to 10 mtrs
     0: eFRQ.text := '1.9';
     1: eFRQ.text := '3.850';
     2: eFRQ.text:= '7.230';
     3: eFRQ.text:= '10.125';
     4: eFRQ.text:= '14.25';
     5: eFRQ.text:= '18.110';
     6: eFRQ.text:='21.320';
     7: eFRQ.text:='24.950';
     8: eFRQ.text:='28.400';
     9: eFRQ.text:='10.125';
     10: eFRQ.text:='50.125';
     end;
end;

procedure TForm1.RadioGroup1Click(Sender: TObject);
begin
  case RadioGroup1.ItemIndex of
     //set the default MODE, currently set to SSB
     0: begin
     eMode.text := 'SSB';
     eRST.text :='59';
     edit5.text :='59';
     end;
     1: begin
     eMode.text := 'CW';
     eRST.text :='599';
     edit5.text :='599';
     end;
     2:
     begin
     eMode.text:='PSK';
     eRST.text :='599';
     edit5.text :='599';
     end;
   end;
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
      eSTN.text :='';
      // eRST.text :='';    //better to keep a value in the entry field
      // Edit5.text :='';   //better to keep a value
      // eMODE.text :='';   //better to keep a value
      eQTH.text :='';
      eCOM.text :='';
end;

procedure TForm1.Help2Click(Sender: TObject);
begin
 Application.MessageBox('Help File goes here.'+#10#13+'Last modified: '+DATEVERSION,'Help...',0);
end;

// uses Printers;  remember to put Printers in the uses clause!

procedure printAlistbox(listbox : TListBox);
// this is a very simple printing routine for printing the contents
// of a list box.  if you use a listbox to display your log instead of
// the stringgrid, this would be useful...if you don't, you can delete
//the entire procedure.
var 
 i, lh : Integer;
begin
 with Printer do
   begin
     // gets the height of the text... 
     lh := canvas.TextHeight(listbox.items.text);
     BeginDoc;
     for i := 0 to listbox.items.Count - 1 do
       Canvas.TextOut(10, 10+i * lh, listbox.items[i]);
     EndDoc;
   end;
end;  


 procedure PrintGrid(sGrid: TStringGrid; sTitle: String);
 // this is a very simple printing routine
var
 X1, X2 : Integer;
 Y1, Y2 : Integer;
 TmpI   : Integer;
 F      : Integer;
 TR     : TRect;
begin
 Printer.Title:=sTitle;
 Printer.BeginDoc;
 Printer.Canvas.Pen.Color:=0;
 Printer.Canvas.Font.Name:='Times New Roman';
 Printer.Canvas.Font.Size:=12;
 Printer.Canvas.Font.Style:=[fsBold, fsUnderline];
 Printer.Canvas.TextOut(0, 100, Printer.Title);
// For F:=1 to sGrid.ColCount-1 do begin
  For F:=0 to sGrid.ColCount do begin
   X1:=0;
  // For TmpI:=1 to (F-1) do
   For TmpI:=0 to (F-1) do
     X1:=X1+5*(sGrid.ColWidths[TmpI]);
   Y1:=300;
   X2:=0;
  // For TmpI:=1 to F do
   For TmpI:=0 to F do
     X2:=X2+5*(sGrid.ColWidths[TmpI]);
   Y2:=450;
   TR:=Rect(X1, Y1, X2-30, Y2);
   Printer.Canvas.Font.Style:=[fsBold];
   Printer.Canvas.Font.Size:=7;
   Printer.Canvas.TextRect(TR, X1+50, 350, sGrid.Cells[F, 0]);
   Printer.Canvas.Font.Style:=[];
   For TmpI:=1 to sGrid.RowCount-1 do begin
     Y1:=150*TmpI+300;
     Y2:=150*(TmpI+1)+300;
     TR:=Rect(X1, Y1, X2-30, Y2);
     Printer.Canvas.TextRect(TR, X1+50, Y1+50, sGrid.Cells[F, TmpI]);
   end;
 end;
 Printer.EndDoc;

end;


procedure TForm1.PrintGridLogBook1Click(Sender: TObject);
begin
    PrintGrid(qso,'LogBook');
end;



procedure TForm1.eSTNKeyPress(Sender: TObject; var Key: Char);
begin
if Key =chr(vk_space) then  //space key makes jump to QTH box
       eQTH.setfocus;
if key = chr(13) then  //enter key enters log data
    bOKclick(sender);
end;

procedure TForm1.ARRLSweepstakes1Click(Sender: TObject);
var
  n : integer;
 // F  : TextFile;  //now global variable
  MultArray: array of string;
  multString:string;
  cnt,cnt2 :integer;

begin
if ContestList.Visible = True then
  begin
     ContestList.visible := False;
     Listbox4.visible := false;
     ARRLs := false;   //ARRL Sweepstakes

  end
else
  begin
     ContestList.visible := True;
      Listbox4.visible := True;
      Listbox4.clear;
      ARRLs:= True;   //ARRL Sweepstakes
      Label1.caption := ARRLSS;
  end;

begin
  AssignFile(F,'sections.mul');
  reset(f);
  ContestList.Clear;
 SetLength(MultArray,81); //allocate memory for the array
 cnt := 0;
 for n:= 0 to 80  do
  begin
    Readln(f, multstring);
    Listbox4.Items.add (multstring);  //***
    if length(multstring)<3 then multstring := multstring +' ';
       MultArray[cnt]:= multstring;
       cnt := cnt+1 ;
   end;
   closefile(f);

 end;
        cnt2 := 0;
        while cnt2 <= 70 do
             begin
                 multString :=  (MultArray[cnt2]+'  '+ MultArray[cnt2+1]+'  '+MultArray[cnt2+2]+'  '+MultArray[cnt2+3]+'  '+MultArray[cnt2+4]+'  '+MultArray[cnt2+5]+'  '+MultArray[cnt2+6]+'  '+MultArray[cnt2+7]+'  '+MultArray[cnt2+8]+'  '+MultArray[cnt2+9]+'  '+MultArray[cnt2+10]+'  ')+MultArray[cnt2+11]+'  ' +MultArray[cnt2+12]  ;  //+'  '+MultArray[cnt2+13]+'  '+MultArray[cnt2+14]+'  ';
                 ContestList.Items.Add(multString);
                 cnt2 := (cnt2)+13;
                end;
       end;

procedure TForm1.TexasQSOParty1Click(Sender: TObject);
var
        TheFile : TextFile;
        filename2, multiplier : string;
        cnt : integer;
        MultArray: array of string;
        multString:string;
        cnt2 :integer;
begin
if ContestList.visible = True then
  begin
  ContestList.visible := False;
  ListBox4.visible := False;
  TXQSO:=false;
  end
else
  begin
  ContestList.visible := True;
  ListBox4.visible := True;
  ListBox4.clear;
  TXQSO:=True;
  Label1.Caption := TXQSOP;
  end;
begin
        SetLength(MultArray,255); //allocate memory for the array
        ContestList.visible := True;
        ContestList.clear;
        filename2 := 'TxCounty.mul';
        AssignFile(Thefile,filename2);
        Reset(Thefile);
         cnt :=0;
        While not Eof(Thefile) do
           Begin
             Readln(Thefile,multiplier);
             Listbox4.Items.add (multiplier);  //***
             MultArray[cnt]:= multiplier;
             cnt := cnt+1 ;
        end;

        CloseFile(Thefile);
        end;

        cnt2 := 0;
        while cnt2 <= 249 do
             begin
                 multString :=  (MultArray[cnt2]+'  '+ MultArray[cnt2+1]+'  '+MultArray[cnt2+2]+'  '+MultArray[cnt2+3]+'  '+MultArray[cnt2+4]+'  '+MultArray[cnt2+5]+'  '+MultArray[cnt2+6]+'  '+MultArray[cnt2+7]+'  '+MultArray[cnt2+8]+'  '+MultArray[cnt2+9]+'  '+MultArray[cnt2+10]+'  ')+MultArray[cnt2+11]+'  ' +MultArray[cnt2+12]  ;  //+'  '+MultArray[cnt2+13]+'  '+MultArray[cnt2+14]+'  ';
                 if cnt2+12 >= 234 then
                     begin
                       cnt2:= cnt2+9;
                       multString := (MultArray[cnt2]+'  '+ MultArray[cnt2+1]+'  '+MultArray[cnt2+2]+'  '+MultArray[cnt2+3]+'  '+MultArray[cnt2+4]+'  '+MultArray[cnt2+5]+'  '+MultArray[cnt2+6]+'  '+MultArray[cnt2+7]+'  '+MultArray[cnt2+8])+'  '+MultArray[cnt2+9]+'  '+MultArray[cnt2+10] ; //+'  '+MultArray[cnt2+11]+'  '+MultArray[cnt2+12];
                       ContestList.Items.Add(multString);
                       break;
                     end
                 else
                     ContestList.Items.Add(multString);
                     cnt2 := (cnt2)+13;
                end;
end;

procedure TForm1.NONE1Click(Sender: TObject);

begin
  ContestList.Visible := False;
  ListBox4.Visible := False;
  ListBox4.Clear;
  TXQSO:= False;
  ARRLs:= False;
  Label1.Caption:=NORMAL;
end;


procedure TForm1.eQTHChange(Sender: TObject);
var
  cnt,cnt2 :integer;
  multstring:string;

begin
  if ARRLs = true then nomultipliers := 78;
  if TXQSO = true then nomultipliers := 253;

  if length(trim(eQTH.text))> 1 then   //check to see if there is a four character multiplier
     if  (ARRLs = True) or (TXQSO = True) then //and  (F = 'sections.mul') then
        begin
                ContestList.clear;

                for cnt:= 0 to nomultipliers  do
                   If eQTH.text = Trim(Listbox4.Items[cnt]) then

                   begin
                     edit4.text :=     LowerCase( (Listbox4.Items[cnt]));
                     Listbox4.Items[cnt] :=     LowerCase( (Listbox4.Items[cnt]));
       //handle contest information
        //----for ARRLs     ARRL sweepstages  remember doesn't keep track of the
        // number of multipliers worked yet nor does it calculate score
      If ARRLs = true then
       // begin
                 cnt2 := 0;
              while cnt2 <= 70 do
                begin
                 multString :=  (Listbox4.Items[cnt2]+'  '+ Listbox4.Items[cnt2+1]+'  '+Listbox4.Items[cnt2+2]+'  '+Listbox4.Items[cnt2+3]+'  '+Listbox4.Items[cnt2+4]+'  '+Listbox4.Items[cnt2+5]+'  '+Listbox4.Items[cnt2+6]+'  '+Listbox4.Items[cnt2+7]+'  '+Listbox4.Items[cnt2+8]+'  '+Listbox4.Items[cnt2+9]+'  '+Listbox4.Items[cnt2+10]+'  ')+Listbox4.Items[cnt2+11]+'  ' +Listbox4.Items[cnt2+12]  ;
                 ContestList.Items.Add(multString);
                 cnt2 := (cnt2)+13;
                end;
         end;
        //---- for TXQSO
         if TXQSO = true then
           begin
             cnt2 := 0;
             while cnt2 <= 249 do
               begin
                 multString :=  (Listbox4.Items[cnt2]+'  '+ Listbox4.Items[cnt2+1]+'  '+Listbox4.Items[cnt2+2]+'  '+Listbox4.Items[cnt2+3]+'  '+Listbox4.Items[cnt2+4]+'  '+Listbox4.Items[cnt2+5]+'  '+Listbox4.Items[cnt2+6]+'  '+Listbox4.Items[cnt2+7]+'  '+Listbox4.Items[cnt2+8]+'  '+Listbox4.Items[cnt2+9]+'  '+Listbox4.Items[cnt2+10]+'  ')+Listbox4.Items[cnt2+11]+'  ' +Listbox4.Items[cnt2+12]  ;
                 if cnt2+12 >= 234 then
                     begin
                       cnt2:= cnt2+9;
                       multString := (Listbox4.Items[cnt2]+'  '+ Listbox4.Items[cnt2+1]+'  '+Listbox4.Items[cnt2+2]+'  '+Listbox4.Items[cnt2+3]+'  '+Listbox4.Items[cnt2+4]+'  '+Listbox4.Items[cnt2+5]+'  '+Listbox4.Items[cnt2+6]+'  '+Listbox4.Items[cnt2+7]+'  '+Listbox4.Items[cnt2+8])+'  '+Listbox4.Items[cnt2+9]+'  '+Listbox4.Items[cnt2+10] ; //+'  '+MultArray[cnt2+11]+'  '+MultArray[cnt2+12];
                       ContestList.Items.Add(multString);
                       break;
                     end
                 else
                 begin
                     ContestList.Items.Add(multString);
                     cnt2 := (cnt2)+13;
                   end;

               end;
        //------------------------------
  end;
  end;

end;

procedure TForm1.ListBox4DblClick(Sender: TObject);
var
  MultSelected : integer;
  cnt2:integer;
  multString:string;
begin
             MultSelected := ListBox4.ItemIndex;
             eQTH.text := ListBox4.Items[MultSelected];
             ContestList.clear;
              //---------------
             if ARRLs = true then
             begin
               cnt2 := 0;
               while cnt2 <= 70 do
                   begin
                     multString :=  (Listbox4.Items[cnt2]+'  '+ Listbox4.Items[cnt2+1]+'  '+Listbox4.Items[cnt2+2]+'  '+Listbox4.Items[cnt2+3]+'  '+Listbox4.Items[cnt2+4]+'  '+Listbox4.Items[cnt2+5]+'  '+Listbox4.Items[cnt2+6]+'  '+Listbox4.Items[cnt2+7]+'  '+Listbox4.Items[cnt2+8]+'  '+Listbox4.Items[cnt2+9]+'  '+Listbox4.Items[cnt2+10]+'  ')+Listbox4.Items[cnt2+11]+'  ' +Listbox4.Items[cnt2+12]  ;  //+'  '+MultArray[cnt2+13]+'  '+MultArray[cnt2+14]+'  ';
                     ContestList.Items.Add(multString);
                     cnt2 := (cnt2)+13;
                   end;
              end;
         //------------------------------
             if TXQSO = true then
             begin
                cnt2 := 0;
                while cnt2 <= 249 do
                     begin
                       multString :=  (Listbox4.Items[cnt2]+'  '+ Listbox4.Items[cnt2+1]+'  '+Listbox4.Items[cnt2+2]+'  '+Listbox4.Items[cnt2+3]+'  '+Listbox4.Items[cnt2+4]+'  '+Listbox4.Items[cnt2+5]+'  '+Listbox4.Items[cnt2+6]+'  '+Listbox4.Items[cnt2+7]+'  '+Listbox4.Items[cnt2+8]+'  '+Listbox4.Items[cnt2+9]+'  '+Listbox4.Items[cnt2+10]+'  ')+Listbox4.Items[cnt2+11]+'  ' +Listbox4.Items[cnt2+12]  ;  //+'  '+MultArray[cnt2+13]+'  '+MultArray[cnt2+14]+'  ';
                       ContestList.Items.Add(multString);
                       cnt2 := (cnt2)+13;
                     end;
             end;
       //---------------------------------------
end;

procedure TForm1.EditCurrentLog1Click(Sender: TObject);
begin
//      SaveInfo(sdQSO.Filename);
     Form2.visible := true;
end;

procedure TForm1.eCOMKeyPress(Sender: TObject; var Key: Char);
begin
if Key =chr(vk_space) then  //space key makes jump to STATION box
       eSTN.setfocus;
if key = chr(13) then  //enter key enters log data
    bOKclick(sender);

 //don't use commas...comma delimited filed messed up if you do
  if Key = #44 then begin   //#44 is a comma
    Key := #47;          // a / is #47  , a - is #45
    end;



end;

procedure TForm1.eQTHKeyPress(Sender: TObject; var Key: Char);

begin //don't use commas...comma delimited filed messed up if you do
  if Key = #44 then begin   //#44 is a comma
    Key := #47;          // a / is #47  , a - is #45
    end;

end;


end.
