unit EditLog;
 
interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Grids, ExtCtrls;
const
  LogEntry : array[0..9] of string = ('QSO#', 'Date', 'UTC','STATION', 'RSTs','RSTr', 'Freq','Mode', 'QTH','Comments');
  //number of fields in logging database   string is the grid header information
  COLQSO = 0;
  COLDATE = 1;
  COLTIME = 2;
  COLSTN = 3;
  COLRST = 4;
  COLRSTr = 5;
  COLFRQ = 6;
  COLMODE = 7;
  COLQTH = 8;
  COLCOM =9 ;

type
  TForm2 = class(TForm)
    Panel1: TPanel;
    Edit1: TEdit;
    Edit2: TEdit;
    Edit3: TEdit;
    Edit4: TEdit;
    Edit5: TEdit;
    Edit6: TEdit;
    Edit7: TEdit;
    Edit8: TEdit;
    Edit9: TEdit;
    Edit10: TEdit;
    ContestListEdit: TListBox;
    qso: TStringGrid;
    Button1: TButton;
    Button2: TButton;
    Edit11: TEdit;
    Button3: TButton;
    ListBox2: TListBox;
    ListBox1: TListBox;
    Label1: TLabel;
    Button4: TButton;
    Label2: TLabel;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form2: TForm2;

  SAVED : boolean;
  DateNum, TimeNow : string;
  SS : string;

     qQSO:string;
     qDate:string;
     qUTC:string;
     qSTATION:string;
     qRST:string;
     qRSTr:string;
     qFreq:string;
     qMode:string;
     qQTH:string;
     qComments:string;
     T :String;
     n : integer;

     // for contests
     ARRLs : boolean;
     TXQSO:boolean;
     nomultipliers:integer;
implementation

uses MainLog;          //refers to form1

{$R *.DFM}


procedure ParseIt(var contact: String);   //use with string list
var
InWord:Boolean;
Index, FirstChar:Integer;
begin
  InWord := False;
  Index := 1;
  FirstChar :=1;
  while Index <=Length(Ss) do     //ss is the string to parse
  begin
    T:=Copy(Ss,Index,1);
    If((T>='0')and (T<='9')) or
    ((T>='A') and (T<='Z')) or
    ((T>='a') and (T<='z')) or
    (T ='_') or
    (T ='/') or
    (T ='?') or
    (T ='.') or
    (T ='-') or
    (T =' ') or
    //(T=',') or    //can not use a comma.  It is the database delimiter
    (T =':')  then
  begin
    If not InWord then FirstChar := Index;
      InWord := true;
      end
      else begin
        If InWord then begin
           T := Copy(Ss, FirstChar, Index-FirstChar);
           Form2.ListBox2.items.add(T);
        end;
        InWord := False;
       end;
       Inc(Index);
 end;
end;

procedure TForm2.Button1Click(Sender: TObject);

//procedure to load the logbook
var
  F  : TextFile;
  dummy : string;
  filename:string;
  n:integer;

rnumb : integer;

begin
   For rnumb := 1 to qso.RowCount do
   qso.Rows[rnumb];   //****

//Form1.new1click(nil);
    filename := form1.odQSO.Filename ;
  AssignFile(F,FileName); //create and open a file called F
  reset(f);
  readln(f, n);
  qso.RowCount := n;    //read the first line of the file, it has the row count
   Form1.qso.RowCount:= n;
 for n:= 0 to (qso.RowCount -2) do
 //while not Eof(F) do
  begin
     Readln(f, dummy);edit2.text := dummy;
     Ss:= dummy +' ';
     ParseIt(Ss);     //parse the logbook record string
     //put the records in the array / grid
        Form2.qso.cells[COLQSO,n] := ListBox2.Items[0];
        Form2.qso.cells[COLDATE,n] := ListBox2.Items[1];
        Form2.qso.cells[COLTIME,n] := ListBox2.Items[2];
        Form2.qso.cells[COLSTN,n]  := ListBox2.Items[3];
        Form2.qso.Cells[COLRST,n] := ListBox2.Items[4];
        Form2.qso.Cells[COLRSTr,n] := ListBox2.Items[5];
        Form2.qso.Cells[COLFRQ,n] :=  ListBox2.Items[6];
        Form2.qso.cells[COLMODE,n] :=  ListBox2.Items[7];
        Form2.qso.Cells[COLQTH,n] :=  ListBox2.Items[8];
        Form2.qso.Cells[COLCOM,n] :=  ListBox2.Items[9];
        //-----------
        ContestListEdit.items.add (ListBox2.Items[0] +'  '+ ListBox2.Items[1]+'  ' +ListBox2.Items[2]+'  '+ ListBox2.Items[3]+'  '+ListBox2.Items[4]+'  '+ListBox2.Items[5]+'  '+  ListBox2.Items[6]+'  '+ListBox2.Items[7]+'  ' + ListBox2.Items[8]+'  '+ ListBox2.Items[9]);
             //------------------
        ListBox2.Clear;   //empty the list box

    end;
    closefile(f);
    Edit1.text :='' ;
       Edit2.text :='' ;
       Edit3.text :='' ;
       Edit4.text :='' ;
       Edit5.text :='' ;
       Edit6.text :='' ;
       Edit7.text :='' ;
       Edit8.text :='' ;
       Edit9.text :='' ;
       Edit10.text :='' ;
end;

procedure TForm2.Button2Click(Sender: TObject);
 var
 editnumber:integer ;
  n:integer;

begin
    ListBox1.Items := qso.Rows[qso.Row];

       Label1.Caption:= ListBox1.Items[0];
       Edit1.text:= ListBox1.Items[1];
       Edit2.text := ListBox1.Items[2];
       Edit3.text:= ListBox1.Items[3];
       Edit4.text:= ListBox1.Items[4];
       Edit5.text := ListBox1.Items[5];
       Edit6.text :=  ListBox1.Items[6];
       Edit7.text :=  ListBox1.Items[7];
       Edit8.text :=  ListBox1.Items[8];
       Edit9.text :=  ListBox1.Items[9];
end;

procedure TForm2.Button3Click(Sender: TObject);
var
 editnumber:integer ;
  n:integer;
begin
  editnumber := strtoint(Label1.caption);
  n:=editnumber;

      //There is presently no error protection for the
      //edit boxes...if you put the wrong values into
      //them while editing, unexpected results can be
      //anticipated.  The error control safegurards are for you to
      //implement.
     if edit1.text <> '' then  //prevents wiping entire entry
     begin
     Form2.qso.cells[COLQSO,n] := Label1.caption;
     Form2.qso.cells[COLDATE,n]:= Edit1.text;
     Form2.qso.cells[COLTIME,n]:=Edit2.text;
     Form2.qso.cells[COLSTN,n]:= Edit3.text;
     Form2.qso.cells[COLRST,n]:= Edit4.text;
     Form2.qso.cells[COLRSTr,n]:= Edit5.text;
     Form2.qso.cells[COLFRQ,n]:= Edit6.text;
     Form2.qso.cells[COLMODE,n]:= Edit7.text;
     Form2.qso.cells[COLQTH,n]:= Edit8.text;
     Form2.qso.cells[COLCOM,n]:= Edit9.text;
    // Form2.qso.cells[COLDATE,n]:= Edit10.text;

      //the following puts the contends of the edited log into
      // the main log...it is not saved until the main log is
      //saved.

     Form1.qso.cells[COLQSO,n] :=Form2.qso.cells[COLQSO,n];
     Form1.qso.cells[COLDATE,n]:= Form2.qso.cells[COLDATE,n];
     Form1.qso.cells[COLTIME,n]:=Form2.qso.cells[COLTIME,n];
     Form1.qso.cells[COLSTN,n]:= Form2.qso.cells[COLSTN,n];
     Form1.qso.cells[COLRST,n]:= Form2.qso.cells[COLRST,n];
     Form1.qso.cells[COLRSTr,n]:= Form2.qso.cells[COLRSTr,n];
     Form1.qso.cells[COLFRQ,n]:= Form2.qso.cells[COLFRQ,n];
     Form1.qso.cells[COLMODE,n]:= Form2.qso.cells[COLMODE,n];
     Form1.qso.cells[COLQTH,n]:= Form2.qso.cells[COLQTH,n];
     Form1.qso.cells[COLCOM,n]:= Form2.qso.cells[COLCOM,n];
    // Form1.qso.cells[COLDATE,n]:= Form2.qso.cells[COLDATE,n];
     //The main log display will not display the changes until the
     //following is executed.
     Form1.qso.Repaint;   
     end
     else

end;

procedure TForm2.Button4Click(Sender: TObject);
begin
         Form2.Visible := False;
end;

end.
