#ARRL2CBR.pl - convert VHF log in old ARRL format to Cabrillo format
# Paul Wade W1GHZ copyright 2000,2001
# version 1.1 fixes date rollover problem 

print "\n\n       ARRL2CBR version 1.1\n\n";
print "Converts VHF log in old ARRL log format to new Cabrillo format\n\n";

print "    Paul Wade W1GHZ copyright 2000\n";
print "    executable released to Public Domain 19 January 2001\n\n";


print "\nFile name for log file in ARRL format: ";

$Infilename = <STDIN>;

#open(INFILE, '<10gfirst.txt') or die "Can't open input file\n";
open(INFILE, $Infilename) or die "Can't open input file\n";


#open(OUTFILE, '>testout.txt') or die "Can't open output file \n";


$Mycall = &GetCall;

    $Outfilename = sprintf('>%s.CBR',$Mycall);
    if (-e $Outfilename)
        {
        print "\nFile " . $Outfilename . " already exists.  OVERWRITE?: ";
        $Yesno = <STDIN>;
        chomp $Yesno;
        $Yesno = uc($Yesno);
        unless ($Yesno eq 'Y') 
            {
            die "\nExiting without overwriting\n";
            }   
        }          

open(OUTFILE, $Outfilename) or die "Can't open output file " . $Outfilename . "\n";

&Header;

# initialize
%Callsworked = ();
$i = 0;
$Unique_calls = 0;
$warnings = 0;


# parse the input file
while(<INFILE>)
    {
    $Nextline = $_;
    chomp($Nextline);
    if ($Nextline =~ /\w/) 
        {
        @QSO = split(/\s+/, $Nextline);
        $nfields = @QSO;
        
#QSO[0] = band
#QSO[1] = mode
#QSO[2] = date dd/mm/yy
#QSO[3] = time
#QSO[4] = sequence #
#QSO[5] = call rcvd
#QSO[6] = grid sent
#QSO[7] = grid rcvd
#QSO[8+] = * if new grid


# find unique calls and list them
        if (&Newcall(@QSO[5]))
            {
            $Unique_calls++;
            }

        if (@QSO[1] =~ /SSB/)       # change SSB to PH
            {
            @QSO[1] = "PH";
            }

        $Cabrillo_date = &FixDate(@QSO[2]);

        if (@QSO[3] =~ /Z/)       # remove Zulu from time
            {
            chop(@QSO[3]);
            }


# write the Cabrillo log format         
#example
#QSO:    50 PH 1997-09-13 1804 NJ2L              FN12fr KB2DMK            FN12

        $line = sprintf ('%5s %2s %10s %4s %-10s        %-6s %-10s        %-6s', 
                        @QSO[0],        #band; 5RJ
                        @QSO[1],        #mode; 2
                        $Cabrillo_date,
#                        @QSO[2],        #date in format:
#                                        #year;4 +hyphen
#                                        #month; 2 +hyphen
#                                        #day; 2
                        @QSO[3],        #time; 4
                        $Mycall,        #call sent; 10LJ+5s 
                        @QSO[6],        #grid sent: 6LJ
                        @QSO[5],        #call rcvd; 10LJ+5s 
                        @QSO[7]);        #grid rcvd; 6LJ 
#                        @QSO[6],        #distance
#                        @QSO[7]);       #QSO points
        
        print OUTFILE "QSO: ".$line."\n";

#        print OUTFILE join(",", @QSO);
#        print OUTFILE "\n";
        $i++;

        print $Nextline;
        print "\n";
        }
    }

print OUTFILE "END-OF-LOG:\n";
close (INFILE);
close (OUTFILE);

#wrapup

print $i. "\n QSOs written to Log file " . $Mycall . ".CBR \n\n";

print " ******** Check it carefully *********\n";
print " Then rename to " .  $Mycall . ".TXT before submitting. \n\n";

if ($warnings) 
    {
    print "WARNING: " . $warnings . " lines not parsed correctly. \n\n";
    }
    
print $Unique_calls . " calls worked \n\n";
    
# write list of calls to file
$Callname = sprintf('>%s.lis',$Mycall);

open(CALLFILE, $Callname) or die "Can't open output file for calls \n";

print CALLFILE "CALL\t\tQSOs\n\n";

foreach $Call (sort(keys(%Callsworked)))
    {
    print CALLFILE "$Call\t\t$Callsworked{$Call}\n";
    }
    
close(CALLFILE);
print $Unique_calls . " calls printed to file " . $Mycall . ".LIS \n";
    

sleep(1);
exit;


sub GetCall
# get the call used
    {
    print "\nCall used: ";

    $My_call = <STDIN>;
    chomp($My_call);
    $My_call = uc($My_call);
    return $My_call;
    }


sub Newcall
# adds QSO to list of calls worked
    {
    my($Call) = shift(@_);
    if (exists($Callsworked{$Call}))
        {
        $Callsworked{$Call} += 1;
        return 0;
        }    
    else
        {
        $Callsworked{$Call} = 1;
        return 1;
        }    
    }

sub FixDate
# puts date into Cabrillo format
    {
    my($Date) = shift(@_);
    my (@Newdate) = split(/\//, $Date);

    my($Day) = @Newdate[0];
    my($Mo) = @Newdate[1];
    my($Yr) = @Newdate[2];
# now for all the special cases
    if ($Yr < 1900)     # 2 digit year
        {
#        if ($Yr > 99)   # old versions of CT write 100 for 00; Y2K bug!
        if ($Yr > 90)  # last century - also make it right for checking old logs
           {
           $Yr = $Yr + 1900;
           }
        else           # 21st century - good until 2090 only!
           {
           $Yr = $Yr + 2000;
           }
        }

    $Date = sprintf('%04s-%02s-%02s', $Yr, $Mo, $Day);
    return $Date;
    }

sub Newcall
# adds QSO to list of calls worked
    {
    my($Call) = shift(@_);
    if (exists($Callsworked{$Call}))
        {
        $Callsworked{$Call} += 1;
        return 0;
        }    
    else
        {
        $Callsworked{$Call} = 1;
        return 1;
        }    
    }


sub Header
# make the Cabrillo summary header like this:

#START-OF-LOG: 2.0
#ARRL-SECTION: WNY
#CONTEST: ARRL-VHF-SEP
#CALLSIGN: NJ2L
#CATEGORY: SINGLE-OP ALL HIGH
#CLAIMED-SCORE: 20805
#OPERATORS: NJ2L
#CLUB: Rochester VHF Group
#NAME: Rus Healy
#ADDRESS: 5960 Canadice Hill Road
#ADDRESS: Springwater, NY 14560
#SOAPBOX: What a great contest!
    {
    print OUTFILE "START-OF-LOG: 2.0\n";

    print "\nEnter ARRL SECTION: ";
    $Section = <STDIN>;
    chomp($Section);
    $Section = uc($Section);
    print OUTFILE "ARRL-SECTION: " . $Section . "\n";

    print "\nEnter CONTEST from this list:\n";
    print "           ARRL-VHF-JAN \n";
    print "           ARRL-VHF-JUN \n";
    print "           ARRL-VHF-SEP \n";
    print "           ARRL-UHF-AUG \n";
    print "           CQ-VHF \n";
    print "    Type it exactly as listed above: ";
    $Contest = <STDIN>;
    chomp($Contest);
    $Contest = uc($Contest);
    print OUTFILE "CONTEST: " . $Contest . "\n";

    print OUTFILE "CALLSIGN: " . $Mycall . "\n";

    print "\nEnter OPERATOR CATEGORY from this list:\n";
    print "           SINGLE-OP \n";
    print "           SINGLE-OP-QRP-PORTABLE \n";
    print "           ROVER \n";
    print "           MULTI-LIMITED\n";
    print "           MULTI-UNLIMITED\n";
    print "           CHECKLOG \n";
    print "    Type it exactly as listed above: ";
    $OpCat = <STDIN>;
    chomp($OpCat);
    $OpCat = uc($OpCat);

    print "\nEnter BAND CATEGORY. Type  ALL or LIMITED :";
    $BandCat = <STDIN>;
    chomp($BandCat);
    $BandCat = uc($BandCat);

    print "\nEnter POWER CATEGORY. Type HIGH, LOW or QRP:";
    $PwrCat = <STDIN>;
    chomp($PwrCat);
    $PwrCat = uc($PwrCat);

    print OUTFILE "CATEGORY: " . $OpCat . " " . $BandCat . " " . $PwrCat . "\n";
    
    print "\nEnter Claimed Score: ";
    $Score = <STDIN>;
    chomp($Score);
    $Score = uc($Score);
    print OUTFILE "CLAIMED SCORE: " . $Score . "\n";

    print "\nEnter Calls of operators: ";
    $Operators = <STDIN>;
    chomp($Operators);
    $Operators = uc($Operators);
    print OUTFILE "OPERATORS: " . $Operators . "\n";

    print "\nEnter CLUB: ";
    $Club = <STDIN>;
    chomp($Club);
    $Club = uc($Club);
    print OUTFILE "CLUB: " . $Club . "\n";

    print "\nEnter Your Name: ";
    $Name = <STDIN>;
    chomp($Name);
    $Name = uc($Name);
    print OUTFILE "NAME: " . $Name . "\n";

    print "\nEnter Street Address: ";
    $Street = <STDIN>;
    chomp($Street);
    $Street = uc($Street);
    print OUTFILE "ADDRESS: " . $Street . "\n";

    print "\nEnter City, State, & Zip: ";
    $Address2 = <STDIN>;
    chomp($Address2);
    $Address2 = uc($Address2);
    print OUTFILE "ADDRESS: " . $Address2 . "\n";

    print "\nEnter Soapbox comments: ";
    $Soapbox = <STDIN>;
    chomp($Soapbox);
    $Soapbox = uc($Soapbox);
    print OUTFILE "SOAPBOX: " . $Soapbox . "\n";

    }  # end of Cabrillo header