/*-----------------------------------------------------------------
  All code is provided for EDUCATIONAL purposes ONLY. There is no
  warranty and no support.

  Copyright (c) Jack Botner and licensed under the MIT license; see
  http://opensource.org/licenses/mit-license.php

  ICOM commander by Jack Botner

  main.h
-----------------------------------------------------------------*/
#ifndef _MAIN_H_
#define _MAIN_H_

#include "common.h"

#define FROM_ADDRESS      0xc0    // CI-V host address
#define TO_ADDRESS        0x94    // CI-V target address

#define INIT_TIMER1			( 65536 - 8000 )    // set the timer counts

#define LED_PORT     PORTB
#define LED_PIN          2

#define EVENT_SW1        1
#define EVENT_SW2        2
#define EVENT_SW3        3
#define EVENT_SW4        4
#define EVENT_1MS        5

#define MAX_CHECKS       8              // number of tests before a switch is debounced

#define SW1               0             // bit positions for switches
#define SW2               1
#define SW3               2
#define SW4               3

#if 0
// EEPROM stuff
typedef struct _MY_EEPROM_DATA
{
	int16_t	  iSetTempC;			// last set temperature (10ths degrees C)
	uint8_t	  ucSystemOn;		    // on/off switch
}
MY_EEPROM_DATA;
#endif

// Functions
void UART_init(void);
void UART_tx(unsigned char character);
void UART_tx_data(unsigned char* data, char length);
void UART_tx_str(char* string);

#endif  //_MAIN_H_
