/*---------------------------------------------------------------
  main.h  by Jack Botner
---------------------------------------------------------------*/
#ifndef _MAIN_H_
#define _MAIN_H_

#include "common.h"
#include "led.h"

#define INIT_TIMER1			( 256 - 250 )
#define TOTAL_PWM_TICKS		500		// 2 ms ticks total time on+off

#define MAX_CHECKS			6		// number of tests before a switch is debounced

#define EEPROM_DELAY_2MS	2500	// wait 5 sec before updating eeprom
#define ADC_DELAY_2MS		15000	// wait 30 sec before sampling adc

#define VDD_MV				4830
#define R8_OHMS				989

// Debounced switches bits
#define ENC_SWITCH_A		0
#define ENC_SWITCH_B		1
#define ENC_SWITCH_PB		2

// Rotary encoder port defines
#define ENCODER_PORT		PINB
#define ENCODER_A			PB5
#define ENCODER_B			PB4
#define ENCODER_PB			PB6

// Events bits
#define EVENT_ADC_COMPLETE		0
#define EVENT_BUTTON_PRESSED    1
#define EVENT_ENCODER_UP		2
#define EVENT_ENCODER_DOWN		3
#define EVENT_UPDATE_EEPROM		4
#define EVENT_REFRESH_LED		5
#define EVENT_DEBOUNCE_IO		6
#define EVENT_10MS_PWM			7

// Functions

void alternate_mainline(void);
void analyze_switch(void);
void debounce_switch(void);

#endif  //_MAIN_H_
