/*-----------------------------------------------------------------
  Released under the MIT License  - see
  http://www.opensource.org/licenses/mit-license.php

  travel_clock by Jack Botner

  rtc.h
-----------------------------------------------------------------*/
#ifndef _RTC_H_
#define _RTC_H_

#define DELAY_1US()  do { __asm__ __volatile__ ( \
						"nop" "\n\t" \
						"nop" "\n\t" \
						"nop" "\n\t" \
						"nop" "\n\t" \
						); } while (0)
	
// DS1302 RTC port defines
#define RTC_PORT			PORTB
#define RTC_PIN	        	PINB
#define RTC_DDR 			DDRB

#define RTC_CE				PB2
#define RTC_IO				PB6
#define RTC_SCLK			PB7

// Functions

uint8_t RTC_get_time( uint8_t *pucHours, uint8_t *pucMinutes, uint8_t *pucSeconds );
void    RTC_init( void );
void    RTC_set_time( uint8_t ucH1, uint8_t ucH2, uint8_t ucM1, uint8_t ucM2, uint8_t ucPMind );

#endif  //_RTC_H_
