/*-----------------------------------------------------------------
  Released under the MIT License  - see
  http://www.opensource.org/licenses/mit-license.php

  travel_clock by Jack Botner

  main.h
-----------------------------------------------------------------*/
#ifndef _MAIN_H_
#define _MAIN_H_

#include "common.h"

#define INIT_CTR0			( 256 - 62 )
#define INIT_CTR1			( 65536 - 31250 )
#define INIT_CTR2			( 256 - 125 )

#define MAX_CHECKS       	6		// number of tests before a switch is debounced

// Events bits
#define EVENT_BUTTON_PRESSED	1
#define EVENT_ENCODER_CW		2
#define EVENT_ENCODER_CCW		3
#define EVENT_HALFSEC			4
#define EVENT_UPDATE_EEPROM     5

// Debounced switches bits
#define ENC_SWITCH_A			0
#define ENC_SWITCH_B			1
#define ENC_SWITCH_PB			2

// Rotary encoder port defines
#define ENCODER_PORT			PINC
#define ENCODER_A				PC4
#define ENCODER_B				PC5
#define ENC_SW_PORT				PINB
#define ENC_SW_PB				PB0

// Beeper port defines
#define BEEPER_PORT				PORTB
#define BEEPER_PIN				PB1

// Other defines
#define ALARM_OFF				0
#define ALARM_ON_QUIET			1
#define ALARM_ON_ACTIVE			2

#define BLINK_NONE				0
#define BLINK_HOURS				1
#define BLINK_MINUTES			2
 
 // EEPROM stuff
 typedef struct _MY_EEPROM_DATA
 {
	 uint8_t	ucAlarmTime[4];
	 uint8_t	ucAlarmPm;
	 uint8_t	ucAlarm_State;
 }
 MY_EEPROM_DATA;

// Functions

void program_clock(void);


#endif  //_MAIN_H_
