/*---------------------------------------------------------------------
  All code is provided for EDUCATIONAL purposes ONLY. There is no
  warranty and no support.

  Module: nju6355.h
---------------------------------------------------------------------*/
#ifndef _NJU6355_H_
#define _NJU6355_H_

// Ports connected to NJU6355

#define RTC_DATA_DDR      DDRB
#define RTC_DATA_DDR_BIT  DDB0
#define RTC_DATA_PORT_IN  PINB
#define RTC_DATA_PORT_OUT PORTB
#define RTC_DATA_BIT      PB0

#define RTC_CLK_PORT      PORTB
#define RTC_CLK_BIT       PB2

#define RTC_IO_PORT       PORTB
#define RTC_IO_BIT        PB1

#define RTC_CE_PORT       PORTB
#define RTC_CE_BIT        PB3

// Real Time Clock parameters

typedef struct _RTCparms
{
  uint8_t rtc_year;
  uint8_t rtc_month;
  uint8_t rtc_day;
  uint8_t rtc_dayweek;
  uint8_t rtc_hours;
  uint8_t rtc_mins;
  uint8_t rtc_secs;
}
RTCPARMS;

// Functions

void rtc_init( void );
void rtc_read( void );
void rtc_write( void );

#endif  //_NJU6355_H_
